/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArrayLengthExpression;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.MemberExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.NullConstantExpression;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.SuperExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

final class FieldExpression
extends MemberExpression {
    Symbol field;
    int fieldPos;
    static final /* synthetic */ boolean $assertionsDisabled;

    FieldExpression(int pos, Symbol field, Expression thisArgument) {
        super((byte)1, pos, thisArgument);
        this.field = field;
        this.fieldPos = field.pos;
    }

    short getAccess() {
        if (!$assertionsDisabled && (this.field.kind & 2) == 0) {
            throw new AssertionError();
        }
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        return fieldSymbol.access;
    }

    String errorName() {
        return this.field.errorName();
    }

    Expression constantFolding(Parser parser) {
        if (!$assertionsDisabled && (this.field.kind & 2) == 0) {
            throw new AssertionError();
        }
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        if ((fieldSymbol.flags & 2) != 0) {
            if (!$assertionsDisabled && fieldSymbol.initializer == null) {
                throw new AssertionError();
            }
            return fieldSymbol.initializer.promoteType(parser, fieldSymbol.type);
        }
        return this;
    }

    private FieldSymbol lookupInterfaceField(Parser parser, int pos, ClassSymbol classSymbol, Identifier name) {
        FieldSymbol fieldSymbolFound = this.lookupInterfaceFieldInClass(parser, pos, classSymbol, null, name);
        if (classSymbol.isTypeParameter()) {
            TypeParameterSymbol tps = (TypeParameterSymbol)classSymbol;
            ClassSymbolList tsl = tps.interfaceBounds;
            while (tsl != null) {
                ClassSymbol interfaceSymbol = tsl.classSymbol;
                ClassScope scope = interfaceSymbol.getClassScope();
                FieldSymbol fieldSymbol = (FieldSymbol)scope.lookupSpecificSymbolInScope(name, 2, true);
                if (fieldSymbol != null && (fieldSymbol.flags & 1) == 0) {
                    if (fieldSymbolFound != null && fieldSymbolFound != fieldSymbol) {
                        parser.error(Message.errorAmbiguousReference, pos, fieldSymbolFound.isErroneous() | fieldSymbol.isErroneous(), name.toString(), fieldSymbolFound.errorName() + " " + Message.inString + " " + fieldSymbolFound.definingClass.errorName(), fieldSymbol.errorName() + " " + Message.inString + " " + fieldSymbol.definingClass.errorName());
                    }
                    fieldSymbolFound = fieldSymbol;
                }
                fieldSymbolFound = this.lookupInterfaceFieldInClass(parser, pos, interfaceSymbol, fieldSymbolFound, name);
                tsl = tsl.next;
            }
        }
        if (fieldSymbolFound == null && classSymbol.isInnerClass()) {
            fieldSymbolFound = this.lookupInterfaceField(parser, pos, classSymbol.getOuterClass(), name);
        }
        return fieldSymbolFound;
    }

    private FieldSymbol lookupInterfaceFieldInClass(Parser parser, int pos, ClassSymbol classSymbol, FieldSymbol fieldSymbolFound, Identifier name) {
        ClassSymbol classSym = classSymbol;
        do {
            classSym = (ClassSymbol)classSym.resolveType(parser, classSym.pos, false, false, false);
            ImplementationList implementationList = classSym.getImplementationList();
            while (implementationList != null) {
                ClassSymbol interfaceSymbol = implementationList.interfaceSymbol;
                ClassScope scope = interfaceSymbol.getClassScope();
                FieldSymbol fieldSymbol = (FieldSymbol)scope.lookupSpecificSymbolInScope(name, 2, true);
                if (fieldSymbol != null && (fieldSymbol.flags & 1) == 0) {
                    if (fieldSymbolFound != null && fieldSymbolFound != fieldSymbol) {
                        parser.error(Message.errorAmbiguousReference, pos, fieldSymbolFound.isErroneous() | fieldSymbol.isErroneous(), name.toString(), fieldSymbolFound.errorName() + " " + Message.inString + " " + fieldSymbolFound.definingClass.errorName(), fieldSymbol.errorName() + " " + Message.inString + " " + fieldSymbol.definingClass.errorName());
                    }
                    fieldSymbolFound = fieldSymbol;
                }
                if (fieldSymbolFound == null && (fieldSymbol = this.lookupInterfaceField(parser, pos, interfaceSymbol, name)) != null && (fieldSymbol.flags & 1) == 0) {
                    fieldSymbolFound = fieldSymbol;
                }
                implementationList = implementationList.next;
            }
        } while ((classSym = classSym.getSuperClassSymbol()) != null);
        return fieldSymbolFound;
    }

    private boolean interfaceFieldIsAmbigous(FieldSymbol fieldSymbol, FieldSymbol interfaceFieldSymbol, ClassSymbol classSymbol) {
        if (interfaceFieldSymbol == null || interfaceFieldSymbol == fieldSymbol || fieldSymbol.definingClass.equalTo(classSymbol)) {
            return false;
        }
        RawClassSymbol interfaceClass = interfaceFieldSymbol.definingClass;
        while (classSymbol != null && !classSymbol.equalTo(fieldSymbol.definingClass)) {
            ImplementationList list = classSymbol.getImplementationList();
            while (list != null) {
                ClassSymbol classSym = list.interfaceSymbol;
                if (classSym.equalTo(interfaceClass)) {
                    return true;
                }
                if (classSym.implementsInterface(interfaceClass)) {
                    return true;
                }
                list = list.next;
            }
            classSymbol = classSymbol.getSuperClassSymbol();
        }
        return false;
    }

    private Symbol lookupFieldSymbol(Parser parser, ClassSymbol classSymbol, Identifier identifier) {
        MethodVariableSymbol localSymbol;
        FieldSymbol interfaceFieldSymbol = null;
        FieldSymbol fieldSymbol = (FieldSymbol)classSymbol.getClassScope().lookupSpecificSymbol(identifier, 2, true);
        if (fieldSymbol != null && (fieldSymbol.flags & 0x20) != 0) {
            fieldSymbol = null;
        }
        if (fieldSymbol == null && classSymbol.isInnerClass() && (localSymbol = (MethodVariableSymbol)classSymbol.getClassScope().lookupSpecificSymbol(identifier, 64, false)) != null && (localSymbol.access & 0x10) != 0) {
            fieldSymbol = parser.getSyntheticFieldForLocalInInnerClass(localSymbol);
        }
        if (fieldSymbol == null) {
            interfaceFieldSymbol = this.lookupInterfaceField(parser, this.pos, classSymbol, identifier);
        } else if (!fieldSymbol.definingClass.equalTo(classSymbol) && (interfaceFieldSymbol = this.lookupInterfaceField(parser, this.pos, classSymbol, identifier)) != null && !fieldSymbol.isAccessible(parser.currentClassSymbol, classSymbol)) {
            fieldSymbol = interfaceFieldSymbol;
            interfaceFieldSymbol = null;
        }
        if (fieldSymbol == null) {
            fieldSymbol = interfaceFieldSymbol;
        } else if (this.interfaceFieldIsAmbigous(fieldSymbol, interfaceFieldSymbol, classSymbol)) {
            parser.error(Message.errorAmbiguousReference, this.pos, interfaceFieldSymbol.isErroneous() | fieldSymbol.isErroneous(), identifier.toString(), fieldSymbol.errorName() + " " + Message.inString + " " + fieldSymbol.definingClass.errorName(), interfaceFieldSymbol.errorName() + " " + Message.inString + " " + interfaceFieldSymbol.definingClass.errorName());
            return FieldSymbol.errorField;
        }
        return fieldSymbol;
    }

    private boolean isConstantInstanceField(FieldSymbol fieldSymbol) {
        if (!$assertionsDisabled && (fieldSymbol.access & 8) != 0) {
            throw new AssertionError();
        }
        return (fieldSymbol.access & 0x10) != 0 && fieldSymbol.initializer != null && fieldSymbol.initializer.kind == 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Expression _resolveAndCheck(Parser parser, boolean isOnLeftHandSide) {
        TypeSymbol thisType;
        ImportSymbol importSymbol;
        RawClassSymbol outerClass;
        String name;
        TypeSymbol typeSymbol;
        ClassSymbol classSymbol;
        if (!(this.field instanceof UnresolvedSymbol)) {
            return this;
        }
        UnresolvedSymbol unresolvedSymbol = (UnresolvedSymbol)this.field;
        if (unresolvedSymbol.qualifierList == null) {
            classSymbol = parser.currentClassSymbol;
        } else {
            if (!this.resolveQualifiedName(parser, unresolvedSymbol)) {
                return ErrorExpression.errorExpression;
            }
            classSymbol = null;
        }
        Expression thisArg = this.thisArgument;
        if (thisArg != null) {
            typeSymbol = (thisArg = thisArg.resolveAndCheck(parser)).getType();
            if (typeSymbol.isArrayType()) {
                if (unresolvedSymbol.identifier.equals(Identifier.lengthIdentifier)) {
                    typeSymbol = ((ArraySymbol)typeSymbol).baseType;
                    if (!typeSymbol.isClass()) return new ArrayLengthExpression(this.pos, thisArg);
                    if (((ClassSymbol)typeSymbol).isAccessible(parser.currentClassSymbol)) {
                        return new ArrayLengthExpression(this.pos, thisArg);
                    }
                }
                classSymbol = parser.javaLangObjectSymbol;
            } else {
                if (!typeSymbol.isClass()) {
                    Error error = parser.error(Message.errorObjectRequired, thisArg.pos, typeSymbol.isErroneous(), typeSymbol.toString());
                    return new ErrorExpression(error);
                }
                classSymbol = typeSymbol.isTypeParameter() ? (TypeParameterSymbol)typeSymbol : ((ClassSymbol)typeSymbol).getClassSymbol();
            }
            this.thisArgument = thisArg;
        }
        if (this.qualification != null) {
            classSymbol = this.qualification.getClassSymbol();
        }
        classSymbol.resolveType(parser, this.pos, true, true, false);
        if (classSymbol.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        FieldSymbol fieldSymbol = (FieldSymbol)this.lookupFieldSymbol(parser, classSymbol, unresolvedSymbol.identifier);
        if (fieldSymbol == FieldSymbol.errorField) {
            return ErrorExpression.errorExpression;
        }
        if (fieldSymbol != null && parser.currentClassSymbol.isInnerClass() && (fieldSymbol.flags & 0x10) != 0) {
            name = unresolvedSymbol.identifier.toString();
            name = name.substring(name.lastIndexOf(Identifier.dollarCharacter) + 1);
            Identifier nonSyntheticIdent = Identifier.getIdentifier(name);
            ClassScope classScope = parser.currentClassSymbol.getClassScope();
            FieldSymbol thisFieldSymbol = (FieldSymbol)classScope.lookupSpecificSymbolInTheThisScope(nonSyntheticIdent, 2, true);
            if (thisFieldSymbol != null && thisFieldSymbol.isAccessible(parser.currentClassSymbol, parser.currentClassSymbol)) {
                fieldSymbol = thisFieldSymbol;
                unresolvedSymbol.symbolFlags = (byte)(unresolvedSymbol.symbolFlags & 0xFFFFFFFB);
            }
        }
        if ((unresolvedSymbol.symbolFlags & 4) != 0) {
            name = unresolvedSymbol.identifier.toString();
            name = name.substring(name.lastIndexOf(Identifier.dollarCharacter) + 1);
            Error error = parser.error(Message.errorNeedsToBeFinal, unresolvedSymbol.pos, false, name);
            return new ErrorExpression(error);
        }
        FieldSymbol inaccessibleField = null;
        if (fieldSymbol != null && classSymbol.isInnerClass()) {
            if (parser.currentClassSymbol.isAnonymousInnerClass() && parser.currentClassSymbol.isInnerClass(classSymbol) && thisArg != null && thisArg instanceof ThisExpression && ((ThisExpression)thisArg).outerClassSymbol != null) {
                if ((parser.currentClassSymbol.access & 8) != 0 && (fieldSymbol.access & 8) == 0 && !this.isConstantInstanceField(fieldSymbol)) {
                    Error error = parser.error(Message.errorDynamicRef, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                    return new ErrorExpression(error);
                }
            } else if (!(fieldSymbol.definingClass.equalTo(classSymbol) || fieldSymbol.definingClass.isSuperclass(classSymbol) || classSymbol.implementsInterface(fieldSymbol.definingClass))) {
                if (thisArg != null || this.qualification != null) {
                    fieldSymbol = null;
                } else if ((classSymbol.access & 8) != 0 && (fieldSymbol.access & 8) == 0 && !this.isConstantInstanceField(fieldSymbol)) {
                    Error error = parser.error(Message.errorDynamicRef, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                    return new ErrorExpression(error);
                }
            } else if (!fieldSymbol.isAccessible(parser.currentClassSymbol, classSymbol) && (parser.currentClassSymbol.getTopLevelClass() != fieldSymbol.definingClass.getTopLevelClass() || fieldSymbol.definingClass.isSuperclass(classSymbol))) {
                FieldSymbol fieldSym;
                inaccessibleField = fieldSymbol;
                outerClass = classSymbol.getOuterClass();
                while (true) {
                    if ((fieldSym = (FieldSymbol)this.lookupFieldSymbol(parser, outerClass, unresolvedSymbol.identifier)) == FieldSymbol.errorField) {
                        return ErrorExpression.errorExpression;
                    }
                    if (fieldSym != null) {
                        if ((classSymbol.access & 8) == 0 || (fieldSym.access & 8) != 0 || this.isConstantInstanceField(fieldSym)) break;
                        fieldSym = null;
                        break;
                    }
                    if (!outerClass.isInnerClass()) break;
                    outerClass = outerClass.getOuterClass();
                }
                fieldSymbol = fieldSym;
            }
        }
        if (parser.parsingAtLeastOneFive && fieldSymbol == null && this.qualification == null && thisArg == null && (importSymbol = parser.currentPackageScope.lookupImportSymbol(unresolvedSymbol.identifier, (byte)2)) != null) {
            Symbol otherSymbol;
            importSymbol.used = true;
            Symbol symbol = importSymbol.importedSymbol;
            if (symbol instanceof FieldSymbol) {
                fieldSymbol = (FieldSymbol)symbol;
            }
            if ((importSymbol.flags & 1) == 0 && (otherSymbol = importSymbol.importSymbolHidesOtherImport()) != null && otherSymbol != symbol) {
                String errStr1 = symbol.errorName();
                if (symbol instanceof FieldSymbol) {
                    errStr1 = errStr1 + " " + Message.inString + " " + ((FieldSymbol)symbol).definingClass.errorName();
                }
                String errStr2 = otherSymbol.errorName();
                if (otherSymbol instanceof FieldSymbol) {
                    errStr2 = errStr2 + " " + Message.inString + " " + ((FieldSymbol)otherSymbol).definingClass.errorName();
                }
                Error error = parser.error(Message.errorAmbiguousReference, this.pos, symbol.isErroneous() | otherSymbol.isErroneous(), classSymbol.errorName(), errStr1, errStr2);
                return new ErrorExpression(error);
            }
        }
        if (fieldSymbol == null) {
            Error error;
            if (inaccessibleField != null) {
                error = parser.error(Message.errorAccessError, this.pos, inaccessibleField.isErroneous(), inaccessibleField.errorName());
                return new ErrorExpression(error);
            }
            error = parser.error(Message.errorNotFound, this.pos, classSymbol.isErroneous(), Message.variableString + " " + unresolvedSymbol.identifier.toString(), Message.inString + " " + classSymbol.errorName());
            return new ErrorExpression(error);
        }
        if (unresolvedSymbol.qualifierList == null && (fieldSymbol.access & 8) != 0) {
            fieldSymbol.checkForAmbigousImport(parser, this.pos, parser.currentPackageScope, (short)2);
        }
        this.field = fieldSymbol;
        fieldSymbol.type = typeSymbol = fieldSymbol.type.resolveType(parser, this.pos, false, true, false);
        if (typeSymbol.containsTypeParameterDefinedBy(null)) {
            typeSymbol = typeSymbol.replaceTypeParameters(parser.currentClassSymbol, null, null, thisArg);
        }
        if (typeSymbol.isTypeParameter() && thisArg != null && (thisType = thisArg.getType()).isParameterizedClass()) {
            ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)thisType;
            TypeParameterSymbol tps = (TypeParameterSymbol)typeSymbol;
            if (pcs.typeVariableList == null && tps.definingSymbol != pcs.genericClassSymbol && tps.definingSymbol != parser.currentClassSymbol && !parser.currentClassSymbol.isInnerClass((RawClassSymbol)tps.definingSymbol)) {
                typeSymbol = tps.bound;
            }
        }
        this.setType(typeSymbol.resolveType(parser, this.pos, false, true, false));
        if (thisArg != null && thisArg instanceof SuperExpression) {
            classSymbol = ((SuperExpression)thisArg).classSymbol;
        }
        if (!fieldSymbol.isAccessible(parser.currentClassSymbol, classSymbol)) {
            if (!fieldSymbol.definingClass.isInnerClass() && !parser.currentClassSymbol.isInnerClass()) {
                Error error = parser.error(Message.errorAccessError, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                return new ErrorExpression(error);
            }
            RawClassSymbol currentTopLevelClass = parser.currentClassSymbol.getTopLevelClass();
            RawClassSymbol definingTopLevelClass = fieldSymbol.definingClass.getTopLevelClass();
            boolean protectedAccess = ((fieldSymbol.definingClass.access | fieldSymbol.access) & 4) != 0;
            RawClassSymbol currentOuterClass = parser.currentClassSymbol;
            RawClassSymbol definingOuterClass = fieldSymbol.definingClass;
            while (true) {
                if (protectedAccess && definingOuterClass.isSuperclass(currentOuterClass) && (thisArg == null || thisArg instanceof ThisExpression || thisArg instanceof SuperExpression || thisArg.getType().equalTo(currentOuterClass))) {
                    this.useAccessor = true;
                    break;
                }
                if (definingOuterClass == currentOuterClass) {
                    this.useAccessor = true;
                    break;
                }
                if (definingOuterClass.isInnerClass()) {
                    definingOuterClass = definingOuterClass.getOuterClass();
                    continue;
                }
                if (!currentOuterClass.isInnerClass()) {
                    Error error = parser.error(Message.errorAccessError, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                    return new ErrorExpression(error);
                }
                definingOuterClass = fieldSymbol.definingClass;
                currentOuterClass = currentOuterClass.getOuterClass();
            }
        }
        if (fieldSymbol.initializer != null && (fieldSymbol.flags & 4) == 0 && parser.currentFieldSymbol != null && fieldSymbol.definingClass.equalTo(parser.currentClassSymbol) && thisArg == null) {
            Error error = parser.error(Message.errorIllegalForwardRef, this.pos, false);
            return new ErrorExpression(error);
        }
        if (parser.currentMethodSymbol != null && parser.currentMethodSymbol.definingClass.equalTo(fieldSymbol.definingClass) && (parser.currentMethodSymbol.isClassInitializer() && (fieldSymbol.access & 8) != 0 || parser.currentMethodSymbol.isDynamicInitializer() && (fieldSymbol.access & 8) == 0) && 0 <= fieldSymbol.pos && this.pos < fieldSymbol.pos && !isOnLeftHandSide && this.qualification == null && thisArg == null) {
            Error error = parser.error(Message.errorIllegalForwardRef, this.pos, false);
            return new ErrorExpression(error);
        }
        if ((fieldSymbol.isDeprecated() || fieldSymbol.definingClass.isDeprecated()) && (!fieldSymbol.definingClass.equalTo(parser.currentClassSymbol) || parser.options.selfDeprecation)) {
            parser.warning(fieldSymbol, Message.warningIsDeprecated, this.pos, fieldSymbol.errorName());
        }
        if ((fieldSymbol.access & 8) == 0) {
            if (thisArg == null) {
                if (parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) == 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) == 0) {
                    if (this.qualification != null) {
                        Error error = parser.error(Message.errorStaticReference, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                        return new ErrorExpression(error);
                    }
                    if (!isOnLeftHandSide && this.isConstantInstanceField(fieldSymbol) && (fieldSymbol.definingClass.equalTo(parser.currentClassSymbol) || parser.currentClassSymbol.isInnerClass(fieldSymbol.definingClass))) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 0x2000);
                        parser.currentClassSymbol.addNameReference(parser, fieldSymbol, this.fieldPos);
                        Expression expr = ((ConstantExpression)fieldSymbol.initializer).copyConstantExpression(this.pos);
                        if (expr instanceof NullConstantExpression) {
                            ((NullConstantExpression)expr).setTypeExempt(fieldSymbol.type);
                        }
                        if (parser.thisInitialized) return expr;
                        if (!fieldSymbol.definingClass.equalTo(parser.currentClassSymbol)) {
                            if (!fieldSymbol.definingClass.isSuperclass(parser.currentClassSymbol)) return expr;
                        }
                        Error error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
                        return new ErrorExpression(error);
                    }
                    thisArg = new ThisExpression(this.pos, parser.currentClassSymbol);
                    this.thisArgument = thisArg.resolveAndCheck(parser);
                } else {
                    Error error = parser.error(Message.errorDynamicRef, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                    return new ErrorExpression(error);
                }
            }
        } else {
            if (thisArg != null) {
                parser.warning(fieldSymbol, Message.warningStaticAccessWithObject, this.pos, fieldSymbol.errorName());
            }
            if (parser.currentClassSymbol.isEnum() && (fieldSymbol.access & 0x4000) == 0 && (fieldSymbol.access & 0x10) == 0 && fieldSymbol.definingClass == parser.currentClassSymbol && (parser.currentFieldSymbol != null || parser.currentMethodSymbol.isConstructor())) {
                parser.error(Error.errorCannotAccessStaticInEnumInit, this.pos, fieldSymbol.isErroneous());
            }
            if (!isOnLeftHandSide && (fieldSymbol.flags & 2) != 0) {
                fieldSymbol.flags = (short)(fieldSymbol.flags | 0x2000);
                Expression expr = fieldSymbol.initializer;
                typeSymbol = expr.getType();
                switch (typeSymbol.typeClass) {
                    default: {
                        if (typeSymbol.equalTo(fieldSymbol.type)) return expr.promoteType(parser, fieldSymbol.type);
                        return this;
                    }
                    case 2: 
                    case 8: 
                    case 16: 
                    case 32: {
                        expr = ((ConstantExpression)expr).copyConstantExpression(this.pos);
                        parser.depInfo.addReference(parser.currentClassSymbol, fieldSymbol.definingClass);
                        if (this.qualification != null) {
                            parser.currentClassSymbol.addNameReference(parser, this.qualification, this.pos);
                        }
                        parser.currentClassSymbol.addNameReference(parser, fieldSymbol, this.fieldPos);
                        return expr.promoteType(parser, fieldSymbol.type);
                    }
                    case 4: 
                }
                int val = typeSymbol.typeKind == 4 ? ((CharConstantExpression)expr).cval : ((IntConstantExpression)expr).ival;
                expr = fieldSymbol.type.typeKind == 4 ? new CharConstantExpression(this.pos, (char)val) : new IntConstantExpression(this.pos, TypeSymbol.intSymbol, val);
                parser.depInfo.addReference(parser.currentClassSymbol, fieldSymbol.definingClass);
                if (this.qualification != null) {
                    parser.currentClassSymbol.addNameReference(parser, this.qualification, this.pos);
                }
                parser.currentClassSymbol.addNameReference(parser, fieldSymbol, this.fieldPos);
                return expr.promoteType(parser, fieldSymbol.type);
            }
        }
        if (fieldSymbol.isSynthetic()) return this;
        if (!(this.thisArgument instanceof ThisExpression)) return this;
        if (parser.currentClassSymbol.isAnonymousInnerClass()) {
            if ((parser.currentClassSymbol.flags & 4) == 0) {
                if (parser.thisInitialized) return this;
            }
            if (!(classSymbol = ((ThisExpression)this.thisArgument).classSymbol).isInnerClass()) return this;
            outerClass = fieldSymbol.definingClass;
            if (((ThisExpression)thisArg).outerClassSymbol != null) {
                if ((parser.currentClassSymbol.flags & 4) != 0) {
                    Error error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
                    return new ErrorExpression(error);
                }
                outerClass = (RawClassSymbol)((ThisExpression)thisArg).outerClassSymbol;
            }
            if (outerClass.equalTo(classSymbol)) return this;
            if (outerClass.isSuperclass(classSymbol)) {
                if (fieldSymbol.isAccessible(parser.currentClassSymbol, classSymbol)) return this;
            }
            if (outerClass.isInterface()) {
                if (classSymbol.implementsInterface(outerClass)) return this;
            }
            if ((parser.currentClassSymbol.flags & 4) != 0) {
                Error error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
                return new ErrorExpression(error);
            }
            if (parser.parsingAtLeastOneFive) {
                if (classSymbol.getClassSymbol().isInnerClass(outerClass)) return this;
            }
            Error error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
            return new ErrorExpression(error);
        }
        if (parser.thisInitialized) return this;
        if (((ThisExpression)this.thisArgument).outerClassSymbol != null) return this;
        if (!fieldSymbol.definingClass.equalTo(parser.currentClassSymbol)) {
            if (!fieldSymbol.definingClass.isSuperclass(parser.currentClassSymbol)) return this;
        }
        Error error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
        return new ErrorExpression(error);
    }

    private static FieldSymbol getFieldSymbol(Parser parser, Expression expr) {
        if (expr instanceof FieldExpression) {
            FieldExpression fieldExpr = (FieldExpression)expr;
            FieldSymbol fieldSymbol = (FieldSymbol)fieldExpr.field;
            if (fieldSymbol.definingClass.equalTo(parser.currentClassSymbol) && (fieldExpr.thisArgument instanceof ThisExpression || (fieldSymbol.access & 8) != 0)) {
                return fieldSymbol;
            }
        }
        return null;
    }

    Expression resolveAndCheck(Parser parser) {
        Expression thisArg = this.thisArgument;
        Expression expr = this._resolveAndCheck(parser, false);
        FieldSymbol fieldSymbol = FieldExpression.getFieldSymbol(parser, expr);
        if (fieldSymbol != null) {
            int index = fieldSymbol.index;
            if (!(parser.suspendDataFlowChecking || parser.defSet.get(index) || thisArg instanceof ThisExpression)) {
                parser.error(Message.errorNotInitialized, this.pos, false, this.errorName());
            }
            parser.useSet.set(index);
        }
        if (expr instanceof FieldExpression) {
            FieldExpression fieldExpr = (FieldExpression)expr;
            fieldSymbol = (FieldSymbol)fieldExpr.field;
            fieldSymbol.flags = (short)(fieldSymbol.flags | 0x2000);
        }
        return expr;
    }

    Expression resolveAndCheckReadBeforeWrite(Parser parser) {
        Expression expr = this._resolveAndCheck(parser, false);
        FieldSymbol fieldSymbol = FieldExpression.getFieldSymbol(parser, expr);
        if (fieldSymbol != null) {
            int index = fieldSymbol.index;
            parser.defSet.set(index);
            parser.posSet.set(index);
        }
        if (expr instanceof FieldExpression) {
            FieldExpression fieldExpr = (FieldExpression)expr;
            fieldSymbol = (FieldSymbol)fieldExpr.field;
            if (!parser.suspendDataFlowChecking && (fieldSymbol.access & 0x10) != 0) {
                parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
            }
            fieldSymbol.flags = (short)(fieldSymbol.flags | 0x2000);
        }
        return expr;
    }

    Expression resolveAndCheckWrite(Parser parser) {
        return this._resolveAndCheck(parser, true);
    }

    void markDefined(Parser parser) {
        FieldSymbol fieldSymbol = FieldExpression.getFieldSymbol(parser, this);
        if (fieldSymbol != null) {
            int index = fieldSymbol.index;
            if (!parser.suspendDataFlowChecking) {
                if ((fieldSymbol.access & 0x10) != 0 && (fieldSymbol.flags & 0x11) != 1) {
                    if (parser.defSet.get(index) || parser.posSet.get(index)) {
                        parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                    } else if (parser.innerSwitchLoop != null && parser.innerSwitchLoop.inLoop()) {
                        LoopStatement loopStatement = parser.innerSwitchLoop.getLoopStatement();
                        if (!$assertionsDisabled && loopStatement.bodyStatements.first == null) {
                            throw new AssertionError();
                        }
                        if (parser.currentStatement == loopStatement) {
                            if (!loopStatement.bodyStatements.last.isLoopExitStatement()) {
                                parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                            }
                        } else if (!parser.currentStatement.parent.last.isLoopExitStatement() && !parser.resolvingForCondition) {
                            loopStatement.possibleReinitialization(this.pos, fieldSymbol);
                        }
                    }
                }
            } else if ((fieldSymbol.access & 0x10) != 0) {
                if (parser.currentFieldSymbol != null && (fieldSymbol.flags & 1) == 0 && parser.defSet.get(index)) {
                    parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                } else if ((fieldSymbol.flags & 0x10) != 0 && this.pos != 0) {
                    parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
                }
            }
            parser.defSet.set(index);
            parser.posSet.set(index);
        } else if (!parser.suspendDataFlowChecking) {
            fieldSymbol = (FieldSymbol)this.field;
            if ((fieldSymbol.access & 0x10) != 0) {
                parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
            }
        }
    }

    void markUsed(Parser parser) {
        FieldSymbol fieldSymbol = FieldExpression.getFieldSymbol(parser, this);
        if (fieldSymbol != null) {
            parser.useSet.set(fieldSymbol.index);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        TypeSymbol fieldType;
        short index;
        Expression thisArg;
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        RawClassSymbol classSymbol = fieldSymbol.definingClass;
        Parser parser = byteCodeGenerator.parser;
        RawClassSymbol currentClassSymbol = parser.currentClassSymbol;
        if ((fieldSymbol.flags & 1) != 0 && classSymbol.isInnerClass() && currentClassSymbol.equalTo(classSymbol) && parser.currentMethodSymbol.isConstructor()) {
            InnerClassSymbol innerClassSymbol = (InnerClassSymbol)classSymbol;
            InnerClassSymbol.HiddenArgumentList hal = innerClassSymbol.hiddenArgumentList;
            while (hal != null) {
                if (hal.fieldSymbol == fieldSymbol) {
                    if (hal.kind == 0 || hal.kind == 1) {
                        byteCodeGenerator.loadLocalVariable(fieldSymbol.type, hal.stackVarIndex);
                    } else {
                        if (!$assertionsDisabled && hal.kind != 2) {
                            throw new AssertionError();
                        }
                        byteCodeGenerator.loadLocalVariable(fieldSymbol.type, (short)(parser.currentMethodSymbol.actualArgCount - hal.stackVarIndex));
                    }
                    return;
                }
                hal = hal.next;
            }
        }
        if ((thisArg = this.thisArgument) != null) {
            classSymbol = ((ClassSymbol)thisArg.getType()).getClassSymbol();
            if (classSymbol.isInnerClass() && thisArg instanceof ThisExpression) {
                RawClassSymbol outerClass = fieldSymbol.definingClass;
                if (((ThisExpression)thisArg).outerClassSymbol != null) {
                    outerClass = (RawClassSymbol)((ThisExpression)thisArg).outerClassSymbol;
                }
                if (!(outerClass.equalTo(classSymbol) || outerClass.isSuperclass(classSymbol) && fieldSymbol.isAccessible(currentClassSymbol, classSymbol) || outerClass.isInterface() && classSymbol.implementsInterface(outerClass))) {
                    if (!byteCodeGenerator.parser.currentMethodSymbol.isConstructor()) {
                        byteCodeGenerator.loadLocalVariable(classSymbol, (short)0);
                    }
                    classSymbol = byteCodeGenerator.generateOuterClassFieldAccessor(fieldSymbol.definingClass, classSymbol, false);
                } else {
                    thisArg.generateByteCode(byteCodeGenerator);
                }
            } else {
                thisArg.generateByteCode(byteCodeGenerator);
            }
            if ((fieldSymbol.access & 8) != 0) {
                this.thisArgument = null;
            }
        } else if (this.qualification != null) {
            classSymbol = this.qualification.getClassSymbol();
        }
        if (this.useAccessor) {
            MethodSymbol methodSymbol = byteCodeGenerator.generateReadAccessor(fieldSymbol);
            index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
            if ((fieldSymbol.access & 8) != 0) {
                if (thisArg != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
            byteCodeGenerator.generate_8_16((byte)-72, index);
        } else if ((fieldSymbol.access & 8) != 0 && (fieldSymbol.flags & 2) != 0) {
            if (thisArg != null) {
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            fieldSymbol.initializer.generateByteCode(byteCodeGenerator);
        } else {
            index = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(classSymbol.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
            if ((fieldSymbol.access & 8) == 0) {
                byteCodeGenerator.generate_8_16((byte)-76, index);
            } else {
                if (thisArg != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
                byteCodeGenerator.generate_8_16((byte)-78, index);
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        TypeSymbol typeSymbol = this.getType();
        if ((typeSymbol.typeClass & 0x28) != 0) {
            byteCodeGenerator.incOpStackHeight(1);
        }
        if (!typeSymbol.equalTo(fieldType = fieldSymbol.type.eraseType())) {
            index = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
            byteCodeGenerator.generate_8_16((byte)-64, index);
        }
        byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(currentClassSymbol, classSymbol);
        if (this.qualification != null) {
            currentClassSymbol.addNameReference(byteCodeGenerator.parser, this.qualification, this.pos);
        }
        currentClassSymbol.addNameReference(parser, fieldSymbol, this.fieldPos);
    }

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean x1) {
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        RawClassSymbol classSymbol = fieldSymbol.definingClass;
        RawClassSymbol currentClassSymbol = byteCodeGenerator.parser.currentClassSymbol;
        Expression thisArg = this.thisArgument;
        if (thisArg != null) {
            classSymbol = ((ClassSymbol)thisArg.getType()).getClassSymbol();
            if ((fieldSymbol.access & 8) != 0) {
                this.thisArgument = null;
            }
            if (!byteCodeGenerator.methodSymbol.isConstructor() || !classSymbol.isInnerClass() || fieldSymbol.definingClass.equalTo(classSymbol) || fieldSymbol.definingClass.isSuperclass(classSymbol)) {
                thisArg.generateByteCode(byteCodeGenerator);
            }
        } else if (this.qualification != null) {
            classSymbol = this.qualification.getClassSymbol();
        }
        if (classSymbol.isInnerClass() && !fieldSymbol.definingClass.equalTo(classSymbol) && !fieldSymbol.definingClass.isSuperclass(classSymbol)) {
            classSymbol = byteCodeGenerator.generateOuterClassFieldAccessor(fieldSymbol.definingClass, classSymbol, false);
        }
        if (this.useAccessor) {
            if ((fieldSymbol.access & 8) == 0) {
                byteCodeGenerator.generate_8(x1 ? (byte)90 : 89);
                byteCodeGenerator.incOpStackHeight(1);
            }
            MethodSymbol methodSymbol = byteCodeGenerator.generateReadAccessor(fieldSymbol);
            short index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
            if ((fieldSymbol.access & 8) != 0) {
                if (thisArg != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
            byteCodeGenerator.generate_8_16((byte)-72, index);
        } else {
            short index = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(classSymbol.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
            if ((fieldSymbol.access & 8) == 0) {
                byteCodeGenerator.generate_8(x1 ? (byte)90 : 89);
                byteCodeGenerator.generate_8_16((byte)-76, index);
                byteCodeGenerator.incOpStackHeight(1);
            } else {
                if (thisArg != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
                byteCodeGenerator.generate_8_16((byte)-78, index);
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        if ((this.getType().typeClass & 0x28) != 0) {
            byteCodeGenerator.incOpStackHeight(1);
        }
        byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(currentClassSymbol, classSymbol);
        if (this.qualification != null) {
            currentClassSymbol.addNameReference(byteCodeGenerator.parser, this.qualification, this.pos);
        }
        currentClassSymbol.addNameReference(byteCodeGenerator.parser, fieldSymbol, this.fieldPos);
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        RawClassSymbol classSymbol = fieldSymbol.definingClass;
        RawClassSymbol currentClassSymbol = byteCodeGenerator.parser.currentClassSymbol;
        if (this.thisArgument != null) {
            classSymbol = ((ClassSymbol)this.thisArgument.getType()).getClassSymbol();
        } else if (this.qualification != null) {
            classSymbol = this.qualification.getClassSymbol();
        }
        if (classSymbol.isInnerClass() && !fieldSymbol.definingClass.equalTo(classSymbol) && !fieldSymbol.definingClass.isSuperclass(classSymbol)) {
            RawClassSymbol outerClass = fieldSymbol.definingClass;
            RawClassSymbol innerClass = classSymbol;
            while (!outerClass.equalTo(classSymbol = innerClass.getOuterClass()) && !outerClass.isSuperclass(classSymbol)) {
                innerClass = classSymbol;
            }
        }
        if (this.useAccessor) {
            MethodSymbol methodSymbol = byteCodeGenerator.generateWriteAccessor(fieldSymbol);
            short index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
            byteCodeGenerator.generate_8_16((byte)-72, index);
            if ((fieldSymbol.access & 8) == 0) {
                byteCodeGenerator.decOpStackHeight(1);
            } else if (this.thisArgument != null) {
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
        } else {
            short index = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(classSymbol.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
            if ((fieldSymbol.access & 8) != 0) {
                byteCodeGenerator.generate_8_16((byte)-77, index);
                if (this.thisArgument != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
            } else {
                byteCodeGenerator.generate_8_16((byte)-75, index);
                byteCodeGenerator.decOpStackHeight(1);
            }
        }
        byteCodeGenerator.decOpStackHeight(1);
        if ((this.getType().typeClass & 0x28) != 0) {
            byteCodeGenerator.decOpStackHeight(1);
        }
        byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(currentClassSymbol, classSymbol);
        if (this.qualification != null) {
            currentClassSymbol.addNameReference(byteCodeGenerator.parser, this.qualification, this.pos);
        }
        currentClassSymbol.addNameReference(byteCodeGenerator.parser, fieldSymbol, this.fieldPos);
    }

    static {
        $assertionsDisabled = !FieldExpression.class.desiredAssertionStatus();
    }
}

