/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArrayElementValue;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassExpression;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.ElementValue;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.TypeSymbol;

final class ExpressionElementValue
extends ElementValue {
    Expression expr;
    private short constantValueIndex;
    private short typeIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    ExpressionElementValue(Identifier elementName, Expression expr, int pos, boolean defaultValue, boolean arrayElement) {
        super(elementName, pos, defaultValue, arrayElement);
        this.expr = expr;
    }

    ElementValue resolveAndCheck(Parser parser, Annotation annotation) {
        super.resolveAndCheck(parser, annotation);
        Expression eexpr = this.expr.resolveAndCheck(parser);
        eexpr = eexpr.foldExpression();
        TypeSymbol exprType = eexpr.getType();
        RawClassSymbol annotationType = ((ClassSymbol)annotation.annotationType).getClassSymbol();
        if (eexpr == ErrorExpression.errorExpression || exprType.isErroneous()) {
            annotationType.flags = (short)(annotationType.flags | 0x10);
            return this;
        }
        if (exprType.isEnum()) {
            if (!(eexpr instanceof FieldExpression)) {
                parser.error(Message.errorConstantRequired, eexpr.pos, false);
                annotationType.flags = (short)(annotationType.flags | 0x10);
                return this;
            }
            FieldExpression fieldExpr = (FieldExpression)eexpr;
            FieldSymbol enumField = (FieldSymbol)fieldExpr.field;
            if ((enumField.access & 0x4000) == 0) {
                parser.error(Message.errorConstantRequired, eexpr.pos, false);
                annotationType.flags = (short)(annotationType.flags | 0x10);
                return this;
            }
        } else if (eexpr.kind == 2) {
            if (this.expr instanceof FieldExpression && ((FieldExpression)this.expr).thisArgument != null) {
                parser.error(Message.errorConstantRequired, eexpr.pos, false);
                annotationType.flags = (short)(annotationType.flags | 0x10);
                return this;
            }
        } else if (eexpr instanceof FieldExpression) {
            if (((FieldExpression)eexpr).thisArgument != null) {
                parser.error(Message.errorConstantRequired, eexpr.pos, false);
                annotationType.flags = (short)(annotationType.flags | 0x10);
                return this;
            }
            FieldExpression fieldExpr = (FieldExpression)eexpr;
            FieldSymbol fieldSymbol = (FieldSymbol)fieldExpr.field;
            if (fieldSymbol.initializer == null || (fieldSymbol.flags & 2) == 0) {
                parser.error(Message.errorConstantRequired, eexpr.pos, false);
                annotationType.flags = (short)(annotationType.flags | 0x10);
                return this;
            }
            eexpr = fieldSymbol.initializer;
        } else if (eexpr.kind != 48) {
            parser.error(Message.errorConstantRequired, eexpr.pos, false);
            annotationType.flags = (short)(annotationType.flags | 0x10);
            return this;
        }
        this.expr = eexpr;
        ElementValue ev = this;
        if (this.typeSymbol.isArrayType()) {
            ArrayList<ExpressionElementValue> list = new ArrayList<ExpressionElementValue>(1);
            list.add(this);
            ev = new ArrayElementValue(this.elementName, list, this.pos, (this.flags & 1) != 0, false);
            ev.typeSymbol = this.typeSymbol;
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            this.flags = (byte)(this.flags | 2);
            this.typeSymbol = ((ArraySymbol)this.typeSymbol).baseType;
        }
        if (!exprType.equalTo(this.typeSymbol)) {
            if (exprType.isNumericType() && this.typeSymbol.isNumericType()) {
                this.expr = this.expr.promoteType(parser, this.typeSymbol);
                if (this.expr.kind == 0) {
                    annotationType.flags = (short)(annotationType.flags | 0x10);
                }
            } else {
                parser.error(Message.errorIncompatibleTypes, this.pos, false, exprType.errorName(), this.typeSymbol.errorName());
                annotationType.flags = (short)(annotationType.flags | 0x10);
            }
        }
        return ev;
    }

    int getAttributeLength() {
        return super.getAttributeLength() + (this.tag == 101 ? 4 : 2);
    }

    void generateConstantPoolEntries(ClassFileWriter cfw, ConstantPool cp) {
        super.generateConstantPoolEntries(cfw, cp);
        TypeSymbol typeSymbol = this.expr.getType();
        block0 : switch (typeSymbol.typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 2: {
                int ival = ((BooleanConstantExpression)this.expr).bval ? 1 : 0;
                this.constantValueIndex = cp.enterConstantPoolInteger(ival);
                this.tag = (byte)90;
                break;
            }
            case 4: {
                int ival = typeSymbol.typeKind == 4 ? ((CharConstantExpression)this.expr).cval & 0xFFFF : ((IntConstantExpression)this.expr).ival;
                this.constantValueIndex = cp.enterConstantPoolInteger(ival);
                switch (typeSymbol.typeKind) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        this.tag = (byte)66;
                        break block0;
                    }
                    case 4: {
                        this.tag = (byte)67;
                        break block0;
                    }
                    case 5: {
                        this.tag = (byte)83;
                        break block0;
                    }
                    case 6: 
                }
                this.tag = (byte)73;
                break;
            }
            case 8: {
                this.constantValueIndex = cp.enterConstantPoolLong(((LongConstantExpression)this.expr).lval);
                this.tag = (byte)74;
                break;
            }
            case 16: {
                this.constantValueIndex = cp.enterConstantPoolFloat(((FloatConstantExpression)this.expr).fval);
                this.tag = (byte)70;
                break;
            }
            case 32: {
                this.constantValueIndex = cp.enterConstantPoolDouble(((DoubleConstantExpression)this.expr).dval);
                this.tag = (byte)68;
                break;
            }
            case 64: {
                if (typeSymbol.isEnum()) {
                    this.typeIndex = cp.enterConstantPoolUtf8(((FieldExpression)this.expr).getType().getSignature());
                    this.constantValueIndex = cp.enterConstantPoolUtf8(((FieldExpression)this.expr).field.identifier.name);
                    this.tag = (byte)101;
                    break;
                }
                if (typeSymbol.equalTo(cfw.parser.javaLangClassSymbol)) {
                    this.constantValueIndex = cp.enterConstantPoolUtf8(((ClassExpression)this.expr).classType.getSignature());
                    this.tag = (byte)99;
                    break;
                }
                this.constantValueIndex = cp.enterConstantPoolUtf8(((StringConstantExpression)this.expr).sval);
                this.tag = (byte)115;
            }
        }
    }

    void write(ClassFileWriter cfw) throws IOException {
        super.write(cfw);
        if (this.tag == 101) {
            int wbIdx = cfw.ensureWriteBufferCapacity(4);
            byte[] wb = cfw.writeBuffer;
            wb[wbIdx + 3] = (byte)this.constantValueIndex;
            wb[wbIdx + 2] = (byte)(this.constantValueIndex >> 8);
            wb[wbIdx + 1] = (byte)this.typeIndex;
            wb[wbIdx] = (byte)(this.typeIndex >> 8);
            cfw.writeBufferIndex = wbIdx + 4;
        } else {
            int wbIdx = cfw.ensureWriteBufferCapacity(2);
            byte[] wb = cfw.writeBuffer;
            wb[wbIdx + 1] = (byte)this.constantValueIndex;
            wb[wbIdx] = (byte)(this.constantValueIndex >> 8);
            cfw.writeBufferIndex = wbIdx + 2;
        }
    }

    static {
        $assertionsDisabled = !ExpressionElementValue.class.desiredAssertionStatus();
    }
}

