/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;

final class EnumMapClassSymbol
extends AnonymousClassSymbol {
    EnumDescriptor enumList;
    static final /* synthetic */ boolean $assertionsDisabled;

    EnumMapClassSymbol(Parser parser, RawClassSymbol classSymbol) {
        super(0, (short)4104);
        if (!$assertionsDisabled && !parser.targetingAtLeastOneFive) {
            throw new AssertionError();
        }
        this.superClass = parser.javaLangObjectPcs;
        this.flags = (short)(this.flags | 0x120);
        this.cd.ccd.sourceFile = classSymbol.cd.ccd.sourceFile;
        this.scope = classSymbol.classScope;
        this.classScope = new ClassScope(this, classSymbol.classScope, parser);
        this.cd.ccd.constantPool = new ConstantPool(parser);
        parser.classResolutionList.classSymbolList.add(this);
        classSymbol.addInnerClass(this);
        this.getClassInitializer();
    }

    boolean isLocalInnerClass() {
        return false;
    }

    static EnumMapClassSymbol getEnumMapClass(Parser parser, RawClassSymbol classSymbol) {
        TypeSymbolList tsl = classSymbol.cd.innerClassList;
        while (tsl != null) {
            if (tsl.typeSymbol instanceof EnumMapClassSymbol) {
                return (EnumMapClassSymbol)tsl.typeSymbol;
            }
            tsl = tsl.next;
        }
        return new EnumMapClassSymbol(parser, classSymbol);
    }

    private Identifier getEnumMapName(RawClassSymbol enumClassSymbol, int level) {
        StringBuffer sb = new StringBuffer(Identifier.dollarString + "sm$");
        while (--level >= 0) {
            sb.append('$');
        }
        sb.append(enumClassSymbol.getInternalName());
        String name = sb.toString().replace('/', '$');
        return Identifier.getIdentifier(name);
    }

    private FieldSymbol addNewEnumMap(RawClassSymbol enumClassSymbol) {
        int level = 0;
        while (true) {
            Identifier identifier;
            FieldSymbol field;
            if ((field = (FieldSymbol)this.classScope.lookupSpecificSymbolInScope(identifier = this.getEnumMapName(enumClassSymbol, level), 2, true)) == null) {
                field = new FieldSymbol(0, this, identifier, ArraySymbol.getArrayType(TypeSymbol.intSymbol, 1), 0, 4120, null);
                field.flags = (short)(field.flags | 0xFFFFA001);
                this.addField(field);
                return field;
            }
            ++level;
        }
    }

    private EnumDescriptor addEnumDescriptor(RawClassSymbol enumClassSymbol) {
        EnumDescriptor el = new EnumDescriptor();
        el.enumClassSymbol = enumClassSymbol;
        el.enumConstList = new ArrayList();
        el.enumMapField = this.addNewEnumMap(enumClassSymbol);
        el.next = this.enumList;
        this.enumList = el;
        return el;
    }

    int getEnumConst(RawClassSymbol enumClassSymbol, FieldSymbol enumConstSymbol) {
        EnumDescriptor el = this.enumList;
        while (el != null) {
            if (el.enumClassSymbol == enumClassSymbol) {
                int cnt = el.enumConstList.size();
                for (int i = 0; i < cnt; ++i) {
                    if (enumConstSymbol != el.enumConstList.get(i)) continue;
                    return i + 1;
                }
                el.enumConstList.add(enumConstSymbol);
                return cnt + 1;
            }
            el = el.next;
        }
        el = this.addEnumDescriptor(enumClassSymbol);
        el.enumConstList.add(enumConstSymbol);
        return 1;
    }

    char[] getMapName(RawClassSymbol enumClassSymbol) {
        EnumDescriptor el = this.enumList;
        while (el != null) {
            if (el.enumClassSymbol == enumClassSymbol) {
                return el.enumMapField.identifier.name;
            }
            el = el.next;
        }
        return this.addEnumDescriptor((RawClassSymbol)enumClassSymbol).enumMapField.identifier.name;
    }

    static {
        $assertionsDisabled = !EnumMapClassSymbol.class.desiredAssertionStatus();
    }

    static final class EnumDescriptor {
        EnumDescriptor next;
        RawClassSymbol enumClassSymbol;
        ArrayList enumConstList;
        FieldSymbol enumMapField;

        EnumDescriptor() {
        }
    }
}

