/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.Symbol;

final class EndOfScopeStatement
extends Statement {
    Object scopeOrDeclList;
    static final /* synthetic */ boolean $assertionsDisabled;

    EndOfScopeStatement(StatementList parent, Object scopeOrDeclList) {
        super(parent, 0, (byte)21);
        if (!$assertionsDisabled && scopeOrDeclList == null) {
            throw new AssertionError();
        }
        this.scopeOrDeclList = scopeOrDeclList;
    }

    void resolveAndCheck(Parser parser) {
        if (parser.suspendDataFlowChecking) {
            Symbol[] declList = this.scopeOrDeclList instanceof Scope ? ((Scope)this.scopeOrDeclList).getSymbols() : (Symbol[])this.scopeOrDeclList;
            int size = declList.length;
            for (int i = 0; i < size; ++i) {
                Symbol symbol = declList[i];
                if (!(symbol instanceof MethodVariableSymbol)) continue;
                MethodVariableSymbol variable = (MethodVariableSymbol)symbol;
                variable.flags = (byte)(variable.flags | 8);
            }
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        int pc = byteCodeGenerator.generateGetPC() & 0xFFFF;
        Symbol[] declList = this.scopeOrDeclList instanceof Scope ? ((Scope)this.scopeOrDeclList).getSymbols() : (Symbol[])this.scopeOrDeclList;
        int size = declList.length;
        for (int i = 0; i < size; ++i) {
            Symbol symbol = declList[i];
            if (!(symbol instanceof MethodVariableSymbol)) continue;
            MethodVariableSymbol variable = (MethodVariableSymbol)symbol;
            variable.endPC = (short)pc;
        }
    }

    boolean isCodeStatement() {
        if (this.next == null) {
            return false;
        }
        this.pos = this.next.pos;
        return this.next.isCodeStatement();
    }

    boolean canReachNextStatement(boolean strict) {
        if (this.prev != null) {
            return this.prev.canReachNextStatement(strict);
        }
        return true;
    }

    static {
        $assertionsDisabled = !EndOfScopeStatement.class.desiredAssertionStatus();
    }
}

