/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;

final class DynamicInitializationStatement
extends Statement {
    private MethodSymbol dynamicInitializer;

    DynamicInitializationStatement(StatementList parent, MethodSymbol dynamicInitializer) {
        super(parent, 0, (byte)20);
        this.dynamicInitializer = dynamicInitializer;
    }

    void resolveAndCheck(Parser parser) {
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        StatementList code = this.dynamicInitializer.cmd.statementList;
        if (code != null) {
            MethodSymbol currentMethod = byteCodeGenerator.methodSymbol;
            if (this.dynamicInitializer.cmd.localVariables != null) {
                for (int i = 1; i < this.dynamicInitializer.cmd.localVariables.size(); ++i) {
                    MethodVariableSymbol localVariable = (MethodVariableSymbol)this.dynamicInitializer.cmd.localVariables.get(i);
                    if (localVariable != null) {
                        localVariable.varStackIndex = currentMethod.localVarCount;
                    }
                    currentMethod.localVarCount = (short)(currentMethod.localVarCount + 1);
                    currentMethod.cmd.localVariables.add(localVariable);
                }
            }
            code.generateByteCode(byteCodeGenerator);
        }
    }
}

