/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ojc.compiler.DepClassFileInfo;

public class DepSourceFileInfo {
    String fullName;
    Vector classFiles;
    int index;
    long modDate;
    HashSet usedBy;

    DepSourceFileInfo(String sourceFile, long modDate) {
        this.fullName = sourceFile;
        this.index = 0;
        this.classFiles = new Vector();
        this.usedBy = new HashSet();
        this.modDate = modDate;
    }

    DepSourceFileInfo(String sourceFile, long modDate, ArrayList defs, Hashtable classes) {
        this(sourceFile, modDate);
        if (defs != null) {
            for (int i = 0; i < defs.size(); ++i) {
                DepClassFileInfo cfi = (DepClassFileInfo)defs.get(i);
                if (!cfi.rcs.isClass()) continue;
                DepClassFileInfo tmp = (DepClassFileInfo)classes.get(cfi.getClassName());
                if (tmp == null) {
                    System.out.println("warning: SourceFileInfo(), shouldn't be null");
                    classes.put(cfi.getClassName(), cfi);
                } else {
                    if (tmp != cfi) {
                        tmp.rcs = cfi.rcs;
                        tmp.modDate = cfi.modDate;
                        tmp.depClasses = cfi.depClasses;
                        System.out.println("warning: SourceFileInfo(), shouldn't be different");
                    }
                    cfi = tmp;
                }
                this.classFiles.addElement(cfi);
            }
        }
    }

    public DepClassFileInfo[] getClassFiles() {
        return this.classFiles.toArray(new DepClassFileInfo[this.classFiles.size()]);
    }

    public DepClassFileInfo[] getUsedBy() {
        return this.usedBy.toArray(new DepClassFileInfo[this.usedBy.size()]);
    }

    public String getSourceFileName() {
        return this.fullName;
    }
}

