/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.LabelStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.SwitchStatement;

final class DefaultStatement
extends LabelStatement {
    DefaultStatement(StatementList parent, int pos) {
        super(parent, pos, (byte)6, null);
    }

    void resolveAndCheck(Parser parser) {
        SwitchLoopList switchRec = parser.innerSwitchLoop;
        while (switchRec != null && switchRec.switchStmt == null) {
            switchRec = switchRec.outerSwitchLoop;
        }
        if (switchRec == null) {
            parser.error(Message.errorOrphanedSymbol, this.pos, false, "default");
        } else {
            SwitchStatement switchStmt = switchRec.switchStmt;
            if (switchStmt.bodyStatements != this.parent) {
                parser.error(Message.errorOrphanedSymbol, this.pos, false, "default");
            }
            if (switchStmt.defaultStmt != this) {
                if (switchStmt.defaultStmt != null) {
                    parser.error(Message.errorDuplicateDefault, this.pos, false);
                }
                switchStmt.defaultStmt = this;
            }
            parser.defSet = (BitSet)switchRec.defSet.clone();
            if (this.prev != null) {
                if (!this.prev.canReachNextStatement(false)) {
                    parser.posSet = (BitSet)switchRec.posSet.clone();
                } else if (this.prev.kind != 5 && this.prev.kind != 6) {
                    parser.warning(null, Message.warningFallThrough, this.prev.pos);
                }
            }
        }
    }
}

