/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.LabeledStatement;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.SynchronizedStatement;
import oracle.ojc.compiler.TryStatement;

final class ContinueStatement
extends Statement {
    LabelSymbol labelSymbol;
    LabelSymbol continueSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    ContinueStatement(StatementList parent, int pos, LabelSymbol labelSymbol) {
        super(parent, pos, (byte)10);
        this.labelSymbol = labelSymbol;
    }

    void resolveAndCheck(Parser parser) {
        this.parent.updateDefUseSetsAfterContinue(parser, this.labelSymbol);
        if (this.labelSymbol != null) {
            LabeledStatement labeledStatement = this.labelSymbol.labeledStatement;
            if (labeledStatement != null) {
                StatementList statementList = labeledStatement.labeledStatements;
                if (statementList == null || statementList.first != (statementList.last.kind == 21 ? statementList.last.prev : statementList.last) || !(statementList.first instanceof LoopStatement) || labeledStatement.labelList.symbol != this.labelSymbol) {
                    parser.error(Message.errorNotLoopLabel, this.pos, false, this.labelSymbol.identifier.toString());
                } else {
                    LoopStatement loop = (LoopStatement)statementList.first;
                    this.continueSymbol = loop.loopRec.getContinueSymbol();
                }
            }
        } else {
            SwitchLoopList switchLoop = parser.innerSwitchLoop;
            while (switchLoop != null && switchLoop.loopStmt == null) {
                switchLoop = switchLoop.outerSwitchLoop;
            }
            if (switchLoop == null) {
                parser.error(Message.errorContinueOutside, this.pos, false);
            } else {
                this.continueSymbol = switchLoop.getContinueSymbol();
            }
        }
        this.setLastStatement();
        if (this.next != null && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        SwitchLoopList sll;
        Statement stmt;
        if (this.labelSymbol != null) {
            stmt = this.labelSymbol.labeledStatement;
        } else {
            sll = byteCodeGenerator.parser.innerSwitchLoop;
            while (true) {
                if (!$assertionsDisabled && sll == null) {
                    throw new AssertionError();
                }
                if (sll.loopStmt != null) {
                    stmt = sll.loopStmt;
                    break;
                }
                sll = sll.outerSwitchLoop;
            }
        }
        StatementList statementList = this.parent;
        SwitchLoopList savedSll = sll = byteCodeGenerator.parser.innerSwitchLoop;
        while (true) {
            if (!$assertionsDisabled && statementList.parent == null) {
                throw new AssertionError();
            }
            if (statementList.parent == stmt) break;
            switch (statementList.parent.kind) {
                case 17: {
                    TryStatement tryStmt = (TryStatement)statementList.parent;
                    if (tryStmt.finallyBody == null || tryStmt.finallyBody == statementList) break;
                    if (!byteCodeGenerator.parser.targetingAtLeastOneFive) {
                        if (tryStmt.finallyLabel == null) {
                            tryStmt.finallyLabel = new Label();
                        }
                        byteCodeGenerator.generateBranch_jsr(tryStmt.finallyLabel);
                        break;
                    }
                    byteCodeGenerator.parser.innerSwitchLoop = sll;
                    tryStmt.finallyBody.generateByteCode(byteCodeGenerator);
                    byteCodeGenerator.parser.innerSwitchLoop = savedSll;
                    break;
                }
                case 15: {
                    SynchronizedStatement syncStmt = (SynchronizedStatement)statementList.parent;
                    byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, syncStmt.localVar);
                    byteCodeGenerator.generate_8((byte)-61);
                    byteCodeGenerator.decOpStackHeight(1);
                }
            }
            if (sll.switchStmt != null && sll.switchStmt.bodyStatements == statementList || sll.loopStmt != null && sll.loopStmt.bodyStatements == statementList) {
                sll = sll.outerSwitchLoop;
            }
            statementList = statementList.parent.parent;
        }
        if (this.continueSymbol != null) {
            byteCodeGenerator.generateBranch_goto(this.continueSymbol.label);
        } else if (!$assertionsDisabled && !byteCodeGenerator.parser.errorFound) {
            throw new AssertionError();
        }
    }

    boolean canReachNextStatement(boolean strict) {
        return false;
    }

    static {
        $assertionsDisabled = !ContinueStatement.class.desiredAssertionStatus();
    }
}

