/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ConstantPoolEntry;
import oracle.ojc.compiler.Identifier;

abstract class ConstantPoolRef
extends ConstantPoolEntry {
    char[] className;
    char[] name;
    char[] signature;
    short classIndex;
    short nameAndTypeIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    ConstantPoolRef(byte kind, ConstantPool constantPool, char[] className, char[] name, char[] signature) {
        super(kind);
        this.className = className;
        this.name = name;
        this.signature = signature;
        this.classIndex = constantPool.enterConstantPoolClass(className);
        this.nameAndTypeIndex = constantPool.enterConstantPoolNameAndType(name, signature);
    }

    int write(ClassFileWriter cfw) throws IOException {
        int wbIdx = cfw.ensureWriteBufferCapacity(5);
        byte[] wb = cfw.writeBuffer;
        wb[wbIdx + 4] = (byte)this.nameAndTypeIndex;
        wb[wbIdx + 3] = (byte)(this.nameAndTypeIndex >> 8);
        wb[wbIdx + 2] = (byte)this.classIndex;
        wb[wbIdx + 1] = (byte)(this.classIndex >> 8);
        wb[wbIdx] = this.tag;
        cfw.writeBufferIndex = wbIdx + 5;
        return 0;
    }

    public int hashCode() {
        if (!($assertionsDisabled || this.className != null && this.name != null && this.signature != null)) {
            throw new AssertionError();
        }
        if (this.hash == 0) {
            this.hash = Identifier.hashCode(this.className) + Identifier.hashCode(this.name) + Identifier.hashCode(this.signature);
        }
        return this.hash;
    }

    static {
        $assertionsDisabled = !ConstantPoolRef.class.desiredAssertionStatus();
    }
}

