/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPoolEntry;

final class ConstantPoolFloat
extends ConstantPoolEntry {
    ConstantPoolFloat nextHashed;
    int bits;

    ConstantPoolFloat(int bits) {
        super((byte)4);
        this.bits = bits;
    }

    int write(ClassFileWriter cfw) throws IOException {
        int wbIdx = cfw.ensureWriteBufferCapacity(5);
        byte[] wb = cfw.writeBuffer;
        wb[wbIdx + 4] = (byte)this.bits;
        wb[wbIdx + 3] = (byte)(this.bits >> 8);
        wb[wbIdx + 2] = (byte)(this.bits >> 16);
        wb[wbIdx + 1] = (byte)(this.bits >> 24);
        wb[wbIdx] = 4;
        cfw.writeBufferIndex = wbIdx + 5;
        return 0;
    }

    static int hashCode(int bits) {
        return bits;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = ConstantPoolFloat.hashCode(this.bits);
        }
        return this.hash;
    }
}

