/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.LogProxy;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.OJCDEBUG;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.Warning;
import oracle.ojc.compiler.WrappedStorage;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public final class Compiler {
    static byte[] loadBuffer;
    private Parser parser;
    private boolean foundDeployables;
    static final /* synthetic */ boolean $assertionsDisabled;

    Compiler(Options options) {
        this.parser = new Parser(options);
        this.foundDeployables = false;
    }

    static void notImplemented() {
        Thread.dumpStack();
        System.exit(-1);
    }

    static int loadFile(Parser parser, Storage sourceFile) {
        int size;
        try {
            sourceFile.open();
            size = sourceFile.size();
            byte[] buffer = loadBuffer;
            if (buffer == null || buffer.length < size) {
                buffer = loadBuffer = new byte[size + 1024];
            }
            sourceFile.read(buffer);
            sourceFile.close();
        }
        catch (Exception e) {
            Error error = new Error(null, Error.errorCannotReadSource, 0, sourceFile.getPath());
            parser.error(error);
            if (loadBuffer == null) {
                loadBuffer = new byte[0];
            }
            return 0;
        }
        return size;
    }

    private static void copyFile(Storage sourceFile, Storage targetDir, Log2 log) {
        try {
            sourceFile.open();
            byte[] buffer = sourceFile.read();
            sourceFile.close();
            Storage targetFile = targetDir.create(sourceFile.getName());
            targetFile.write(buffer, 0, buffer.length);
            targetFile.close();
            if (System.getProperty("resetClassTimestampToSource") != null && targetFile instanceof FileStorage) {
                ((FileStorage)targetFile).setLastModified(sourceFile.modDate());
            }
        }
        catch (Exception e) {
            Error error = new Error(null, Error.errorCannotCopy, 0, sourceFile.getPath(), targetDir.getPath());
            log.printError(error.message.getMessage());
        }
    }

    private static String changeForwardSlashesToBackwardSlashes(String str) {
        if (str != null && File.separator.charAt(0) == '\\') {
            str = str.replace('/', '\\');
        }
        return str;
    }

    private static String[] expandFile(String[] argv, int curIndex, Log2 log) {
        try {
            int i;
            String fileName = argv[curIndex].substring(1);
            if (!new File(fileName).exists()) {
                Error error = new Error(null, Error.errorCannotReadSource, 0, fileName);
                log.printError(error.message.getMessage());
                return null;
            }
            FileInputStream f = new FileInputStream(fileName);
            int fileSize = f.available();
            byte[] buf = new byte[fileSize];
            f.read(buf, 0, fileSize);
            f.close();
            boolean firstChar = false;
            boolean inString = false;
            int argCnt = 0;
            block2: for (i = 0; i < fileSize; ++i) {
                if (buf[i] == 96) {
                    if (i + 1 < fileSize && buf[i + 1] == 10) {
                        buf[i++] = 1;
                        buf[i] = 1;
                        continue;
                    }
                    if (i + 2 < fileSize && buf[i + 1] == 13 && buf[i + 2] == 10) {
                        buf[i++] = 1;
                        buf[i++] = 1;
                        buf[i] = 1;
                        continue;
                    }
                }
                if (!inString && Character.isWhitespace((char)buf[i])) {
                    buf[i] = 0;
                    firstChar = false;
                    continue;
                }
                if (!firstChar) {
                    if (buf[i] == 35) {
                        while (i < fileSize) {
                            byte b = buf[i];
                            buf[i] = 0;
                            if (b == 10) continue block2;
                            ++i;
                        }
                        continue;
                    }
                    firstChar = true;
                    ++argCnt;
                }
                if (buf[i] != 34) continue;
                buf[i] = 0;
                inString = !inString;
            }
            if (argCnt == 0) {
                return argv;
            }
            String[] newArgv = new String[argCnt + argv.length - 1];
            if (curIndex > 0) {
                System.arraycopy(argv, 0, newArgv, 0, curIndex);
            }
            if (curIndex + 1 < argv.length) {
                System.arraycopy(argv, curIndex + 1, newArgv, curIndex + argCnt, argv.length - (curIndex + 1));
            }
            for (i = 0; i < fileSize; ++i) {
                if (buf[i] == 0) continue;
                int len = 0;
                int j = i;
                while (j < fileSize && buf[j] != 0) {
                    if (buf[j++] == 1) continue;
                    ++len;
                }
                byte[] tmpbuf = new byte[len];
                len = 0;
                while (i < fileSize && buf[i] != 0) {
                    if (buf[i] != 1) {
                        tmpbuf[len++] = buf[i];
                    }
                    ++i;
                }
                newArgv[curIndex++] = Compiler.changeForwardSlashesToBackwardSlashes(new String(tmpbuf));
            }
            return newArgv;
        }
        catch (Throwable e) {
            return argv;
        }
    }

    private static void banner(Log log) {
        log.println("Oracle Java Compiler 11.1.1");
        log.println("Copyright (c) 1997-2009 Oracle Corporation. All Rights Reserved.");
    }

    static void standardUsage(Log log) {
        Compiler.banner(log);
        log.println(Message.usageString + ": ojc <" + Message.optionsString + "> <" + Message.sourceFilesString + "> <@" + Message.argumentFilesString + ">");
        log.println(Message.standardUsageScreen);
    }

    static void nonstandardUsage(Log log) {
        Compiler.banner(log);
        log.println(Message.nonStandardUsageScreen);
    }

    static void help(Log2 log, String option) {
        if (option.startsWith("-")) {
            option = option.substring(1);
        }
        boolean loaded = false;
        try {
            int index;
            Locale locale = Locale.getDefault();
            ResourceBundle rb = ResourceBundle.getBundle("oracle.ojc.ojchelp", locale);
            loaded = true;
            String value = rb.getString(option);
            if (value.charAt(0) == '-') {
                value = rb.getString(value.substring(1));
            }
            if ((index = value.indexOf("%%")) >= 0) {
                value = value.replaceAll("%%", File.pathSeparator);
            }
            Compiler.banner(log);
            log.println(value);
        }
        catch (Exception e) {
            if (!loaded) {
                log.printError("can't load OJC resource file");
            }
            log.printError("option not found in OJC resource file");
        }
    }

    private static boolean containsWildcardCharacters(String str) {
        if (!$assertionsDisabled && str == null) {
            throw new AssertionError();
        }
        return str.indexOf(42) >= 0 || str.indexOf(63) >= 0;
    }

    static boolean matches(String s, int soffset, String p, int poffset) {
        if (poffset >= p.length()) {
            return soffset >= s.length();
        }
        if (p.charAt(poffset) == '*') {
            return Compiler.matches(s, soffset, p, poffset + 1) || soffset < s.length() && Compiler.matches(s, soffset + 1, p, poffset);
        }
        if (soffset >= s.length()) {
            return false;
        }
        char sc = s.charAt(soffset);
        char pc = p.charAt(poffset);
        return (pc == '?' || Character.toUpperCase(sc) == Character.toUpperCase(pc) || sc == '/' && pc == '\\' || sc == '\\' && pc == '/') && Compiler.matches(s, soffset + 1, p, poffset + 1);
    }

    private static boolean ignoreDirectory(String[] ignoreDirs, String name) {
        if (ignoreDirs != null) {
            for (int i = 0; i < ignoreDirs.length; ++i) {
                if (!Compiler.matches(name, 0, "*" + ignoreDirs[i], 0)) continue;
                return true;
            }
        }
        return false;
    }

    private static void expandSourceFiles(ArrayList sourceFiles, int curRecurseLevel, int maxRecurseLevel, String[] ignoreDirs, String str) {
        File dir;
        File file = new File(str);
        String pathName = file.getParent();
        String fileName = file.getName();
        if (pathName == null) {
            String string = pathName = str.indexOf(File.separator) == 0 ? "" : ".";
        }
        if ((dir = new File(pathName + File.separator)) == null) {
            sourceFiles.add(new SourcePackageRecord(str, false));
            return;
        }
        String[] files = dir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String fullName = pathName + File.separator + files[i];
                if (new File(fullName).isDirectory() && curRecurseLevel < maxRecurseLevel) {
                    if (Compiler.ignoreDirectory(ignoreDirs, fullName)) continue;
                    Compiler.expandSourceFiles(sourceFiles, curRecurseLevel + 1, maxRecurseLevel, ignoreDirs, fullName + File.separator + fileName);
                    continue;
                }
                if (!Compiler.matches(files[i], 0, fileName, 0)) continue;
                sourceFiles.add(new SourcePackageRecord(fullName, false));
            }
        }
    }

    public static ArrayList parseCommandLine(Log log, String[] args, Options options) {
        LogProxy logProxy = new LogProxy(log);
        if (args.length == 0) {
            Compiler.standardUsage(log);
            return null;
        }
        Warning.defaultAllWarnings();
        ArrayList<SourcePackageRecord> sourceFiles = new ArrayList<SourcePackageRecord>();
        String[] ignoreDirs = null;
        int recurseLevel = 0;
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                ++i;
                continue;
            }
            if (args[i].startsWith("-")) {
                if (args[i].equals("-recurse")) {
                    if (i + 1 < args.length) {
                        try {
                            recurseLevel = Integer.parseInt(args[i + 1]);
                            if (recurseLevel < 0) {
                                recurseLevel = 0;
                            }
                            ++i;
                        }
                        catch (NumberFormatException e) {
                            recurseLevel = Integer.MAX_VALUE;
                        }
                    }
                    ++i;
                    continue;
                }
                if (args[i].equals("-rx")) {
                    if (i + 1 >= args.length) continue;
                    ignoreDirs = Options.stringToArray(args[++i], ",");
                    continue;
                }
                if (args[i].equals("-s")) {
                    ++i;
                    while (i < args.length && !args[i].startsWith("-")) {
                        sourceFiles.add(new SourcePackageRecord(args[i++], false));
                    }
                    continue;
                }
                if (args[i].equals("-p")) {
                    ++i;
                    while (i < args.length && !args[i].startsWith("-")) {
                        sourceFiles.add(new SourcePackageRecord(args[i++], true));
                    }
                    continue;
                }
                int result = options.parseOption(args, i);
                if (result == 0) {
                    return null;
                }
                i += result;
                continue;
            }
            if (args[i].startsWith("@")) {
                if ((args = Compiler.expandFile(args, i, logProxy)) != null) continue;
                return null;
            }
            if (Compiler.containsWildcardCharacters(args[i])) {
                Compiler.expandSourceFiles(sourceFiles, 0, recurseLevel, ignoreDirs, args[i++]);
                continue;
            }
            sourceFiles.add(new SourcePackageRecord(args[i++], false));
        }
        if (options.makeFile == null) {
            options.addNameReferences = false;
        }
        if (!options.checkSourceTargetVersions()) {
            return null;
        }
        if (sourceFiles.isEmpty() && !options.helpPrinted) {
            Compiler.standardUsage(log);
        }
        return sourceFiles;
    }

    private static void printStoragePath(Log log, Storage[] storagePath, String separator) {
        int size = storagePath.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                log.print(separator);
            }
            log.print(storagePath[i].getPath());
        }
    }

    private int deployFiles(Options options, ArrayList deployables) {
        long ms = System.currentTimeMillis();
        int deployCnt = 0;
        if (options.destinationDir != null) {
            File destFile;
            if (options.destinationFile == null) {
                destFile = new File(options.destinationDir);
                if (!destFile.exists() && !destFile.mkdirs()) {
                    this.parser.error(Message.errorUnableToCreateOutputDir, 0, false, options.destinationDir);
                }
                options.destinationFile = new DirectoryStorage(destFile);
            }
            Storage targetBaseDir = options.destinationFile;
            HashMap<File, Storage> storageCache = new HashMap<File, Storage>();
            block0: for (int i = 0; i < deployables.size(); ++i) {
                DeployRecord dr = (DeployRecord)deployables.get(i);
                for (int j = 0; j < options.deployExtensions.length; ++j) {
                    Storage targetFile;
                    if (!dr.file.getName().endsWith(options.deployExtensions[j])) continue;
                    this.foundDeployables = true;
                    String packageDir = dr.packageName.replace('.', File.separatorChar);
                    packageDir = targetBaseDir.getPath() + File.separator + packageDir;
                    destFile = new File(packageDir);
                    Storage targetDir = (Storage)storageCache.get(destFile);
                    if (targetDir == null) {
                        if (!destFile.exists() && !destFile.mkdirs()) {
                            options.getLog().printError("unable to create output directory " + packageDir);
                            options.errorFound = true;
                        }
                        targetDir = new DirectoryStorage(destFile);
                        storageCache.put(destFile, targetDir);
                    }
                    if (!options.rebuild && (targetFile = targetDir.open(dr.file.getName())) != null && dr.file.modDate() <= targetFile.modDate()) continue block0;
                    if (options.verbose || options.noquiet) {
                        options.getLog().println("[" + Message.deployingString + " " + dr.file.getName() + " " + Message.toString + " " + targetDir + "]");
                    }
                    Compiler.copyFile(dr.file, targetDir, options.getLog());
                    ++deployCnt;
                    continue block0;
                }
            }
            if (deployCnt > 0 && (options.verbose || options.elapsedTime)) {
                options.getLog().println("[" + Message.deploymentTimeString + " " + (System.currentTimeMillis() - ms) + "ms]");
            }
        }
        return deployCnt;
    }

    private static String internalError(Log2 log, Throwable e, ArrayList sourceFiles, Options options, Parser parser) {
        Error error = new Error(null, Error.errorInternalError, 0);
        log.printError(error.message.getMessage());
        if (options != null) {
            options.errorFound = true;
        }
        try {
            String fileName = "ojcInternalError.log";
            String tmpDirName = System.getProperty("java.io.tmpdir");
            if (tmpDirName != null) {
                if (!tmpDirName.endsWith(options.fileSeparator)) {
                    tmpDirName = tmpDirName + options.fileSeparator;
                }
                fileName = tmpDirName + fileName;
            }
            File f = new File(fileName);
            FileOutputStream fileOut = new FileOutputStream(f);
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bytesOut);
            out.println("OJC internal error log:");
            out.print("----------------------------------------------------");
            out.println("----------------------------");
            out.println("Compiler version: 11.1.1");
            out.println("Build number:     5948");
            out.println("Source files:");
            if (sourceFiles == null || sourceFiles.size() == 0) {
                out.println("\t" + (sourceFiles == null ? "<null>!" : "None!"));
            } else {
                int size = sourceFiles.size();
                for (int i = 0; i < size; ++i) {
                    Storage storage = (Storage)sourceFiles.get(i);
                    out.println("\t" + storage.getPath());
                }
            }
            out.println();
            out.println("Options:");
            if (options == null) {
                out.println("<null>");
            } else {
                options.print(out);
            }
            out.println();
            out.println("Parser:");
            if (parser == null) {
                out.println("<null>");
            } else {
                parser.print(out);
            }
            out.println();
            bytesOut.flush();
            String detailsWithoutStacktrace = bytesOut.toString();
            e.printStackTrace(out);
            out.close();
            fileOut.write(bytesOut.toByteArray());
            fileOut.flush();
            fileOut.close();
            log.println(Message.substitePercentArgument(Message.internalErrorLogString, f.getPath(), 1));
            return detailsWithoutStacktrace;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Unknown compiler state";
        }
    }

    private static void outOfMemoryError(Log2 log) {
        Error error = new Error(null, Error.errorOutOfMemoryError, 0);
        log.printError(error.message.getMessage());
    }

    public static int main_throws_exceptions(ArrayList sourceFiles, Options options) throws Exception {
        if (!Compiler.isOjcAllowed()) {
            return 1;
        }
        Message.initializeMessages(options.getLog());
        options.sourceTargetJDKDefault = false;
        if (sourceFiles.size() > 0) {
            return Compiler.main_internal(sourceFiles, options, options.getLog());
        }
        return 0;
    }

    public static int main(ArrayList sourceFiles, Options options) {
        try {
            return Compiler.main_throws_exceptions(sourceFiles, options);
        }
        catch (Exception e) {
            return 2;
        }
    }

    public static int main(String[] args, Log log) {
        return Compiler.main(args, log, null);
    }

    public static int main(String[] args, Log log, IdeEnv ideEnv) {
        if (!Compiler.isOjcAllowed()) {
            return 1;
        }
        try {
            Message.initializeMessages(log);
            Options options = new Options(log);
            options.ideEnv = ideEnv;
            ArrayList sourceFiles = Compiler.parseCommandLine(options.getLog(), args, options);
            if (sourceFiles == null) {
                return 1;
            }
            if (sourceFiles.size() > 0) {
                return Compiler.main_internal(sourceFiles, options, options.getLog());
            }
        }
        catch (Exception e) {
            return 2;
        }
        return 0;
    }

    public static int main(String[] args, List storages, Log log) {
        if (!Compiler.isOjcAllowed()) {
            return 1;
        }
        try {
            ArrayList sourceFiles;
            Message.initializeMessages(log);
            Options options = new Options(log);
            options.helpPrinted = true;
            if (args != null && args.length > 0) {
                sourceFiles = Compiler.parseCommandLine(options.getLog(), args, options);
                if (sourceFiles == null) {
                    return 1;
                }
            } else {
                sourceFiles = new ArrayList();
            }
            if (storages != null) {
                sourceFiles.addAll(storages);
            }
            if (sourceFiles.size() > 0) {
                return Compiler.main_internal(sourceFiles, options, options.getLog());
            }
            Compiler.standardUsage(log);
        }
        catch (Exception e) {
            return 2;
        }
        return 0;
    }

    private static boolean isOjcAllowed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int main_internal(ArrayList sourceFiles, Options options, Log2 log) throws Exception {
        int compileResult;
        Exception finalException;
        block72: {
            Parser parser;
            block71: {
                int obj22;
                block70: {
                    int obj22;
                    block69: {
                        int n;
                        finalException = null;
                        parser = null;
                        ArrayList compilables = null;
                        compileResult = 0;
                        try {
                            block68: {
                                try {
                                    boolean noCompilables;
                                    Identifier.initializeIdentifiers(options.targetJDKVersion);
                                    Symbol.initializeSymbols();
                                    Expression.initializeExpressions();
                                    Annotation.initializeStatics();
                                    int messageNumber = Message.warningDirectoryDoesntExist.getNumber();
                                    boolean warnNonExistingPath = messageNumber >= Warning.warnings.size() || Warning.warnings.get(messageNumber);
                                    boolean warnEndorsedDir = true;
                                    if (options.endorseddirsStr == null) {
                                        options.endorseddirsStr = System.getProperty("java.endorsed.dirs");
                                        warnEndorsedDir = false;
                                    }
                                    if (options.bootClasspathStr == null) {
                                        options.bootClasspathStr = System.getProperty("sun.boot.class.path");
                                        if (options.bootClasspathStr == null) {
                                            options.bootClasspathStr = System.getProperty("java.class.path");
                                        }
                                        if (options.bootClasspathStr == null && warnNonExistingPath) {
                                            options.makeClassPath(options.bootClasspathStr, Message.bootclasspathString, false, false);
                                        }
                                    } else if (warnNonExistingPath) {
                                        options.makeClassPath(options.bootClasspathStr, Message.bootclasspathString, true, false);
                                    }
                                    if (options.prependBootClasspathStr != null) {
                                        if (warnNonExistingPath) {
                                            options.makeClassPath(options.prependBootClasspathStr, Message.bootclasspathString, true, false);
                                        }
                                        options.bootClasspathStr = options.bootClasspathStr == null ? options.prependBootClasspathStr : options.prependBootClasspathStr + options.bootClasspathStr;
                                    }
                                    if (options.appendBootClasspathStr != null) {
                                        if (warnNonExistingPath) {
                                            options.makeClassPath(options.appendBootClasspathStr, Message.bootclasspathString, true, false);
                                        }
                                        options.bootClasspathStr = options.bootClasspathStr == null ? options.appendBootClasspathStr : options.bootClasspathStr + options.appendBootClasspathStr;
                                    }
                                    boolean warnExtDir = true;
                                    if (options.extdirsStr == null) {
                                        options.extdirsStr = System.getProperty("java.ext.dirs");
                                        warnExtDir = false;
                                    }
                                    if (options.classpathStr == null && options.classpathStorage == null) {
                                        options.classpathStr = System.getProperty("env.class.path");
                                    }
                                    boolean warnSourcepath = true;
                                    if (options.sourcepathStr == null && options.sourcepathStorage == null) {
                                        options.sourcepathStr = System.getProperty("env.source.path");
                                        if (options.sourcepathStr == null && options.classpathStr != null) {
                                            options.sourcepathStr = options.classpathStr;
                                            warnSourcepath = false;
                                        }
                                    }
                                    if (options.endorseddirsStr != null) {
                                        options.endorseddirs = options.makeClassPath(options.endorseddirsStr, Message.endorsedDirectoryListString, warnEndorsedDir, true);
                                    }
                                    if (options.bootClasspathStr != null) {
                                        options.bootClasspath = options.makeClassPath(options.bootClasspathStr, Message.bootclasspathString, false, false);
                                    }
                                    if (options.extdirsStr != null) {
                                        options.extdirs = options.makeClassPath(options.extdirsStr, Message.extensionDirectoryListString, warnExtDir, true);
                                    }
                                    if (options.classpathStr != null) {
                                        options.classpath = options.makeClassPath(options.classpathStr, Message.classpathString, true, false);
                                    } else if (options.classpathStorage != null) {
                                        options.classpath = options.classpathStorage;
                                    }
                                    options.classpath = Compiler.makeWrappedPath(options.classpath);
                                    if (options.sourcepathStr != null) {
                                        options.sourcepath = options.makeClassPath(options.sourcepathStr, Message.sourcepathString, warnSourcepath, false);
                                    } else if (options.sourcepathStorage != null) {
                                        options.sourcepath = options.sourcepathStorage;
                                    }
                                    if (options.verbosepath) {
                                        log.print("[endorsed dirs: ");
                                        if (options.endorseddirs != null) {
                                            Compiler.printStoragePath(log, options.endorseddirs, options.pathSeparator);
                                        }
                                        log.println(" ]");
                                        log.print("[boot classpath: ");
                                        if (options.bootClasspath != null) {
                                            Compiler.printStoragePath(log, options.bootClasspath, options.pathSeparator);
                                        }
                                        log.println(" ]");
                                        log.print("[ext dirs: ");
                                        if (options.extdirs != null) {
                                            Compiler.printStoragePath(log, options.extdirs, options.pathSeparator);
                                        }
                                        log.println(" ]");
                                        log.print("[classpath: ");
                                        if (options.classpath != null) {
                                            Compiler.printStoragePath(log, options.classpath, options.pathSeparator);
                                        }
                                        log.println(" ]");
                                        log.print("[sourcepath: ");
                                        if (options.sourcepath != null) {
                                            Compiler.printStoragePath(log, options.sourcepath, "");
                                        }
                                        log.println(" ]");
                                    }
                                    if (options.verbose) {
                                        log.println("[encoding: " + options.encoding + "]");
                                    }
                                    Compiler compiler = new Compiler(options);
                                    parser = compiler.parser;
                                    if (parser.errorFound || options.errorFound) {
                                        n = 1;
                                        Object var34_29 = null;
                                        break block68;
                                    }
                                    RawClassSymbol.javaLangObjectSymbol = parser.javaLangObjectSymbol;
                                    ArrayList<DeployRecord> deployables = new ArrayList<DeployRecord>();
                                    compilables = new ArrayList();
                                    for (int i = 0; i < sourceFiles.size(); ++i) {
                                        String packageName;
                                        Storage sourceFile;
                                        Object obj22 = sourceFiles.get(i);
                                        if (obj22 instanceof Storage) {
                                            compilables.add(obj22);
                                            continue;
                                        }
                                        SourcePackageRecord spr = (SourcePackageRecord)obj22;
                                        if (spr.isPackage) {
                                            ArrayList sourceFilesInPackage = options.findSourcesInPackage(parser, spr.source);
                                            if (sourceFilesInPackage == null) continue;
                                            for (int j = 0; j < sourceFilesInPackage.size(); ++j) {
                                                sourceFile = (Storage)sourceFilesInPackage.get(j);
                                                if (sourceFile.getName().endsWith(".java")) {
                                                    compilables.add(sourceFile);
                                                    continue;
                                                }
                                                deployables.add(new DeployRecord(spr.source, sourceFile));
                                            }
                                            continue;
                                        }
                                        sourceFile = new FileStorage(new File(spr.source));
                                        if (spr.source.endsWith(".java")) {
                                            compilables.add(sourceFile);
                                            continue;
                                        }
                                        int index = spr.source.lastIndexOf(File.separatorChar);
                                        if (index < 0) {
                                            packageName = "";
                                        } else {
                                            packageName = spr.source.substring(0, index);
                                            packageName = packageName.replace(File.separatorChar, '.');
                                        }
                                        deployables.add(new DeployRecord(packageName, sourceFile));
                                    }
                                    boolean bl = noCompilables = compilables.size() == 0;
                                    if (options.makeFile != null) {
                                        compilables = parser.depInfo.analyzeSources(compilables, options);
                                        parser.depInfo.startWritingNameRefFile(options.makeFile);
                                    }
                                    compilables = Compiler.trimDuplicates(compilables);
                                    long startTime = System.currentTimeMillis();
                                    parser.parse(compilables);
                                    long endTime = System.currentTimeMillis();
                                    int deployCnt = 0;
                                    if ((!parser.errorFound || options.generateClassesDespiteErrors) && deployables.size() > 0 && options.deployExtensions != null && options.destinationDir != null) {
                                        deployCnt = compiler.deployFiles(options, deployables);
                                    }
                                    int n2 = compileResult = parser.errorFound ? 1 : 0;
                                    if (parser.sourceFileList.size() == 0 && deployCnt == 0 && !options.verbose) {
                                        if (noCompilables && !compiler.foundDeployables) {
                                            Compiler.standardUsage(log);
                                            obj22 = 1;
                                            break block69;
                                        }
                                        obj22 = compileResult;
                                        break block70;
                                    }
                                    parser.printMessages(log);
                                    Compiler.checkUnusedZipFiles(parser, options.classpath);
                                    if (options.verbose || options.elapsedTime) {
                                        String lineString = parser.sourceLineCount == 1 ? Message.lineString : Message.linesString;
                                        String sfileString = parser.sourceFileList.size() == 1 ? Message.fileString : Message.filesString;
                                        String cfileString = parser.classFileCount == 1 ? Message.classString : Message.classesString;
                                        String dfileString = deployCnt == 1 ? Message.fileString : Message.filesString;
                                        log.print("[" + parser.sourceLineCount + " " + lineString + " " + Message.compiledString + " " + Message.inString + " " + (endTime - startTime) + "ms " + Message.fromString + " " + parser.sourceFileList.size() + " " + sfileString + ", " + Message.generatingString + " " + parser.classFileCount + " " + cfileString);
                                        if (deployCnt > 0) {
                                            log.print(", " + Message.deployingString + " " + deployCnt + " " + dfileString);
                                        }
                                        log.println("]");
                                    }
                                    break block71;
                                }
                                catch (OutOfMemoryError e) {
                                    Compiler.outOfMemoryError(options.getLog());
                                    int obj22 = 4;
                                    Object var34_33 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    return obj22;
                                }
                                catch (RuntimeException e) {
                                    String msg = e.getMessage();
                                    if (msg != null && msg.equals("user aborted")) {
                                        int n3 = 3;
                                        Object var34_34 = null;
                                        options.releaseJars();
                                        Options.releaseStatics();
                                        Identifier.releaseIdentifiers();
                                        Symbol.releaseSymbols();
                                        Expression.releaseExpressions();
                                        Annotation.releaseStatics();
                                        OJCDEBUG.releaseStatics();
                                        if (parser != null) {
                                            parser.depInfo.clear();
                                            parser.depInfo = null;
                                        }
                                        return n3;
                                    }
                                    e.printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), e, compilables, options, parser);
                                    finalException = new Exception(message, e);
                                    Object var34_35 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block72;
                                }
                                catch (AssertionError e) {
                                    ((Throwable)((Object)e)).printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), (Throwable)((Object)e), compilables, options, parser);
                                    finalException = new Exception(message, (Throwable)((Object)e));
                                    Object var34_36 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block72;
                                }
                                catch (StackOverflowError e) {
                                    e.printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), e, compilables, options, parser);
                                    finalException = new Exception(message, e);
                                    Object var34_37 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block72;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), e, compilables, options, parser);
                                    finalException = new Exception(message, e);
                                    Object var34_38 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block72;
                                }
                                catch (java.lang.Error e) {
                                    e.printStackTrace();
                                    String message = Compiler.internalError(options.getLog(), e, compilables, options, parser);
                                    finalException = new Exception(message, e);
                                    Object var34_39 = null;
                                    options.releaseJars();
                                    Options.releaseStatics();
                                    Identifier.releaseIdentifiers();
                                    Symbol.releaseSymbols();
                                    Expression.releaseExpressions();
                                    Annotation.releaseStatics();
                                    OJCDEBUG.releaseStatics();
                                    if (parser != null) {
                                        parser.depInfo.clear();
                                        parser.depInfo = null;
                                    }
                                    break block72;
                                }
                            }
                            options.releaseJars();
                        }
                        catch (Throwable throwable) {
                            Object var34_40 = null;
                            options.releaseJars();
                            Options.releaseStatics();
                            Identifier.releaseIdentifiers();
                            Symbol.releaseSymbols();
                            Expression.releaseExpressions();
                            Annotation.releaseStatics();
                            OJCDEBUG.releaseStatics();
                            if (parser != null) {
                                parser.depInfo.clear();
                                parser.depInfo = null;
                            }
                            throw throwable;
                        }
                        Options.releaseStatics();
                        Identifier.releaseIdentifiers();
                        Symbol.releaseSymbols();
                        Expression.releaseExpressions();
                        Annotation.releaseStatics();
                        OJCDEBUG.releaseStatics();
                        if (parser != null) {
                            parser.depInfo.clear();
                            parser.depInfo = null;
                        }
                        return n;
                    }
                    Object var34_30 = null;
                    options.releaseJars();
                    Options.releaseStatics();
                    Identifier.releaseIdentifiers();
                    Symbol.releaseSymbols();
                    Expression.releaseExpressions();
                    Annotation.releaseStatics();
                    OJCDEBUG.releaseStatics();
                    if (parser != null) {
                        parser.depInfo.clear();
                        parser.depInfo = null;
                    }
                    return obj22;
                }
                Object var34_31 = null;
                options.releaseJars();
                Options.releaseStatics();
                Identifier.releaseIdentifiers();
                Symbol.releaseSymbols();
                Expression.releaseExpressions();
                Annotation.releaseStatics();
                OJCDEBUG.releaseStatics();
                if (parser != null) {
                    parser.depInfo.clear();
                    parser.depInfo = null;
                }
                return obj22;
            }
            Object var34_32 = null;
            options.releaseJars();
            Options.releaseStatics();
            Identifier.releaseIdentifiers();
            Symbol.releaseSymbols();
            Expression.releaseExpressions();
            Annotation.releaseStatics();
            OJCDEBUG.releaseStatics();
            if (parser != null) {
                parser.depInfo.clear();
                parser.depInfo = null;
            }
        }
        if (finalException != null) {
            throw finalException;
        }
        return compileResult;
    }

    private static Storage[] makeWrappedPath(Storage[] pathEntries) {
        if (Warning.warnings.get(Warning.warningZipFileNotUsed.getNumber()) && pathEntries != null) {
            int x;
            HashMap<Storage, Storage> pathEntryMap = new HashMap<Storage, Storage>();
            Storage[] newEntries = new Storage[pathEntries.length];
            for (x = 0; x < pathEntries.length; ++x) {
                String pathName = pathEntries[x].getName();
                if (pathName != null && (pathName.endsWith(".jar") || pathName.endsWith(".zip"))) {
                    if (pathName.equals("rt.jar") || pathName.equals("jsse.jar") || pathName.equals("jce.jar") || pathName.equals("charsets.jar")) {
                        String fullName = pathEntries[x].getPath();
                        if (fullName == null) continue;
                        if ((fullName = fullName.replace('\\', '/')).endsWith("jre/lib/rt.jar") || fullName.endsWith("jre/lib/jsse.jar") || fullName.endsWith("jre/lib/jce.jar") || fullName.endsWith("jre/lib/charsets.jar")) {
                            newEntries[x] = pathEntries[x];
                            continue;
                        }
                        newEntries[x] = new WrappedStorage(pathEntries[x]);
                        pathEntryMap.put(pathEntries[x], newEntries[x]);
                        continue;
                    }
                    newEntries[x] = new WrappedStorage(pathEntries[x]);
                    pathEntryMap.put(pathEntries[x], newEntries[x]);
                    continue;
                }
                newEntries[x] = pathEntries[x];
            }
            for (x = 0; x < newEntries.length; ++x) {
                WrappedStorage enclosingWrappedStorage;
                Storage enclosingStorage;
                if (!(newEntries[x] instanceof WrappedStorage) || (enclosingStorage = (Storage)newEntries[x].getProperty("enclosing_storage")) == null || (enclosingWrappedStorage = (WrappedStorage)pathEntryMap.get(enclosingStorage)) == null) continue;
                WrappedStorage newWrappedStorage = (WrappedStorage)newEntries[x];
                newWrappedStorage.setParent(enclosingWrappedStorage);
            }
            pathEntryMap.clear();
            return newEntries;
        }
        return pathEntries;
    }

    private static void checkUnusedZipFiles(Parser parser, Storage[] pathEntries) {
        if (Warning.warnings.get(Warning.warningZipFileNotUsed.getNumber()) && pathEntries != null) {
            PrintWriter writer = null;
            if (System.getProperty("ojc.unused.zip.file") != null) {
                File file = new File(System.getProperty("ojc.unused.zip.file"));
                file.getParentFile().mkdirs();
                try {
                    writer = new PrintWriter(file);
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            for (int x = 0; x < pathEntries.length; ++x) {
                WrappedStorage wrappedStorage;
                if (!(pathEntries[x] instanceof WrappedStorage) || pathEntries[x].getProperty("enclosing_storage") != null || (wrappedStorage = (WrappedStorage)pathEntries[x]).hasBeenUsedForIO()) continue;
                String path = wrappedStorage.getPath();
                Warning warning = new Warning(null, Message.warningZipFileNotUsed, 0, path);
                parser.warning(warning);
                if (writer == null) continue;
                writer.println(path);
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static ArrayList trimDuplicates(ArrayList compilables) {
        HashSet<String> pathNames = new HashSet<String>(compilables.size());
        for (int i = compilables.size() - 1; i >= 0; --i) {
            Storage storage = (Storage)compilables.get(i);
            String pathName = storage.getPath();
            if (pathNames.contains(pathName)) {
                compilables.remove(i);
                continue;
            }
            pathNames.add(pathName);
        }
        return compilables;
    }

    static {
        $assertionsDisabled = !Compiler.class.desiredAssertionStatus();
    }

    static class DeployRecord {
        String packageName;
        Storage file;

        DeployRecord(String packageName, Storage file) {
            this.packageName = packageName;
            this.file = file;
        }
    }

    static class SourcePackageRecord {
        boolean isPackage;
        String source;

        SourcePackageRecord(String source, boolean isPackage) {
            this.source = source;
            this.isPackage = isPackage;
        }
    }
}

