/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSuperClassException;

final class ClassScope
extends Scope {
    private static final int CLASS_SYMBOLTABLE_SIZE = 32;
    Scope outerScope;
    RawClassSymbol classSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClassScope(RawClassSymbol classSymbol, Scope outerScope, Parser parser) {
        super((byte)2, 32, parser);
        this.classSymbol = classSymbol;
        this.outerScope = outerScope;
    }

    Symbol lookupSymbol(Identifier identifier, boolean ignoreImports) {
        ClassScope classScope;
        ClassSymbol classSym;
        Symbol symbol = this.lookupSymbolInTheThisScope(identifier, ignoreImports);
        if (symbol != null) {
            return symbol;
        }
        RawClassSymbol lastClassSym = classSym = this.classSymbol;
        do {
            if (classSym.isInnerClass()) {
                RawClassSymbol outerClass = ((ClassSymbol)classSym).getOuterClass();
                while (true) {
                    if ((symbol = (classScope = outerClass.getClassScope()).lookupSymbolInScope(identifier, ignoreImports)) != null) {
                        return symbol;
                    }
                    if (!outerClass.isInnerClass()) break;
                    outerClass = ((ClassSymbol)outerClass).getOuterClass();
                }
            }
            if (classSym instanceof UnresolvedClassSymbol) {
                throw new UnresolvedSuperClassException(classSym);
            }
            lastClassSym = classSym;
        } while ((classSym = ((ClassSymbol)classSym).getSuperClassSymbol()) != null);
        Scope scope = this.outerScope;
        if (scope.kind == 2) {
            classScope = (ClassScope)scope;
            if (classScope.classSymbol.isAnonymousInnerClass()) {
                symbol = scope.lookupSymbol(identifier, ignoreImports);
                if (symbol != null) {
                    return symbol;
                }
                return classScope.outerScope.lookupSymbol(identifier, ignoreImports);
            }
        }
        return scope.lookupSymbol(identifier, ignoreImports);
    }

    Symbol lookupSymbolInTheThisScope(Identifier identifier, boolean ignoreImports) {
        Symbol symbol;
        ClassScope classScope;
        ClassSymbol classSym = this.classSymbol;
        RawClassSymbol lastClassSym = classSym;
        do {
            if (classSym instanceof UnresolvedClassSymbol) {
                throw new UnresolvedSuperClassException(classSym);
            }
            classScope = classSym.getClassScope();
            if (!$assertionsDisabled && classScope == null) {
                throw new AssertionError();
            }
            symbol = classScope.lookupSymbolInScope(identifier, ignoreImports);
            if (symbol != null) {
                return symbol;
            }
            lastClassSym = classSym;
        } while ((classSym = classSym.getSuperClassSymbol()) != null);
        classSym = this.classSymbol;
        do {
            ImplementationList list = classSym.getImplementationList();
            while (list != null) {
                classScope = list.interfaceSymbol.getClassScope();
                if (!$assertionsDisabled && classScope == null) {
                    throw new AssertionError();
                }
                symbol = classScope.lookupSymbol(identifier, ignoreImports);
                if (symbol != null) {
                    return symbol;
                }
                list = list.next;
            }
        } while ((classSym = classSym.getSuperClassSymbol()) != null);
        return null;
    }

    Symbol lookupSpecificSymbol(Identifier identifier, int symbolKind, boolean ignoreImports) {
        ClassScope classScope;
        ClassSymbol abstractClassSym;
        Symbol symbol = this.lookupSpecificSymbolInTheThisScope(identifier, symbolKind, ignoreImports);
        if (symbol != null) {
            return symbol;
        }
        RawClassSymbol lastClassSym = abstractClassSym = this.classSymbol;
        do {
            if (abstractClassSym.isInnerClass()) {
                RawClassSymbol outerClass = ((ClassSymbol)abstractClassSym).getOuterClass();
                while (true) {
                    if ((symbol = (classScope = outerClass.getClassScope()).lookupSpecificSymbolInScope(identifier, symbolKind, ignoreImports)) != null) {
                        return symbol;
                    }
                    if (!outerClass.isInnerClass()) break;
                    outerClass = ((ClassSymbol)outerClass).getOuterClass();
                }
            }
            if (abstractClassSym instanceof UnresolvedClassSymbol) {
                throw new UnresolvedSuperClassException(abstractClassSym);
            }
            lastClassSym = abstractClassSym;
        } while ((abstractClassSym = ((ClassSymbol)abstractClassSym).getSuperClassSymbol()) != null);
        Scope scope = this.outerScope;
        if (scope.kind == 2) {
            classScope = (ClassScope)scope;
            if (classScope.classSymbol.isAnonymousInnerClass()) {
                symbol = scope.lookupSpecificSymbol(identifier, symbolKind, ignoreImports);
                if (symbol != null) {
                    return symbol;
                }
                return classScope.outerScope.lookupSpecificSymbol(identifier, symbolKind, ignoreImports);
            }
        }
        return scope.lookupSpecificSymbol(identifier, symbolKind, ignoreImports);
    }

    Symbol lookupSpecificSymbolInTheThisScope(Identifier identifier, int symbolKind, boolean ignoreImports) {
        Symbol symbol;
        ClassSymbol abstractClassSym = this.classSymbol;
        do {
            if (abstractClassSym.isUnresolvedType()) {
                throw new UnresolvedSuperClassException(abstractClassSym);
            }
            ClassScope classScope = abstractClassSym.getClassScope();
            symbol = classScope.lookupSpecificSymbolInScope(identifier, symbolKind, ignoreImports);
            if (symbol == null) continue;
            return symbol;
        } while ((abstractClassSym = abstractClassSym.getSuperClassSymbol()) != null);
        abstractClassSym = this.classSymbol;
        do {
            ImplementationList impl = abstractClassSym.getImplementationList();
            while (impl != null) {
                if (impl.interfaceSymbol instanceof UnresolvedClassSymbol) {
                    throw new UnresolvedSuperClassException(impl.interfaceSymbol);
                }
                RawClassSymbol classSym = impl.interfaceSymbol.getClassSymbol();
                symbol = classSym.lookupSpecificSymbolInClass(this.parser, identifier, symbolKind, false);
                if (symbol != null) {
                    return symbol;
                }
                impl = impl.next;
            }
        } while ((abstractClassSym = abstractClassSym.getSuperClassSymbol()) != null);
        return null;
    }

    String errorName() {
        return this.classSymbol.errorName();
    }

    boolean isSubScopeOf(Scope scope) {
        if (this == scope) {
            return true;
        }
        return this.outerScope.isSubScopeOf(scope);
    }

    Scope getOuterScope() {
        return this.outerScope;
    }

    static {
        $assertionsDisabled = !ClassScope.class.desiredAssertionStatus();
    }
}

