/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.ConstantPoolClass;
import oracle.ojc.compiler.ConstantPoolDouble;
import oracle.ojc.compiler.ConstantPoolEntry;
import oracle.ojc.compiler.ConstantPoolFloat;
import oracle.ojc.compiler.ConstantPoolInteger;
import oracle.ojc.compiler.ConstantPoolLong;
import oracle.ojc.compiler.ConstantPoolString;
import oracle.ojc.compiler.ConstantPoolUtf8;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IdentifierList;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.interfaces.Storage;

final class ClassFileReader {
    private static final char[] syntheticName;
    private static final char[] constantValueName;
    private static final char[] exceptionsName;
    private static final char[] innerClassesName;
    private static final char[] deprecatedName;
    private static final char[] annotationDefaultName;
    private static final char[] runtimeVisibleAnnotationsName;
    private static final char[] runtimeInvisibleAnnotationsName;
    private static final char[] signatureName;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClassFileReader() {
    }

    private static void signatureToArgumentList(Parser parser, MethodSymbol methodSymbol, char[] signature, StorageScope packageScope, boolean lazy) {
        short localVarIndex = 0;
        short argCount = 0;
        int dimensions = 0;
        int index = 1;
        ArgumentVariableList list = null;
        ArgumentVariableList last = null;
        if ((methodSymbol.access & 8) == 0) {
            localVarIndex = 1;
        }
        try {
            block15: while (true) {
                TypeSymbol type;
                char c = signature[index++];
                switch (c) {
                    default: {
                        return;
                    }
                    case ')': {
                        methodSymbol.actualArgCount = localVarIndex;
                        methodSymbol.argCount = argCount;
                        methodSymbol.argumentList = list;
                        return;
                    }
                    case 'L': {
                        int firstIndex = index - 1;
                        while ((c = signature[index++]) != ';') {
                        }
                        type = packageScope.lookupSignature(signature, firstIndex);
                        if (type != null) break;
                        type = TypeSymbol.errorSymbol;
                        break;
                    }
                    case '[': {
                        while (true) {
                            ++dimensions;
                            c = signature[index];
                            if (c != '[') continue block15;
                            ++index;
                        }
                    }
                    case 'Z': {
                        type = TypeSymbol.booleanSymbol;
                        break;
                    }
                    case 'B': {
                        type = TypeSymbol.byteSymbol;
                        break;
                    }
                    case 'C': {
                        type = TypeSymbol.charSymbol;
                        break;
                    }
                    case 'S': {
                        type = TypeSymbol.shortSymbol;
                        break;
                    }
                    case 'I': {
                        type = TypeSymbol.intSymbol;
                        break;
                    }
                    case 'J': {
                        type = TypeSymbol.longSymbol;
                        break;
                    }
                    case 'F': {
                        type = TypeSymbol.floatSymbol;
                        break;
                    }
                    case 'D': {
                        type = TypeSymbol.doubleSymbol;
                    }
                }
                if (dimensions > 0) {
                    type = ArraySymbol.getArrayType(type, dimensions);
                    dimensions = 0;
                }
                short s = localVarIndex;
                localVarIndex = (short)(localVarIndex + 1);
                ArgumentVariableSymbol arg = new ArgumentVariableSymbol(0, methodSymbol, null, type, 0, 0, null, s);
                argCount = (short)(argCount + 1);
                if ((type.typeClass & 0x28) != 0) {
                    localVarIndex = (short)(localVarIndex + 1);
                }
                ArgumentVariableList sl = new ArgumentVariableList(arg);
                if (list == null) {
                    list = last = sl;
                    continue;
                }
                last.next = sl;
                last = sl;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private static TypeVariableList parseTypeArguments(Parser parser, CharBuffer charBuffer) {
        TypeVariableList last = null;
        TypeVariableList list = null;
        do {
            TypeVariableSymbol typeVar;
            char c;
            if ((c = charBuffer.getChar()) == '*') {
                typeVar = new TypeVariableSymbol(0, 0, null);
                charBuffer.skipChar();
            } else {
                byte kind;
                if (c == '+') {
                    kind = 2;
                    charBuffer.skipChar();
                } else if (c == '-') {
                    kind = 3;
                    charBuffer.skipChar();
                } else {
                    kind = 1;
                }
                typeVar = new TypeVariableSymbol(0, kind, (ReferenceTypeSymbol)ClassFileReader.parseFieldTypeSignature(parser, charBuffer));
            }
            TypeVariableList tvl = new TypeVariableList(typeVar);
            if (last == null) {
                list = last = tvl;
                continue;
            }
            last.next = tvl;
            last = tvl;
        } while (charBuffer.getChar() != '>');
        charBuffer.skipChar();
        return list;
    }

    private static ClassSymbol parseClassTypeSignature(Parser parser, CharBuffer charBuffer) {
        UnresolvedClassSymbol classSymbol;
        block8: {
            IdentifierList il;
            char c;
            Identifier identifier;
            StorageScope scope = parser.globalScope;
            charBuffer.skipChar();
            IdentifierList qualifierLast = null;
            IdentifierList qualifierList = null;
            while (true) {
                identifier = charBuffer.nextIdentifier(false);
                c = charBuffer.nextChar();
                if (c != '/') {
                    if (qualifierList != null) break;
                    scope = parser.unnamedPackageScope;
                    break;
                }
                il = new IdentifierList(0, identifier);
                if (qualifierList == null) {
                    qualifierList = qualifierLast = il;
                    continue;
                }
                qualifierLast.next = il;
                qualifierLast = il;
            }
            TypeVariableList tvl = null;
            if (c == '<') {
                tvl = ClassFileReader.parseTypeArguments(parser, charBuffer);
                c = charBuffer.nextChar();
            }
            classSymbol = new UnresolvedClassSymbol(qualifierList, identifier, tvl, scope);
            if (c != '$' && c != '.') break block8;
            qualifierLast = null;
            qualifierList = null;
            while (true) {
                identifier = charBuffer.nextIdentifier(false);
                c = charBuffer.nextChar();
                if (c == '<') {
                    tvl = ClassFileReader.parseTypeArguments(parser, charBuffer);
                    classSymbol = new UnresolvedClassSymbol(classSymbol, qualifierList, identifier, tvl);
                    identifier = null;
                    c = charBuffer.nextChar();
                }
                if (c != '.' && c != '$') break;
                il = new IdentifierList(0, identifier);
                if (qualifierList == null) {
                    qualifierList = qualifierLast = il;
                    continue;
                }
                qualifierLast.next = il;
                qualifierLast = il;
            }
            if (identifier != null) {
                classSymbol = new UnresolvedClassSymbol(classSymbol, qualifierList, identifier, null);
            }
        }
        return classSymbol;
    }

    private static TypeSymbol parseTypeSignature(Parser parser, CharBuffer charBuffer) {
        TypeSymbol typeSymbol;
        switch (charBuffer.getChar()) {
            default: {
                return ClassFileReader.parseFieldTypeSignature(parser, charBuffer);
            }
            case 'V': {
                typeSymbol = TypeSymbol.voidSymbol;
                break;
            }
            case 'Z': {
                typeSymbol = TypeSymbol.booleanSymbol;
                break;
            }
            case 'B': {
                typeSymbol = TypeSymbol.byteSymbol;
                break;
            }
            case 'S': {
                typeSymbol = TypeSymbol.shortSymbol;
                break;
            }
            case 'C': {
                typeSymbol = TypeSymbol.charSymbol;
                break;
            }
            case 'I': {
                typeSymbol = TypeSymbol.intSymbol;
                break;
            }
            case 'J': {
                typeSymbol = TypeSymbol.longSymbol;
                break;
            }
            case 'F': {
                typeSymbol = TypeSymbol.floatSymbol;
                break;
            }
            case 'D': {
                typeSymbol = TypeSymbol.doubleSymbol;
            }
        }
        charBuffer.skipChar();
        return typeSymbol;
    }

    private static TypeSymbol parseFieldTypeSignature(Parser parser, CharBuffer charBuffer) {
        switch (charBuffer.getChar()) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case '[': {
                int dimension = 1;
                while (true) {
                    charBuffer.skipChar();
                    if (charBuffer.getChar() != '[') break;
                    ++dimension;
                }
                TypeSymbol typeSymbol = ClassFileReader.parseTypeSignature(parser, charBuffer);
                return ArraySymbol.getArrayType(typeSymbol, dimension);
            }
            case 'T': {
                charBuffer.skipChar();
                Identifier identifier = charBuffer.nextIdentifier(true);
                charBuffer.skipChar();
                return new TypeParameterSymbol(0, identifier, parser.javaLangObjectSymbol, 0, null);
            }
            case 'L': 
        }
        return ClassFileReader.parseClassTypeSignature(parser, charBuffer);
    }

    private static TypeParameterList parseFormalTypeParameters(Parser parser, CharBuffer charBuffer) {
        TypeParameterList firstTpl = null;
        char c = charBuffer.getChar();
        if (c == '<') {
            TypeParameterList tpl;
            ClassSymbolList list;
            charBuffer.skipChar();
            TypeParameterList lastTpl = null;
            do {
                Identifier identifier = charBuffer.nextIdentifier(true);
                charBuffer.skipChar();
                c = charBuffer.getChar();
                if (c == ':') {
                    charBuffer.skipChar();
                }
                ClassSymbol bound = (ClassSymbol)ClassFileReader.parseFieldTypeSignature(parser, charBuffer);
                list = null;
                c = charBuffer.getChar();
                while (c == ':') {
                    charBuffer.skipChar();
                    ClassSymbolList tsl = new ClassSymbolList((ClassSymbol)ClassFileReader.parseFieldTypeSignature(parser, charBuffer));
                    tsl.next = list;
                    list = tsl;
                    c = charBuffer.getChar();
                }
                TypeParameterSymbol tps = new TypeParameterSymbol(0, identifier, bound, 0, list);
                tpl = new TypeParameterList(tps);
                if (lastTpl == null) {
                    firstTpl = lastTpl = tpl;
                    continue;
                }
                lastTpl.next = tpl;
                lastTpl = tpl;
            } while (c != '>');
            charBuffer.skipChar();
            tpl = firstTpl;
            while (tpl != null) {
                tpl.typeParameter.bound = (ClassSymbol)tpl.typeParameter.bound.replaceTypeParameters(firstTpl);
                list = tpl.typeParameter.interfaceBounds;
                while (list != null) {
                    list.classSymbol = (ClassSymbol)list.classSymbol.replaceTypeParameters(firstTpl);
                    list = list.next;
                }
                tpl = tpl.next;
            }
        }
        return firstTpl;
    }

    private static void parseFieldSignature(Parser parser, FieldSymbol fieldSymbol, char[] signature) {
        fieldSymbol.type = ClassFileReader.parseFieldTypeSignature(parser, new CharBuffer(signature));
    }

    private static void parseMethodSignature(Parser parser, MethodSymbol methodSymbol, char[] signature) {
        TypeSymbol typeSymbol;
        TypeParameterList methodTpl;
        CharBuffer charBuffer = new CharBuffer(signature);
        methodSymbol.typeParameterList = methodTpl = ClassFileReader.parseFormalTypeParameters(parser, charBuffer);
        TypeParameterList tpl = methodTpl;
        while (tpl != null) {
            tpl.typeParameter.definingSymbol = methodSymbol;
            tpl = tpl.next;
        }
        if (!$assertionsDisabled && charBuffer.getChar() != '(') {
            throw new AssertionError();
        }
        charBuffer.skipChar();
        ArgumentVariableList sl = methodSymbol.argumentList;
        if (methodSymbol.isConstructor() && methodSymbol.definingClass.isInnerClass()) {
            ArrayList<ArgumentVariableList> argsBackwards = new ArrayList<ArgumentVariableList>();
            while (sl != null) {
                argsBackwards.add(0, sl);
                sl = sl.next;
            }
            ArrayList<TypeSymbol> typesBackwards = new ArrayList<TypeSymbol>();
            while (charBuffer.getChar() != ')') {
                typeSymbol = ClassFileReader.parseTypeSignature(parser, charBuffer);
                typesBackwards.add(0, typeSymbol);
            }
            for (int x = 0; x < typesBackwards.size(); ++x) {
                if (!$assertionsDisabled && x >= argsBackwards.size()) {
                    throw new AssertionError();
                }
                sl = (ArgumentVariableList)argsBackwards.get(x);
                typeSymbol = (TypeSymbol)typesBackwards.get(x);
                sl.argSymbol.type = typeSymbol.replaceTypeParameters(methodTpl);
            }
        } else {
            while (charBuffer.getChar() != ')') {
                if (!$assertionsDisabled && sl == null) {
                    throw new AssertionError();
                }
                typeSymbol = ClassFileReader.parseTypeSignature(parser, charBuffer);
                sl.argSymbol.type = typeSymbol.replaceTypeParameters(methodTpl);
                sl = sl.next;
            }
        }
        charBuffer.skipChar();
        typeSymbol = ClassFileReader.parseTypeSignature(parser, charBuffer);
        methodSymbol.resultType = typeSymbol.replaceTypeParameters(methodTpl);
        while (charBuffer.more()) {
            if (!$assertionsDisabled && charBuffer.getChar() != '^') {
                throw new AssertionError();
            }
            charBuffer.skipChar();
            typeSymbol = ClassFileReader.parseFieldTypeSignature(parser, charBuffer);
            MethodSymbol.ThrowsList tl = new MethodSymbol.ThrowsList((ClassSymbol)typeSymbol.replaceTypeParameters(methodTpl));
            tl.next = methodSymbol.throwsList;
            methodSymbol.throwsList = tl;
        }
    }

    private static TypeParameterList removeHiddenTypeParameters(TypeParameterList masterList, TypeParameterList excludeList) {
        TypeParameterList tpl1;
        TypeParameterList tplList = masterList;
        TypeParameterList tpl0 = masterList;
        block0: while (tpl0 != null) {
            tpl1 = excludeList;
            while (tpl1 != null) {
                if (tpl0.typeParameter.identifier == tpl1.typeParameter.identifier) {
                    tplList = null;
                    break block0;
                }
                tpl1 = tpl1.next;
            }
            tpl0 = tpl0.next;
        }
        if (tplList == null) {
            tpl0 = masterList;
            while (tpl0 != null) {
                boolean addMasterTp = true;
                tpl1 = excludeList;
                while (tpl1 != null) {
                    if (tpl0.typeParameter.identifier == tpl1.typeParameter.identifier) {
                        addMasterTp = false;
                        break;
                    }
                    tpl1 = tpl1.next;
                }
                if (addMasterTp) {
                    TypeParameterList tpl = new TypeParameterList(tpl0.typeParameter);
                    tpl.next = tplList;
                    tplList = tpl;
                }
                tpl0 = tpl0.next;
            }
        }
        return tplList;
    }

    private static void parseClassSignature(Parser parser, RawClassSymbol classSymbol, char[] classSignature) {
        TypeParameterList classTpl;
        CharBuffer charBuffer = new CharBuffer(classSignature);
        classSymbol.flags = (short)(classSymbol.flags | 0x4000);
        RawClassSymbol.GenericClassData gcd = new RawClassSymbol.GenericClassData(classSymbol.cd);
        classSymbol.cd = gcd;
        gcd.typeParameterList = classTpl = ClassFileReader.parseFormalTypeParameters(parser, charBuffer);
        TypeParameterList tpl = classTpl;
        while (tpl != null) {
            tpl.typeParameter.definingSymbol = classSymbol;
            tpl = tpl.next;
        }
        MethodSymbol methodSymbol = gcd.methodList;
        while (methodSymbol != null) {
            MethodSymbol.ThrowsList tl = methodSymbol.throwsList;
            while (tl != null) {
                tl.throwsType = tl.throwsType.replaceTypeParameters(classTpl);
                tl = tl.next;
            }
            tpl = classTpl;
            if (methodSymbol.typeParameterList == null || (tpl = ClassFileReader.removeHiddenTypeParameters(classTpl, methodSymbol.typeParameterList)) != null) {
                ArgumentVariableList avl = methodSymbol.argumentList;
                while (avl != null) {
                    avl.argSymbol.type = avl.argSymbol.type.replaceTypeParameters(tpl);
                    avl = avl.next;
                }
                methodSymbol.resultType = methodSymbol.resultType.replaceTypeParameters(tpl);
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        FieldSymbol fieldSymbol = gcd.fieldList;
        while (fieldSymbol != null) {
            fieldSymbol.type = fieldSymbol.type.replaceTypeParameters(classTpl);
            fieldSymbol = fieldSymbol.nextInClass;
        }
        classSymbol.superClass = ClassFileReader.parseClassTypeSignature(parser, charBuffer);
        classSymbol.superClass.replaceTypeParameters(classTpl);
        if (charBuffer.more()) {
            ImplementationList implList = null;
            do {
                ClassSymbol interfaceSymbol = ClassFileReader.parseClassTypeSignature(parser, charBuffer);
                interfaceSymbol.replaceTypeParameters(classTpl);
                ImplementationList impl = new ImplementationList(interfaceSymbol);
                impl.next = implList;
                implList = impl;
            } while (charBuffer.more());
            classSymbol.setImplementationList(implList);
        }
    }

    private static boolean isSyntheticUtf8(char[] cbuf) {
        return Identifier.compare(cbuf, syntheticName);
    }

    private static boolean isConstantValueUtf8(char[] cbuf) {
        return Identifier.compare(cbuf, constantValueName);
    }

    private static boolean isExceptionsUtf8(char[] cbuf) {
        return Identifier.compare(cbuf, exceptionsName);
    }

    private static boolean isInnerClassesUtf8(char[] cbuf) {
        return Identifier.compare(cbuf, innerClassesName);
    }

    private static boolean isDeprecatedUtf8(char[] cbuf) {
        return Identifier.compare(cbuf, deprecatedName);
    }

    private static boolean isAnnotationDefaultUtf8(char[] cbuf) {
        return Identifier.compare(cbuf, annotationDefaultName);
    }

    private static boolean isRuntimeVisibleAnnotationsUtf8(char[] cbuf) {
        return Identifier.compare(cbuf, runtimeVisibleAnnotationsName);
    }

    private static boolean isRuntimeInvisibleAnnotationsUtf8(char[] cbuf) {
        return Identifier.compare(cbuf, runtimeInvisibleAnnotationsName);
    }

    private static boolean isSignatureUtf8(char[] cbuf) {
        return Identifier.compare(cbuf, signatureName);
    }

    private static int skipElementValue(byte[] rb, int off) {
        switch (rb[off]) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 99: 
            case 115: {
                off += 3;
                break;
            }
            case 101: {
                off += 5;
                break;
            }
            case 64: {
                off = ClassFileReader.skipAnnotation(rb, off + 1);
                break;
            }
            case 91: {
                int size = rb[off + 2] & 0xFF | (rb[off + 1] & 0xFF) << 8;
                off += 3;
                while (--size >= 0) {
                    off = ClassFileReader.skipElementValue(rb, off);
                }
                break block0;
            }
        }
        return off;
    }

    private static int skipAnnotation(byte[] rb, int off) {
        int cnt = rb[off + 3] & 0xFF | (rb[off + 2] & 0xFF) << 8;
        off += 4;
        while (--cnt >= 0) {
            off = ClassFileReader.skipElementValue(rb, off + 2);
        }
        return off;
    }

    static void readClassFile(Parser parser, int pos, RawClassSymbol classSymbol, boolean lazy) {
        RawClassSymbol rcs;
        InnerClassSymbol innerClass;
        MethodSymbol methodSymbol;
        ImplementationList impl;
        ClassSymbol classSym;
        ClassSymbol superClass;
        byte[] rb;
        ClassScope classScope = new ClassScope(classSymbol, classSymbol.scope, parser);
        StorageScope packageScope = (StorageScope)classSymbol.getTopLevelClass().scope;
        long ms = System.currentTimeMillis();
        Storage storage = parser.options.findStorageOfClass(classSymbol);
        if (storage == null) {
            return;
        }
        try {
            storage.open();
            rb = storage.read();
            storage.close();
        }
        catch (IOException e) {
            parser.error(Message.errorCannotReadClass, 0, false, storage.getName(), storage.getPath());
            return;
        }
        try {
            int cnt2;
            int attrLen;
            boolean addToList;
            TypeSymbol typeSymbol;
            short access;
            int nameIdx;
            int typeIdx;
            String str;
            ConstantPoolUtf8 utf8Cpe;
            ConstantPoolClass classCpe;
            int j;
            int idx;
            int len;
            int i;
            int version;
            if (rb[3] != -66 || rb[2] != -70 || rb[1] != -2 || rb[0] != -54) {
                parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                return;
            }
            switch (rb[7]) {
                default: {
                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                    return;
                }
                case 45: {
                    if (rb[6] != 0 || rb[5] != 3 || rb[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                        return;
                    }
                    version = 110;
                    break;
                }
                case 46: {
                    if (rb[6] != 0 || rb[5] != 0 || rb[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                        return;
                    }
                    version = 120;
                    break;
                }
                case 47: {
                    if (rb[6] != 0 || rb[5] != 0 || rb[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                        return;
                    }
                    version = 130;
                    break;
                }
                case 48: {
                    if (rb[6] != 0 || rb[5] != 0 || rb[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                        return;
                    }
                    version = 140;
                    break;
                }
                case 49: {
                    if (rb[6] != 0 || rb[5] != 0 || rb[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                        return;
                    }
                    version = 150;
                    break;
                }
                case 50: {
                    if (rb[6] != 0 || rb[5] != 0 || rb[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                        return;
                    }
                    version = 160;
                    break;
                }
                case 51: {
                    if (rb[6] != 0 || rb[5] != 0 || rb[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                        return;
                    }
                    version = 170;
                }
            }
            boolean readJDK15features = parser.targetingAtLeastOneFive && version >= 150;
            int deprecatedIndex = 0;
            int innerClassesIndex = 0;
            int syntheticIndex = 0;
            int constantValueIndex = 0;
            int exceptionsIndex = 0;
            int annotationDefaultIndex = 0;
            int runtimeVisibleAnnotationsIndex = 0;
            int runtimeInvisibleAnnotationsIndex = 0;
            int signatureIndex = 0;
            int cnt = rb[9] & 0xFF | (rb[8] & 0xFF) << 8;
            ArrayList<ConstantPoolEntry> constantPoolVector = new ArrayList<ConstantPoolEntry>(cnt + 1);
            constantPoolVector.add(null);
            int rbIndex = 10;
            block37: for (i = 1; i < cnt; ++i) {
                switch (rb[rbIndex]) {
                    default: {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                        return;
                    }
                    case 7: {
                        constantPoolVector.add(new ConstantPoolClass((short)(rb[rbIndex + 2] & 0xFF | (rb[rbIndex + 1] & 0xFF) << 8)));
                        rbIndex += 3;
                        continue block37;
                    }
                    case 8: {
                        constantPoolVector.add(new ConstantPoolString((short)(rb[rbIndex + 2] & 0xFF | (rb[rbIndex + 1] & 0xFF) << 8)));
                        rbIndex += 3;
                        continue block37;
                    }
                    case 3: {
                        constantPoolVector.add(new ConstantPoolInteger(rb[rbIndex + 4] & 0xFF | (rb[rbIndex + 3] & 0xFF) << 8 | (rb[rbIndex + 2] & 0xFF) << 16 | (rb[rbIndex + 1] & 0xFF) << 24));
                        rbIndex += 5;
                        continue block37;
                    }
                    case 4: {
                        constantPoolVector.add(new ConstantPoolFloat(rb[rbIndex + 4] & 0xFF | (rb[rbIndex + 3] & 0xFF) << 8 | (rb[rbIndex + 2] & 0xFF) << 16 | (rb[rbIndex + 1] & 0xFF) << 24));
                        rbIndex += 5;
                        continue block37;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        constantPoolVector.add(null);
                        rbIndex += 5;
                        continue block37;
                    }
                    case 5: {
                        constantPoolVector.add(new ConstantPoolLong((long)rb[rbIndex + 8] & 0xFFL | ((long)rb[rbIndex + 7] & 0xFFL) << 8 | ((long)rb[rbIndex + 6] & 0xFFL) << 16 | ((long)rb[rbIndex + 5] & 0xFFL) << 24 | ((long)rb[rbIndex + 4] & 0xFFL) << 32 | ((long)rb[rbIndex + 3] & 0xFFL) << 40 | ((long)rb[rbIndex + 2] & 0xFFL) << 48 | ((long)rb[rbIndex + 1] & 0xFFL) << 56));
                        ++i;
                        constantPoolVector.add(null);
                        rbIndex += 9;
                        continue block37;
                    }
                    case 6: {
                        constantPoolVector.add(new ConstantPoolDouble((long)rb[rbIndex + 8] & 0xFFL | ((long)rb[rbIndex + 7] & 0xFFL) << 8 | ((long)rb[rbIndex + 6] & 0xFFL) << 16 | ((long)rb[rbIndex + 5] & 0xFFL) << 24 | ((long)rb[rbIndex + 4] & 0xFFL) << 32 | ((long)rb[rbIndex + 3] & 0xFFL) << 40 | ((long)rb[rbIndex + 2] & 0xFFL) << 48 | ((long)rb[rbIndex + 1] & 0xFFL) << 56));
                        ++i;
                        constantPoolVector.add(null);
                        rbIndex += 9;
                        continue block37;
                    }
                    case 1: {
                        len = rb[rbIndex + 2] & 0xFF | (rb[rbIndex + 1] & 0xFF) << 8;
                        char[] cbuf = new char[len];
                        rbIndex += 3;
                        idx = 0;
                        j = 0;
                        while (j < len) {
                            byte b;
                            if (((b = rb[rbIndex + j++]) & 0x80) != 0) {
                                byte b1 = rb[rbIndex + j++];
                                if ((b & 0xE0) == 192) {
                                    cbuf[idx++] = (char)((b & 0x1F) << 6 | b1 & 0x3F);
                                    continue;
                                }
                                byte b2 = rb[rbIndex + j++];
                                cbuf[idx++] = (char)((b & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F);
                                continue;
                            }
                            cbuf[idx++] = (char)(b & 0xFF);
                        }
                        if (len > idx) {
                            char[] tbuf = new char[idx];
                            System.arraycopy(cbuf, 0, tbuf, 0, idx);
                            cbuf = tbuf;
                        }
                        if (ClassFileReader.isConstantValueUtf8(cbuf)) {
                            constantValueIndex = i;
                        } else if (ClassFileReader.isSyntheticUtf8(cbuf)) {
                            syntheticIndex = i;
                        } else if (ClassFileReader.isExceptionsUtf8(cbuf)) {
                            exceptionsIndex = i;
                        } else if (ClassFileReader.isInnerClassesUtf8(cbuf)) {
                            innerClassesIndex = i;
                        } else if (ClassFileReader.isDeprecatedUtf8(cbuf)) {
                            deprecatedIndex = i;
                        }
                        if (readJDK15features) {
                            if (ClassFileReader.isAnnotationDefaultUtf8(cbuf)) {
                                annotationDefaultIndex = i;
                            } else if (ClassFileReader.isRuntimeVisibleAnnotationsUtf8(cbuf)) {
                                runtimeVisibleAnnotationsIndex = i;
                            } else if (ClassFileReader.isRuntimeInvisibleAnnotationsUtf8(cbuf)) {
                                runtimeInvisibleAnnotationsIndex = i;
                            } else if (ClassFileReader.isSignatureUtf8(cbuf)) {
                                signatureIndex = i;
                            }
                        }
                        constantPoolVector.add(new ConstantPoolUtf8(cbuf));
                        rbIndex += len;
                    }
                }
            }
            superClass = null;
            idx = rb[rbIndex + 5] & 0xFF | (rb[rbIndex + 4] & 0xFF) << 8;
            if (idx == 0) {
                if (parser.javaLangObjectSymbol != null && classSymbol != parser.javaLangObjectSymbol) {
                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                    return;
                }
                if (parser.options.javaLangObjectJDKVersion == 0) {
                    parser.options.javaLangObjectJDKVersion = version;
                }
            } else {
                classCpe = (ConstantPoolClass)constantPoolVector.get(idx);
                utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(classCpe.nameIndex);
                str = new String(utf8Cpe.string);
                superClass = packageScope.lookupClass(str);
                if (superClass == null) {
                    superClass = packageScope.enterClass(str);
                }
                classSymbol.superClass = superClass;
            }
            int thisClassIdx = rb[rbIndex + 3] & 0xFF | (rb[rbIndex + 2] & 0xFF) << 8;
            classCpe = (ConstantPoolClass)constantPoolVector.get(thisClassIdx);
            utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(classCpe.nameIndex);
            str = new String(utf8Cpe.string);
            if (!classSymbol.equalTo(packageScope.lookupClass(str))) {
                parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                return;
            }
            classSymbol.access = (short)(rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8);
            if ((classSymbol.access & 0x2000) != 0) {
                classSymbol.cd = new RawClassSymbol.AnnotationClassData();
            }
            ParameterizedClassSymbol.updateAccessOfExistingParameterizedClasses(classSymbol);
            len = rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8;
            rbIndex += 8;
            ImplementationList implementationList = null;
            for (i = 0; i < len; ++i) {
                idx = rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8;
                rbIndex += 2;
                classCpe = (ConstantPoolClass)constantPoolVector.get(idx);
                utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(classCpe.nameIndex);
                str = new String(utf8Cpe.string);
                classSym = packageScope.lookupClass(str);
                if (classSym == null) {
                    classSym = packageScope.enterClass(str);
                }
                impl = new ImplementationList(classSym);
                impl.next = implementationList;
                implementationList = impl;
            }
            classSymbol.setImplementationList(implementationList);
            len = rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8;
            rbIndex += 2;
            for (i = 0; i < len; ++i) {
                cnt = rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8;
                typeIdx = rb[rbIndex + 5] & 0xFF | (rb[rbIndex + 4] & 0xFF) << 8;
                nameIdx = rb[rbIndex + 3] & 0xFF | (rb[rbIndex + 2] & 0xFF) << 8;
                access = (short)(rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8);
                rbIndex += 8;
                utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(typeIdx);
                typeSymbol = packageScope.lookupSignature(utf8Cpe.string, 0);
                if (typeSymbol == null) {
                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                    return;
                }
                utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(nameIdx);
                FieldSymbol fieldSymbol = new FieldSymbol(0, classSymbol, Identifier.getIdentifier(utf8Cpe.string), typeSymbol, 0, access, null);
                addToList = true;
                if ((fieldSymbol.access & 0x1000) != 0) {
                    fieldSymbol.flags = (short)(fieldSymbol.flags | 1);
                    addToList = false;
                }
                classScope.enterSymbol(fieldSymbol);
                while (--cnt >= 0) {
                    idx = rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8;
                    if (idx == syntheticIndex) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 1);
                        addToList = false;
                    } else if (idx == deprecatedIndex) {
                        fieldSymbol.deprecate();
                    } else if (idx == constantValueIndex) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 2);
                        idx = rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8;
                        ConstantPoolEntry cpe = (ConstantPoolEntry)constantPoolVector.get(idx);
                        block21 : switch (cpe.tag) {
                            default: {
                                parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                                return;
                            }
                            case 3: {
                                ConstantPoolInteger integerCpe = (ConstantPoolInteger)cpe;
                                switch (typeSymbol.typeKind) {
                                    default: {
                                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                                        return;
                                    }
                                    case 2: {
                                        fieldSymbol.initializer = new BooleanConstantExpression(0, integerCpe.ival == 1);
                                        break block21;
                                    }
                                    case 4: {
                                        fieldSymbol.initializer = new CharConstantExpression(0, (char)integerCpe.ival);
                                        break block21;
                                    }
                                    case 3: {
                                        IntConstantExpression expr = new IntConstantExpression(0, TypeSymbol.byteSymbol, integerCpe.ival);
                                        ((Expression)expr).setType(TypeSymbol.byteSymbol);
                                        fieldSymbol.initializer = expr;
                                        break block21;
                                    }
                                    case 5: {
                                        IntConstantExpression expr = new IntConstantExpression(0, TypeSymbol.shortSymbol, integerCpe.ival);
                                        ((Expression)expr).setType(TypeSymbol.shortSymbol);
                                        fieldSymbol.initializer = expr;
                                        break block21;
                                    }
                                    case 6: 
                                }
                                fieldSymbol.initializer = new IntConstantExpression(0, TypeSymbol.intSymbol, integerCpe.ival);
                                break;
                            }
                            case 5: {
                                if (typeSymbol.typeKind != 7) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                                    return;
                                }
                                ConstantPoolLong longCpe = (ConstantPoolLong)cpe;
                                fieldSymbol.initializer = new LongConstantExpression(0, longCpe.lval);
                                break;
                            }
                            case 4: {
                                if (typeSymbol.typeKind != 8) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                                    return;
                                }
                                ConstantPoolFloat floatCpe = (ConstantPoolFloat)cpe;
                                fieldSymbol.initializer = new FloatConstantExpression(0, Float.intBitsToFloat(floatCpe.bits));
                                break;
                            }
                            case 6: {
                                if (typeSymbol.typeKind != 9) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                                    return;
                                }
                                ConstantPoolDouble doubleCpe = (ConstantPoolDouble)cpe;
                                fieldSymbol.initializer = new DoubleConstantExpression(0, Double.longBitsToDouble(doubleCpe.bits));
                                break;
                            }
                            case 8: {
                                if (typeSymbol.typeKind != 10) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                                    return;
                                }
                                classSym = (ClassSymbol)typeSymbol;
                                if (classSym != parser.javaLangStringPcs && classSym != parser.javaLangObjectPcs) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                                    return;
                                }
                                ConstantPoolString stringCpe = (ConstantPoolString)cpe;
                                utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(stringCpe.strIndex);
                                fieldSymbol.initializer = new StringConstantExpression(0, parser.javaLangStringPcs, utf8Cpe.string);
                                break;
                            }
                        }
                    } else if (idx == signatureIndex) {
                        idx = rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8;
                        utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(idx);
                        ClassFileReader.parseFieldSignature(parser, fieldSymbol, utf8Cpe.string);
                    }
                    attrLen = rb[rbIndex + 5] & 0xFF | (rb[rbIndex + 4] & 0xFF) << 8 | (rb[rbIndex + 3] & 0xFF) << 16 | (rb[rbIndex + 2] & 0xFF) << 24;
                    rbIndex += 2 + attrLen + 4;
                }
                if (!addToList) continue;
                classSymbol.addField(fieldSymbol);
            }
            len = rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8;
            rbIndex += 2;
            for (i = 0; i < len; ++i) {
                Symbol symbol;
                cnt = rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8;
                typeIdx = rb[rbIndex + 5] & 0xFF | (rb[rbIndex + 4] & 0xFF) << 8;
                nameIdx = rb[rbIndex + 3] & 0xFF | (rb[rbIndex + 2] & 0xFF) << 8;
                access = (short)(rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8);
                rbIndex += 8;
                utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(typeIdx);
                char[] signature = utf8Cpe.string;
                idx = Identifier.lastIndexOf(signature, ')') + 1;
                typeSymbol = packageScope.lookupSignature(signature, idx);
                if (typeSymbol == null) {
                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
                    return;
                }
                utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(nameIdx);
                Identifier identifier = Identifier.getIdentifier(utf8Cpe.string);
                methodSymbol = new MethodSymbol(0, classSymbol, identifier, typeSymbol, 0, access, null, false);
                ClassFileReader.signatureToArgumentList(parser, methodSymbol, signature, packageScope, lazy);
                if (readJDK15features) {
                    addToList = (methodSymbol.access & 0x1040) != 4096;
                } else {
                    boolean bl = addToList = (methodSymbol.access & 0x1000) == 0;
                }
                if ((methodSymbol.access & 0x1000) != 0) {
                    methodSymbol.flags = (short)(methodSymbol.flags | 1);
                }
                if ((symbol = classScope.lookupSpecificSymbolInScope(identifier, 8, true)) == null) {
                    classScope.enterSymbol(methodSymbol);
                } else {
                    MethodSymbol baseMethodSymbol = (MethodSymbol)symbol;
                    methodSymbol.nextWithSameName = baseMethodSymbol.nextWithSameName;
                    baseMethodSymbol.nextWithSameName = methodSymbol;
                }
                while (--cnt >= 0) {
                    idx = rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8;
                    if (idx == syntheticIndex) {
                        addToList = false;
                    } else if (idx == deprecatedIndex) {
                        methodSymbol.deprecate();
                    } else if (idx == exceptionsIndex) {
                        cnt2 = (rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8) * 2;
                        for (j = 0; j < cnt2; j += 2) {
                            idx = rb[rbIndex + j + 9] & 0xFF | (rb[rbIndex + j + 8] & 0xFF) << 8;
                            classCpe = (ConstantPoolClass)constantPoolVector.get(idx);
                            utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(classCpe.nameIndex);
                            str = new String(utf8Cpe.string);
                            classSym = packageScope.lookupClass(str);
                            if (classSym == null) {
                                classSym = packageScope.enterClass(str);
                            }
                            MethodSymbol.ThrowsList tl = new MethodSymbol.ThrowsList(classSym);
                            tl.next = methodSymbol.throwsList;
                            methodSymbol.throwsList = tl;
                        }
                    } else if (idx == signatureIndex) {
                        idx = rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8;
                        utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(idx);
                        ClassFileReader.parseMethodSignature(parser, methodSymbol, utf8Cpe.string);
                    } else if (idx == annotationDefaultIndex) {
                        methodSymbol.flags = (short)(methodSymbol.flags | 0x40);
                    }
                    attrLen = rb[rbIndex + 5] & 0xFF | (rb[rbIndex + 4] & 0xFF) << 8 | (rb[rbIndex + 3] & 0xFF) << 16 | (rb[rbIndex + 2] & 0xFF) << 24;
                    rbIndex += 2 + attrLen + 4;
                }
                if (!addToList) continue;
                methodSymbol.nextInClass = classSymbol.cd.methodList;
                classSymbol.cd.methodList = methodSymbol;
            }
            cnt = rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8;
            rbIndex += 2;
            while (--cnt >= 0) {
                idx = rb[rbIndex + 1] & 0xFF | (rb[rbIndex] & 0xFF) << 8;
                if (idx == deprecatedIndex) {
                    classSymbol.deprecate();
                } else if (idx == innerClassesIndex) {
                    cnt2 = (rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8) * 8;
                    for (j = 0; j < cnt2; j += 8) {
                        idx = rb[rbIndex + j + 9] & 0xFF | (rb[rbIndex + j + 8] & 0xFF) << 8;
                        if (idx == thisClassIdx) {
                            access = (short)(rb[rbIndex + j + 15] & 0xFF | (rb[rbIndex + j + 14] & 0xFF) << 8);
                            classSymbol.access = (short)(classSymbol.access & 0xFFFFFFF8);
                            classSymbol.access = (short)(classSymbol.access | access);
                            continue;
                        }
                        classCpe = (ConstantPoolClass)constantPoolVector.get(idx);
                        utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(classCpe.nameIndex);
                        str = new String(utf8Cpe.string);
                        idx = str.lastIndexOf(36);
                        String name = str.substring(idx + 1);
                        idx = rb[rbIndex + j + 11] & 0xFF | (rb[rbIndex + j + 10] & 0xFF) << 8;
                        if (idx != thisClassIdx || (idx = rb[rbIndex + j + 13] & 0xFF | (rb[rbIndex + j + 12] & 0xFF) << 8) == 0) continue;
                        utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(idx);
                        str = new String(utf8Cpe.string);
                        if (str.equals("") || !str.equals(name)) continue;
                        access = (short)(rb[rbIndex + j + 15] & 0xFF | (rb[rbIndex + j + 14] & 0xFF) << 8);
                        innerClass = new InnerClassSymbol(0, Identifier.getIdentifier(str), access, null, null, false);
                        classScope.enterSymbol(innerClass);
                        classSymbol.addInnerClass(innerClass);
                    }
                } else if (idx == signatureIndex) {
                    idx = rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8;
                    utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(idx);
                    ClassFileReader.parseClassSignature(parser, classSymbol, utf8Cpe.string);
                } else if (classSymbol.isAnnotation()) {
                    RawClassSymbol.AnnotationClassData acd = (RawClassSymbol.AnnotationClassData)classSymbol.cd;
                    if (idx == runtimeVisibleAnnotationsIndex || idx == runtimeInvisibleAnnotationsIndex) {
                        cnt2 = rb[rbIndex + 7] & 0xFF | (rb[rbIndex + 6] & 0xFF) << 8;
                        int off = rbIndex + 8;
                        while (--cnt2 >= 0) {
                            idx = rb[off + 1] & 0xFF | (rb[off] & 0xFF) << 8;
                            utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(idx);
                            str = new String(utf8Cpe.string);
                            if (str.equals("Ljava/lang/annotation/Retention;")) {
                                idx = rb[off + 10] & 0xFF | (rb[off + 9] & 0xFF) << 8;
                                utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(idx);
                                str = new String(utf8Cpe.string);
                                if (str.equals("SOURCE")) {
                                    acd.retention = 0;
                                } else if (str.equals("CLASS")) {
                                    acd.retention = 1;
                                } else {
                                    if (!$assertionsDisabled && !str.equals("RUNTIME")) {
                                        throw new AssertionError();
                                    }
                                    acd.retention = (byte)2;
                                }
                                off += 11;
                                continue;
                            }
                            if (str.equals("Ljava/lang/annotation/Target;")) {
                                int cnt3 = rb[off + 8] & 0xFF | (rb[off + 7] & 0xFF) << 8;
                                off += 9;
                                acd.target = 0;
                                while (--cnt3 >= 0) {
                                    idx = rb[off + 4] & 0xFF | (rb[off + 3] & 0xFF) << 8;
                                    utf8Cpe = (ConstantPoolUtf8)constantPoolVector.get(idx);
                                    str = new String(utf8Cpe.string);
                                    if (str.equals("TYPE")) {
                                        acd.target = (byte)(acd.target | 1);
                                    } else if (str.equals("FIELD")) {
                                        acd.target = (byte)(acd.target | 2);
                                    } else if (str.equals("METHOD")) {
                                        acd.target = (byte)(acd.target | 4);
                                    } else if (str.equals("PARAMETER")) {
                                        acd.target = (byte)(acd.target | 8);
                                    } else if (str.equals("CONSTRUCTOR")) {
                                        acd.target = (byte)(acd.target | 0x10);
                                    } else if (str.equals("LOCAL_VARIABLE")) {
                                        acd.target = (byte)(acd.target | 0x20);
                                    } else if (str.equals("ANNOTATION_TYPE")) {
                                        acd.target = (byte)(acd.target | 0x40);
                                    } else {
                                        if (!$assertionsDisabled && !str.equals("PACKAGE")) {
                                            throw new AssertionError();
                                        }
                                        acd.target = (byte)(acd.target | 0xFFFFFF80);
                                    }
                                    off += 5;
                                }
                                continue;
                            }
                            off = ClassFileReader.skipAnnotation(rb, off);
                        }
                    }
                }
                attrLen = rb[rbIndex + 5] & 0xFF | (rb[rbIndex + 4] & 0xFF) << 8 | (rb[rbIndex + 3] & 0xFF) << 16 | (rb[rbIndex + 2] & 0xFF) << 24;
                rbIndex += 2 + attrLen + 4;
            }
        }
        catch (Exception e) {
            parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getPath());
            return;
        }
        classSymbol.classScope = classScope;
        superClass = classSymbol.superClass;
        if (superClass != null) {
            if (superClass instanceof UnresolvedClassSymbol) {
                classSymbol.superClass = superClass = (ClassSymbol)superClass.resolveType(parser, 0, false, false, lazy);
            }
            rcs = superClass.getClassSymbol();
            if (!lazy) {
                rcs.loadType(parser, pos, false, true);
                classSymbol.superClass = (ClassSymbol)superClass.resolveType(parser, 0, false, false, false);
            }
            classSymbol.flags = (short)(classSymbol.flags | superClass.getClassSymbol().flags & 0xC00);
            if (classSymbol.hasCompiledSuperclasses()) {
                parser.loadedClassesWithCompiledSuperclassesList.add(classSymbol);
            }
        }
        if ((impl = classSymbol.getImplementationList()) != null) {
            classSymbol.flags = (short)(classSymbol.flags | 0x400);
            do {
                if ((classSym = impl.interfaceSymbol) instanceof UnresolvedClassSymbol) {
                    impl.interfaceSymbol = classSym = (ClassSymbol)classSym.resolveType(parser, 0, false, false, lazy);
                }
                rcs = classSym.getClassSymbol();
                if (!lazy) {
                    rcs.loadType(parser, pos, false, true);
                    impl.interfaceSymbol = (ClassSymbol)classSym.resolveType(parser, 0, false, false, false);
                }
                if (parser.javaIoSerializableSymbol == null || !classSym.equalTo(parser.javaIoSerializableSymbol)) continue;
                classSymbol.flags = (short)(classSymbol.flags | 0x800);
            } while ((impl = impl.next) != null);
        }
        TypeParameterList tpl = classSymbol.cd.getTypeParameterList();
        while (tpl != null) {
            classSym = tpl.typeParameter.bound;
            if (classSym instanceof UnresolvedClassSymbol) {
                tpl.typeParameter.bound = (ClassSymbol)classSym.resolveType(parser, 0, false, false, false);
            }
            ClassSymbolList csl = tpl.typeParameter.interfaceBounds;
            while (csl != null) {
                classSym = csl.classSymbol;
                if (classSym instanceof UnresolvedClassSymbol) {
                    csl.classSymbol = (ClassSymbol)classSym.resolveType(parser, 0, false, false, false);
                }
                csl = csl.next;
            }
            tpl = tpl.next;
        }
        methodSymbol = classSymbol.cd.methodList;
        while (methodSymbol != null) {
            ClassFileReader.trimThrownTypeParameterBounds(methodSymbol);
            methodSymbol = methodSymbol.nextInClass;
        }
        if (classSymbol.isNonStaticInnerClass()) {
            boolean addedHiddenOuterThis = false;
            innerClass = (InnerClassSymbol)classSymbol;
            methodSymbol = (MethodSymbol)classSymbol.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
            while (methodSymbol != null) {
                if (!$assertionsDisabled && methodSymbol.argumentList == null) {
                    throw new AssertionError();
                }
                methodSymbol.argumentList = methodSymbol.argumentList.next;
                methodSymbol.argCount = (short)(methodSymbol.argCount - 1);
                if (!addedHiddenOuterThis) {
                    addedHiddenOuterThis = true;
                    innerClass.addHiddenOuterThisArgument(innerClass.getOuterClass(), null);
                }
                methodSymbol = methodSymbol.nextWithSameName;
            }
        }
        if (!lazy) {
            classSymbol.flags = (short)(classSymbol.flags | 0x40);
        }
        if (parser.options.verbose) {
            parser.options.log.println("[" + Message.loadingString + " " + storage.getPath() + " " + (System.currentTimeMillis() - ms) + "ms ]");
        }
    }

    static void trimThrownTypeParameterBounds(MethodSymbol methodSymbol) {
        MethodSymbol.ThrowsList throwsList = methodSymbol.throwsList;
        while (throwsList != null) {
            TypeSymbol thrownType = throwsList.throwsType;
            if (thrownType.isTypeParameter()) {
                MethodSymbol.ThrowsList checkList = methodSymbol.throwsList;
                MethodSymbol.ThrowsList prevList = null;
                while (checkList != null) {
                    TypeSymbol checkType;
                    if (checkList != throwsList && ((TypeParameterSymbol)thrownType).bound.equalTo(checkType = checkList.throwsType)) {
                        if (prevList == null) {
                            methodSymbol.throwsList = checkList.next;
                            break;
                        }
                        prevList.next = checkList.next;
                        break;
                    }
                    prevList = checkList;
                    checkList = checkList.next;
                }
            }
            throwsList = throwsList.next;
        }
    }

    static {
        $assertionsDisabled = !ClassFileReader.class.desiredAssertionStatus();
        syntheticName = new char[]{'S', 'y', 'n', 't', 'h', 'e', 't', 'i', 'c'};
        constantValueName = new char[]{'C', 'o', 'n', 's', 't', 'a', 'n', 't', 'V', 'a', 'l', 'u', 'e'};
        exceptionsName = new char[]{'E', 'x', 'c', 'e', 'p', 't', 'i', 'o', 'n', 's'};
        innerClassesName = new char[]{'I', 'n', 'n', 'e', 'r', 'C', 'l', 'a', 's', 's', 'e', 's'};
        deprecatedName = new char[]{'D', 'e', 'p', 'r', 'e', 'c', 'a', 't', 'e', 'd'};
        annotationDefaultName = new char[]{'A', 'n', 'n', 'o', 't', 'a', 't', 'i', 'o', 'n', 'D', 'e', 'f', 'a', 'u', 'l', 't'};
        runtimeVisibleAnnotationsName = new char[]{'R', 'u', 'n', 't', 'i', 'm', 'e', 'V', 'i', 's', 'i', 'b', 'l', 'e', 'A', 'n', 'n', 'o', 't', 'a', 't', 'i', 'o', 'n', 's'};
        runtimeInvisibleAnnotationsName = new char[]{'R', 'u', 'n', 't', 'i', 'm', 'e', 'I', 'n', 'v', 'i', 's', 'i', 'b', 'l', 'e', 'A', 'n', 'n', 'o', 't', 'a', 't', 'i', 'o', 'n', 's'};
        signatureName = new char[]{'S', 'i', 'g', 'n', 'a', 't', 'u', 'r', 'e'};
    }

    private static class CharBuffer {
        char[] array;
        int start;

        CharBuffer(char[] array) {
            this.array = array;
        }

        boolean more() {
            return this.start < this.array.length;
        }

        char getChar() {
            return this.array[this.start];
        }

        void skipChar() {
            ++this.start;
        }

        char nextChar() {
            return this.array[this.start++];
        }

        Identifier nextIdentifier(boolean ignoreDollarSign) {
            int last;
            int first = last = this.start;
            block4: while (true) {
                switch (this.array[last]) {
                    default: {
                        ++last;
                        continue block4;
                    }
                    case '$': {
                        if (!ignoreDollarSign) break block4;
                        ++last;
                        continue block4;
                    }
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '<': 
                }
                break;
            }
            this.start = last;
            return Identifier.getIdentifier(this.array, first, last);
        }
    }
}

