/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;

final class ClassExpression
extends Expression {
    TypeSymbol classType;

    ClassExpression(int pos, TypeSymbol classType, Parser parser) {
        super((byte)48, pos);
        this.classType = classType;
        if (!parser.targetingAtLeastOneFive) {
            parser.currentClassSymbol.flags = (short)(parser.currentClassSymbol.flags | 8);
        }
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        this.classType = typeSymbol = this.classType.resolveType(parser, this.pos, true, true, false);
        if (typeSymbol.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        typeSymbol.checkDeprecated(parser, this.pos);
        TypeSymbol baseType = typeSymbol;
        if (typeSymbol.isArrayType()) {
            baseType = ((ArraySymbol)typeSymbol).baseType;
        }
        if (baseType.isTypeParameter()) {
            parser.error(Message.errorIllegalTypeParameterOperator, this.pos, false, this.toString());
        }
        if (baseType.isClass()) {
            RawClassSymbol classSymbol = ((ClassSymbol)baseType).getClassSymbol();
            parser.depInfo.addReference(parser.currentClassSymbol, classSymbol);
            parser.currentClassSymbol.addNameReference(parser, classSymbol, this.pos);
        }
        TypeVariableList tvl = null;
        if (parser.parsingAtLeastOneFive && typeSymbol.isReferenceType()) {
            tvl = new TypeVariableList(new TypeVariableSymbol(0, 1, (ReferenceTypeSymbol)typeSymbol));
        }
        this.setType(ParameterizedClassSymbol.getParameterizedClassSymbol(parser.javaLangClassSymbol, tvl, null));
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (this.classType.isPrimitiveType()) {
            short index = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(TypeSymbol.classInternalName[this.classType.typeKind], Identifier.typeIdentifier.name, Identifier.javaLangClassSignature.name);
            byteCodeGenerator.generate_8_16((byte)-78, index);
        } else {
            TypeSymbol baseType;
            if (!byteCodeGenerator.parser.targetingAtLeastOneFive) {
                String fieldName;
                String className;
                if (this.classType.isArrayType()) {
                    StringBuffer sbc = new StringBuffer("[");
                    StringBuffer sbf = new StringBuffer("array$");
                    int i = ((ArraySymbol)this.classType).dimension;
                    while (--i > 0) {
                        sbc.append('[');
                        sbf.append('$');
                    }
                    baseType = ((ArraySymbol)this.classType).baseType;
                    if (baseType.isPrimitiveType()) {
                        char baseChar = TypeSymbol.typeKindToSignature[baseType.typeKind][0];
                        sbc.append(baseChar);
                        sbf.append(baseChar);
                    } else {
                        String baseName = new String(baseType.getInternalName());
                        sbc.append('L');
                        sbc.append(baseName.replace('/', '.'));
                        sbc.append(';');
                        sbf.append('L');
                        sbf.append(baseName.replace('/', '$'));
                    }
                    className = sbc.toString();
                    fieldName = sbf.toString();
                } else {
                    className = new String(this.classType.getInternalName()).replace('/', '.');
                    fieldName = "class$" + className.replace('.', '$');
                }
                MethodSymbol classLoaderMethod = byteCodeGenerator.parser.currentClassSymbol.cd.ccd.classLoaderMethod;
                FieldSymbol fieldSymbol = classLoaderMethod.definingClass.getClassFieldSymbol(byteCodeGenerator.parser, fieldName);
                short fieldIdx = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(classLoaderMethod.definingClass.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
                byteCodeGenerator.generate_8_16_8((byte)-78, fieldIdx, (byte)89);
                byteCodeGenerator.incOpStackHeight(2);
                Label label = new Label();
                byteCodeGenerator.generateBranch_ifnonnull(label);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(2);
                short index = byteCodeGenerator.constantPool.enterConstantPoolString(className.toCharArray());
                if (index > 255) {
                    byteCodeGenerator.generate_8_16((byte)19, index);
                } else {
                    byteCodeGenerator.generate_8_8((byte)18, (byte)index);
                }
                index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(classLoaderMethod.definingClass.getInternalName(), classLoaderMethod.identifier.name, classLoaderMethod.getSignature());
                byteCodeGenerator.generate_8_16_8((byte)-72, index, (byte)89);
                byteCodeGenerator.generate_8_16((byte)-77, fieldIdx);
                byteCodeGenerator.setLabel(label);
            } else {
                short index = byteCodeGenerator.constantPool.enterConstantPoolClass(this.classType.getInternalName());
                if (index > 255) {
                    byteCodeGenerator.generate_8_16((byte)19, index);
                } else {
                    byteCodeGenerator.generate_8_8((byte)18, (byte)index);
                }
            }
            RawClassSymbol classSymbol = null;
            if (this.classType.isArrayType()) {
                baseType = ((ArraySymbol)this.classType).baseType;
                if (baseType.isClass()) {
                    classSymbol = ((ClassSymbol)baseType).getClassSymbol();
                }
            } else {
                classSymbol = ((ClassSymbol)this.classType).getClassSymbol();
            }
            if (classSymbol != null) {
                byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(byteCodeGenerator.parser.currentClassSymbol, classSymbol);
            }
        }
        byteCodeGenerator.incOpStackHeight(1);
    }

    public String toString() {
        return ".class";
    }
}

