/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class BitExpression
extends BinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    BitExpression(byte kind, int pos, Expression leftOperand, Expression rightOperand) {
        super(kind, pos, leftOperand, rightOperand);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol commonType;
        Expression leftOp = this.leftOperand.resolveAndCheck(parser);
        Expression rightOp = this.rightOperand.resolveAndCheck(parser);
        TypeSymbol leftOpType = leftOp.getType();
        TypeSymbol rightOpType = rightOp.getType();
        if (leftOpType.typeKind == 2 && rightOpType.typeKind == 2) {
            commonType = TypeSymbol.booleanSymbol;
            this.setType(commonType);
        } else {
            commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType);
            this.setType(commonType);
            if (commonType.isErroneous() || (commonType.typeClass & 0x30) != 0) {
                if (parser.parsingAtLeastOneFive && (leftOpType.equalTo(parser.javaLangBooleanSymbol) || leftOpType == TypeSymbol.booleanSymbol) && (rightOpType.equalTo(parser.javaLangBooleanSymbol) || rightOpType == TypeSymbol.booleanSymbol)) {
                    commonType = TypeSymbol.booleanSymbol;
                    this.setType(commonType);
                } else {
                    Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, rightOpType.isErroneous() | leftOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                    return new ErrorExpression(error);
                }
            }
        }
        this.leftOperand = leftOp.promoteType(parser, commonType);
        this.rightOperand = rightOp.promoteType(parser, commonType);
        return this.foldExpression();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator, byte intOpcode, byte longOpcode) {
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 2: 
            case 4: {
                byteCodeGenerator.generate_8(intOpcode);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8(longOpcode);
                byteCodeGenerator.decOpStackHeight(2);
            }
        }
    }

    static {
        $assertionsDisabled = !BitExpression.class.desiredAssertionStatus();
    }
}

