/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.Parser;

abstract class BinaryExpression
extends Expression {
    Expression leftOperand;
    Expression rightOperand;

    BinaryExpression(byte kind, int pos, Expression leftOperand, Expression rightOperand) {
        super(kind, pos);
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    Expression constantFolding(Parser parser) {
        this.leftOperand = this.leftOperand.constantFolding(parser);
        this.rightOperand = this.rightOperand.constantFolding(parser);
        return this.foldExpression();
    }

    protected void generateByteCodeForAssignmentExpression(ByteCodeGenerator byteCodeGenerator, Expression leftOp) {
        if (this.getType().typeKind != 1) {
            if ((leftOp.getType().typeClass & 0x28) != 0) {
                if (leftOp.kind == 3) {
                    byteCodeGenerator.generate_8((byte)94);
                } else if (leftOp instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)92);
                } else {
                    FieldSymbol fieldVar = (FieldSymbol)((FieldExpression)leftOp).field;
                    if ((fieldVar.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        byteCodeGenerator.generate_8((byte)93);
                    }
                }
                byteCodeGenerator.incOpStackHeight(2);
            } else {
                if (leftOp.kind == 3) {
                    byteCodeGenerator.generate_8((byte)91);
                } else if (leftOp instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)89);
                } else {
                    FieldSymbol fieldVar = (FieldSymbol)((FieldExpression)leftOp).field;
                    if ((fieldVar.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        byteCodeGenerator.generate_8((byte)90);
                    }
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        leftOp.generateByteCodeWrite(byteCodeGenerator);
    }
}

