/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AppendStringExpression;
import oracle.ojc.compiler.AssignmentOperationExpression;
import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class AssignmentPlusExpression
extends AssignmentOperationExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    AssignmentPlusExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)6, pos, leftOperand, rightOperand);
    }

    Expression resolveAndCheck(Parser parser) {
        Expression leftOp = this.leftOperand;
        byte kind = leftOp.kind;
        if (kind != 1 && kind != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, leftOp.pos, kind == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        leftOp = leftOp.resolveAndCheckReadBeforeWrite(parser);
        kind = leftOp.kind;
        if (kind != 1 && kind != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, kind == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        Expression rightOp = this.rightOperand;
        rightOp = rightOp.resolveAndCheck(parser);
        RawClassSymbol javaLangString = parser.javaLangStringSymbol;
        TypeSymbol leftOpType = leftOp.getType();
        if (leftOpType.equalTo(javaLangString)) {
            if (rightOp.getType().typeKind == 1) {
                Error error = parser.error(Message.errorTypeNotAllowed, this.pos, false, TypeSymbol.voidSymbol.errorName());
                return new ErrorExpression(error);
            }
            if (rightOp.kind != 51) {
                rightOp = new AppendStringExpression(parser, rightOp);
            }
        } else {
            TypeSymbol rightOpType = rightOp.getType();
            TypeSymbol commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType);
            if (commonType.isErroneous()) {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, rightOpType.isErroneous() | leftOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                return new ErrorExpression(error);
            }
        }
        this.setType(leftOpType);
        this.leftOperand = leftOp;
        this.rightOperand = rightOp;
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression leftOp = this.leftOperand;
        TypeSymbol leftOpType = leftOp.getType();
        Parser parser = byteCodeGenerator.parser;
        if (leftOpType.equalTo(parser.javaLangStringSymbol)) {
            char[] signature;
            char[] className;
            ConstantPool constantPool = byteCodeGenerator.constantPool;
            boolean savedDoingStringConcatonation = byteCodeGenerator.doingStringConcatonation;
            byteCodeGenerator.doingStringConcatonation = true;
            if (!parser.targetingAtLeastOneFive) {
                className = Identifier.javaLangStringBufferInternal.name;
                signature = Identifier.javaLangStringBufferMethodStringSignature.name;
            } else {
                className = Identifier.javaLangStringBuilderInternal.name;
                signature = Identifier.javaLangStringBuilderMethodStringSignature.name;
            }
            short index = constantPool.enterConstantPoolClass(className);
            byteCodeGenerator.generate_8_16((byte)-69, index);
            byteCodeGenerator.generate_8((byte)89);
            byteCodeGenerator.incOpStackHeight(2);
            index = constantPool.enterConstantPoolMethodRef(className, Identifier.initializerIdentifier.name, Identifier.voidMethodSignature.name);
            byteCodeGenerator.generate_8_16((byte)-73, index);
            byteCodeGenerator.decOpStackHeight(1);
            index = constantPool.enterConstantPoolMethodRef(className, Identifier.appendIdentifier.name, signature);
            leftOp.generateByteCodeReadBeforeWrite(byteCodeGenerator, true);
            byteCodeGenerator.generate_8_16((byte)-74, index);
            byteCodeGenerator.decOpStackHeight(1);
            this.rightOperand.generateByteCode(byteCodeGenerator);
            index = constantPool.enterConstantPoolMethodRef(className, Identifier.toStringIdentifier.name, Identifier.javaLangStringMethodSignature.name);
            byteCodeGenerator.generate_8_16((byte)-74, index);
            byteCodeGenerator.doingStringConcatonation = savedDoingStringConcatonation;
        } else {
            leftOp.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
            TypeSymbol primitiveType = null;
            if (leftOpType.isReferenceType()) {
                primitiveType = BoxingExpression.getPrimitiveType(parser, leftOpType);
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, leftOpType, primitiveType);
                leftOpType = primitiveType;
            }
            Expression rightOp = this.rightOperand;
            TypeSymbol rightOpType = rightOp.getType();
            TypeSymbol commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType);
            byte commonTypeClass = commonType.typeClass;
            byteCodeGenerator.generateWideningPrimitiveConversion(leftOpType.typeClass, commonTypeClass);
            rightOp.generateByteCode(byteCodeGenerator);
            if (rightOpType.isReferenceType()) {
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, rightOpType, leftOpType);
            }
            byteCodeGenerator.generateWideningPrimitiveConversion(rightOpType.typeClass, commonTypeClass);
            switch (commonTypeClass) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 4: {
                    byteCodeGenerator.generate_8((byte)96);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 8: {
                    byteCodeGenerator.generate_8((byte)97);
                    byteCodeGenerator.decOpStackHeight(2);
                    break;
                }
                case 16: {
                    byteCodeGenerator.generate_8((byte)98);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 32: {
                    byteCodeGenerator.generate_8((byte)99);
                    byteCodeGenerator.decOpStackHeight(2);
                }
            }
            byteCodeGenerator.generateNarrowingPrimitiveConversion(commonTypeClass, leftOpType.typeKind);
            if (primitiveType != null) {
                AutoBoxingExpression.generateByteCode(byteCodeGenerator, primitiveType, leftOp.getType());
            }
        }
        this.generateByteCodeForAssignmentExpression(byteCodeGenerator, leftOp);
    }

    public String toString() {
        return "+=";
    }

    static {
        $assertionsDisabled = !AssignmentPlusExpression.class.desiredAssertionStatus();
    }
}

