/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class AssignmentOperationExpression
extends BinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    AssignmentOperationExpression(byte kind, int pos, Expression leftOperand, Expression rightOperand) {
        super(kind, pos, leftOperand, rightOperand);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol rightOpType;
        Expression leftOp = this.leftOperand;
        byte kind = leftOp.kind;
        if (kind != 1 && kind != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, leftOp.pos, kind == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        leftOp = leftOp.resolveAndCheckReadBeforeWrite(parser);
        kind = leftOp.kind;
        if (kind != 1 && kind != 3) {
            Error error = parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, kind == 0, Message.variableString, Message.valueString);
            return new ErrorExpression(error);
        }
        Expression rightOp = this.rightOperand;
        rightOp = rightOp.resolveAndCheck(parser);
        TypeSymbol leftOpType = leftOp.getType();
        TypeSymbol commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType = rightOp.getType());
        if (commonType.isErroneous()) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, rightOpType.isErroneous() | leftOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
            return new ErrorExpression(error);
        }
        this.setType(leftOpType);
        this.leftOperand = leftOp;
        this.rightOperand = rightOp;
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator, byte intOpcode, byte longOpcode, byte floatOpcode, byte doubleOpcode) {
        Expression leftOp = this.leftOperand;
        leftOp.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
        TypeSymbol leftOpType = leftOp.getType();
        Parser parser = byteCodeGenerator.parser;
        TypeSymbol primitiveType = null;
        if (leftOpType.isReferenceType()) {
            primitiveType = BoxingExpression.getPrimitiveType(parser, leftOpType);
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, leftOpType, primitiveType);
            leftOpType = primitiveType;
        }
        Expression rightOp = this.rightOperand;
        TypeSymbol rightOpType = rightOp.getType();
        TypeSymbol commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType);
        byte commonTypeClass = commonType.typeClass;
        byteCodeGenerator.generateWideningPrimitiveConversion(leftOpType.typeClass, commonTypeClass);
        rightOp.generateByteCode(byteCodeGenerator);
        if (rightOpType.isReferenceType()) {
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, rightOpType, leftOpType);
        }
        byteCodeGenerator.generateWideningPrimitiveConversion(rightOpType.typeClass, commonTypeClass);
        switch (commonTypeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                byteCodeGenerator.generate_8(intOpcode);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8(longOpcode);
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8(floatOpcode);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8(doubleOpcode);
                byteCodeGenerator.decOpStackHeight(2);
            }
        }
        byteCodeGenerator.generateNarrowingPrimitiveConversion(commonTypeClass, leftOpType.typeKind);
        if (primitiveType != null) {
            AutoBoxingExpression.generateByteCode(byteCodeGenerator, primitiveType, leftOp.getType());
        }
        this.generateByteCodeForAssignmentExpression(byteCodeGenerator, leftOp);
    }

    static {
        $assertionsDisabled = !AssignmentOperationExpression.class.desiredAssertionStatus();
    }
}

