/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.NullConstantExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

final class ArrayExpression
extends Expression {
    static byte[] aload_opcode = new byte[12];
    static byte[] astore_opcode;
    Expression arrayExpr;
    Expression indexExpr;

    ArrayExpression(Expression arrayExpr, Expression indexExpr) {
        super((byte)3, arrayExpr.pos);
        this.arrayExpr = arrayExpr;
        this.indexExpr = indexExpr;
    }

    Expression resolveAndCheck(Parser parser) {
        Expression arrExpr = this.arrayExpr;
        arrExpr = arrExpr.resolveAndCheck(parser);
        Expression idxExpr = this.indexExpr;
        idxExpr = idxExpr.resolveAndCheck(parser);
        TypeSymbol arrType = arrExpr.getType();
        if ((arrType.typeClass & 0xFFFFFF80) == 0) {
            int pos = arrExpr.pos;
            if (arrExpr instanceof NullConstantExpression) {
                parser.error(Message.errorNullDeref, pos, false);
            } else {
                parser.error(Message.errorArrayRequired, pos, false, arrType.errorName());
            }
            this.setType(TypeSymbol.errorSymbol);
        } else if (arrType.isErroneous()) {
            this.setType(arrType);
        } else {
            ArraySymbol arraySymbol = (ArraySymbol)arrType;
            this.setType(ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1));
        }
        TypeSymbol idxType = idxExpr.getType();
        if ((idxType.typeClass & 4) == 0) {
            TypeSymbol primitiveType;
            if (parser.parsingAtLeastOneFive && idxType.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, idxType)) != null && (primitiveType.typeClass & 4) != 0) {
                idxExpr = new AutoUnboxingExpression(idxExpr, primitiveType);
                idxType = primitiveType;
            } else {
                Error error = parser.error(Message.errorIncompatibleTypes, idxExpr.pos, false, idxType.errorName(), "int");
                return new ErrorExpression(error);
            }
        }
        idxType = TypeSymbol.unaryNumericPromotion(parser, idxType);
        this.indexExpr = idxExpr.promoteType(parser, idxType);
        this.arrayExpr = arrExpr;
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.arrayExpr.generateByteCode(byteCodeGenerator);
        this.indexExpr.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8(aload_opcode[this.getType().typeKind]);
        TypeSymbol typeSymbol = this.getType();
        if ((typeSymbol.typeClass & 0x28) == 0) {
            byteCodeGenerator.decOpStackHeight(1);
        }
        ArraySymbol arrayType = (ArraySymbol)this.arrayExpr.getType();
        TypeSymbol elementType = ArraySymbol.getArrayType(arrayType.baseType, arrayType.dimension - 1).eraseType();
        if (!typeSymbol.equalTo(elementType)) {
            short index = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
            byteCodeGenerator.generate_8_16((byte)-64, index);
        }
    }

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean x1) {
        this.arrayExpr.generateByteCode(byteCodeGenerator);
        this.indexExpr.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8_8(x1 ? (byte)93 : 92, aload_opcode[this.getType().typeKind]);
        byteCodeGenerator.incOpStackHeight(2);
        if ((this.getType().typeClass & 0x28) == 0) {
            byteCodeGenerator.decOpStackHeight(1);
        }
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.generate_8(astore_opcode[this.getType().typeKind]);
        byteCodeGenerator.decOpStackHeight(3);
        if ((this.getType().typeClass & 0x28) != 0) {
            byteCodeGenerator.decOpStackHeight(1);
        }
    }

    static {
        ArrayExpression.aload_opcode[11] = 50;
        ArrayExpression.aload_opcode[10] = 50;
        ArrayExpression.aload_opcode[2] = 51;
        ArrayExpression.aload_opcode[3] = 51;
        ArrayExpression.aload_opcode[4] = 52;
        ArrayExpression.aload_opcode[5] = 53;
        ArrayExpression.aload_opcode[6] = 46;
        ArrayExpression.aload_opcode[7] = 47;
        ArrayExpression.aload_opcode[8] = 48;
        ArrayExpression.aload_opcode[9] = 49;
        astore_opcode = new byte[12];
        ArrayExpression.astore_opcode[11] = 83;
        ArrayExpression.astore_opcode[10] = 83;
        ArrayExpression.astore_opcode[2] = 84;
        ArrayExpression.astore_opcode[3] = 84;
        ArrayExpression.astore_opcode[4] = 85;
        ArrayExpression.astore_opcode[5] = 86;
        ArrayExpression.astore_opcode[6] = 79;
        ArrayExpression.astore_opcode[7] = 80;
        ArrayExpression.astore_opcode[8] = 81;
        ArrayExpression.astore_opcode[9] = 82;
    }
}

