/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ide.Version;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.DefaultXMIMetaModelProvider;
import oracle.mof.xmi.XMIMetaModelProvider;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIPropertyType;
import oracle.mof.xmi.XMIType;
import oracle.mof.xmi.XMLWriter;

public abstract class XMIWriter {
    private XMLWriter m_writer;
    private String m_exporter = Version.NAME;
    private String m_exporterVersion = Version.VER;
    private XMIMetaModelProvider m_metamodelProvider = new DefaultXMIMetaModelProvider();
    private ArrayList<XMIProperty> m_properties = new ArrayList();
    private boolean m_propertyAsAttribute;
    private boolean m_inInstance;
    private boolean m_hasAttributeContent;
    private boolean m_longReferences;

    public final void setMetaModelProvider(XMIMetaModelProvider provider) {
        ContractUtils.checkNull(provider, "Provider must not be null");
        this.m_metamodelProvider = provider;
    }

    public final XMIMetaModelProvider getMetaModelProvider() {
        return this.m_metamodelProvider;
    }

    public final void setXMLWriter(XMLWriter writer) {
        ContractUtils.checkNull(writer, "Writer must not be null");
        this.m_writer = writer;
        this.m_writer.setMaxAttributes(Integer.MAX_VALUE);
    }

    protected final XMLWriter getXMLWriter() {
        return this.m_writer;
    }

    public final void setExporter(String exporter) {
        this.m_exporter = exporter == null ? "" : exporter;
    }

    protected final String getExporter() {
        return this.m_exporter;
    }

    public final void setExporterVersion(String exporterVersion) {
        this.m_exporterVersion = exporterVersion == null ? "" : exporterVersion;
    }

    protected final String getExporterVersion() {
        return this.m_exporterVersion;
    }

    public void setLongReferences(boolean longReferences) {
        this.m_longReferences = longReferences;
    }

    private void pushProperty(XMIProperty property) {
        this.m_properties.add(property);
    }

    private XMIProperty popProperty() {
        return this.m_properties.remove(this.m_properties.size() - 1);
    }

    protected XMIProperty peekProperty() {
        return this.m_properties.size() == 0 ? null : this.m_properties.get(this.m_properties.size() - 1);
    }

    public void abort() {
        this.m_writer.abort();
    }

    public abstract void startXMI() throws IOException;

    public final void startInstance(XMIType type) {
        if (this.m_inInstance) {
            throw new IllegalStateException("Cannot output instance within instance");
        }
        XMIProperty property = this.peekProperty();
        if (property != null && property.getPropertyType() != XMIPropertyType.COMPOSITE) {
            throw new IllegalStateException("Cannot output instance within non-composite property");
        }
        this.m_writer.setMaxAttributes(Integer.MAX_VALUE);
        this.m_inInstance = true;
        this.startInstanceImpl(type);
    }

    public abstract void startInstanceImpl(XMIType var1);

    public void startProperty(XMIProperty property) {
        if (!this.m_inInstance) {
            throw new IllegalStateException("Cannot output property within property");
        }
        this.m_inInstance = false;
        this.pushProperty(property);
        if (this.useAttributeForProperty(property)) {
            this.m_propertyAsAttribute = true;
            this.m_hasAttributeContent = false;
        } else {
            if (property.getPropertyType().isAttributeOnly()) {
                throw new IllegalStateException((Object)((Object)property.getPropertyType()) + " cannot be output as XML element");
            }
            this.startPropertyAsElementInternal(property);
        }
    }

    private void startPropertyAsAttributeInternal(XMIProperty property) {
        XMIPropertyType pt = property.getPropertyType();
        String name = pt.getAttributeName(this, property);
        if (!pt.isAttributeOnly()) {
            this.m_writer.setMaxAttributes(0);
        }
        this.m_writer.startAttribute(name);
    }

    private void startPropertyAsElementInternal(XMIProperty property) {
        this.m_propertyAsAttribute = false;
        this.m_writer.setMaxAttributes(Integer.MAX_VALUE);
        this.startPropertyAsElement(property);
    }

    protected boolean useAttributeForProperty(XMIProperty property) {
        if (this.getXMLWriter().isOpenElementState()) {
            XMIPropertyType pt = property.getPropertyType();
            if (pt.isDatatype()) {
                return !property.isMultivalued();
            }
            return XMIPropertyType.REFERENCE == pt && !this.m_longReferences;
        }
        return false;
    }

    protected abstract String getIdAttribute();

    protected abstract String getUUIDAttribute();

    protected abstract String getLabelAttribute();

    protected abstract void startPropertyAsElement(XMIProperty var1);

    public void outputValue(String value) {
        if (value != null) {
            XMIProperty property = this.peekProperty();
            if (this.m_propertyAsAttribute) {
                if (!property.getPropertyType().isDatatype()) {
                    if ('#' == value.charAt(0)) {
                        value = value.substring(1);
                    } else {
                        if (this.m_hasAttributeContent) {
                            this.m_writer.endAttribute();
                        }
                        this.startPropertyAsElementInternal(property);
                        this.outputValueAsElement(property, value);
                        return;
                    }
                }
                if (this.m_hasAttributeContent) {
                    this.m_writer.outputContent(" ");
                } else {
                    this.startPropertyAsAttributeInternal(property);
                    this.m_hasAttributeContent = true;
                }
                this.m_writer.outputContent(value);
            } else {
                this.outputValueAsElement(property, value);
            }
        }
    }

    protected abstract void outputValueAsElement(XMIProperty var1, String var2);

    protected void outputRef(String ref) {
        if ('#' == ref.charAt(0)) {
            this.m_writer.outputAttribute(this.getIdRefAttribute(), ref.substring(1));
        } else {
            this.m_writer.outputAttribute("href", ref);
        }
    }

    protected abstract String getIdRefAttribute();

    public void endProperty() {
        if (this.m_inInstance) {
            throw new IllegalStateException("Open instance not property");
        }
        this.m_inInstance = true;
        XMIProperty property = this.popProperty();
        XMLWriter writer = this.getXMLWriter();
        if (this.m_propertyAsAttribute) {
            if (this.m_hasAttributeContent) {
                writer.endAttribute();
            }
            this.m_propertyAsAttribute = false;
        } else {
            this.endPropertyAsElement(property);
        }
    }

    protected abstract void endPropertyAsElement(XMIProperty var1);

    public void outputProperty(XMIProperty property, String value) {
        this.startProperty(property);
        this.outputValue(value);
        this.endProperty();
    }

    public final void endInstance() {
        if (!this.m_inInstance) {
            throw new IllegalStateException("Open property not instance");
        }
        this.m_inInstance = false;
        this.getXMLWriter().endElement();
    }

    public abstract void endXMI() throws IOException;
}

