/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.XMIException;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIPropertyType;
import oracle.mof.xmi.XMIType;
import oracle.mof.xmi.XMIWriter;

public class XMIExporter {
    private final PropertyExporter PROPERTY_EXPORTER = new PropertyExporter();
    private final PropertyExporter REFERENCE_EXPORTER = new ReferenceExporter();
    private final PropertyExporter COMPOSITE_EXPORTER = new CompositeExporter();
    private XMIWriter m_writer;
    private Object[] m_instances;

    public XMIExporter(XMIWriter writer, Object ... instances) {
        ContractUtils.checkNull(writer, "Missing writer");
        ContractUtils.checkNull(instances, "Missing instances");
        this.m_writer = writer;
        this.m_instances = instances;
    }

    public void export() throws XMIException {
        try {
            this.m_writer.startXMI();
        }
        catch (IOException ioe) {
            throw new XMIException(null, ioe, 2);
        }
        try {
            for (Object instance : this.m_instances) {
                this.exportInstance(instance);
            }
        }
        catch (Exception e) {
            this.m_writer.abort();
            if (e instanceof XMIException) {
                throw (XMIException)e;
            }
            throw new XMIException(null, e, 2);
        }
        try {
            this.m_writer.endXMI();
        }
        catch (IOException ioe) {
            throw new XMIException(null, ioe, 2);
        }
    }

    private void exportInstance(Object instance) throws XMIException {
        if (instance == null) {
            throw new IllegalStateException("Missing instance");
        }
        XMIType t = this.findType(instance);
        if (t == null) {
            throw new IllegalStateException("Missing type");
        }
        this.m_writer.startInstance(t);
        Collection<? extends XMIProperty> properties = t.getProperties();
        if (properties != null) {
            IdentityHashMap<Object, Object> composites = new IdentityHashMap<Object, Object>();
            for (XMIProperty xMIProperty : properties) {
                Iterator value = xMIProperty.getValue(instance);
                if (value == null) continue;
                XMIPropertyType pt = xMIProperty.getPropertyType();
                PropertyExporter pe = this.PROPERTY_EXPORTER;
                if (pt == XMIPropertyType.REFERENCE) {
                    pe = this.REFERENCE_EXPORTER;
                } else if (pt == XMIPropertyType.COMPOSITE) {
                    pe = this.COMPOSITE_EXPORTER;
                }
                boolean multivalued = xMIProperty.isMultivalued();
                if (multivalued) {
                    if (value instanceof Iterable) {
                        value = ((Iterable)((Object)value)).iterator();
                    }
                    if (value instanceof Iterator) {
                        Iterator values = value;
                        if (!values.hasNext()) continue;
                        this.m_writer.startProperty(xMIProperty);
                        while (values.hasNext()) {
                            pe.export(instance, composites, values.next());
                        }
                        this.m_writer.endProperty();
                        continue;
                    }
                    int length = Array.getLength(value);
                    if (length <= 0) continue;
                    this.m_writer.startProperty(xMIProperty);
                    for (int i = 0; i < length; ++i) {
                        pe.export(instance, composites, Array.get(value, i));
                    }
                    this.m_writer.endProperty();
                    continue;
                }
                this.m_writer.startProperty(xMIProperty);
                pe.export(instance, composites, value);
                this.m_writer.endProperty();
            }
        }
        this.m_writer.endInstance();
    }

    private XMIType findType(Object instance) throws XMIException {
        return this.m_writer.getMetaModelProvider().getTypeForInstance(instance);
    }

    private class CompositeExporter
    extends PropertyExporter {
        private CompositeExporter() {
        }

        @Override
        public void export(Object context, IdentityHashMap<Object, Object> composites, Object value) throws XMIException {
            if (value instanceof String || composites.containsKey(value)) {
                XMIExporter.this.REFERENCE_EXPORTER.export(context, composites, value);
            } else {
                composites.put(value, value);
                XMIExporter.this.exportInstance(value);
            }
        }
    }

    private class ReferenceExporter
    extends PropertyExporter {
        private ReferenceExporter() {
        }

        @Override
        public void export(Object context, IdentityHashMap<Object, Object> composites, Object value) throws XMIException {
            String ref = value instanceof String ? (String)value : XMIExporter.this.findType(value).getId(context, value);
            XMIExporter.this.m_writer.outputValue(ref);
        }
    }

    private class PropertyExporter {
        private PropertyExporter() {
        }

        public void export(Object context, IdentityHashMap<Object, Object> composites, Object value) throws XMIException {
            XMIExporter.this.m_writer.outputValue(value.toString());
        }
    }
}

