/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.bm.util.ResourcePicker;
import oracle.javatools.util.BundleLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XMIErrorHandler
implements ErrorHandler {
    private ResourcePicker m_rp = new ResourcePicker(BundleLoader.getBundle((String)"oracle.mof.xmi.res.XMIResources"));
    private URL m_location;
    private boolean m_errorOccurred;
    private ArrayList<XMIErrorMessage> m_messages = new ArrayList();

    public XMIErrorHandler(URL location) {
        if (location == null) {
            throw new IllegalArgumentException("Missing location");
        }
        this.m_location = location;
    }

    @Override
    public void warning(SAXParseException exception) {
        this.createMessage(false, exception);
    }

    @Override
    public void error(SAXParseException exception) {
        this.createMessage(true, exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.error(exception);
    }

    public void exception(Exception exception) {
        this.createMessage(true, -1, -1, exception.getMessage());
    }

    private void createMessage(boolean error, SAXParseException exception) {
        this.createMessage(error, exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage());
    }

    private void createMessage(boolean error, int lineNumber, int columnNumber, String message) {
        if (error) {
            this.m_errorOccurred = true;
        }
        this.m_messages.add(new XMIErrorMessage(error, lineNumber, columnNumber, message));
    }

    public boolean hasErrors() {
        return this.m_errorOccurred;
    }

    public Collection<XMIErrorMessage> getMessages() {
        return Collections.unmodifiableCollection(this.m_messages);
    }

    public void sort() {
        Collections.sort(this.m_messages);
    }

    public class XMIErrorMessage
    implements Comparable<XMIErrorMessage> {
        private boolean m_error;
        private int m_lineNumber;
        private int m_columnNumber;
        private String m_message;

        private XMIErrorMessage(boolean error, int lineNumber, int columnNumber, String message) {
            this.m_error = error;
            this.m_lineNumber = lineNumber;
            this.m_columnNumber = columnNumber;
            this.m_message = lineNumber != -1 ? XMIErrorHandler.this.m_rp.getString(error ? "ErrorMessage.text" : "WarningMessage.text", new Object[]{Integer.toString(lineNumber), Integer.toString(columnNumber), message}) : XMIErrorHandler.this.m_rp.getString(error ? "NoLocationErrorMessage.text" : "NoLocationWarningMessage.text", (Object)message);
        }

        public boolean isError() {
            return this.m_error;
        }

        public URL getFile() {
            return XMIErrorHandler.this.m_location;
        }

        public int getLineNumber() {
            return this.m_lineNumber;
        }

        public int getColumnNumber() {
            return this.m_columnNumber;
        }

        public String toString() {
            return this.m_message;
        }

        @Override
        public int compareTo(XMIErrorMessage m) {
            if (this.m_error ^ m.m_error) {
                return this.m_error ? -1 : 1;
            }
            int ln = this.m_lineNumber - m.m_lineNumber;
            if (ln != 0) {
                return ln;
            }
            return this.m_columnNumber - m.m_columnNumber;
        }
    }
}

