/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.io.IOException;
import oracle.mof.xmi.XMIMetaModel;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIType;
import oracle.mof.xmi.XMIWriter;
import oracle.mof.xmi.XMLWriter;

public class XMI21Writer
extends XMIWriter {
    @Override
    public void startXMI() throws IOException {
        XMLWriter writer = this.getXMLWriter();
        writer.startDocument();
        writer.startElement("xmi:XMI");
        writer.outputAttribute("xmi:version", "2.1");
        writer.outputAttribute("xmlns:xmi", "http://schema.omg.org/spec/XMI/2.1");
        for (XMIMetaModel m : this.getMetaModelProvider().getMetaModels()) {
            writer.outputAttribute("xmlns:" + m.getNSPrefix(), m.getNSURI());
        }
        writer.startElement("documentation");
        writer.outputAttribute("exporter", this.getExporter());
        writer.outputAttribute("exporterVersion", this.getExporterVersion());
        writer.endElement();
    }

    @Override
    public void startInstanceImpl(XMIType type) {
        XMLWriter writer = this.getXMLWriter();
        String name = type.getMetaModel().getNSPrefix() + ":" + type.getName();
        XMIProperty composite = this.peekProperty();
        if (composite == null) {
            writer.startElement(name);
        } else {
            this.outputPropertyElement(composite);
            if (type != composite.getType()) {
                writer.outputAttribute("xmi:type", name);
            }
        }
    }

    @Override
    protected String getIdAttribute() {
        return "xmi:id";
    }

    @Override
    protected String getUUIDAttribute() {
        return "xmi:uuid";
    }

    @Override
    protected String getLabelAttribute() {
        return "xmi:label";
    }

    @Override
    protected void startPropertyAsElement(XMIProperty property) {
    }

    @Override
    protected void outputValueAsElement(XMIProperty property, String value) {
        XMLWriter writer = this.getXMLWriter();
        this.outputPropertyElement(property);
        if (property.getPropertyType().isDatatype()) {
            writer.outputContent(value);
        } else {
            this.outputRef(value);
        }
        writer.endElement();
    }

    @Override
    protected String getIdRefAttribute() {
        return "xmi:idref";
    }

    private void outputPropertyElement(XMIProperty property) {
        this.getXMLWriter().startElement(property.getName());
    }

    @Override
    protected void endPropertyAsElement(XMIProperty property) {
    }

    @Override
    public void endXMI() throws IOException {
        XMLWriter writer = this.getXMLWriter();
        writer.endElement();
        writer.endDocument();
    }
}

