/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.io.IOException;
import oracle.mof.xmi.XMIMetaModel;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIPropertyType;
import oracle.mof.xmi.XMIType;
import oracle.mof.xmi.XMIWriter;
import oracle.mof.xmi.XMLWriter;

public class XMI11Writer
extends XMIWriter {
    @Override
    public void startXMI() throws IOException {
        XMLWriter writer = this.getXMLWriter();
        writer.startDocument();
        writer.startElement("XMI");
        writer.outputAttribute("xmi.version", "1.1");
        for (XMIMetaModel m : this.getMetaModelProvider().getMetaModels()) {
            writer.outputAttribute("xmlns:" + m.getNSPrefix(), m.getNSURI());
        }
        writer.startElement("XMI.header");
        writer.startElement("XMI.documentation");
        writer.startElement("XMI.exporter");
        writer.outputContent(this.getExporter());
        writer.endElement();
        writer.startElement("XMI.exporterVersion");
        writer.outputContent(this.getExporterVersion());
        writer.endElement();
        writer.endElement();
        for (XMIMetaModel m : this.getMetaModelProvider().getMetaModels()) {
            writer.startElement("XMI.metamodel");
            writer.outputAttribute("xmi.name", m.getName());
            writer.outputAttribute("xmi.version", m.getVersion());
            writer.outputAttribute("href", m.getNSURI());
            writer.endElement();
        }
        writer.endElement();
        writer.startElement("XMI.content");
    }

    @Override
    public void startInstanceImpl(XMIType type) {
        XMLWriter writer = this.getXMLWriter();
        writer.startElement(type.getMetaModel().getNSPrefix() + ":" + type.getName());
    }

    @Override
    protected String getIdAttribute() {
        return "xmi.id";
    }

    @Override
    protected String getUUIDAttribute() {
        return "xmi.uuid";
    }

    @Override
    protected String getLabelAttribute() {
        return "xmi.label";
    }

    private void outputPropertyElement(XMIProperty property) {
        XMIType type = property.getOwningType();
        this.getXMLWriter().startElement(type.getMetaModel().getNSPrefix() + ":" + type.getName() + "." + property.getName());
    }

    @Override
    protected void startPropertyAsElement(XMIProperty property) {
        if (!property.getPropertyType().isDatatype()) {
            this.outputPropertyElement(property);
        }
    }

    @Override
    protected void outputValueAsElement(XMIProperty property, String value) {
        XMLWriter writer = this.getXMLWriter();
        XMIPropertyType propertyType = property.getPropertyType();
        if (propertyType.isDatatype()) {
            this.outputPropertyElement(property);
            if (propertyType == XMIPropertyType.ENUMERATION) {
                writer.outputAttribute("xmi.value", value);
            } else {
                writer.outputContent(value);
            }
        } else {
            this.startInstanceImpl(property.getType());
            this.outputRef(value);
        }
        this.getXMLWriter().endElement();
    }

    @Override
    protected String getIdRefAttribute() {
        return "xmi.idref";
    }

    @Override
    protected void endPropertyAsElement(XMIProperty property) {
        if (!property.getPropertyType().isDatatype()) {
            this.getXMLWriter().endElement();
        }
    }

    @Override
    public void endXMI() throws IOException {
        XMLWriter writer = this.getXMLWriter();
        writer.endElement();
        writer.endElement();
        writer.endDocument();
    }
}

