/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.XMIException;
import oracle.mof.xmi.XMIMetaModel;
import oracle.mof.xmi.XMIMetaModelProvider;
import oracle.mof.xmi.XMIType;

public class DefaultXMIMetaModelProvider
implements XMIMetaModelProvider {
    private ArrayList<XMIMetaModel> m_metamodels = new ArrayList();
    private HashMap<String, XMIMetaModel> m_metamodelsByURI = new HashMap();

    @Override
    public Collection<XMIMetaModel> getMetaModels() {
        return Collections.unmodifiableCollection(this.m_metamodels);
    }

    @Override
    public XMIMetaModel getMetaModel(String uri) {
        ContractUtils.checkNull(uri, "The URI must not be null");
        return this.m_metamodelsByURI.get(uri);
    }

    @Override
    public XMIType getTypeForInstance(Object instance) throws XMIException {
        for (XMIMetaModel mm : this.m_metamodels) {
            XMIType t = mm.getTypeForInstance(instance);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public void addMetaModel(XMIMetaModel metamodel) {
        ContractUtils.checkNull(metamodel, "The metamodel must not be null");
        this.addMetaModel(metamodel.getNSURI(), metamodel);
        this.addMetaModel(DefaultXMIMetaModelProvider.createFakeURI(metamodel.getNSPrefix(), metamodel.getVersion()), metamodel);
        String[] uris = metamodel.getAdditionalNamespaces();
        if (uris != null) {
            for (int i = uris.length - 1; i >= 0; --i) {
                String uri = uris[i];
                ContractUtils.checkNull(uri, "URI must not be null");
                this.addMetaModel(uri, metamodel);
            }
        }
        this.m_metamodels.add(metamodel);
    }

    private void addMetaModel(String uri, XMIMetaModel metamodel) {
        if (this.m_metamodelsByURI.put(uri, metamodel) != null) {
            throw new IllegalStateException("Handler already registered for: " + uri);
        }
    }

    public static String createFakeURI(String name, String version) {
        return name + "#" + version;
    }
}

