/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.utils.Connections;

public class ConnectionPanel
extends JPanel {
    private static final long serialVersionUID = 4165381162747429352L;
    private static final int INSET = 5;
    private JComboBox m_comboBox;

    public ConnectionPanel(String string, boolean bl) {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)jLabel, gridBagConstraints);
        String[] stringArray = null;
        stringArray = bl ? this.getOracleCons() : this.getNonOracleConNames();
        this.m_comboBox = new JComboBox<String>(stringArray);
        if (stringArray.length > 0) {
            this.m_comboBox.setSelectedIndex(0);
        }
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        this.add((Component)this.m_comboBox, gridBagConstraints2);
    }

    private String[] getOracleCons() {
        Connections connections = Connections.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = connections.getConnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!connections.isOracle(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getNonOracleConNames() {
        Connections connections = Connections.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = connections.getConnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Properties properties = connections.getConnectionInfo(string);
            if (!properties.getProperty("RaptorConnectionType").equals("ACCESS")) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String getSelectedConName() {
        if (this.m_comboBox.getSelectedItem() != null) {
            return this.m_comboBox.getSelectedItem().toString();
        }
        return "";
    }
}

