/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import oracle.ide.vhv.model.ContextElement;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.MergeElement;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.GraphShape;
import oracle.ide.vhv.view.VersionTreeDiagram;

public class MergeShape
extends GraphShape {
    QuadCurve2D m_shape = null;
    GraphShape m_childShape;
    int m_childConnectionSide;
    private static final double BEND_CONSTANT = 0.125;
    private static final int ARROW_LENGTH = 10;
    private static final int ARROW_WIDTH = 5;

    MergeShape(String label, GraphShape parent, int parentConnectionSide, GraphShape child, int childConnectionSide, GraphElement clientObject) {
        super(label, parent, parentConnectionSide, clientObject);
        this.m_childShape = child;
        this.m_childConnectionSide = childConnectionSide;
    }

    @Override
    public String getToolTipText() {
        String sourceVersionLabel = null;
        String targetVersionLabel = null;
        try {
            sourceVersionLabel = ((ContextElement)this.getGraphElement().getParentElement()).getVersionableResource().getVersionLabel();
            targetVersionLabel = ((ContextElement)this.getGraphElement().getChildElement()).getVersionableResource().getVersionLabel();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (sourceVersionLabel != null && targetVersionLabel != null) {
                return VHVArb.format(64, new String[]{sourceVersionLabel, targetVersionLabel, this.getGraphElement().getUserResource().getName(), DateFormat.getDateTimeInstance().format(this.getGraphElement().getDatestamp())});
            }
            return VHVArb.format(63, new String[]{this.getGraphElement().getUserResource().getName(), DateFormat.getDateTimeInstance().format(this.getGraphElement().getDatestamp())});
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isMoveable() {
        return false;
    }

    @Override
    public void paint(Graphics2D g, boolean paintText) {
        MergeElement me = (MergeElement)this.getGraphElement();
        if (me.isSystemMerge()) {
            g.setColor(VersionTreeDiagram.getSystemMergeColor());
            g.setStroke(new BasicStroke(1.0f));
        } else {
            g.setColor(VersionTreeDiagram.getManualMergeColor());
            float[] dash = new float[]{5.0f, 5.0f};
            g.setStroke(new BasicStroke(1.0f, 2, 1, 0.0f, dash, 0.0f));
        }
        if (!((GraphShape)this.getParentShape()).isHiding() && !this.getChildShape().isHiding()) {
            if (this.m_shape == null || this.getConnectionPoint().getX() != this.m_shape.getX1() || this.getConnectionPoint().getY() != this.m_shape.getY1() || this.getChildConnectionPoint().getX() != this.m_shape.getX2() || this.getChildConnectionPoint().getY() != this.m_shape.getY2()) {
                Point2D plp = this.getParentShape().getLocation();
                Point2D clp = this.getChildShape().getLocation();
                double deltaX = plp.getX() - clp.getX();
                double deltaY = plp.getY() - clp.getY();
                if (deltaX == 0.0 || Math.abs(deltaX / deltaY) < 0.2) {
                    if (clp.getY() > plp.getY()) {
                        this.m_connectionSide = 3;
                        this.m_childConnectionSide = 1;
                    } else {
                        this.m_connectionSide = 1;
                        this.m_childConnectionSide = 3;
                    }
                } else if (deltaY == 0.0 || Math.abs(deltaY / deltaX) < 0.2) {
                    if (clp.getX() > plp.getX()) {
                        this.m_connectionSide = 2;
                        this.m_childConnectionSide = 4;
                    } else {
                        this.m_connectionSide = 4;
                        this.m_childConnectionSide = 2;
                    }
                } else if (clp.getX() > plp.getX()) {
                    if (clp.getY() > plp.getY()) {
                        this.m_connectionSide = 3;
                        this.m_childConnectionSide = 4;
                    } else {
                        this.m_connectionSide = 1;
                        this.m_childConnectionSide = 4;
                    }
                } else if (clp.getY() > plp.getY()) {
                    this.m_connectionSide = 3;
                    this.m_childConnectionSide = 2;
                } else {
                    this.m_connectionSide = 1;
                    this.m_childConnectionSide = 2;
                }
                Point2D ccp = this.getChildConnectionPoint();
                Point2D pcp = this.getConnectionPoint();
                if (ccp.equals(pcp)) {
                    return;
                }
                int sign = plp.getX() >= clp.getX() ? -1 : 1;
                int n = plp.getY() >= clp.getY() ? -1 : 1;
                double mod = Math.sqrt(Math.pow(pcp.getX() - ccp.getX(), 2.0) + Math.pow(pcp.getY() - ccp.getY(), 2.0));
                double bend = 0.125 + 16.0 / mod;
                Point2D.Double cp = new Point2D.Double(pcp.getX() + 0.5 * (ccp.getX() - pcp.getX()) + bend * (double)(sign *= n) * (pcp.getY() - ccp.getY()), pcp.getY() + 0.5 * (ccp.getY() - pcp.getY()) + bend * (double)sign * (ccp.getX() - pcp.getX()));
                this.m_shape = new QuadCurve2D.Double(pcp.getX(), pcp.getY(), ((Point2D)cp).getX(), ((Point2D)cp).getY(), ccp.getX(), ccp.getY());
            }
            if (g.getClip().getBounds2D().intersectsLine(new Line2D.Double(this.m_shape.getP1(), this.m_shape.getCtrlPt())) || g.getClip().getBounds2D().intersectsLine(new Line2D.Double(this.m_shape.getP2(), this.m_shape.getCtrlPt()))) {
                if (this.isHighlighted()) {
                    g.setStroke(new BasicStroke(3.0f));
                }
                g.draw(this.m_shape);
                g.setStroke(new BasicStroke(1.0f));
                this.paintArrowHead(g, this.m_shape.getP2(), this.m_shape.getCtrlPt());
                if (this.isSelected()) {
                    this.paintSelectionMark(g, this.m_shape.getP1(), this.m_shape.getP2());
                }
            }
        } else if (!this.getChildShape().isHiding()) {
            this.m_childConnectionSide = 2;
            Point2D ccp = this.getChildConnectionPoint();
            Point2D.Double pcp = new Point2D.Double(ccp.getX() + 10.0 + (double)STUB_SIZE, ccp.getY());
            Line2D.Double line = new Line2D.Double(ccp, pcp);
            g.draw(line);
            this.paintArrowHead(g, ccp, pcp);
            this.paintStubMark(g, pcp);
        }
    }

    private void paintArrowHead(Graphics2D g, Point2D tip, Point2D direction) {
        double mod = Math.sqrt(Math.pow(direction.getX() - tip.getX(), 2.0) + Math.pow(direction.getY() - tip.getY(), 2.0));
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)tip.getX(), (float)tip.getY());
        gp.lineTo((float)(tip.getX() + (10.0 * (direction.getX() - tip.getX()) + 5.0 * (tip.getY() - direction.getY())) / mod), (float)(tip.getY() + (10.0 * (direction.getY() - tip.getY()) + 5.0 * (direction.getX() - tip.getX())) / mod));
        gp.lineTo((float)(tip.getX() + (10.0 * (direction.getX() - tip.getX()) - 5.0 * (tip.getY() - direction.getY())) / mod), (float)(tip.getY() + (10.0 * (direction.getY() - tip.getY()) - 5.0 * (direction.getX() - tip.getX())) / mod));
        gp.closePath();
        g.fill(gp);
    }

    private void paintSelectionMark(Graphics2D g, Point2D pcp, Point2D ccp) {
        GeneralPath gp;
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        if (this.m_childConnectionSide == 4) {
            g.setStroke(new BasicStroke(2.0f));
            gp = new GeneralPath();
            gp.moveTo((float)ccp.getX() + 3.0f, (float)ccp.getY() - 3.0f);
            gp.lineTo((float)ccp.getX() + 3.0f, (float)ccp.getY() - 9.0f);
            gp.lineTo((float)ccp.getX() - 3.0f, (float)ccp.getY() - 9.0f);
            gp.moveTo((float)ccp.getX() + 3.0f, (float)ccp.getY() + 3.0f);
            gp.lineTo((float)ccp.getX() + 3.0f, (float)ccp.getY() + 9.0f);
            gp.lineTo((float)ccp.getX() - 3.0f, (float)ccp.getY() + 9.0f);
            g.draw(gp);
            g.setStroke(new BasicStroke(1.0f));
        } else if (this.m_childConnectionSide == 2) {
            g.setStroke(new BasicStroke(2.0f));
            gp = new GeneralPath();
            gp.moveTo((float)ccp.getX() - 3.0f, (float)ccp.getY() - 3.0f);
            gp.lineTo((float)ccp.getX() - 3.0f, (float)ccp.getY() - 9.0f);
            gp.lineTo((float)ccp.getX() + 3.0f, (float)ccp.getY() - 9.0f);
            gp.moveTo((float)ccp.getX() - 3.0f, (float)ccp.getY() + 3.0f);
            gp.lineTo((float)ccp.getX() - 3.0f, (float)ccp.getY() + 9.0f);
            gp.lineTo((float)ccp.getX() + 3.0f, (float)ccp.getY() + 9.0f);
            g.draw(gp);
            g.setStroke(new BasicStroke(1.0f));
        } else if (this.m_childConnectionSide == 1) {
            g.setStroke(new BasicStroke(2.0f));
            gp = new GeneralPath();
            gp.moveTo((float)ccp.getX() + 9.0f, (float)ccp.getY() - 3.0f);
            gp.lineTo((float)ccp.getX() + 9.0f, (float)ccp.getY() + 3.0f);
            gp.lineTo((float)ccp.getX() + 3.0f, (float)ccp.getY() + 3.0f);
            gp.moveTo((float)ccp.getX() - 9.0f, (float)ccp.getY() - 3.0f);
            gp.lineTo((float)ccp.getX() - 9.0f, (float)ccp.getY() + 3.0f);
            gp.lineTo((float)ccp.getX() - 3.0f, (float)ccp.getY() + 3.0f);
            g.draw(gp);
            g.setStroke(new BasicStroke(1.0f));
        } else if (this.m_childConnectionSide == 3) {
            g.setStroke(new BasicStroke(2.0f));
            gp = new GeneralPath();
            gp.moveTo((float)ccp.getX() + 9.0f, (float)ccp.getY() + 3.0f);
            gp.lineTo((float)ccp.getX() + 9.0f, (float)ccp.getY() - 3.0f);
            gp.lineTo((float)ccp.getX() + 3.0f, (float)ccp.getY() - 3.0f);
            gp.moveTo((float)ccp.getX() - 9.0f, (float)ccp.getY() + 3.0f);
            gp.lineTo((float)ccp.getX() - 9.0f, (float)ccp.getY() - 3.0f);
            gp.lineTo((float)ccp.getX() - 3.0f, (float)ccp.getY() - 3.0f);
            g.draw(gp);
            g.setStroke(new BasicStroke(1.0f));
        }
        if (this.m_connectionSide == 4) {
            g.setStroke(new BasicStroke(2.0f));
            gp = new GeneralPath();
            gp.moveTo((float)pcp.getX() + 3.0f, (float)pcp.getY() - 3.0f);
            gp.lineTo((float)pcp.getX() + 3.0f, (float)pcp.getY() - 9.0f);
            gp.lineTo((float)pcp.getX() - 3.0f, (float)pcp.getY() - 9.0f);
            gp.moveTo((float)pcp.getX() + 3.0f, (float)pcp.getY() + 3.0f);
            gp.lineTo((float)pcp.getX() + 3.0f, (float)pcp.getY() + 9.0f);
            gp.lineTo((float)pcp.getX() - 3.0f, (float)pcp.getY() + 9.0f);
            g.draw(gp);
            g.setStroke(new BasicStroke(1.0f));
        } else if (this.m_connectionSide == 2) {
            g.setStroke(new BasicStroke(2.0f));
            gp = new GeneralPath();
            gp.moveTo((float)pcp.getX() - 3.0f, (float)pcp.getY() - 3.0f);
            gp.lineTo((float)pcp.getX() - 3.0f, (float)pcp.getY() - 9.0f);
            gp.lineTo((float)pcp.getX() + 3.0f, (float)pcp.getY() - 9.0f);
            gp.moveTo((float)pcp.getX() - 3.0f, (float)pcp.getY() + 3.0f);
            gp.lineTo((float)pcp.getX() - 3.0f, (float)pcp.getY() + 9.0f);
            gp.lineTo((float)pcp.getX() + 3.0f, (float)pcp.getY() + 9.0f);
            g.draw(gp);
            g.setStroke(new BasicStroke(1.0f));
        } else if (this.m_connectionSide == 1) {
            g.setStroke(new BasicStroke(2.0f));
            gp = new GeneralPath();
            gp.moveTo((float)pcp.getX() + 9.0f, (float)pcp.getY() - 3.0f);
            gp.lineTo((float)pcp.getX() + 9.0f, (float)pcp.getY() + 3.0f);
            gp.lineTo((float)pcp.getX() + 3.0f, (float)pcp.getY() + 3.0f);
            gp.moveTo((float)pcp.getX() - 9.0f, (float)pcp.getY() - 3.0f);
            gp.lineTo((float)pcp.getX() - 9.0f, (float)pcp.getY() + 3.0f);
            gp.lineTo((float)pcp.getX() - 3.0f, (float)pcp.getY() + 3.0f);
            g.draw(gp);
            g.setStroke(new BasicStroke(1.0f));
        } else if (this.m_connectionSide == 3) {
            g.setStroke(new BasicStroke(2.0f));
            gp = new GeneralPath();
            gp.moveTo((float)pcp.getX() + 9.0f, (float)pcp.getY() + 3.0f);
            gp.lineTo((float)pcp.getX() + 9.0f, (float)pcp.getY() - 3.0f);
            gp.lineTo((float)pcp.getX() + 3.0f, (float)pcp.getY() - 3.0f);
            gp.moveTo((float)pcp.getX() - 9.0f, (float)pcp.getY() + 3.0f);
            gp.lineTo((float)pcp.getX() - 9.0f, (float)pcp.getY() - 3.0f);
            gp.lineTo((float)pcp.getX() - 3.0f, (float)pcp.getY() - 3.0f);
            g.draw(gp);
            g.setStroke(new BasicStroke(1.0f));
        }
        g.setColor(oldColor);
    }

    public GraphShape getChildShape() {
        return this.m_childShape;
    }

    public void setChildShape(GraphShape gs) {
        this.m_childShape = gs;
    }

    @Override
    public void move(double dX, double dY) {
    }

    @Override
    public Rectangle2D getBounds2D() {
        Point2D pcp = this.getConnectionPoint();
        Point2D ccp = this.getChildConnectionPoint();
        Rectangle2D.Double bounds = new Rectangle2D.Double(Math.min(pcp.getX(), ccp.getX()), Math.min(pcp.getY(), ccp.getY()), Math.abs(pcp.getX() - ccp.getX()), Math.abs(pcp.getY() - ccp.getY()));
        bounds.add(this.m_shape.getCtrlPt());
        return bounds;
    }

    @Override
    public Rectangle2D getTotalBounds2D() {
        return this.getBounds2D();
    }

    @Override
    public Shape getShape() {
        return null;
    }

    @Override
    public Point2D getLocation() {
        return null;
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.m_shape != null) {
            double deltaY;
            GeneralPath gp = new GeneralPath();
            double deltaX = Math.abs(this.m_shape.getX1() - this.m_shape.getX2());
            if (deltaX > (deltaY = Math.abs(this.m_shape.getY1() - this.m_shape.getY2()))) {
                gp.append(new QuadCurve2D.Double(this.m_shape.getX1() - 4.0, this.m_shape.getY1() - 4.0, this.m_shape.getCtrlX(), this.m_shape.getCtrlY() - 4.0, this.m_shape.getX2() + 4.0, this.m_shape.getY2() - 4.0), false);
                gp.append(new QuadCurve2D.Double(this.m_shape.getX2() + 4.0, this.m_shape.getY2() + 4.0, this.m_shape.getCtrlX(), this.m_shape.getCtrlY() + 4.0, this.m_shape.getX1() - 4.0, this.m_shape.getY1() + 4.0), true);
            } else {
                gp.append(new QuadCurve2D.Double(this.m_shape.getX1() - 4.0, this.m_shape.getY1() - 4.0, this.m_shape.getCtrlX() - 4.0, this.m_shape.getCtrlY(), this.m_shape.getX2() - 4.0, this.m_shape.getY2() + 4.0), false);
                gp.append(new QuadCurve2D.Double(this.m_shape.getX2() + 4.0, this.m_shape.getY2() - 4.0, this.m_shape.getCtrlX() + 4.0, this.m_shape.getCtrlY(), this.m_shape.getX1() + 4.0, this.m_shape.getY1() + 4.0), true);
            }
            gp.closePath();
            return gp.contains(x, y);
        }
        return false;
    }

    @Override
    public Point2D getTopConnectionPoint() {
        return null;
    }

    @Override
    public Point2D getBottomConnectionPoint() {
        return null;
    }

    @Override
    public Point2D getLeftConnectionPoint() {
        return null;
    }

    @Override
    public Point2D getRightConnectionPoint() {
        return null;
    }

    public Point2D getChildConnectionPoint() {
        switch (this.m_childConnectionSide) {
            case 1: {
                return this.m_childShape.getTopConnectionPoint();
            }
            case 2: {
                return this.m_childShape.getRightConnectionPoint();
            }
            case 3: {
                return this.m_childShape.getBottomConnectionPoint();
            }
            case 4: {
                return this.m_childShape.getLeftConnectionPoint();
            }
        }
        return null;
    }

    @Override
    public int getScrollX() {
        return 0;
    }

    @Override
    public int getScrollY() {
        return 0;
    }

    @Override
    public GraphShape getAbove() {
        if (this.getChildShape().getLocation().getY() > this.getParentShape().getLocation().getY()) {
            return (GraphShape)this.getParentShape();
        }
        return this.getChildShape();
    }

    @Override
    public GraphShape getBelow() {
        if (this.getChildShape().getLocation().getY() > this.getParentShape().getLocation().getY()) {
            return this.getChildShape();
        }
        return (GraphShape)this.getParentShape();
    }

    @Override
    public GraphShape getRight() {
        if (this.getParentShape().getLocation().getX() > this.getChildShape().getLocation().getX()) {
            return (GraphShape)this.getParentShape();
        }
        return this.getChildShape();
    }

    @Override
    public GraphShape getLeft() {
        if (this.getParentShape().getLocation().getX() > this.getChildShape().getLocation().getX()) {
            return this.getChildShape();
        }
        return (GraphShape)this.getParentShape();
    }
}

