/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.thread;

import oracle.ldap.util.QClosedException;
import oracle.ldap.util.WorkQueue;
import oracle.ldap.util.thread.ThreadPoolException;
import oracle.ldap.util.thread.ThreadPoolJob;
import oracle.ldap.util.thread.ThreadPoolManager;

public class ThreadPool {
    public static final int DEFAULT_JOB_PRIORITY = 5;
    public static final int MIN_JOB_PRIORITY = 1;
    public static final int MAX_JOB_PRIORITY = 10;
    public static final int DEFAULT_MIN_THREADS = 1;
    public static final int DEFAULT_MAX_THREADS = 10;
    private WorkQueue m_pQ = null;
    private ThreadPoolManager m_tpm = null;

    public ThreadPool() {
        this(1, 10, 5);
    }

    public ThreadPool(int nMinThr, int nMaxThr) {
        this(nMinThr, nMaxThr, 5);
    }

    public ThreadPool(int nMinThr, int nMaxThr, int jobPriority) {
        if (jobPriority < 1 || jobPriority > 10) {
            throw new IllegalArgumentException("VALUE_NOT_IN_RANGE");
        }
        this.m_pQ = new WorkQueue(10);
        this.m_tpm = new ThreadPoolManager(this.m_pQ, nMinThr, nMaxThr, jobPriority);
    }

    public void execute(ThreadPoolJob threadPoolJob) throws ThreadPoolException {
        if (null == threadPoolJob) {
            throw new IllegalArgumentException("CANNOT_PASS_NULL_ARGUMENT");
        }
        this.executeJob(threadPoolJob);
    }

    public void execute(Runnable job, int priority) throws ThreadPoolException {
        ThreadPoolJob tpj = new ThreadPoolJob(job, priority);
        this.executeJob(tpj);
    }

    public void close() {
        this.m_pQ.close();
    }

    protected boolean isPriorityValid(int pri) {
        return pri >= 1 && pri <= 10;
    }

    protected synchronized void executeJob(ThreadPoolJob threadPoolJob) throws ThreadPoolException {
        try {
            this.m_pQ.enqueue(threadPoolJob, threadPoolJob.getJobPriority());
        }
        catch (QClosedException qce) {
            throw new ThreadPoolException("THRAED_POOL_CLOSED");
        }
        this.m_tpm.jobArrived();
    }
}

