/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.schema;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class XferInterfaceDefn {
    private static final String ATTR_ifName = "orclOdipProfileInterfaceType";
    private static final String ATTR_SUBSCRIPTIONMODE = "orclOdipProfileProvSubscriptionMode";
    private static final String ATTR_READER = "orclOdipProvInterfaceProcessor;reader";
    private static final String ATTR_WRITER = "orclOdipProvInterfaceProcessor;writer";
    private static final String ATTR_STSUPDATE = "orclOdipProvInterfaceProcessor;sUpdate";
    private static final String ATTR_FILTER = "orclOdipProvInterfaceFilter";
    private static final String ATTR_PROFILEUPDATE = "orclOdipProfileStatusUpdate";
    private String m_ifName = null;
    private String m_subMode = null;
    private String m_reader = null;
    private String m_writer = null;
    private String m_sUpdate = null;
    private String[] m_filter = null;
    private boolean m_pUpdate = false;

    public XferInterfaceDefn() {
    }

    public XferInterfaceDefn(String name, String mode, String reader, String writer, String sUpdate, String filter) {
        this.m_ifName = name;
        this.m_reader = reader;
        this.m_writer = writer;
        this.m_sUpdate = sUpdate;
        this.m_subMode = mode;
        this.m_pUpdate = false;
    }

    public XferInterfaceDefn(Attributes attrs) throws NamingException, NoSuchElementException {
        Attribute attr = attrs.get(ATTR_ifName);
        this.m_ifName = attr != null ? ((String)attr.get()).toLowerCase().trim() : "";
        attr = attrs.get(ATTR_READER);
        this.m_reader = attr != null ? (String)attr.get() : "";
        attr = attrs.get(ATTR_WRITER);
        this.m_writer = attr != null ? (String)attr.get() : "";
        attr = attrs.get(ATTR_STSUPDATE);
        this.m_sUpdate = attr != null ? (String)attr.get() : null;
        attr = attrs.get(ATTR_FILTER);
        if (attr != null) {
            NamingEnumeration<?> penum = attr.getAll();
            boolean i = false;
            ArrayList<String> alist = new ArrayList<String>();
            while (penum.hasMoreElements()) {
                alist.add((String)penum.nextElement());
            }
            this.m_filter = alist.toArray(new String[0]);
        }
        this.m_subMode = (attr = attrs.get(ATTR_SUBSCRIPTIONMODE)) != null ? (String)attr.get() : null;
        attr = attrs.get(ATTR_PROFILEUPDATE);
        if (attr != null) {
            String tmp = (String)attr.get();
            this.m_pUpdate = tmp.equalsIgnoreCase("true");
        }
    }

    public String getName() {
        return this.m_ifName;
    }

    public String getReader() {
        return this.m_reader;
    }

    public String getWriter() {
        return this.m_writer;
    }

    public String getStsUpdate() {
        return this.m_sUpdate;
    }

    public boolean isProfileUpdateRequired() {
        return this.m_pUpdate;
    }

    public String getSubscriptionMode() {
        return this.m_subMode;
    }

    public String[] getSearchFilters() {
        return this.m_filter;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        String nl = System.getProperty("line.separator");
        str.append("Xfer Interface Defn : ").append("Interface Name : ").append(this.m_ifName).append(nl).append("Import Reader : ").append(this.m_reader).append(nl).append("Import Writer : ").append(this.m_writer).append(nl).append("Status update : ").append(this.m_sUpdate).append(nl).append("Filter : ").append(this.m_filter).append(nl);
        return new String(str);
    }
}

