/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.schema;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.ldap.util.DistinguishedName;
import oracle.ldap.util.jndi.ConnectionUtil;
import oracle.ldap.util.schema.XferInterfaceDefn;

public class XferInterfaceConfig {
    private static final String EXPORT_CONTAINER = "CN=EXPORT";
    private static final String EXPORT_MODE = "EXPORT";
    private static ArrayList m_expDefns = new ArrayList();
    private static final String IMPORT_CONTAINER = "CN=IMPORT";
    private static final String IMPORT_MODE = "IMPORT";
    private static ArrayList m_impDefns = new ArrayList();
    private static XferInterfaceConfig s_ifConfig = null;
    private static final String INTERFACE_DEFN_OBJCLASS = "orclOdipProvInterfaceDetails";

    public static XferInterfaceConfig getInstance(LdapContext ctx, String subtree) {
        if (s_ifConfig == null) {
            s_ifConfig = new XferInterfaceConfig();
            try {
                s_ifConfig.initialise(ctx, subtree);
            }
            catch (Exception ex) {
                System.out.println("Error in eventschemareader");
                ex.printStackTrace();
            }
        }
        return s_ifConfig;
    }

    public void initialise(LdapContext lCtx, String subtree) throws NamingException, NoSuchElementException {
        String val = "cn=interfaceconfig, " + subtree;
        SearchControls pCtls = new SearchControls();
        pCtls.setSearchScope(2);
        pCtls.setTimeLimit(3000000);
        NamingEnumeration<SearchResult> enumVar = lCtx.search(val, "Objectclass=orclOdipProvInterfaceDetails", pCtls);
        while (enumVar.hasMoreElements()) {
            SearchResult pRes = (SearchResult)enumVar.nextElement();
            DistinguishedName name = new DistinguishedName(pRes.getName());
            DistinguishedName exp = new DistinguishedName(EXPORT_CONTAINER);
            DistinguishedName imp = new DistinguishedName(IMPORT_CONTAINER);
            Attributes attrs = pRes.getAttributes();
            XferInterfaceDefn defn = new XferInterfaceDefn(attrs);
            if (defn != null && name.startsWith(exp)) {
                m_expDefns.add(defn);
            }
            if (!name.startsWith(imp)) continue;
            m_impDefns.add(defn);
        }
    }

    public static String[] getProvModeNames(String ifType, String mode) {
        int i;
        XferInterfaceDefn defn = null;
        ArrayList<String> names = new ArrayList<String>();
        for (i = 0; i < m_expDefns.size(); ++i) {
            if (!mode.equalsIgnoreCase(EXPORT_MODE) || !(defn = (XferInterfaceDefn)m_expDefns.get(i)).getName().equalsIgnoreCase(ifType)) continue;
            names.add(defn.getSubscriptionMode());
        }
        for (i = 0; i < m_impDefns.size(); ++i) {
            if (!mode.equalsIgnoreCase(IMPORT_MODE) || !(defn = (XferInterfaceDefn)m_impDefns.get(i)).getName().equalsIgnoreCase(ifType)) continue;
            names.add(defn.getSubscriptionMode());
        }
        return names.toArray(new String[0]);
    }

    public static XferInterfaceDefn getInterfaceDefn(String ifType, String mode, String provMode) {
        XferInterfaceDefn defn;
        block3: {
            block2: {
                defn = null;
                if (!mode.equalsIgnoreCase(EXPORT_MODE)) break block2;
                for (int i = 0; !(i >= m_expDefns.size() || (defn = (XferInterfaceDefn)m_expDefns.get(i)).getName().equalsIgnoreCase(ifType) && defn.getSubscriptionMode().equalsIgnoreCase(provMode)); ++i) {
                }
                break block3;
            }
            if (!mode.equalsIgnoreCase(IMPORT_MODE)) break block3;
            for (int i = 0; !(i >= m_impDefns.size() || (defn = (XferInterfaceDefn)m_impDefns.get(i)).getName().equalsIgnoreCase(ifType) && defn.getSubscriptionMode().equalsIgnoreCase(provMode)); ++i) {
            }
        }
        return defn;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = m_expDefns.size() - 1; i >= 0; --i) {
            XferInterfaceDefn defn = (XferInterfaceDefn)m_expDefns.get(i);
            str.append("IFName: ").append(defn.getName()).append('\n').append("Reader: ").append(defn.getReader()).append('\n').append("Writer: ").append(defn.getWriter());
        }
        return new String(str);
    }

    public static void main(String[] args) {
        try {
            XferInterfaceConfig ifConfig = new XferInterfaceConfig();
            InitialLdapContext lCtx = ConnectionUtil.getDefaultDirCtx("dlsun1451", "3060", "cn=orcladmin", "welcome");
            System.out.println("Initializing the connection ... done");
            ifConfig.initialise(lCtx, "cn=configuration,cn=provisioning,cn=directory integration platform,cn=products,cn=oraclecontext");
            System.out.println(ifConfig.toString());
        }
        catch (Exception ex) {
            System.out.println("Exception " + ex.toString());
            ex.printStackTrace();
        }
    }
}

