/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.schema;

public class Plugin {
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static final String POLICY_PLUGIN = "PolicyPlugin";
    public static final String MOD_PLUGIN = "ModPlugin";
    public static final String ACTION_PLUGIN = "ActionPlugin";
    public static final String DELIVERY_PLUGIN_OUT = "EVENT_DELIVERY_OUT";
    public static final String DELIVERY_PLUGIN_IN = "EVENT_DELIVERY_IN";
    public static final String PRE_DELIVERY_PLUGIN_OUT = "PRE_EVENT_DELIVERY_OUT";
    private String m_pluginName = null;
    private String m_status = null;
    private String m_desc = null;
    private String m_execName = null;
    private String m_additionalInfo = null;
    private String[] m_pluginEvents = null;

    public Plugin(String pluginName) {
        this.m_pluginName = pluginName;
    }

    public Plugin(String pluginName, String status, String desc, String pluginExecName, String additionalInfo, String[] pluginEvts) {
        this(pluginName);
        this.m_status = status;
        this.m_desc = desc;
        this.m_execName = pluginExecName;
        this.m_additionalInfo = additionalInfo;
        this.m_pluginEvents = pluginEvts;
    }

    public String getType() {
        return this.m_pluginName;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public boolean isEnabled() {
        return this.m_status != null ? this.m_status.equalsIgnoreCase(ENABLE) : false;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public void setDescription(String desc) {
        this.m_desc = desc;
    }

    public String getExecName() {
        return this.m_execName;
    }

    public void setExecName(String execName) {
        this.m_execName = execName;
    }

    public String getAdditionalInfo() {
        return this.m_additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.m_additionalInfo = additionalInfo;
    }

    public String[] getEventList() {
        return this.m_pluginEvents;
    }

    public void setEventList(String[] evts) {
        this.m_pluginEvents = evts;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(nl).append("----------------------------------------------").append(nl).append("Plugin Type     : " + this.getType()).append(nl).append("Status          : " + this.getStatus()).append(nl).append("Description     : " + this.getDescription()).append(nl).append("Exec Name       : " + this.getExecName()).append(nl).append("Additional Info : " + this.getAdditionalInfo()).append(nl).append("Events          : ");
        for (int i = 0; this.m_pluginEvents != null && i < this.m_pluginEvents.length; ++i) {
            sbuf.append(nl).append("                  " + this.m_pluginEvents[i]);
        }
        sbuf.append(nl).append("----------------------------------------------");
        return sbuf.toString();
    }

    public static void main(String[] args) {
        Plugin plugin = new Plugin("EventDeliveryPlugin", ENABLE, "Plugin to deliver events", "oracle.email.ldap.plugin.EventDeliveryPlugin", null, new String[]{"USER_ADD", "USER_MODIFY", "USER_DELETE"});
        System.out.println(plugin);
        plugin.setStatus(DISABLE);
        plugin.setDescription("New Description");
        plugin.setExecName("oracle.ldap.plugin.NewExecName");
        plugin.setAdditionalInfo("Additional Info");
        plugin.setEventList(new String[]{"NEW_USER_ADD", "NEW_USER_MODIFY", "NEW_USER_DELETE"});
        System.out.println(plugin);
    }
}

