/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.repapi;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.Util;
import oracle.ldap.util.repapi.RegistrationUtils;
import oracle.ldap.util.repapi.SchemaConstants;
import oracle.ldap.util.repapi.SchemaException;

public class RegistrationHelper
implements SchemaConstants {
    public static boolean isEntryExist(boolean isSSL, String oidHost, String oidPort, String userDN, String userPassword, String containerName, String childName) throws SchemaException, Exception {
        String dn = "orclApplicationCommonName=" + childName + ",cn=" + containerName + "," + "cn=Products, cn=OracleContext";
        InitialLdapContext ctx = RegistrationUtils.getDefaultDirCtx(isSSL, oidHost, oidPort, userDN, userPassword);
        boolean ret = Util.dnExists(ctx, dn);
        try {
            ctx.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    public static String makeNewOIDEntry(boolean isSSL, String oidHost, String oidPort, String userDN, String userPassword, String containerName, String childName, Hashtable attributes, String[] userPrivilege) throws SchemaException, Exception {
        String dn = "orclApplicationCommonName=" + childName + ",cn=" + containerName + "," + "cn=Products, cn=OracleContext";
        return RegistrationHelper.makeNewOIDEntry(isSSL, oidHost, oidPort, userDN, userPassword, dn, attributes, userPrivilege);
    }

    public static String makeNewOIDEntry(boolean isSSL, String oidHost, String oidPort, String userDN, String userPassword, String dn, Hashtable attributes, String[] privilege) throws SchemaException, Exception {
        InitialLdapContext ldapContext = RegistrationUtils.getDefaultDirCtx(isSSL, oidHost, oidPort, userDN, userPassword);
        if (privilege != null && privilege.length > 0) {
            for (int i = 0; i < privilege.length; ++i) {
                try {
                    ldapContext.lookup("cn=" + privilege[i] + ", " + "cn=Groups,cn=OracleContext");
                    continue;
                }
                catch (NameNotFoundException e) {
                    try {
                        ldapContext.close();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    throw new SchemaException("Unable to Create " + dn + " in " + oidHost + " " + oidPort + ". Requested privilege " + privilege[i] + " could not be found. Base Exception " + e);
                }
                catch (NamingException e) {
                    try {
                        ldapContext.close();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    throw new SchemaException("Unable to Create " + dn + " in " + oidHost + " " + oidPort + ". Lookup failed for requested privilege " + privilege[i] + ". Base Exception " + e);
                }
            }
        }
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("orclApplicationEntity");
        attrs.put(objclass);
        if (attributes != null && attributes.size() > 0) {
            Enumeration enumValue = attributes.keys();
            while (enumValue.hasMoreElements()) {
                String attrName = (String)enumValue.nextElement();
                BasicAttribute attr = new BasicAttribute(attrName);
                attr.add(attributes.get(attrName));
                attrs.put(attr);
            }
        }
        try {
            DirContext result = ldapContext.createSubcontext(dn, (Attributes)attrs);
            result.close();
        }
        catch (NamingException e) {
            try {
                ldapContext.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw new SchemaException("Unable to Create " + dn + " in " + oidHost + " " + oidPort + ". Base Exception : " + e);
        }
        if (privilege != null && privilege.length > 0) {
            for (int i = 0; i < privilege.length; ++i) {
                try {
                    RegistrationHelper.saveAppendAttribute(ldapContext, "cn=" + privilege[i] + ", " + "cn=Groups,cn=OracleContext", "uniquemember", dn);
                    continue;
                }
                catch (SchemaException e) {
                    try {
                        ldapContext.destroySubcontext(dn);
                        ldapContext.close();
                    }
                    catch (NamingException e1) {
                        // empty catch block
                    }
                    throw new SchemaException("Unable to Create " + dn + " in " + oidHost + " " + oidPort + ". Base Exception : " + e);
                }
            }
        }
        String ownerDN = RegistrationHelper.createComponentOwnerEntries(ldapContext, dn, userDN);
        String associatedDN = RegistrationHelper.createAssociatedMidtierEntries(ldapContext, dn, new String[0], ownerDN);
        RegistrationHelper.createComponentOwnerACIEntries(ldapContext, dn);
        RegistrationHelper.createAssociatedMidtierACIEntries(ldapContext, dn, new String[0], ownerDN);
        RegistrationHelper.setACIsForApplicationEntity(ldapContext, dn, ownerDN, associatedDN);
        try {
            ldapContext.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return dn;
    }

    public static void saveAppendAttribute(DirContext ctx, String dn, String attributeName, String attributeValue) throws SchemaException {
        Hashtable<String, String> tbl = new Hashtable<String, String>(1);
        tbl.put(attributeName, attributeValue);
        RegistrationHelper.saveAppendAttribute(ctx, dn, tbl);
    }

    public static void saveAppendAttribute(DirContext ldapContext, String dn, Hashtable attributes) throws SchemaException {
        int numAttrs = attributes.size();
        String[] attrNames = new String[numAttrs];
        int i = 0;
        Enumeration e = attributes.keys();
        while (e.hasMoreElements()) {
            attrNames[i] = (String)e.nextElement();
            ++i;
        }
        try {
            for (i = 0; i < attrNames.length; ++i) {
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(attrNames[i], (String)attributes.get(attrNames[i])))};
                try {
                    ldapContext.modifyAttributes(dn, mods);
                    continue;
                }
                catch (AttributeInUseException e2) {
                    // empty catch block
                }
            }
        }
        catch (Exception e2) {
            throw new SchemaException("Unable to save Attribute for the " + dn + " in " + ". Base Exception : " + e2);
        }
    }

    private static String createComponentOwnerEntries(DirContext ldapContext, String entryDN, String principal) throws SchemaException {
        String dn = "cn=Component Owners," + entryDN;
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute objclass = new BasicAttribute("objectclass");
            objclass.add("top");
            objclass.add("orclGroup");
            objclass.add("orclACPGroup");
            objclass.add("groupOfUniqueNames");
            attrs.put(objclass);
            attrs.put(new BasicAttribute("uniquemember", principal));
            attrs.put(new BasicAttribute("displayName", "Component Owners"));
            attrs.put(new BasicAttribute("description", "Owners of this Component"));
            DirContext result = ldapContext.createSubcontext(dn, (Attributes)attrs);
            result.close();
        }
        catch (NamingException e) {
            throw new SchemaException("Unable to Create " + dn + " in " + ". Base Exception : " + e);
        }
        return dn;
    }

    private static String createAssociatedMidtierEntries(DirContext ldapContext, String entryDN, String[] instanceDNs, String ownerDN) throws SchemaException {
        String dn = "cn=Associated Mid-tiers," + entryDN;
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute objclass = new BasicAttribute("objectclass");
            objclass.add("top");
            objclass.add("orclGroup");
            objclass.add("orclACPGroup");
            objclass.add("groupOfUniqueNames");
            attrs.put(objclass);
            attrs.put(new BasicAttribute("displayName", "Mid-tiers associated with the component"));
            attrs.put(new BasicAttribute("description", "Mid-tiers associated with the component"));
            DirContext result = ldapContext.createSubcontext(dn, (Attributes)attrs);
            result.close();
            for (int i = 0; i < instanceDNs.length; ++i) {
                RegistrationHelper.saveAppendAttribute(ldapContext, dn, "uniquemember", instanceDNs[i]);
            }
        }
        catch (NamingException e) {
            throw new SchemaException("Unable to Create " + dn + " in " + ". Base Exception : " + e);
        }
        return dn;
    }

    private static String createComponentOwnerACIEntries(DirContext ldapContext, String entryDN) throws SchemaException {
        String dn = "cn=Component Owners," + entryDN;
        try {
            String value1 = "access to entry by dnattr=(uniqueMember) (browse, delete,add) by * (none)";
            String value2 = "access to attr=(*) by dnattr=(uniqueMember) (read,search,write,compare) by * (none)";
            BasicAttribute att = new BasicAttribute("orclentrylevelaci");
            att.add(value1);
            att.add(value2);
            ModificationItem[] acis = new ModificationItem[]{new ModificationItem(1, att)};
            ((InitialDirContext)ldapContext).modifyAttributes(dn, acis);
        }
        catch (NamingException e) {
            throw new SchemaException("Unable to Create " + dn + " in " + ". Base Exception : " + e);
        }
        return dn;
    }

    private static String createAssociatedMidtierACIEntries(DirContext ldapContext, String entryDN, String[] instanceDN, String ownerDN) throws SchemaException {
        String dn = "cn=Associated Mid-tiers," + entryDN;
        try {
            String value1 = "access to entry by group=\"" + ownerDN + "\" (browse, delete,add) by * (none)";
            String value2 = "access to attr=(*) by group=\"" + ownerDN + "\" (read,search,write,compare) by * (none)";
            BasicAttribute att = new BasicAttribute("orclentrylevelaci");
            att.add(value1);
            att.add(value2);
            ModificationItem[] acis = new ModificationItem[]{new ModificationItem(1, att)};
            ((InitialDirContext)ldapContext).modifyAttributes(dn, acis);
        }
        catch (NamingException e) {
            throw new SchemaException("Unable to Create " + dn + " in " + ". Base Exception : " + e);
        }
        return dn;
    }

    private static void setACIsForApplicationEntity(DirContext ldapContext, String entryDN, String ownerDN, String associatedDN) throws SchemaException {
        try {
            String value1 = "access to entry by group=\"" + associatedDN + "\" (browse,proxy) by group=\"" + ownerDN + "\" (browse, add, delete) by dn=\"" + entryDN + "\" (browse,add,delete) by * (none)";
            String value2 = "access to attr=(*) by group=\"" + ownerDN + "\" (read,search,write,compare) by dn=\"" + entryDN + "\" (read,search, write,compare) by * (none)";
            BasicAttribute att = new BasicAttribute("orclaci");
            att.add(value1);
            att.add(value2);
            ModificationItem[] acis = new ModificationItem[]{new ModificationItem(1, att)};
            ((InitialDirContext)ldapContext).modifyAttributes(entryDN, acis);
        }
        catch (NamingException e) {
            throw new SchemaException("Unable to Change ACIs for " + entryDN + " in " + ". Base Exception : " + e);
        }
    }
}

