/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.repapi;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NoPermissionException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.repapi.RegistrationUtils;
import oracle.ldap.util.repapi.SchemaConstants;
import oracle.ldap.util.repapi.SchemaException;

public class DeRegistrationHelper
implements SchemaConstants {
    public static boolean deleteOIDEntry(boolean isSSL, String oidHost, String oidPort, String userDN, String userPassword, String containerName, String childName) throws SchemaException {
        String dn = null;
        if (containerName != null && containerName.trim().length() > 0 && childName != null && childName.trim().length() > 0) {
            dn = "orclApplicationCommonName=" + childName + ",cn=" + containerName + "," + "cn=Products, cn=OracleContext";
        }
        return DeRegistrationHelper.deleteOIDEntry(isSSL, oidHost, oidPort, userDN, userPassword, dn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteOIDEntry(boolean isSSL, String oidHost, String oidPort, String userDN, String userPassword, String dn) throws SchemaException {
        InitialContext ctx = null;
        try {
            ctx = RegistrationUtils.getDefaultDirCtx(isSSL, oidHost, oidPort, userDN, userPassword);
            PropertySetCollection psc = Util.ldapSearch((DirContext)((Object)ctx), "cn=groups,cn=oraclecontext", "uniquemember=" + dn, 1, new String[]{"dn"});
            if (!psc.isEmpty()) {
                for (int i = 0; i < psc.size(); ++i) {
                    String curDN = psc.getPropertySet(i).getDN();
                    DeRegistrationHelper.removeAttribute((DirContext)((Object)ctx), curDN, "uniquemember", dn);
                }
            }
            try {
                Util.bulkDelete((DirContext)((Object)ctx), dn, true);
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                ctx.close();
            }
            catch (Exception e) {}
        }
        return true;
    }

    public static void removeAttribute(DirContext ldapContext, String dn, String attributeName, String attributeValue) throws SchemaException {
        Hashtable<String, String> tbl = new Hashtable<String, String>(1);
        tbl.put(attributeName, attributeValue);
        DeRegistrationHelper.removeAttribute(ldapContext, dn, tbl);
    }

    public static void removeAttribute(DirContext ldapContext, String dn, Hashtable attributes) throws SchemaException {
        int numAttrs = attributes.size();
        String[] attrNames = new String[numAttrs];
        int i = 0;
        Enumeration e = attributes.keys();
        while (e.hasMoreElements()) {
            attrNames[i] = (String)e.nextElement();
            ++i;
        }
        for (i = 0; i < attrNames.length; ++i) {
            try {
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(attrNames[i], (String)attributes.get(attrNames[i])))};
                ldapContext.modifyAttributes(dn, mods);
                continue;
            }
            catch (NoSuchAttributeException e2) {
                continue;
            }
            catch (NoPermissionException npe) {
                continue;
            }
            catch (NameNotFoundException e3) {
                continue;
            }
            catch (Exception e4) {
                throw new SchemaException("Unable to remove the instance dn " + (String)attributes.get(attrNames[i]) + " from the uniquemember " + "attribute of the dn: " + dn + " in " + "\nBase Exception : " + e4);
            }
        }
    }
}

