/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningInboundProfileV2;
import oracle.ldap.util.provisioning.ProvisioningOutboundProfileV2;
import oracle.ldap.util.provisioning.ProvisioningProfile;

class ProvisioningProfileV2
extends ProvisioningProfile {
    public static final int MODE_INBOUND = 1;
    public static final int MODE_OUTBOUND = 2;
    public static final int MODE_BOTH = 3;
    public static final String INBOUND_RDN = "cn=ApplicationToOID";
    public static final String INBOUND_RDN_VAL = "ApplicationToOID";
    protected String profileStatus;
    protected int profileMode = 2;
    protected String profileMaxEventPerInvocation;
    protected String profileMaxEventPerSchedule;
    protected String profileMaxErrors;
    protected String crypt_key;
    protected ProvisioningInboundProfileV2 inBoundV2Profile;
    protected ProvisioningOutboundProfileV2 outBoundV2Profile;
    public static final String PROV_PROFILE_VERSION = "2.0";

    public ProvisioningProfileV2() {
    }

    public ProvisioningProfileV2(DirContext ctx, String profile_dn) throws Exception {
        this.readV2ProfileFromDir(ctx, profile_dn);
        this.readInboundV2ProfileFromDir(ctx, profile_dn);
        this.readOutboundV2ProfileFromDir(ctx, profile_dn);
        if (!this.getInboundProfilev2().isValid()) {
            this.setProfileMode(2);
        } else if (!this.getOutboundProfilev2().isValid()) {
            this.setProfileMode(1);
        } else {
            this.setProfileMode(3);
        }
    }

    public ProvisioningProfileV2(DirContext ctx, String appDN, String orgDN) throws Exception {
        String profile_DN = ProvisioningProfile.composeProfileDN(ctx, appDN, orgDN);
        this.readV2ProfileFromDir(ctx, profile_DN);
        this.readInboundV2ProfileFromDir(ctx, profile_DN);
        this.readOutboundV2ProfileFromDir(ctx, profile_DN);
        if (!this.getInboundProfilev2().isValid()) {
            this.setProfileMode(2);
        } else if (!this.getOutboundProfilev2().isValid()) {
            this.setProfileMode(1);
        } else {
            this.setProfileMode(3);
        }
    }

    public static void process(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        int status = 0;
        String emsg = "";
        ProvisioningProfileV2 my_profile = null;
        switch (cmd.getOperation()) {
            case 1: {
                try {
                    my_profile = ProvisioningProfileV2.createNewProfileV2(ctx, cmd);
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_SUCCESS"));
                    System.out.println(resBundle.getString("PROFILE_NAME") + my_profile.getProfileName());
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV2.getResultStr(e, "PROV_PROFILE_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 2: {
                try {
                    my_profile = new ProvisioningProfileV2(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Updating Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    my_profile.checkIntfVersion(cmd);
                    boolean test = false;
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Disable");
                        }
                        my_profile.getInboundProfilev2().disable(ctx);
                        ProvisioningProfile.LOG("Disabled InBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled MAIN Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Disable");
                        }
                        my_profile.disable(ctx, my_profile.getOutboundProfilev2().getDN());
                        ProvisioningProfile.LOG("Disabled OutBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled MAIN Profile");
                    } else if (cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                        my_profile.getInboundProfilev2().disable(ctx);
                        ProvisioningProfile.LOG("Disabled InBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled Main Profile");
                    } else if (cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                        my_profile.disable(ctx, my_profile.getOutboundProfilev2().getDN());
                        ProvisioningProfile.LOG("Disabled OutBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled Main Profile");
                    } else {
                        my_profile.getInboundProfilev2().disable(ctx);
                        ProvisioningProfile.LOG("Disabled InBound Profile");
                        my_profile.disable(ctx, my_profile.getOutboundProfilev2().getDN());
                        ProvisioningProfile.LOG("Disabled OutBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled Main Profile");
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_DISABLED"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV2.getResultStr(e, "PROV_PROFILE_MOD_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 3: {
                try {
                    my_profile = new ProvisioningProfileV2(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Updating Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    my_profile.checkIntfVersion(cmd);
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Enable");
                        }
                        my_profile.getInboundProfilev2().enable(ctx);
                        ProvisioningProfile.LOG("Enabled InBound Profile");
                        my_profile.enable(ctx);
                        ProvisioningProfile.LOG("Enabled Main Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Enable");
                        }
                        my_profile.enable(ctx, my_profile.getOutboundProfilev2().getDN());
                        ProvisioningProfile.LOG("Enabled OutBound Profile");
                        my_profile.enable(ctx);
                        ProvisioningProfile.LOG("Enabled Main Profile");
                    } else {
                        my_profile.enable(ctx);
                        ProvisioningProfile.LOG("Enabled Main Profile");
                        if (cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            my_profile.getInboundProfilev2().enable(ctx);
                            ProvisioningProfile.LOG("Enabled InBound Profile");
                        } else if (cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            my_profile.enable(ctx, my_profile.getOutboundProfilev2().getDN());
                            ProvisioningProfile.LOG("Enabled OutBound Profile");
                        } else {
                            my_profile.getInboundProfilev2().enable(ctx);
                            ProvisioningProfile.LOG("Enabled InBound Profile");
                            my_profile.enable(ctx, my_profile.getOutboundProfilev2().getDN());
                            ProvisioningProfile.LOG("Enabled OutBound Profile");
                        }
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_ENABLED"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV2.getResultStr(e, "PROV_PROFILE_MOD_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 4: {
                try {
                    my_profile = new ProvisioningProfileV2(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Getting Profile(s) Status");
                    int pmode = my_profile.getProfileMode();
                    my_profile.checkIntfVersion(cmd);
                    if (pmode == 1) {
                        my_profile.status(ctx);
                        my_profile.getInboundProfilev2().status(ctx);
                        ProvisioningProfile.LOG("InBound Profile Status Success");
                        break;
                    }
                    if (pmode == 2) {
                        my_profile.status(ctx);
                        my_profile.getOutboundProfilev2().status(ctx);
                        ProvisioningProfile.LOG("OutBound Profile Status Success");
                        break;
                    }
                    my_profile.status(ctx);
                    my_profile.getInboundProfilev2().status(ctx);
                    my_profile.getOutboundProfilev2().status(ctx);
                    ProvisioningProfile.LOG("Main Profile(s) Status");
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV2.getResultStr(e, "PROV_PROFILE_NO_STATUS");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 5: {
                try {
                    my_profile = new ProvisioningProfileV2(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Deleting Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    ProvisioningProfile.LOG("Profile Mode : " + pmode);
                    my_profile.checkIntfVersion(cmd);
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND. Cannot Delete");
                        }
                        my_profile.getInboundProfilev2().delete(ctx);
                        ProvisioningProfile.LOG("Deleted InBound Profile");
                        my_profile.delete(ctx);
                        ProvisioningProfile.LOG("Deleted Main Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Delete");
                        }
                        my_profile.delete(ctx, my_profile.getOutboundProfilev2().getDN());
                        ProvisioningProfile.LOG("Deleted OutBound Profile");
                        my_profile.delete(ctx);
                        ProvisioningProfile.LOG("Deleted Main Profile");
                    } else {
                        if (!cmdProfileMode.equalsIgnoreCase("BOTH")) {
                            throw new Exception("Profile currently BOTH. Please use PROFILE_MODE=BOTH to Delete");
                        }
                        my_profile.getInboundProfilev2().delete(ctx);
                        ProvisioningProfile.LOG("Deleted InBound Profile");
                        my_profile.delete(ctx, my_profile.getOutboundProfilev2().getDN());
                        ProvisioningProfile.LOG("Deleted OutBound Profile");
                        my_profile.delete(ctx);
                        ProvisioningProfile.LOG("Deleted Main Profile");
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_DELETED"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV2.getResultStr(e, "PROV_PROFILE_DELETE_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 6: {
                try {
                    my_profile = new ProvisioningProfileV2(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Resetting Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    my_profile.checkIntfVersion(cmd);
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Reset");
                        }
                        my_profile.getInboundProfilev2().reset(ctx);
                        ProvisioningProfile.LOG("Reset InBound Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Reset");
                        }
                        my_profile.reset(ctx, my_profile.getOutboundProfilev2().getDN());
                        ProvisioningProfile.LOG("Reset OutBound Profile");
                    } else {
                        if (cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            my_profile.getInboundProfilev2().reset(ctx);
                            ProvisioningProfile.LOG("Reset InBound Profile");
                        }
                        if (cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            my_profile.reset(ctx, my_profile.getOutboundProfilev2().getDN());
                            ProvisioningProfile.LOG("Reset OutBound Profile");
                        }
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_RESET_SUCCESS"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV2.getResultStr(e, "PROV_PROFILE_RESET_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 7: {
                try {
                    my_profile = new ProvisioningProfileV2(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Modifying Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    my_profile.checkIntfVersion(cmd);
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Modify");
                        }
                        my_profile.getInboundProfilev2().modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified InBound Profile");
                        my_profile.modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified Main Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Modify");
                        }
                        my_profile.getOutboundProfilev2().modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified OutBound Profile");
                        my_profile.modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified Main Profile");
                    } else {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            my_profile.getInboundProfilev2().modify(ctx, cmd);
                            ProvisioningProfile.LOG("Modified InBound Profile");
                        }
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            my_profile.getOutboundProfilev2().modify(ctx, cmd);
                            ProvisioningProfile.LOG("Modified OutBound Profile");
                        }
                        my_profile.modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified Main Profile");
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_MOD_SUCCESS"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV2.getResultStr(e, "PROV_PROFILE_MOD_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 8: {
                try {
                    my_profile = new ProvisioningProfileV2(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    my_profile.checkIntfVersion(cmd);
                    my_profile.exists(ctx);
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_FOUND"));
                    System.out.println(resBundle.getString("PROFILE_NAME") + my_profile.getProfileName());
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV2.getResultStr(e, "PROV_PROFILE_NOT_FOUND");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            default: {
                if (!apimode) {
                    System.out.println(resBundle.getString("PROV_PROFILE_INVALID_OPERATION"));
                    status = -1;
                    break;
                }
                throw new Exception(resBundle.getString("PROV_PROFILE_INVALID_OPERATION"));
            }
        }
    }

    public void modify(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        Vector additionalInfoVect;
        int attrCount = 0;
        ModificationItem[] tmpMods = new ModificationItem[64];
        BasicAttribute ldapattr = null;
        if (cmd.get("SCHEDULE") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileSchedule", cmd.get("SCHEDULE")));
        }
        if (cmd.get("MAX_RETRIES") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxRetries", cmd.get("MAX_RETRIES")));
        }
        if (cmd.get("INTERFACE_NAME") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceName", cmd.get("INTERFACE_NAME")));
        }
        if (cmd.get("INTERFACE_TYPE") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceType", cmd.get("INTERFACE_TYPE")));
        }
        if (cmd.get("INTERFACE_VERSION") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceVersion", cmd.get("INTERFACE_VERSION")));
        }
        if (cmd.get("INTERFACE_CONNECT_INFO") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceConnectInformation", cmd.get("INTERFACE_CONNECT_INFO")));
        }
        if ((additionalInfoVect = cmd.getVector("INTERFACE_ADDITIONAL_INFO")) != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclODIPProfileInterfaceAdditionalInformation");
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceAdditionalInformation");
            for (int i = 0; i < additionalInfoVect.size(); ++i) {
                ldapattr.add(additionalInfoVect.elementAt(i));
            }
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if (cmd.get("MAX_EVENTS_PER_INVOCATION") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxEventsPerInvocation", cmd.get("MAX_EVENTS_PER_INVOCATION")));
        }
        if (cmd.get("MAX_EVENTS_PER_SCHEDULE") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxEventsPerSchedule", cmd.get("MAX_EVENTS_PER_SCHEDULE")));
        }
        if (cmd.get("PROFILE_GROUP") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileExecGroupID", cmd.get("PROFILE_GROUP")));
        }
        if (cmd.get("PROFILE_DEBUG") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileDebugLevel", cmd.get("PROFILE_DEBUG")));
        }
        if (cmd.get("CRYPT_KEY") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPEncryptedAttrKey", cmd.get("CRYPT_KEY")));
        }
        if (cmd.get("PROFILE_MAX_ERRORS") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxErrors", cmd.get("PROFILE_MAX_ERRORS")));
        }
        ModificationItem[] mods = new ModificationItem[attrCount];
        System.arraycopy(tmpMods, 0, mods, 0, attrCount);
        ProvisioningProfile.LOG("Modifying entry : (" + this.profileDN + ")");
        ctx.modifyAttributes(this.profileDN, mods);
    }

    public void disable(DirContext ctx) throws Exception {
        this.disable(ctx, this.profileDN);
    }

    public void enable(DirContext ctx) throws Exception {
        this.enable(ctx, this.profileDN);
    }

    public void disable(DirContext ctx, String profDN) throws Exception {
        if (this.getProfileStatus().equalsIgnoreCase("DISABLED") && !apimode) {
            System.out.println(resBundle.getString("PROV_PROFILE_ALREADY_DISABLED"));
        }
        ProvisioningProfile.LOG("Disabling entry : (" + profDN + ")");
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("orclStatus", "DISABLED"))};
        ctx.modifyAttributes(profDN, mods);
    }

    public void enable(DirContext ctx, String profDN) throws Exception {
        if (this.getProfileStatus().equalsIgnoreCase("ENABLED") && !apimode) {
            System.out.println(resBundle.getString("PROV_PROFILE_ALREADY_ENABLED"));
        }
        ProvisioningProfile.LOG("Enabling entry : (" + profDN + ")");
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("orclStatus", "ENABLED"))};
        ctx.modifyAttributes(profDN, mods);
    }

    public void reset(DirContext ctx) throws Exception {
        this.reset(ctx, this.profileDN);
    }

    public void reset(DirContext ctx, String profDN) throws Exception {
        ModificationItem[] mods = new ModificationItem[1];
        ProvisioningProfile.LOG("Resetting entry : (" + profDN + ")");
        if (this.getProfileProcessingErrors() != null) {
            mods[0] = new ModificationItem(3, new BasicAttribute("orclODIPProfileProcessingErrors"));
            ctx.modifyAttributes(profDN, mods);
        }
    }

    public void delete(DirContext ctx) throws Exception {
        this.delete(ctx, this.profileDN);
    }

    public void delete(DirContext ctx, String dn) throws Exception {
        ProvisioningProfile.LOG("Deleting entry : (" + dn + ")");
        ctx.destroySubcontext(dn);
    }

    public void status(DirContext ctx) throws Exception {
    }

    protected static String getProfileVersion() {
        return PROV_PROFILE_VERSION;
    }

    public static ProvisioningProfileV2 createNewProfileV2(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        ProvisioningProfileV2 ret_prof = null;
        boolean entry_exists = false;
        Object existing_entry = null;
        Object event_vector = null;
        String mode = cmd.get("PROFILE_MODE");
        int pmode = 2;
        if (mode.equalsIgnoreCase("OUTBOUND")) {
            pmode = 2;
        }
        if (mode.equalsIgnoreCase("INBOUND")) {
            pmode = 1;
        }
        if (mode.equalsIgnoreCase("BOTH")) {
            pmode = 3;
        }
        String profile_dn = ProvisioningProfile.composeProfileDN(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
        if (pmode != 2 && (entry_exists = ProvisioningProfileV2.directoryEntryExists(ctx, "cn=ApplicationToOID," + profile_dn))) {
            throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
        }
        if (pmode != 1 && (entry_exists = ProvisioningProfileV2.directoryEntryExists(ctx, "cn=OIDToApplication," + profile_dn))) {
            throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
        }
        entry_exists = ProvisioningProfileV2.directoryEntryExists(ctx, profile_dn);
        if (entry_exists) {
            throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
        }
        BasicAttribute ldapattr = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("orclODIPProvisioningIntegrationProfileV2");
        attrs.put(objclass);
        ldapattr = new BasicAttribute("orclODIPProfileName");
        ldapattr.add(ProvisioningProfileV2.getRDNAttrValue(ctx, profile_dn));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclVersion");
        ldapattr.add(ProvisioningProfileV2.getProfileVersion());
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclStatus");
        ldapattr.add(cmd.get("PROFILE_STATUS"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningAppName");
        if (cmd.get("APPLICATION_NAME") != null) {
            ldapattr.add(cmd.get("APPLICATION_NAME"));
        } else {
            ldapattr.add(ProvisioningProfileV2.getRDNAttrValue(ctx, cmd.get("APPLICATION_DN")));
        }
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningOrgName");
        ldapattr.add(ProvisioningProfileV2.getRDNAttrValue(ctx, cmd.get("ORGANIZATION_DN")));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningAppGUID");
        ldapattr.add(ProvisioningProfileV2.getDirectoryEntryGUID(ctx, cmd.get("APPLICATION_DN")));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningOrgGUID");
        ldapattr.add(ProvisioningProfileV2.getDirectoryEntryGUID(ctx, cmd.get("ORGANIZATION_DN")));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileSchedule");
        ldapattr.add(cmd.get("SCHEDULE"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileMaxRetries");
        ldapattr.add(cmd.get("MAX_RETRIES"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileInterfaceName");
        ldapattr.add(cmd.get("INTERFACE_NAME"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileInterfaceType");
        ldapattr.add(cmd.get("INTERFACE_TYPE"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileInterfaceVersion");
        ldapattr.add(cmd.get("INTERFACE_VERSION"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileInterfaceConnectInformation");
        ldapattr.add(cmd.get("INTERFACE_CONNECT_INFO"));
        attrs.put(ldapattr);
        Vector additionalInfoVector = null;
        additionalInfoVector = cmd.getVector("INTERFACE_ADDITIONAL_INFO");
        if (additionalInfoVector != null) {
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceAdditionalInformation");
            for (int i = 0; i < additionalInfoVector.size(); ++i) {
                ldapattr.add((String)additionalInfoVector.elementAt(i));
            }
            attrs.put(ldapattr);
        }
        ldapattr = new BasicAttribute("orclODIPProfileMaxEventsPerInvocation");
        ldapattr.add(cmd.get("MAX_EVENTS_PER_INVOCATION"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileMaxEventsPerSchedule");
        ldapattr.add(cmd.get("MAX_EVENTS_PER_SCHEDULE"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileExecGroupID");
        ldapattr.add(cmd.get("PROFILE_GROUP"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileDebugLevel");
        ldapattr.add(cmd.get("PROFILE_DEBUG"));
        attrs.put(ldapattr);
        if (!oldDIT) {
            if (cmd.get("APPLICATION_TYPE") != null) {
                ldapattr = new BasicAttribute("orclApplicationType");
                ldapattr.add(cmd.get("APPLICATION_TYPE"));
                attrs.put(ldapattr);
            }
            if (cmd.get("APPLICATION_DISPLAY_NAME") != null) {
                ldapattr = new BasicAttribute("orclApplicationDisplayName");
                ldapattr.add(cmd.get("APPLICATION_DISPLAY_NAME"));
                attrs.put(ldapattr);
            }
            if (cmd.get("USER_DATA_LOCATION") != null) {
                ldapattr = new BasicAttribute("orclApplicationUserDataLoc");
                ldapattr.add(cmd.get("USER_DATA_LOCATION"));
                attrs.put(ldapattr);
            }
            if (cmd.get("DEFAULT_PROVISIONING_POLICY") != null) {
                ldapattr = new BasicAttribute("orclApplicationDefaultPolicy");
                ldapattr.add(cmd.get("DEFAULT_PROVISIONING_POLICY"));
                attrs.put(ldapattr);
            }
        }
        ldapattr = new BasicAttribute("orclODIPEncryptedAttrKey");
        ldapattr.add(cmd.get("CRYPT_KEY"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileMaxErrors");
        ldapattr.add(cmd.get("PROFILE_MAX_ERRORS"));
        attrs.put(ldapattr);
        ProvisioningProfile.LOG(((Object)attrs).toString());
        DirContext result = ctx.createSubcontext(profile_dn, (Attributes)attrs);
        ProvisioningProfile.LOG("Created Main Profile Entry Successfully");
        ProvisioningInboundProfileV2 in = null;
        if (pmode != 2) {
            in = ProvisioningInboundProfileV2.createNewInboundProfileV2(ctx, cmd);
        }
        ProvisioningOutboundProfileV2 out = null;
        if (pmode != 1) {
            out = ProvisioningOutboundProfileV2.createNewOutboundProfileV2(ctx, cmd);
        }
        ret_prof = new ProvisioningProfileV2(ctx, profile_dn);
        ret_prof.setProfileMode(pmode);
        ProvisioningProfile.LOG("Created Main Profile Object Successfully");
        if (!apimode) {
            System.out.println(resBundle.getString("APPLICATION") + ret_prof.getProvisioningProfileAppName());
            System.out.println(resBundle.getString("ORGANIZATION") + ret_prof.getProvisioningProfileOrgName());
            System.out.println(resBundle.getString("STATUS") + ret_prof.getProfileStatus());
            System.out.println(resBundle.getString("SCHEDULE") + ret_prof.getProfileSchedule());
            System.out.println(resBundle.getString("MAX_RETRIES") + ret_prof.getProfileMaxRetries());
            System.out.println(resBundle.getString("EXECUTION_GRP") + ret_prof.getProfileGroup());
            System.out.println(resBundle.getString("INTERFACE_NAME") + ret_prof.getProfileInterfaceName());
            System.out.println(resBundle.getString("INTERFACE_TYPE") + ret_prof.getProfileInterfaceType());
            System.out.println(resBundle.getString("INTERFACE_VER") + ret_prof.getProfileInterfaceVersion());
            System.out.println(resBundle.getString("INTERFACE_CONN_INFO") + "---");
            System.out.println(resBundle.getString("INTERFACE_ADDITIONAL_INFO") + ret_prof.getProfileInterfaceAdditionalInfo());
            if (in != null) {
                System.out.println(resBundle.getString("MAPPING_RULES") + ret_prof.getInboundProfilev2().getProfileMapRules());
                System.out.println(resBundle.getString("EVENT_PERMITTED_OPS") + ret_prof.getInboundProfilev2().getProfilePermttdOprns());
            }
            if (out != null) {
                System.out.println(resBundle.getString("LAST_APPLIED_CHG_NUM") + ret_prof.getOutboundProfilev2().getProfileChgLogLastAppliedChangeNumber());
                System.out.println(resBundle.getString("EVENT_SUBCP") + ret_prof.getOutboundProfilev2().getProvisioningProfileEventSubscription());
            }
        }
        return ret_prof;
    }

    private void readV2ProfileFromDir(DirContext ctx, String profile_dn) throws Exception {
        String[] attr_list = new String[]{"*", "orclguid"};
        Property ldap_attr = null;
        ProvisioningProfile.LOG("Searching For MAIN Profile v2 : " + profile_dn);
        PropertySetCollection entry = Util.getEntryDetails(ctx, profile_dn, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
        this.profileDN = profile_dn;
        ldap_attr = entry_details.getProperty("orclODIPProfileName");
        if (ldap_attr != null) {
            this.setProfileName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclStatus")) != null) {
            this.setProfileStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclVersion")) != null) {
            this.setProfileVersion((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileSchedule")) != null) {
            this.setProfileSchedule((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileMaxRetries")) != null) {
            this.setProfileMaxRetries((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileMaxEventsPerInvocation")) != null) {
            this.setProfileMaxEventPerInvc((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileMaxEventsPerSchedule")) != null) {
            this.setProfileMaxEventPerSch((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileExecGroupID")) != null) {
            this.setProfileGroup((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPEncryptedAttrKey")) != null) {
            this.setProfileCryptKey((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileMaxErrors")) != null) {
            this.setProfileMaxErrors((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceName")) != null) {
            this.setProfileInterfaceName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceType")) != null) {
            this.setProfileInterfaceType((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceVersion")) != null) {
            this.setProfileInterfaceVersion((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceConnectInformation")) != null) {
            this.setProfileInterfaceConnectInfo((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceAdditionalInformation")) != null && ldap_attr.size() > 0) {
            Vector<Object> interfaceAdditionalInfoVect = new Vector<Object>();
            for (int i = 0; i < ldap_attr.size(); ++i) {
                interfaceAdditionalInfoVect.addElement(ldap_attr.getValue(i));
            }
            this.setProfileInterfaceAdditionalInfo(interfaceAdditionalInfoVect);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningAppName")) != null) {
            this.setProvisioningProfileAppName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningAppGUID")) != null) {
            this.setProvisioningProfileAppGUID((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningOrgName")) != null) {
            this.setProvisioningProfileOrgName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningOrgGUID")) != null) {
            this.setProvisioningProfileOrgGUID((String)ldap_attr.getValue(0));
        }
    }

    public void readInboundV2ProfileFromDir(DirContext ctx, String profile_dn) throws Exception {
        this.inBoundV2Profile = new ProvisioningInboundProfileV2(ctx, profile_dn);
    }

    public void readOutboundV2ProfileFromDir(DirContext ctx, String profile_dn) throws Exception {
        this.outBoundV2Profile = new ProvisioningOutboundProfileV2(ctx, profile_dn);
    }

    public ProvisioningInboundProfileV2 getInboundProfilev2() {
        return this.inBoundV2Profile;
    }

    public void setInboundProfilev2(ProvisioningInboundProfileV2 inprof) {
        this.inBoundV2Profile = inprof;
    }

    public ProvisioningOutboundProfileV2 getOutboundProfilev2() {
        return this.outBoundV2Profile;
    }

    public void setOutboundProfilev2(ProvisioningOutboundProfileV2 outprof) {
        this.outBoundV2Profile = outprof;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String newProfileName) {
        this.profileName = newProfileName;
    }

    public int getProfileMode() {
        return this.profileMode;
    }

    public void setProfileMode(int mode) {
        this.profileMode = mode;
    }

    public String getProfileStatus() {
        return this.profileStatus;
    }

    public void setProfileStatus(String newProfileStatus) {
        this.profileStatus = newProfileStatus;
    }

    public void setProfileVersion(String newProfileVersion) {
        this.profileVersion = newProfileVersion;
    }

    public String getProfileSchedule() {
        return this.profileSchedule;
    }

    public void setProfileSchedule(String newProfileSchedule) {
        this.profileSchedule = newProfileSchedule;
    }

    public String getProfileMaxRetries() {
        return this.profileMaxRetries;
    }

    public void setProfileMaxRetries(String newProfileMaxRetries) {
        this.profileMaxRetries = newProfileMaxRetries;
    }

    public void setProfileMaxEventPerInvc(String val) {
        this.profileMaxEventPerInvocation = val;
    }

    public void setProfileMaxEventPerSch(String val) {
        this.profileMaxEventPerSchedule = val;
    }

    public void setProfileGroup(String val) {
        this.profileGroup = val;
    }

    public void setProfileCryptKey(String val) {
        this.crypt_key = val;
    }

    public void setProfileMaxErrors(String val) {
        this.profileMaxErrors = val;
    }

    public String getProfileInterfaceName() {
        return this.profileInterfaceName;
    }

    public void setProfileInterfaceName(String newProfileInterfaceName) {
        this.profileInterfaceName = newProfileInterfaceName;
    }

    public String getProfileInterfaceType() {
        return this.profileInterfaceType;
    }

    public void setProfileInterfaceType(String newProfileInterfaceType) {
        this.profileInterfaceType = newProfileInterfaceType;
    }

    public String getProfileInterfaceVersion() {
        return this.profileInterfaceVersion;
    }

    public void setProfileInterfaceVersion(String newProfileInterfaceVersion) {
        this.profileInterfaceVersion = newProfileInterfaceVersion;
    }

    public String getProfileInterfaceConnectInfo() {
        return this.profileInterfaceConnectInfo;
    }

    public void setProfileInterfaceConnectInfo(String newProfileInterfaceConnectInfo) {
        this.profileInterfaceConnectInfo = newProfileInterfaceConnectInfo;
    }

    public Vector getProfileInterfaceAdditionalInfo() {
        return this.profileInterfaceAdditionalInfo;
    }

    public void setProfileInterfaceAdditionalInfo(Vector additionalInfo) {
        this.profileInterfaceAdditionalInfo = additionalInfo;
    }

    public String getProfileChgLogLastAppliedChangeNumber() {
        return this.profileChgLogLastAppliedChangeNumber;
    }

    public void setProfileChgLogLastAppliedChangeNumber(String newProfileChgLogLastAppliedChangeNumber) {
        this.profileChgLogLastAppliedChangeNumber = newProfileChgLogLastAppliedChangeNumber;
    }

    public String getProfileChgLogSubscriberDisable() {
        return this.profileChgLogSubscriberDisable;
    }

    public void setProfileChgLogSubscriberDisable(String newProfileChgLogSubscriberDisable) {
        this.profileChgLogSubscriberDisable = newProfileChgLogSubscriberDisable;
    }

    public Vector getProvisioningProfileEventSubscription() {
        return this.provisioningProfileEventSubscription;
    }

    public void setProvisioningProfileEventSubscription(Vector newProvisioningProfileEventSubscription) {
        this.provisioningProfileEventSubscription = newProvisioningProfileEventSubscription;
    }

    public String getProvisioningProfileAppName() {
        return this.provisioningProfileAppName;
    }

    public void setProvisioningProfileAppName(String newProvisioningProfileAppName) {
        this.provisioningProfileAppName = newProvisioningProfileAppName;
    }

    public String getProvisioningProfileAppGUID() {
        return this.provisioningProfileAppGUID;
    }

    public void setProvisioningProfileAppGUID(String newProvisioningProfileAppGUID) {
        this.provisioningProfileAppGUID = newProvisioningProfileAppGUID;
    }

    public String getProvisioningProfileOrgName() {
        return this.provisioningProfileOrgName;
    }

    public void setProvisioningProfileOrgName(String newProvisioningProfileOrgName) {
        this.provisioningProfileOrgName = newProvisioningProfileOrgName;
    }

    public String getProvisioningProfileOrgGUID() {
        return this.provisioningProfileOrgGUID;
    }

    public void setProvisioningProfileOrgGUID(String newProvisioningProfileOrgGUID) {
        this.provisioningProfileOrgGUID = newProvisioningProfileOrgGUID;
    }
}

