/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.NUtil;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningProfileV2;
import oracle.ldap.util.provisioning.ProvisioningProfileV3;

public class ProvisioningProfile {
    static final int OPTYPE_CREATE = 1;
    static final int OPTYPE_DISABLE = 2;
    static final int OPTYPE_ENABLE = 3;
    static final int OPTYPE_STATUS = 4;
    static final int OPTYPE_DELETE = 5;
    static final int OPTYPE_RESET = 6;
    static final int OPTYPE_MODIFY = 7;
    static final int OPTYPE_EXISTS = 8;
    public static final String OP_CREATE = "CREATE";
    public static final String OP_MODIFY = "MODIFY";
    public static final String OP_DELETE = "DELETE";
    public static final String OP_ENABLE = "ENABLE";
    public static final String OP_DISABLE = "DISABLE";
    public static final String OP_STATUS = "STATUS";
    public static final String OP_RESET = "RESET";
    public static final String OP_EXISTS = "EXISTS";
    public static final String OPERATION = "OPERATION";
    public static final String LDAP_HOST = "LDAP_HOST";
    public static final String LDAP_PORT = "LDAP_PORT";
    public static final String LDAP_USER_DN = "LDAP_USER_DN";
    public static final String LDAP_USER_PASSWORD = "LDAP_USER_PASSWORD";
    public static final String PROFILE_STATUS = "PROFILE_STATUS";
    public static final String PROFILE_MODE = "PROFILE_MODE";
    public static final String SCHEDULE = "SCHEDULE";
    public static final String MAX_RETRIES = "MAX_RETRIES";
    public static final String MAX_EVENTS_PER_INVOCATION = "MAX_EVENTS_PER_INVOCATION";
    public static final String MAX_EVENTS_PER_SCHEDULE = "MAX_EVENTS_PER_SCHEDULE";
    public static final String PROFILE_GROUP = "PROFILE_GROUP";
    public static final String PROFILE_DEBUG = "PROFILE_DEBUG";
    public static final String CRYPT_KEY = "CRYPT_KEY";
    public static final String PROFILE_MAX_ERRORS = "PROFILE_MAX_ERRORS";
    public static final String APPLICATION_DN = "APPLICATION_DN";
    public static final String APPLICATION_NAME = "APPLICATION_NAME";
    public static final String APPLICATION_TYPE = "APPLICATION_TYPE";
    public static final String ORGANIZATION_DN = "ORGANIZATION_DN";
    public static final String ORGANIZATION_NAME = "ORGANIZATION_NAME";
    public static final String INTERFACE_NAME = "INTERFACE_NAME";
    public static final String INTERFACE_TYPE = "INTERFACE_TYPE";
    public static final String INTERFACE_CONNECT_INFO = "INTERFACE_CONNECT_INFO";
    public static final String INTERFACE_VERSION = "INTERFACE_VERSION";
    public static final String INTERFACE_ADDITIONAL_INFO = "INTERFACE_ADDITIONAL_INFO";
    public static final String EVENT_SUBSCRIPTION = "EVENT_SUBSCRIPTION";
    public static final String EVENT_MAPPING_RULES = "EVENT_MAPPING_RULES";
    public static final String EVENT_PERMITTED_OPERATIONS = "EVENT_PERMITTED_OPERATIONS";
    public static final String LASTCHANGENUMBER = "LASTCHANGENUMBER";
    public static final String SUBSCRIPTION_MODE = "SUBSCRIPTION_MODE";
    public static final String SSL_MODE = "SSL_MODE";
    public static final String USER_DATA_LOCATION = "USER_DATA_LOCATION";
    public static final String DEFAULT_PROVISIONING_POLICY = "DEFAULT_PROVISIONING_POLICY";
    public static final String ENABLE_BOOTSTRAP = "ENABLE_BOOTSTRAP";
    public static final String ENABLE_UPGRADE = "ENABLE_UPGRADE";
    public static final String MAX_PROV_FAILURE_RETRIES = "MAX_PROV_FAILURE_RETRIES";
    public static final String APPLICATION_DISPLAY_NAME = "APPLICATION_DISPLAY_NAME";
    public static final String APPLICATION_ISDASVISIBLE = "APPLICATION_ISDASVISIBLE";
    public static final String MANAGE_APPLICATION_DEFAULTS = "MANAGE_APPLICATION_DEFAULTS";
    protected String profileDN;
    protected String profileName;
    protected String profileStatus;
    protected String profileVersion = "3.0";
    protected String profileSchedule = "3600";
    protected String profileMaxRetries = "5";
    protected String profileGroup = "0";
    protected String profileInterfaceName;
    protected String profileInterfaceType;
    protected String profileInterfaceVersion;
    protected String profileInterfaceConnectInfo;
    protected Vector profileInterfaceAdditionalInfo;
    protected String profileChgLogLastAppliedChangeNumber;
    protected String profileChgLogSubscriberDisable;
    protected Vector provisioningProfileEventSubscription = null;
    protected String provisioningProfileAppName;
    protected String provisioningProfileAppGUID;
    protected String provisioningProfileOrgName;
    protected String provisioningProfileOrgGUID;
    protected String profileProcessingStatus;
    protected Vector profileProcessingErrors = null;
    protected String profileLastProcessingTime;
    protected String profileLastSuccessfulProcTime;
    protected String provisioningProfileAttrMapRules;
    static final String PROV_PROFILE_CONTAINER_OLD = "cn=Provisioning Profiles, cn=Changelog Subscriber, cn=Oracle Internet Directory";
    static final String PROV_PROFILE_CONTAINER = "cn=Profiles,cn=Provisioning,cn=Directory Integration Platform,cn=Products,cn=OracleContext";
    static final String PROFILE_VERSION = "PROFILE_VERSION";
    static final String PROV_PROFILE_VERSION = "1.0";
    static final String ERROR_PREFIX = "ERROR: ";
    static String NEW_LINE = System.getProperty("line.separator");
    static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    static boolean apimode = true;
    static boolean oldDIT = false;

    public ProvisioningProfile() {
    }

    ProvisioningProfile(DirContext ctx, String profile_dn) throws Exception {
        this.readProfileFromDirectory(ctx, profile_dn);
    }

    ProvisioningProfile(DirContext ctx, String appDN, String orgDN) throws Exception {
        String profile_DN = ProvisioningProfile.composeProfileDN(ctx, appDN, orgDN);
        this.readProfileFromDirectory(ctx, profile_DN);
    }

    protected static String getProfileVersion() {
        return PROV_PROFILE_VERSION;
    }

    static String getOIDVersion(DirContext ctx) throws Exception {
        try {
            RootOracleContext roc = new RootOracleContext(ctx);
            String directoryVersion = roc.getVersion(ctx);
            ProvisioningProfile.LOG("OID Version :" + directoryVersion);
            return directoryVersion;
        }
        catch (Exception ipe) {
            throw new Exception(ipe.getMessage());
        }
    }

    public static void ProfileHandler(String[] args) throws Exception {
        Object my_profile = null;
        ProvisioningCmdArgs cmd = null;
        DirContext ctx = null;
        try {
            if (args == null || args.length == 0) {
                ProvisioningCmdArgs.usage();
                return;
            }
            cmd = new ProvisioningCmdArgs(args);
            if (cmd.get(LDAP_USER_PASSWORD) != null && !apimode) {
                ProvisioningCmdArgs.usage();
                throw new InvalidParameterException(resBundle.getString("PROV_UNSUPPORTED_ARG") + " - " + LDAP_USER_PASSWORD);
            }
            if (cmd.get(INTERFACE_CONNECT_INFO) != null && !apimode) {
                ProvisioningCmdArgs.usage();
                throw new InvalidParameterException(resBundle.getString("PROV_UNSUPPORTED_ARG") + " - " + INTERFACE_CONNECT_INFO);
            }
            if (!apimode) {
                String password = ProvisioningProfile.promptMessage(resBundle.getString("PROMPT_PASSWORD"));
                cmd.put(LDAP_USER_PASSWORD, password);
                String conninfo = ProvisioningProfile.promptMessage(resBundle.getString("PROMPT_CONNINFO"));
                if (!conninfo.equals("")) {
                    cmd.put(INTERFACE_CONNECT_INFO, conninfo);
                }
            }
            cmd.validateCmdArgs();
        }
        catch (InvalidParameterException ipe) {
            throw new Exception(ipe.getMessage());
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        ctx = ProvisioningProfile.getJNDIConnection(cmd.get(LDAP_HOST), cmd.get(LDAP_PORT), cmd.get(LDAP_USER_DN), cmd.get(LDAP_USER_PASSWORD), cmd.get(SSL_MODE));
        String oidVersion = ProvisioningProfile.getOIDVersion(ctx);
        String cmd_intf_ver = cmd.get(INTERFACE_VERSION);
        oldDIT = Integer.parseInt(oidVersion) <= 90500 || cmd_intf_ver.compareTo("3.0") < 0;
        if (Integer.parseInt(oidVersion) < Integer.parseInt("90400") && !cmd_intf_ver.equals(PROV_PROFILE_VERSION) && !cmd_intf_ver.equals("1.1")) {
            ProvisioningProfile.LOG("Forcing interface vers to 1.1 for pre 904 ");
            cmd.put(INTERFACE_VERSION, "1.1");
            cmd.put(PROFILE_VERSION, PROV_PROFILE_VERSION);
        }
        cmd.computeDefaultValues(ctx);
        ProvisioningProfile.manageProfiles(ctx, cmd);
    }

    public static void ProfileHandler(DirContext ctx, String[] args) throws Exception {
        Object my_profile = null;
        ProvisioningCmdArgs cmd = null;
        try {
            cmd = new ProvisioningCmdArgs(args);
            cmd.validateCmdArgs();
        }
        catch (InvalidParameterException ipe) {
            throw new Exception(ipe.getMessage());
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
        if (ctx == null) {
            throw new Exception("Invalid LDAP Handle Passed..");
        }
        String oidVersion = ProvisioningProfile.getOIDVersion(ctx);
        String cmd_intf_ver = cmd.get(INTERFACE_VERSION);
        oldDIT = Integer.parseInt(oidVersion) <= 90500 || cmd_intf_ver.compareTo("3.0") < 0;
        if (Integer.parseInt(oidVersion) < Integer.parseInt("90400") && !cmd_intf_ver.equals(PROV_PROFILE_VERSION) && !cmd_intf_ver.equals("1.1")) {
            ProvisioningProfile.LOG("Forcing interface vers to 1.1 for pre 904 ");
            cmd.put(INTERFACE_VERSION, "1.1");
            cmd.put(PROFILE_VERSION, PROV_PROFILE_VERSION);
        }
        cmd.computeDefaultValues(ctx);
        ProvisioningProfile.manageProfiles(ctx, cmd);
    }

    void checkIntfVersion(ProvisioningCmdArgs cmd) throws Exception {
        String cmd_intf_ver;
        String prof_intf_ver = this.getProfileInterfaceVersion();
        if (!prof_intf_ver.equalsIgnoreCase(cmd_intf_ver = cmd.get(INTERFACE_VERSION))) {
            throw new Exception(resBundle.getString("PROV_INTERFACE_MISMATCH") + " - " + prof_intf_ver);
        }
    }

    private static void manageProfiles(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        block46: {
            String emsg = "";
            String entryDN = ProvisioningProfile.composeProfileDN(ctx, cmd.get(APPLICATION_DN), cmd.get(ORGANIZATION_DN));
            String version = cmd.get(PROFILE_VERSION);
            if (version.equals("2.0")) {
                ProvisioningProfileV2.process(ctx, cmd);
                break block46;
            }
            if (version.equals("3.0")) {
                ProvisioningProfileV3.process(ctx, cmd);
                break block46;
            }
            ProvisioningProfile my_profile = null;
            switch (cmd.getOperation()) {
                case 1: {
                    try {
                        my_profile = ProvisioningProfile.createNewProfile(ctx, cmd);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_SUCCESS"));
                            System.out.println(resBundle.getString("PROFILE_NAME") + my_profile.getProfileName());
                        }
                        break;
                    }
                    catch (Exception e) {
                        emsg = ProvisioningProfile.getResultStr(e, "PROV_PROFILE_FAILURE");
                        if (!apimode) {
                            System.out.println(emsg);
                            break;
                        }
                        throw new Exception(emsg);
                    }
                }
                case 2: {
                    try {
                        my_profile = new ProvisioningProfile(ctx, cmd.get(APPLICATION_DN), cmd.get(ORGANIZATION_DN));
                        my_profile.checkIntfVersion(cmd);
                        my_profile.disable(ctx);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_DISABLED"));
                        }
                        break;
                    }
                    catch (Exception e) {
                        emsg = ProvisioningProfile.getResultStr(e, "PROV_PROFILE_MOD_FAILURE");
                        if (!apimode) {
                            System.out.println(emsg);
                            break;
                        }
                        throw new Exception(emsg);
                    }
                }
                case 3: {
                    try {
                        my_profile = new ProvisioningProfile(ctx, cmd.get(APPLICATION_DN), cmd.get(ORGANIZATION_DN));
                        my_profile.checkIntfVersion(cmd);
                        my_profile.enable(ctx);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_ENABLED"));
                        }
                        break;
                    }
                    catch (Exception e) {
                        emsg = ProvisioningProfile.getResultStr(e, "PROV_PROFILE_MOD_FAILURE");
                        if (!apimode) {
                            System.out.println(emsg);
                            break;
                        }
                        throw new Exception(emsg);
                    }
                }
                case 4: {
                    try {
                        my_profile = new ProvisioningProfile(ctx, cmd.get(APPLICATION_DN), cmd.get(ORGANIZATION_DN));
                        my_profile.checkIntfVersion(cmd);
                        my_profile.status(ctx);
                        break;
                    }
                    catch (Exception e) {
                        emsg = ProvisioningProfile.getResultStr(e, "PROV_PROFILE_NO_STATUS");
                        if (!apimode) {
                            System.out.println(emsg);
                            break;
                        }
                        throw new Exception(emsg);
                    }
                }
                case 5: {
                    try {
                        my_profile = new ProvisioningProfile(ctx, cmd.get(APPLICATION_DN), cmd.get(ORGANIZATION_DN));
                        my_profile.checkIntfVersion(cmd);
                        my_profile.delete(ctx);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_DELETED"));
                        }
                        break;
                    }
                    catch (Exception e) {
                        emsg = ProvisioningProfile.getResultStr(e, "PROV_PROFILE_DELETE_FAILURE");
                        if (!apimode) {
                            System.out.println(emsg);
                            break;
                        }
                        throw new Exception(emsg);
                    }
                }
                case 6: {
                    try {
                        my_profile = new ProvisioningProfile(ctx, cmd.get(APPLICATION_DN), cmd.get(ORGANIZATION_DN));
                        my_profile.checkIntfVersion(cmd);
                        my_profile.reset(ctx);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_RESET_SUCCESS"));
                        }
                        break;
                    }
                    catch (Exception e) {
                        emsg = ProvisioningProfile.getResultStr(e, "PROV_PROFILE_RESET_FAILURE");
                        if (!apimode) {
                            System.out.println(emsg);
                            break;
                        }
                        throw new Exception(emsg);
                    }
                }
                case 7: {
                    try {
                        my_profile = new ProvisioningProfile(ctx, cmd.get(APPLICATION_DN), cmd.get(ORGANIZATION_DN));
                        my_profile.checkIntfVersion(cmd);
                        my_profile.modify(ctx, cmd);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_MOD_SUCCESS"));
                        }
                        break;
                    }
                    catch (Exception e) {
                        emsg = ProvisioningProfile.getResultStr(e, "PROV_PROFILE_MOD_FAILURE");
                        if (!apimode) {
                            System.out.println(emsg);
                            break;
                        }
                        throw new Exception(emsg);
                    }
                }
                case 8: {
                    try {
                        my_profile = new ProvisioningProfile(ctx, cmd.get(APPLICATION_DN), cmd.get(ORGANIZATION_DN));
                        my_profile.checkIntfVersion(cmd);
                        my_profile.exists(ctx);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_FOUND"));
                            System.out.println(resBundle.getString("PROFILE_NAME") + my_profile.getProfileName());
                        }
                        break;
                    }
                    catch (Exception e) {
                        emsg = ProvisioningProfile.getResultStr(e, "PROV_PROFILE_NOT_FOUND");
                        if (!apimode) {
                            System.out.println(emsg);
                            break;
                        }
                        throw new Exception(emsg);
                    }
                }
                default: {
                    if (!apimode) {
                        System.out.println(resBundle.getString("PROV_PROFILE_INVALID_OPERATION"));
                        break;
                    }
                    throw new Exception(resBundle.getString("PROV_PROFILE_INVALID_OPERATION"));
                }
            }
        }
    }

    static String getResultStr(Exception e, String ecode) {
        String msg = ERROR_PREFIX + e.getMessage() + "\n" + resBundle.getString(ecode);
        return msg;
    }

    public static void main(String[] args) {
        boolean status = false;
        try {
            apimode = false;
            ProvisioningProfile.ProfileHandler(args);
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    void modify(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        String lastChgNum;
        Vector event_vector;
        Vector additionalInfoVect;
        int attrCount = 0;
        ModificationItem[] tmpMods = new ModificationItem[32];
        BasicAttribute ldapattr = null;
        if (cmd.get(SCHEDULE) != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileSchedule", cmd.get(SCHEDULE)));
        }
        if (cmd.get(MAX_RETRIES) != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxRetries", cmd.get(MAX_RETRIES)));
        }
        if (cmd.get(INTERFACE_NAME) != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceName", cmd.get(INTERFACE_NAME)));
        }
        if (cmd.get(INTERFACE_TYPE) != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceType", cmd.get(INTERFACE_TYPE)));
        }
        if (cmd.get(INTERFACE_CONNECT_INFO) != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceConnectInformation", cmd.get(INTERFACE_CONNECT_INFO)));
        }
        if (cmd.get(PROFILE_GROUP) != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileExecGroupID", cmd.get(PROFILE_GROUP)));
        }
        if (cmd.get(PROFILE_DEBUG) != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileDebugLevel", cmd.get(PROFILE_DEBUG)));
        }
        if ((additionalInfoVect = cmd.getVector(INTERFACE_ADDITIONAL_INFO)) != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclODIPProfileInterfaceAdditionalInformation");
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceAdditionalInformation");
            for (int i = 0; i < additionalInfoVect.size(); ++i) {
                ldapattr.add(additionalInfoVect.elementAt(i));
            }
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if ((event_vector = cmd.getVector(EVENT_SUBSCRIPTION)) != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclODIPProvisioningEventSubscription");
            ldapattr = new BasicAttribute("orclODIPProvisioningEventSubscription");
            for (int i = 0; i < event_vector.size(); ++i) {
                ldapattr.add(event_vector.elementAt(i));
            }
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if ((lastChgNum = cmd.get(LASTCHANGENUMBER)) != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclLastAppliedChangeNumber");
            ldapattr = new BasicAttribute("orclLastAppliedChangeNumber");
            ldapattr.add(lastChgNum);
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if (attrCount == 0) {
            ProvisioningProfile.LOG("Nothing TO modify in Profile");
        }
        ModificationItem[] mods = new ModificationItem[attrCount];
        System.arraycopy(tmpMods, 0, mods, 0, attrCount);
        ProvisioningProfile.LOG("Modifying entry : (" + this.profileDN + ")");
        ctx.modifyAttributes(this.profileDN, mods);
    }

    void disable(DirContext ctx) throws Exception {
        if (this.getProfileStatus().equalsIgnoreCase("DISABLED")) {
            System.out.println(resBundle.getString("PROV_PROFILE_ALREADY_DISABLED"));
        }
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("orclStatus", "DISABLED"))};
        ctx.modifyAttributes(this.profileDN, mods);
    }

    void enable(DirContext ctx) throws Exception {
        if (this.getProfileStatus().equalsIgnoreCase("ENABLED")) {
            System.out.println(resBundle.getString("PROV_PROFILE_ALREADY_ENABLED"));
        }
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("orclStatus", "ENABLED"))};
        ctx.modifyAttributes(this.profileDN, mods);
    }

    void reset(DirContext ctx) throws Exception {
        ModificationItem[] mods = new ModificationItem[1];
        if (this.getProfileProcessingErrors() != null) {
            mods[0] = new ModificationItem(3, new BasicAttribute("orclODIPProfileProcessingErrors"));
            ctx.modifyAttributes(this.profileDN, mods);
        }
    }

    void delete(DirContext ctx) throws Exception {
        ctx.destroySubcontext(this.profileDN);
        ProvisioningProfile.LOG("Profile has been successfully deleted");
    }

    void status(DirContext ctx) throws Exception {
        String[] attr_list = new String[]{"*", "orclguid"};
        Property ldap_attr = null;
        PropertySetCollection entry = Util.getEntryDetails(ctx, this.profileDN, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
        ldap_attr = entry_details.getProperty("orclLastAppliedChangeNumber");
        if (ldap_attr != null) {
            this.setProfileChgLogLastAppliedChangeNumber((String)ldap_attr.getValue(0));
            System.out.println("orclLastAppliedChangeNumber: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclSubscriberDisable")) != null) {
            this.setProfileChgLogSubscriberDisable((String)ldap_attr.getValue(0));
            System.out.println("orclSubscriberDisable: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)ldap_attr.getValue(0));
            System.out.println("orclODIPProfileProcessingStatus: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingErrors")) != null && ldap_attr.size() > 0) {
            Vector<Object> errorVector = new Vector<Object>();
            for (int i = 0; i < ldap_attr.size(); ++i) {
                errorVector.addElement(ldap_attr.getValue(i));
                System.out.println("orclODIPProfileProcessingErrors: " + (String)ldap_attr.getValue(0));
            }
            this.setProfileProcessingErrors(errorVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)ldap_attr.getValue(0));
            System.out.println("orclODIPProfileLastProcessingTime: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)ldap_attr.getValue(0));
            System.out.println("orclODIPProfileLastSuccessfulProcessingTime: " + (String)ldap_attr.getValue(0));
        }
    }

    void exists(DirContext ctx) throws Exception {
        String[] attr_list = new String[]{"*", "orclguid"};
        Object ldap_attr = null;
        PropertySetCollection entry = Util.getEntryDetails(ctx, this.profileDN, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
    }

    static ProvisioningProfile createNewProfile(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        ProvisioningProfile ret_prof = null;
        boolean entry_exists = false;
        Object existing_entry = null;
        Vector event_vector = null;
        Vector additionalInfoVector = null;
        String profile_dn = ProvisioningProfile.composeProfileDN(ctx, cmd.get(APPLICATION_DN), cmd.get(ORGANIZATION_DN));
        entry_exists = ProvisioningProfile.directoryEntryExists(ctx, profile_dn);
        if (!entry_exists) {
            int i;
            BasicAttribute ldapattr = null;
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute objclass = new BasicAttribute("objectclass");
            objclass.add("top");
            objclass.add("orclODIPProvisioningIntegrationProfile");
            objclass.add("orclChangeSubscriber");
            attrs.put(objclass);
            ldapattr = new BasicAttribute("orclODIPProfileName");
            ldapattr.add(ProvisioningProfile.getRDNAttrValue(ctx, profile_dn));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclVersion");
            ldapattr.add(PROV_PROFILE_VERSION);
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclStatus");
            ldapattr.add(cmd.get(PROFILE_STATUS));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProvisioningAppName");
            if (cmd.get(APPLICATION_NAME) != null) {
                ldapattr.add(cmd.get(APPLICATION_NAME));
            } else {
                ldapattr.add(ProvisioningProfile.getRDNAttrValue(ctx, cmd.get(APPLICATION_DN)));
            }
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProvisioningOrgName");
            ldapattr.add(ProvisioningProfile.getRDNAttrValue(ctx, cmd.get(ORGANIZATION_DN)));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProvisioningAppGUID");
            ldapattr.add(ProvisioningProfile.getDirectoryEntryGUID(ctx, cmd.get(APPLICATION_DN)));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProvisioningOrgGUID");
            ldapattr.add(ProvisioningProfile.getDirectoryEntryGUID(ctx, cmd.get(ORGANIZATION_DN)));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProfileSchedule");
            ldapattr.add(cmd.get(SCHEDULE));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProfileMaxRetries");
            ldapattr.add(cmd.get(MAX_RETRIES));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProfileExecGroupID");
            ldapattr.add(cmd.get(PROFILE_GROUP));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProfileDebugLevel");
            ldapattr.add(cmd.get(PROFILE_DEBUG));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceName");
            ldapattr.add(cmd.get(INTERFACE_NAME));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceType");
            ldapattr.add(cmd.get(INTERFACE_TYPE));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceVersion");
            ldapattr.add(cmd.get(INTERFACE_VERSION));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceConnectInformation");
            ldapattr.add(cmd.get(INTERFACE_CONNECT_INFO));
            attrs.put(ldapattr);
            additionalInfoVector = cmd.getVector(INTERFACE_ADDITIONAL_INFO);
            if (additionalInfoVector != null) {
                ldapattr = new BasicAttribute("orclODIPProfileInterfaceAdditionalInformation");
                for (i = 0; i < additionalInfoVector.size(); ++i) {
                    ldapattr.add((String)additionalInfoVector.elementAt(i));
                }
                attrs.put(ldapattr);
            }
            if ((event_vector = cmd.getVector(EVENT_SUBSCRIPTION)) != null) {
                ldapattr = new BasicAttribute("orclODIPProvisioningEventSubscription");
                for (i = 0; i < event_vector.size(); ++i) {
                    ldapattr.add((String)event_vector.elementAt(i));
                }
                attrs.put(ldapattr);
            }
            ldapattr = new BasicAttribute("orclLastAppliedChangeNumber");
            ldapattr.add(ProvisioningProfile.getCurrentChangeNumber(ctx));
            attrs.put(ldapattr);
            ldapattr = new BasicAttribute("orclSubscriberDisable");
            ldapattr.add("0");
            attrs.put(ldapattr);
            DirContext result = ctx.createSubcontext(profile_dn, (Attributes)attrs);
            ret_prof = new ProvisioningProfile(ctx, profile_dn);
            if (!apimode) {
                System.out.println(resBundle.getString("APPLICATION") + ret_prof.getProvisioningProfileAppName());
                System.out.println(resBundle.getString("ORGANIZATION") + ret_prof.getProvisioningProfileOrgName());
                System.out.println(resBundle.getString(OP_STATUS) + ret_prof.getProfileStatus());
                System.out.println(resBundle.getString(SCHEDULE) + ret_prof.getProfileSchedule());
                System.out.println(resBundle.getString(MAX_RETRIES) + ret_prof.getProfileMaxRetries());
                System.out.println(resBundle.getString("EXECUTION_GRP") + ret_prof.getProfileGroup());
                System.out.println(resBundle.getString(INTERFACE_NAME) + ret_prof.getProfileInterfaceName());
                System.out.println(resBundle.getString(INTERFACE_TYPE) + ret_prof.getProfileInterfaceType());
                System.out.println(resBundle.getString("INTERFACE_VER") + ret_prof.getProfileInterfaceVersion());
                System.out.println(resBundle.getString("INTERFACE_CONN_INFO") + "---");
                System.out.println(resBundle.getString(INTERFACE_ADDITIONAL_INFO) + ret_prof.getProfileInterfaceAdditionalInfo());
                System.out.println(resBundle.getString("LAST_APPLIED_CHG_NUM") + ret_prof.getProfileChgLogLastAppliedChangeNumber());
                System.out.println(resBundle.getString("EVENT_SUBCP") + ret_prof.getProvisioningProfileEventSubscription());
            }
            return ret_prof;
        }
        throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
    }

    private void readProfileFromDirectory(DirContext ctx, String profile_dn) throws Exception {
        int i;
        String[] attr_list = new String[]{"*", "orclguid"};
        Property ldap_attr = null;
        PropertySetCollection entry = Util.getEntryDetails(ctx, profile_dn, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
        this.profileDN = profile_dn;
        ldap_attr = entry_details.getProperty("orclODIPProfileName");
        if (ldap_attr != null) {
            this.setProfileName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclStatus")) != null) {
            this.setProfileStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclVersion")) != null) {
            this.setProfileVersion((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileSchedule")) != null) {
            this.setProfileSchedule((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileMaxRetries")) != null) {
            this.setProfileMaxRetries((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileExecGroupID")) != null) {
            this.setProfileGroup((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceName")) != null) {
            this.setProfileInterfaceName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceType")) != null) {
            this.setProfileInterfaceType((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceVersion")) != null) {
            this.setProfileInterfaceVersion((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceConnectInformation")) != null) {
            this.setProfileInterfaceConnectInfo((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclLastAppliedChangeNumber")) != null) {
            this.setProfileChgLogLastAppliedChangeNumber((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclSubscriberDisable")) != null) {
            this.setProfileChgLogSubscriberDisable((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceAdditionalInformation")) != null && ldap_attr.size() > 0) {
            Vector<Object> interfaceAdditionalInfoVect = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                interfaceAdditionalInfoVect.addElement(ldap_attr.getValue(i));
            }
            this.setProfileInterfaceAdditionalInfo(interfaceAdditionalInfoVect);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningEventSubscription")) != null && ldap_attr.size() > 0) {
            Vector<Object> eventVector = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                eventVector.addElement(ldap_attr.getValue(i));
            }
            this.setProvisioningProfileEventSubscription(eventVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningAppName")) != null) {
            this.setProvisioningProfileAppName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningAppGUID")) != null) {
            this.setProvisioningProfileAppGUID((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningOrgName")) != null) {
            this.setProvisioningProfileOrgName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningOrgGUID")) != null) {
            this.setProvisioningProfileOrgGUID((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingErrors")) != null && ldap_attr.size() > 0) {
            Vector<Object> errorVector = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                errorVector.addElement(ldap_attr.getValue(i));
            }
            this.setProfileProcessingErrors(errorVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)ldap_attr.getValue(0));
        }
    }

    String getProfileName() {
        return this.profileName;
    }

    void setProfileName(String newProfileName) {
        this.profileName = newProfileName;
    }

    String getProfileStatus() {
        return this.profileStatus;
    }

    void setProfileStatus(String newProfileStatus) {
        this.profileStatus = newProfileStatus;
    }

    void setProfileVersion(String newProfileVersion) {
        this.profileVersion = newProfileVersion;
    }

    String getProfileSchedule() {
        return this.profileSchedule;
    }

    void setProfileSchedule(String newProfileSchedule) {
        this.profileSchedule = newProfileSchedule;
    }

    String getProfileMaxRetries() {
        return this.profileMaxRetries;
    }

    void setProfileMaxRetries(String newProfileMaxRetries) {
        this.profileMaxRetries = newProfileMaxRetries;
    }

    String getProfileGroup() {
        return this.profileGroup;
    }

    void setProfileGroup(String val) {
        this.profileGroup = val;
    }

    String getProfileInterfaceName() {
        return this.profileInterfaceName;
    }

    void setProfileInterfaceName(String newProfileInterfaceName) {
        this.profileInterfaceName = newProfileInterfaceName;
    }

    String getProfileInterfaceType() {
        return this.profileInterfaceType;
    }

    void setProfileInterfaceType(String newProfileInterfaceType) {
        this.profileInterfaceType = newProfileInterfaceType;
    }

    String getProfileInterfaceVersion() {
        return this.profileInterfaceVersion;
    }

    void setProfileInterfaceVersion(String newProfileInterfaceVersion) {
        this.profileInterfaceVersion = newProfileInterfaceVersion;
    }

    String getProfileInterfaceConnectInfo() {
        return this.profileInterfaceConnectInfo;
    }

    void setProfileInterfaceConnectInfo(String newProfileInterfaceConnectInfo) {
        this.profileInterfaceConnectInfo = newProfileInterfaceConnectInfo;
    }

    String getProfileChgLogLastAppliedChangeNumber() {
        return this.profileChgLogLastAppliedChangeNumber;
    }

    void setProfileChgLogLastAppliedChangeNumber(String newProfileChgLogLastAppliedChangeNumber) {
        this.profileChgLogLastAppliedChangeNumber = newProfileChgLogLastAppliedChangeNumber;
    }

    String getProfileChgLogSubscriberDisable() {
        return this.profileChgLogSubscriberDisable;
    }

    void setProfileChgLogSubscriberDisable(String newProfileChgLogSubscriberDisable) {
        this.profileChgLogSubscriberDisable = newProfileChgLogSubscriberDisable;
    }

    Vector getProfileInterfaceAdditionalInfo() {
        return this.profileInterfaceAdditionalInfo;
    }

    void setProfileInterfaceAdditionalInfo(Vector additionalInfo) {
        this.profileInterfaceAdditionalInfo = additionalInfo;
    }

    Vector getProvisioningProfileEventSubscription() {
        return this.provisioningProfileEventSubscription;
    }

    void setProvisioningProfileEventSubscription(Vector newProvisioningProfileEventSubscription) {
        this.provisioningProfileEventSubscription = newProvisioningProfileEventSubscription;
    }

    String getProvisioningProfileAppName() {
        return this.provisioningProfileAppName;
    }

    void setProvisioningProfileAppName(String newProvisioningProfileAppName) {
        this.provisioningProfileAppName = newProvisioningProfileAppName;
    }

    String getProvisioningProfileAppGUID() {
        return this.provisioningProfileAppGUID;
    }

    void setProvisioningProfileAppGUID(String newProvisioningProfileAppGUID) {
        this.provisioningProfileAppGUID = newProvisioningProfileAppGUID;
    }

    String getProvisioningProfileOrgName() {
        return this.provisioningProfileOrgName;
    }

    void setProvisioningProfileOrgName(String newProvisioningProfileOrgName) {
        this.provisioningProfileOrgName = newProvisioningProfileOrgName;
    }

    String getProvisioningProfileOrgGUID() {
        return this.provisioningProfileOrgGUID;
    }

    void setProvisioningProfileOrgGUID(String newProvisioningProfileOrgGUID) {
        this.provisioningProfileOrgGUID = newProvisioningProfileOrgGUID;
    }

    String getProfileProcessingStatus() {
        return this.profileProcessingStatus;
    }

    void setProfileProcessingStatus(String newProfileProcessingStatus) {
        this.profileProcessingStatus = newProfileProcessingStatus;
    }

    Vector getProfileProcessingErrors() {
        return this.profileProcessingErrors;
    }

    void setProfileProcessingErrors(Vector newProfileProcessingErrors) {
        this.profileProcessingErrors = newProfileProcessingErrors;
    }

    String getProfileLastProcessingTime() {
        return this.profileLastProcessingTime;
    }

    void setProfileLastProcessingTime(String newProfileLastProcessingTime) {
        this.profileLastProcessingTime = newProfileLastProcessingTime;
    }

    String getProfileLastSuccessfulProcTime() {
        return this.profileLastSuccessfulProcTime;
    }

    void setProfileLastSuccessfulProcTime(String newProfileLastSuccessfulProcTime) {
        this.profileLastSuccessfulProcTime = newProfileLastSuccessfulProcTime;
    }

    public static DirContext getJNDIConnection(String ldap_host, String ldap_port, String ldap_bindDN, String ldap_bindPswd, String ssl) throws Exception {
        InitialDirContext dirContext;
        block6: {
            dirContext = null;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + ldap_host + ":" + ldap_port + "/");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", ldap_bindDN);
            env.put("java.naming.security.credentials", ldap_bindPswd);
            int sslmode = 0;
            try {
                sslmode = Integer.parseInt(ssl);
            }
            catch (Exception ex) {
                sslmode = 0;
            }
            Properties prop = System.getProperties();
            if (sslmode >= 1) {
                prop.put("SSLSocketFactoryImplClass", "oracle.ldap.util.jndi.LDAPJSSESocketFactoryImpl");
                env.put("java.naming.ldap.factory.socket", "oracle.ldap.util.jndi.LDAPJSSESocketFactoryImpl");
                env.put("java.naming.security.protocol", "ssl");
            }
            try {
                dirContext = new InitialDirContext(env);
            }
            catch (NamingException ne) {
                if (ne instanceof CommunicationException) {
                    throw new Exception(ERROR_PREFIX + resBundle.getString("PROV_PROFILE_CONN_ERR"));
                }
                if (!(ne instanceof AuthenticationException)) break block6;
                throw new Exception(ERROR_PREFIX + resBundle.getString("PROV_PROFILE_AUTH_ERR"));
            }
        }
        return dirContext;
    }

    static String getDirectoryEntryGUID(DirContext ctx, String entryDN) {
        PropertySetCollection propSetCol = null;
        try {
            String[] attrList = new String[]{"orclguid"};
            propSetCol = Util.getEntryDetails(ctx, entryDN, "(objectclass=*)", 0, attrList);
        }
        catch (NamingException e) {
            System.out.println(resBundle.getString("UNABLE_GET_GUID") + entryDN);
            System.out.println(e);
            return null;
        }
        PropertySet propSet = propSetCol.getPropertySet(entryDN);
        Property myProp = propSet.getProperty("orclguid");
        Object guidValue = myProp.getValue(0);
        if (guidValue instanceof byte[]) {
            return new String((byte[])guidValue);
        }
        return (String)guidValue;
    }

    static String composeProfileDN(DirContext ctx, String appDN, String orgDN) throws Exception {
        String appGUID = ProvisioningProfile.getDirectoryEntryGUID(ctx, appDN);
        String orgGUID = ProvisioningProfile.getDirectoryEntryGUID(ctx, orgDN);
        if (appGUID == null) {
            throw new Exception("Unable to locate application.. ");
        }
        if (orgGUID == null) {
            throw new Exception("Unable to locate organization.. ");
        }
        if (!oldDIT) {
            return new String("orclODIPProfileName=" + orgGUID + "_" + appGUID + ", " + PROV_PROFILE_CONTAINER);
        }
        return new String("orclODIPProfileName=" + orgGUID + "_" + appGUID + ", " + PROV_PROFILE_CONTAINER_OLD);
    }

    static String getRDNAttrValue(DirContext ctx, String DN) {
        try {
            String myDN = Util.normalizeDN(DN);
            NameParser parser = ctx.getNameParser("");
            Name inputDN = parser.parse(myDN);
            String RDN = inputDN.get(inputDN.size() - 1);
            int index = RDN.indexOf(61);
            String RDN_value = RDN.substring(index + 1).trim();
            return RDN_value;
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    static String getCurrentChangeNumber(DirContext ctx) {
        try {
            String[] attrs = new String[]{"lastchangenumber"};
            PropertySetCollection myPropSetCollection = Util.getEntryDetails(ctx, "", "(objectclass=*)", 0, attrs);
            PropertySet myPropSet = myPropSetCollection.getPropertySet(0);
            Property myProp = myPropSet.getProperty("lastchangenumber");
            Object current_chg_number_value = myProp.getValue(0);
            return (String)current_chg_number_value;
        }
        catch (Exception e) {
            return null;
        }
    }

    static boolean directoryEntryExists(DirContext ctx, String entry_dn) {
        block3: {
            String[] attr_list = new String[]{"orclguid"};
            PropertySetCollection existing_entry = null;
            try {
                existing_entry = Util.getEntryDetails(ctx, entry_dn, "objectclass=*", 0, null);
            }
            catch (Exception e) {
                if (e instanceof NameNotFoundException) {
                    return false;
                }
                if (!(e instanceof NameNotFoundException)) break block3;
                System.out.println(e);
                return false;
            }
        }
        return true;
    }

    static void LOG(String ptrStr) {
        if (!apimode && ProvisioningCmdArgs.debug > 0) {
            System.out.println(ptrStr);
        }
    }

    static String promptMessage(String message) throws IOException {
        System.out.print(message);
        return NUtil.readLineNoEcho("");
    }
}

