/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningOutboundProfileV2;
import oracle.ldap.util.provisioning.ProvisioningProfile;

class ProvisioningOutboundProfile
extends ProvisioningOutboundProfileV2 {
    protected Vector m_subscriptionModes;
    protected String m_version = "3.0";

    public ProvisioningOutboundProfile(DirContext ctx, String profile_dn) throws Exception {
        try {
            this.readProfileFromDirectory(ctx, "cn=OIDToApplication," + profile_dn);
        }
        catch (Exception e) {
            this.valid = false;
        }
    }

    public ProvisioningOutboundProfile(DirContext ctx, String appDN, String orgDN) throws Exception {
        try {
            String profile_DN = ProvisioningProfile.composeProfileDN(ctx, appDN, orgDN);
            this.readProfileFromDirectory(ctx, "cn=OIDToApplication," + profile_DN);
        }
        catch (Exception e) {
            this.valid = false;
        }
    }

    public void modify(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        String lastChgNum;
        int attrCount = 0;
        ModificationItem[] tmpMods = new ModificationItem[32];
        BasicAttribute ldapattr = null;
        Vector event_vector = cmd.getVector("EVENT_SUBSCRIPTION");
        if (event_vector != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclODIPProvisioningEventSubscription");
            ldapattr = new BasicAttribute("orclODIPProvisioningEventSubscription");
            for (int i = 0; i < event_vector.size(); ++i) {
                ldapattr.add(event_vector.elementAt(i));
            }
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if ((lastChgNum = cmd.get("LASTCHANGENUMBER")) != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclLastAppliedChangeNumber");
            ldapattr = new BasicAttribute("orclLastAppliedChangeNumber");
            ldapattr.add(lastChgNum);
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        String isBootStrapEnabled = cmd.get("ENABLE_BOOTSTRAP");
        ProvisioningProfile.LOG("Requesting BootStrap: " + isBootStrapEnabled);
        String isUpgradeEnabled = cmd.get("ENABLE_UPGRADE");
        ProvisioningProfile.LOG("Requesting Upgrade: " + isUpgradeEnabled);
        Vector subscriptionModes = cmd.getVector("SUBSCRIPTION_MODE");
        if (subscriptionModes != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclODIPProfileProvSubscriptionMode");
            ldapattr = new BasicAttribute("orclODIPProfileProvSubscriptionMode");
            for (int i = 0; i < subscriptionModes.size(); ++i) {
                String provMode = ((String)subscriptionModes.elementAt(i)).trim();
                if (provMode.equalsIgnoreCase("bootstrap") || provMode.equalsIgnoreCase("upgrade")) continue;
                ldapattr.add(subscriptionModes.elementAt(i));
            }
            if (isBootStrapEnabled.equalsIgnoreCase("true")) {
                ldapattr.add("bootstrap");
            }
            if (isUpgradeEnabled.equalsIgnoreCase("true")) {
                ldapattr.add("upgrade");
            }
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if (attrCount == 0) {
            ProvisioningProfile.LOG("Nothing TO modify in OUTBOUND Profile");
            return;
        }
        ModificationItem[] mods = new ModificationItem[attrCount];
        System.arraycopy(tmpMods, 0, mods, 0, attrCount);
        ProvisioningProfile.LOG("Modifying entry : (" + this.m_outboundProfileDN + ")");
        ctx.modifyAttributes(this.m_outboundProfileDN, mods);
    }

    public static ProvisioningOutboundProfile createNewOutboundProfile(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        ProvisioningOutboundProfile ret_prof = null;
        boolean entry_exists = false;
        Vector event_vector = null;
        String profile_dn = ProvisioningProfile.composeProfileDN(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
        entry_exists = ProvisioningProfile.directoryEntryExists(ctx, "cn=OIDToApplication," + profile_dn);
        if (entry_exists) {
            throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
        }
        BasicAttribute ldapattr = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("orclODIPProvisioningIntegrationOutBoundProfile");
        objclass.add("orclChangeSubscriber");
        attrs.put(objclass);
        ldapattr = new BasicAttribute("cn");
        ldapattr.add("OIDToApplication");
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclStatus");
        ldapattr.add(cmd.get("PROFILE_STATUS"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningAppGUID");
        ldapattr.add(ProvisioningProfile.getDirectoryEntryGUID(ctx, cmd.get("APPLICATION_DN")));
        attrs.put(ldapattr);
        event_vector = cmd.getVector("EVENT_SUBSCRIPTION");
        if (event_vector != null) {
            ldapattr = new BasicAttribute("orclODIPProvisioningEventSubscription");
            for (int i = 0; i < event_vector.size(); ++i) {
                ldapattr.add((String)event_vector.elementAt(i));
            }
            attrs.put(ldapattr);
        }
        String isBootStrapEnabled = cmd.get("ENABLE_BOOTSTRAP");
        ProvisioningProfile.LOG("Requesting BootStrap: " + isBootStrapEnabled);
        String isUpgradeEnabled = cmd.get("ENABLE_UPGRADE");
        ProvisioningProfile.LOG("Requesting Upgrade: " + isUpgradeEnabled);
        Vector subscriptionModesVector = cmd.getVector("SUBSCRIPTION_MODE");
        if (subscriptionModesVector != null) {
            ldapattr = new BasicAttribute("orclODIPProfileProvSubscriptionMode");
            for (int i = 0; i < subscriptionModesVector.size(); ++i) {
                String provMode = ((String)subscriptionModesVector.elementAt(i)).trim();
                if (provMode.equalsIgnoreCase("bootstrap") || provMode.equalsIgnoreCase("upgrade")) continue;
                ldapattr.add((String)subscriptionModesVector.elementAt(i));
            }
            if (isBootStrapEnabled.equalsIgnoreCase("true")) {
                ldapattr.add("bootstrap");
            }
            if (isUpgradeEnabled.equalsIgnoreCase("true")) {
                ldapattr.add("upgrade");
            }
            attrs.put(ldapattr);
        }
        ldapattr = new BasicAttribute("orclLastAppliedChangeNumber");
        String lastChgNum = cmd.get("LASTCHANGENUMBER");
        if (lastChgNum != null) {
            ldapattr.add(lastChgNum);
        } else {
            ldapattr.add(ProvisioningProfile.getCurrentChangeNumber(ctx));
        }
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclSubscriberDisable");
        ldapattr.add("0");
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclVersion");
        ldapattr.add(cmd.get("INTERFACE_VERSION"));
        attrs.put(ldapattr);
        ProvisioningProfile.LOG(((Object)attrs).toString());
        DirContext result = ctx.createSubcontext("cn=OIDToApplication," + profile_dn, (Attributes)attrs);
        ProvisioningProfile.LOG("Created OutBound SubProfile Entry Successfully");
        ret_prof = new ProvisioningOutboundProfile(ctx, profile_dn);
        ProvisioningProfile.LOG("Created OutBound SubProfile Object Successfully");
        return ret_prof;
    }

    private void readProfileFromDirectory(DirContext ctx, String profile_dn) throws Exception {
        int i;
        Vector<Object> eventVector;
        String[] attr_list = new String[]{"*", "orclguid"};
        Property ldap_attr = null;
        ProvisioningProfile.LOG("Searching For OUTBOUND Profile : " + profile_dn);
        PropertySetCollection entry = Util.getEntryDetails(ctx, profile_dn, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
        this.m_outboundProfileDN = profile_dn;
        ldap_attr = entry_details.getProperty("orclVersion");
        if (ldap_attr != null) {
            this.setProfileVersion((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclStatus")) != null) {
            this.setProfileStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclLastAppliedChangeNumber")) != null) {
            this.setProfileChgLogLastAppliedChangeNumber((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclSubscriberDisable")) != null) {
            this.setProfileChgLogSubscriberDisable((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningEventSubscription")) != null && ldap_attr.size() > 0) {
            eventVector = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                eventVector.addElement(ldap_attr.getValue(i));
            }
            this.setProvisioningProfileEventSubscription(eventVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProvSubscriptionMode")) != null && ldap_attr.size() > 0) {
            eventVector = new Vector();
            for (i = 0; i < ldap_attr.size(); ++i) {
                eventVector.addElement(ldap_attr.getValue(i));
            }
            this.setProfileSubscriptionModes(eventVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingErrors")) != null && ldap_attr.size() > 0) {
            Vector<Object> errorVector = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                errorVector.addElement(ldap_attr.getValue(i));
            }
            this.setProfileProcessingErrors(errorVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)ldap_attr.getValue(0));
        }
    }

    public String getProfileStatus() {
        return this.profileStatus;
    }

    public void setProfileStatus(String newProfileStatus) {
        this.profileStatus = newProfileStatus;
    }

    public Vector getProfileSubscriptionModes() {
        return this.m_subscriptionModes;
    }

    public void setProfileSubscriptionModes(Vector newProvisioningProfileSubscriptionModes) {
        this.m_subscriptionModes = newProvisioningProfileSubscriptionModes;
    }

    public void setProfileVersion(String version) {
        this.m_version = version;
    }
}

