/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningProfile;
import oracle.ldap.util.provisioning.ProvisioningProfileV2;

class ProvisioningInboundProfileV2
extends ProvisioningProfileV2 {
    protected Vector profileEventMapRules;
    protected Vector profileEventPermittedOprns;
    protected String profileAppLastId;
    protected String profileProcessingStatus;
    protected Vector profileProcessingErrors = null;
    protected String profileLastProcessingTime;
    protected String profileLastSuccessfulProcTime;
    protected boolean valid = true;

    public ProvisioningInboundProfileV2() {
    }

    public ProvisioningInboundProfileV2(DirContext ctx, String profile_dn) throws Exception {
        try {
            this.readProfileFromDirectory(ctx, "cn=ApplicationToOID," + profile_dn);
            this.valid = true;
        }
        catch (Exception e) {
            this.valid = false;
        }
    }

    public ProvisioningInboundProfileV2(DirContext ctx, String appDN, String orgDN) throws Exception {
        try {
            String profile_DN = ProvisioningInboundProfileV2.composeProfileDN(ctx, appDN, orgDN);
            this.readProfileFromDirectory(ctx, "cn=ApplicationToOID," + profile_DN);
        }
        catch (Exception e) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void modify(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        Vector permttd_oprns_vector;
        int attrCount = 0;
        ModificationItem[] tmpMods = new ModificationItem[32];
        BasicAttribute ldapattr = null;
        Vector mapRules_vector = cmd.getVector("EVENT_MAPPING_RULES");
        if (mapRules_vector != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclODIPProvisioningEventMappingRules");
            ldapattr = new BasicAttribute("orclODIPProvisioningEventMappingRules");
            for (int i = 0; i < mapRules_vector.size(); ++i) {
                ldapattr.add(mapRules_vector.elementAt(i));
            }
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if ((permttd_oprns_vector = cmd.getVector("EVENT_PERMITTED_OPERATIONS")) != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclODIPProvisioningEventPermittedOperations");
            ldapattr = new BasicAttribute("orclODIPProvisioningEventPermittedOperations");
            for (int i = 0; i < permttd_oprns_vector.size(); ++i) {
                ldapattr.add(permttd_oprns_vector.elementAt(i));
            }
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if (attrCount == 0) {
            ProvisioningProfile.LOG("Nothing TO modify in INBOUND Profile");
            return;
        }
        ModificationItem[] mods = new ModificationItem[attrCount];
        System.arraycopy(tmpMods, 0, mods, 0, attrCount);
        ProvisioningProfile.LOG("Modifying entry : (" + this.profileDN + ")");
        ctx.modifyAttributes(this.profileDN, mods);
    }

    public void status(DirContext ctx) throws Exception {
        String[] attr_list = new String[]{"*", "orclguid"};
        Property ldap_attr = null;
        PropertySetCollection entry = Util.getEntryDetails(ctx, this.profileDN, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
        System.out.println(resBundle.getString("INBOUND_PROFILE_STATUS_DETAILS"));
        System.out.println("---------------------------------");
        ldap_attr = entry_details.getProperty("orclODIPProfileLastAppliedAppEventID");
        if (ldap_attr != null) {
            System.out.println("orclODIPProfileLastAppliedAppEventID: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)ldap_attr.getValue(0));
            System.out.println("orclODIPProfileProcessingStatus: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingErrors")) != null && ldap_attr.size() > 0) {
            Vector<Object> errorVector = new Vector<Object>();
            for (int i = 0; i < ldap_attr.size(); ++i) {
                errorVector.addElement(ldap_attr.getValue(i));
                System.out.println("orclODIPProfileProcessingErrors: " + (String)ldap_attr.getValue(0));
            }
            this.setProfileProcessingErrors(errorVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)ldap_attr.getValue(0));
            System.out.println("orclODIPProfileLastProcessingTime: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)ldap_attr.getValue(0));
            System.out.println("orclODIPProfileLastSuccessfulProcessingTime: " + (String)ldap_attr.getValue(0));
        }
    }

    public static ProvisioningInboundProfileV2 createNewInboundProfileV2(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        int i;
        ProvisioningInboundProfileV2 ret_prof = null;
        boolean entry_exists = false;
        Vector mapRules_vector = null;
        Vector permttd_oprns_vector = null;
        String profile_dn = ProvisioningProfile.composeProfileDN(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
        entry_exists = ProvisioningInboundProfileV2.directoryEntryExists(ctx, "cn=ApplicationToOID," + profile_dn);
        if (entry_exists) {
            throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
        }
        BasicAttribute ldapattr = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("orclODIPProvisioningIntegrationInBoundProfileV2");
        attrs.put(objclass);
        ldapattr = new BasicAttribute("cn");
        ldapattr.add("ApplicationToOID");
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclStatus");
        ldapattr.add(cmd.get("PROFILE_STATUS"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileLastAppliedAppEventID");
        ldapattr.add("0");
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningAppGUID");
        ldapattr.add(ProvisioningInboundProfileV2.getDirectoryEntryGUID(ctx, cmd.get("APPLICATION_DN")));
        attrs.put(ldapattr);
        mapRules_vector = cmd.getVector("EVENT_MAPPING_RULES");
        if (mapRules_vector != null) {
            ldapattr = new BasicAttribute("orclODIPProvisioningEventMappingRules");
            for (i = 0; i < mapRules_vector.size(); ++i) {
                ldapattr.add((String)mapRules_vector.elementAt(i));
            }
            attrs.put(ldapattr);
        }
        if ((permttd_oprns_vector = cmd.getVector("EVENT_PERMITTED_OPERATIONS")) != null) {
            ldapattr = new BasicAttribute("orclODIPProvisioningEventPermittedOperations");
            for (i = 0; i < permttd_oprns_vector.size(); ++i) {
                ldapattr.add((String)permttd_oprns_vector.elementAt(i));
            }
            attrs.put(ldapattr);
        }
        ProvisioningProfile.LOG(((Object)attrs).toString());
        DirContext result = ctx.createSubcontext("cn=ApplicationToOID," + profile_dn, (Attributes)attrs);
        ProvisioningProfile.LOG("Created InBound SubProfile Entry Successfully");
        ret_prof = new ProvisioningInboundProfileV2(ctx, profile_dn);
        ProvisioningProfile.LOG("Created InBound SubProfile Object Successfully");
        return ret_prof;
    }

    private void readProfileFromDirectory(DirContext ctx, String profile_dn) throws Exception {
        int i;
        String[] attr_list = new String[]{"*", "orclguid"};
        Property ldap_attr = null;
        ProvisioningProfile.LOG("Searching For INBOUND Profile : " + profile_dn);
        PropertySetCollection entry = Util.getEntryDetails(ctx, profile_dn, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
        this.profileDN = profile_dn;
        ldap_attr = entry_details.getProperty("orclStatus");
        if (ldap_attr != null) {
            this.setProfileStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastAppliedAppEventID")) != null) {
            this.setProfileLastAppId((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningAppGUID")) != null) {
            this.setProvisioningProfileAppGUID((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningEventMappingRules")) != null && ldap_attr.size() > 0) {
            Vector<Object> mapRules_vector = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                mapRules_vector.addElement(ldap_attr.getValue(i));
            }
            this.setProfileMapRules(mapRules_vector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningEventPermittedOperations")) != null && ldap_attr.size() > 0) {
            Vector<Object> permttd_oprns = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                permttd_oprns.addElement(ldap_attr.getValue(i));
            }
            this.setProfilePermttdOprns(permttd_oprns);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingErrors")) != null && ldap_attr.size() > 0) {
            Vector<Object> errorVector = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                errorVector.addElement(ldap_attr.getValue(i));
            }
            this.setProfileProcessingErrors(errorVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)ldap_attr.getValue(0));
        }
    }

    public String getProfileStatus() {
        return this.profileStatus;
    }

    public void setProfileStatus(String newProfileStatus) {
        this.profileStatus = newProfileStatus;
    }

    public void setProfileLastAppId(String id) {
        this.profileAppLastId = id;
    }

    public Vector getProfileMapRules() {
        return this.profileEventMapRules;
    }

    public void setProfileMapRules(Vector rules) {
        this.profileEventMapRules = rules;
    }

    public Vector getProfilePermttdOprns() {
        return this.profileEventPermittedOprns;
    }

    public void setProfilePermttdOprns(Vector oprns) {
        this.profileEventPermittedOprns = oprns;
    }

    public String getProfileProcessingStatus() {
        return this.profileProcessingStatus;
    }

    public void setProfileProcessingStatus(String newProfileProcessingStatus) {
        this.profileProcessingStatus = newProfileProcessingStatus;
    }

    public Vector getProfileProcessingErrors() {
        return this.profileProcessingErrors;
    }

    public void setProfileProcessingErrors(Vector newProfileProcessingErrors) {
        this.profileProcessingErrors = newProfileProcessingErrors;
    }

    public String getProfileLastProcessingTime() {
        return this.profileLastProcessingTime;
    }

    public void setProfileLastProcessingTime(String newProfileLastProcessingTime) {
        this.profileLastProcessingTime = newProfileLastProcessingTime;
    }

    public String getProfileLastSuccessfulProcTime() {
        return this.profileLastSuccessfulProcTime;
    }

    public void setProfileLastSuccessfulProcTime(String newProfileLastSuccessfulProcTime) {
        this.profileLastSuccessfulProcTime = newProfileLastSuccessfulProcTime;
    }
}

