/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.directory.DirContext;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ParamDefn;
import oracle.ldap.util.provisioning.ProvisioningProfile;

class ProvisioningCmdArgs {
    public static Vector mParamDefns = new Vector();
    private Hashtable vars;
    private int operation_type = 0;
    static final char PARAM_NAME_VALUE_DELIM = '=';
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private static String NEW_LINE = " \r\n";
    static String ERROR_PREFIX = "ERROR: ";
    static int debug = 0;
    private static final String OID_LDAP = "OID_LDAP";
    private static final String PLSQL = "PLSQL";
    private static final String JAVA = "JAVA";

    public ProvisioningCmdArgs(String[] args) throws InvalidParameterException {
        ProvisioningCmdArgs.initializeParamDefns();
        this.vars = new Hashtable(300);
        this.setDefaultValues();
        this.parseInputParameters(args, '=');
    }

    public int getOperation() {
        return this.operation_type;
    }

    public String toString() {
        return this.vars.toString();
    }

    public void put(String name, Object value) {
        this.vars.put(name, value);
    }

    public void putVector(String name, Vector values) {
        this.vars.put(name, values);
    }

    public String get(String name) {
        Object obj = this.vars.get(name);
        return obj == null ? null : obj.toString();
    }

    public Vector getVector(String name) {
        Object obj = this.vars.get(name);
        return obj == null ? null : (Vector)obj;
    }

    private void setDefaultValues() {
        this.put("INTERFACE_VERSION", "2.0");
        this.put("PROFILE_MODE", "OUTBOUND");
    }

    void computeDefaultValues(DirContext ctx) throws Exception {
        try {
            String orgDNParam = this.get("ORGANIZATION_DN");
            String orgNameParam = this.get("ORGANIZATION_NAME");
            if (orgDNParam == null && orgNameParam == null) {
                ProvisioningProfile.LOG("Locating the Default Subscriber");
                RootOracleContext rootctx = new RootOracleContext(ctx);
                Subscriber subs = rootctx.getSubscriber(ctx, Util.IDTYPE_DEFAULT, null, null);
                String dn = subs.getDn(ctx);
                this.put("ORGANIZATION_DN", dn);
                ProvisioningProfile.LOG("Organization DN now is : " + this.get("ORGANIZATION_DN"));
            } else if (orgNameParam != null && orgDNParam == null) {
                ProvisioningProfile.LOG("Organization Simple Name specified is : " + orgNameParam);
                RootOracleContext rootctx = new RootOracleContext(ctx);
                Subscriber subs = rootctx.getSubscriber(ctx, Util.IDTYPE_SIMPLE, orgNameParam, null);
                String dn = subs.getDn(ctx);
                this.put("ORGANIZATION_DN", dn);
                ProvisioningProfile.LOG("Organization DN now is : " + this.get("ORGANIZATION_DN"));
            } else if (orgNameParam == null && orgDNParam != null) {
                this.put("ORGANIZATION_DN", orgDNParam);
            } else if (orgNameParam != null && orgDNParam != null) {
                this.put("ORGANIZATION_DN", orgDNParam);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new InvalidParameterException("Unable to resolve Organization : " + ex.toString());
        }
    }

    private void parseInputParameters(String[] args, char delim) throws InvalidParameterException {
        int len = args.length;
        Vector<String> eventVect = new Vector<String>();
        Vector<String> mappingRuleVect = new Vector<String>();
        Vector<String> permittedOprnsVect = new Vector<String>();
        Vector<String> additionalInfoVect = new Vector<String>();
        Vector<String> subscriptionModeVect = new Vector<String>();
        String paramName = null;
        String paramValue = null;
        int index = 0;
        for (int iCn = 0; iCn < len; ++iCn) {
            index = args[iCn].indexOf(61);
            if (index == -1) {
                throw new InvalidParameterException(resBundle.getString("PARAMETER_VALUE_NOT_SPECIFIED") + " : " + args[iCn]);
            }
            paramName = args[iCn].substring(0, index).trim();
            if (paramName.equals("")) {
                throw new InvalidParameterException(resBundle.getString("PARAMETER_NAME_NOT_SPECIFIED"));
            }
            paramValue = args[iCn].substring(index + 1).trim();
            if (paramValue.equals("")) {
                throw new InvalidParameterException(resBundle.getString("PARAMETER_VALUE_NOT_SPECIFIED") + " : " + args[iCn]);
            }
            if (paramName.equalsIgnoreCase("OPERATION")) {
                this.put("OPERATION", paramValue);
                if (paramValue.equalsIgnoreCase("CREATE")) {
                    this.operation_type = 1;
                    continue;
                }
                if (paramValue.equalsIgnoreCase("DISABLE")) {
                    this.operation_type = 2;
                    continue;
                }
                if (paramValue.equalsIgnoreCase("ENABLE")) {
                    this.operation_type = 3;
                    continue;
                }
                if (paramValue.equalsIgnoreCase("STATUS")) {
                    this.operation_type = 4;
                    continue;
                }
                if (paramValue.equalsIgnoreCase("DELETE")) {
                    this.operation_type = 5;
                    continue;
                }
                if (paramValue.equalsIgnoreCase("RESET")) {
                    this.operation_type = 6;
                    continue;
                }
                if (paramValue.equalsIgnoreCase("MODIFY")) {
                    this.operation_type = 7;
                    continue;
                }
                if (!paramValue.equalsIgnoreCase("EXISTS")) continue;
                this.operation_type = 8;
                continue;
            }
            if (paramName.equalsIgnoreCase("LDAP_HOST")) {
                this.put("LDAP_HOST", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("LDAP_PORT")) {
                this.put("LDAP_PORT", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("SSL_MODE")) {
                this.put("SSL_MODE", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("LDAP_USER_DN")) {
                this.put("LDAP_USER_DN", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("LDAP_USER_PASSWORD")) {
                this.put("LDAP_USER_PASSWORD", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("PROFILE_MODE")) {
                this.put("PROFILE_MODE", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("PROFILE_STATUS")) {
                this.put("PROFILE_STATUS", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("APPLICATION_NAME")) {
                this.put("APPLICATION_NAME", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("APPLICATION_DN")) {
                this.put("APPLICATION_DN", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("APPLICATION_TYPE")) {
                this.put("APPLICATION_TYPE", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("APPLICATION_DISPLAY_NAME")) {
                this.put("APPLICATION_DISPLAY_NAME", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("APPLICATION_ISDASVISIBLE")) {
                this.put("APPLICATION_ISDASVISIBLE", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("MANAGE_APPLICATION_DEFAULTS")) {
                this.put("MANAGE_APPLICATION_DEFAULTS", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("ORGANIZATION_DN")) {
                this.put("ORGANIZATION_DN", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("ORGANIZATION_NAME")) {
                this.put("ORGANIZATION_NAME", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("INTERFACE_NAME")) {
                this.put("INTERFACE_NAME", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("INTERFACE_TYPE")) {
                this.put("INTERFACE_TYPE", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("INTERFACE_CONNECT_INFO")) {
                this.put("INTERFACE_CONNECT_INFO", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("INTERFACE_VERSION")) {
                this.put("INTERFACE_VERSION", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("INTERFACE_ADDITIONAL_INFO")) {
                additionalInfoVect.addElement(paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("SCHEDULE")) {
                this.put("SCHEDULE", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("MAX_RETRIES")) {
                this.put("MAX_RETRIES", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("MAX_EVENTS_PER_INVOCATION")) {
                this.put("MAX_EVENTS_PER_INVOCATION", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("MAX_EVENTS_PER_SCHEDULE")) {
                this.put("MAX_EVENTS_PER_SCHEDULE", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("PROFILE_GROUP")) {
                this.put("PROFILE_GROUP", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("PROFILE_DEBUG")) {
                this.put("PROFILE_DEBUG", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("CRYPT_KEY")) {
                this.put("CRYPT_KEY", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("PROFILE_MAX_ERRORS")) {
                this.put("PROFILE_MAX_ERRORS", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("LASTCHANGENUMBER")) {
                this.put("LASTCHANGENUMBER", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("USER_DATA_LOCATION")) {
                this.put("USER_DATA_LOCATION", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("DEFAULT_PROVISIONING_POLICY")) {
                this.put("DEFAULT_PROVISIONING_POLICY", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("ENABLE_BOOTSTRAP")) {
                this.put("ENABLE_BOOTSTRAP", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("ENABLE_UPGRADE")) {
                this.put("ENABLE_UPGRADE", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("MAX_PROV_FAILURE_RETRIES")) {
                this.put("MAX_PROV_FAILURE_RETRIES", paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("DEBUG")) {
                debug = Integer.parseInt(paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("EVENT_SUBSCRIPTION")) {
                eventVect.addElement(paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("SUBSCRIPTION_MODE")) {
                subscriptionModeVect.addElement(paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase("EVENT_MAPPING_RULES")) {
                mappingRuleVect.addElement(paramValue);
                continue;
            }
            if (!paramName.equalsIgnoreCase("EVENT_PERMITTED_OPERATIONS")) continue;
            permittedOprnsVect.addElement(paramValue);
        }
        if (additionalInfoVect.size() > 0) {
            this.putVector("INTERFACE_ADDITIONAL_INFO", additionalInfoVect);
        }
        if (eventVect.size() > 0) {
            this.putVector("EVENT_SUBSCRIPTION", eventVect);
        }
        if (mappingRuleVect.size() > 0) {
            this.putVector("EVENT_MAPPING_RULES", mappingRuleVect);
        }
        if (permittedOprnsVect.size() > 0) {
            this.putVector("EVENT_PERMITTED_OPERATIONS", permittedOprnsVect);
        }
        if (subscriptionModeVect.size() > 0) {
            this.putVector("SUBSCRIPTION_MODE", subscriptionModeVect);
        }
    }

    public static void initializeParamDefns() {
        ParamDefn parameter = null;
        parameter = new ParamDefn("1.0", null, "OPERATION", true, "CREATE");
        parameter.setValidValues(new String[]{"CREATE", "DISABLE", "ENABLE", "EXISTS", "STATUS", "DELETE", "RESET", "MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "LDAP_HOST", false, "localhost");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "LDAP_PORT", false, "389");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "SSL_MODE", false, "0");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "LDAP_USER_DN", false, "cn=orcladmin");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "LDAP_USER_PASSWORD", true, true, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "PROFILE_STATUS", false, "ENABLED");
        parameter.setValidValues(new String[]{"ENABLED", "DISABLED"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "PROFILE_MODE", false, "OUTBOUND");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "SCHEDULE", false, "3600");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "MAX_RETRIES", false, "5");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "APPLICATION_DN", true, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "APPLICATION_TYPE", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "APPLICATION_DISPLAY_NAME", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "APPLICATION_ISDASVISIBLE", false, "FALSE");
        parameter.setValidValues(new String[]{"TRUE", "FALSE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "APPLICATION_SEQUENCE", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "ORGANIZATION_DN", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "ORGANIZATION_NAME", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "INTERFACE_NAME", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "INTERFACE_TYPE", false, PLSQL);
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        parameter.setValidValues(new String[]{PLSQL});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "INTERFACE_CONNECT_INFO", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "INTERFACE_ADDITIONAL_INFO", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "INTERFACE_VERSION", false, "1.1");
        parameter.setValidValues(new String[]{"1.0", "1.1"});
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "PROFILE_GROUP", false, "default");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "PROFILE_DEBUG", false, "0");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "EVENT_SUBSCRIPTION", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("1.0", null, "LASTCHANGENUMBER", false, null);
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "OPERATION", true, "CREATE");
        parameter.setValidValues(new String[]{"CREATE", "DISABLE", "ENABLE", "EXISTS", "STATUS", "DELETE", "RESET", "MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "LDAP_HOST", false, "localhost");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "LDAP_PORT", false, "389");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "SSL_MODE", false, "0");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "LDAP_USER_DN", false, "cn=orcladmin");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "LDAP_USER_PASSWORD", true, true, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "PROFILE_STATUS", false, "ENABLED");
        parameter.setValidValues(new String[]{"ENABLED", "DISABLED"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "PROFILE_MODE", false, "OUTBOUND");
        parameter.setValidValues(new String[]{"BOTH", "INBOUND", "OUTBOUND"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "SCHEDULE", false, "3600");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "MAX_RETRIES", false, "5");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "APPLICATION_DN", true, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "APPLICATION_TYPE", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "APPLICATION_DISPLAY_NAME", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "APPLICATION_ISDASVISIBLE", false, "FALSE");
        parameter.setValidValues(new String[]{"TRUE", "FALSE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "APPLICATION_SEQUENCE", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "ORGANIZATION_DN", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "ORGANIZATION_NAME", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "INTERFACE_NAME", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "INTERFACE_TYPE", false, PLSQL);
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        parameter.setValidValues(new String[]{PLSQL});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "INTERFACE_CONNECT_INFO", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "INTERFACE_ADDITIONAL_INFO", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "INTERFACE_VERSION", false, "2.0");
        parameter.setValidValues(new String[]{"2.0", "2.1"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "MAX_EVENTS_PER_INVOCATION", false, "1");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "MAX_EVENTS_PER_SCHEDULE", false, "100");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "PROFILE_GROUP", false, "default");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "PROFILE_DEBUG", false, "0");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "CRYPT_KEY", false, "ABCDEFGH");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", null, "PROFILE_MAX_ERRORS", false, "50");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", "OUTBOUND", "EVENT_SUBSCRIPTION", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", "BOTH", "EVENT_SUBSCRIPTION", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", "OUTBOUND", "LASTCHANGENUMBER", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", "BOTH", "LASTCHANGENUMBER", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", "INBOUND", "EVENT_MAPPING_RULES", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", "BOTH", "EVENT_MAPPING_RULES", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", "INBOUND", "EVENT_PERMITTED_OPERATIONS", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("2.0", "BOTH", "EVENT_PERMITTED_OPERATIONS", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "OPERATION", true, "CREATE");
        parameter.setValidValues(new String[]{"CREATE", "DISABLE", "ENABLE", "EXISTS", "STATUS", "DELETE", "RESET", "MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "LDAP_HOST", false, "localhost");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "LDAP_PORT", false, "389");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "SSL_MODE", false, "0");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "LDAP_USER_DN", false, "cn=orcladmin");
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "LDAP_USER_PASSWORD", true, true, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "PROFILE_STATUS", false, "ENABLED");
        parameter.setValidValues(new String[]{"ENABLED", "DISABLED"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "PROFILE_MODE", false, "OUTBOUND");
        parameter.setValidValues(new String[]{"BOTH", "INBOUND", "OUTBOUND"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "SCHEDULE", false, "3600");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "MAX_RETRIES", false, "5");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "APPLICATION_DN", true, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "APPLICATION_NAME", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "APPLICATION_TYPE", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "APPLICATION_DISPLAY_NAME", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "APPLICATION_ISDASVISIBLE", false, "TRUE");
        parameter.setValidValues(new String[]{"TRUE", "FALSE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "MANAGE_APPLICATION_DEFAULTS", false, "TRUE");
        parameter.setValidValues(new String[]{"TRUE", "FALSE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "APPLICATION_SEQUENCE", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "ORGANIZATION_DN", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "ORGANIZATION_NAME", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "INTERFACE_NAME", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "INTERFACE_TYPE", false, PLSQL);
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        parameter.setValidValues(new String[]{OID_LDAP, JAVA, PLSQL});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "INTERFACE_CONNECT_INFO", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "INTERFACE_ADDITIONAL_INFO", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "INTERFACE_VERSION", false, "3.0");
        parameter.setValidValues(new String[]{"3.0"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "MAX_EVENTS_PER_INVOCATION", false, "1");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "MAX_EVENTS_PER_SCHEDULE", false, "100");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "PROFILE_GROUP", false, "default");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "PROFILE_DEBUG", false, "0");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "CRYPT_KEY", false, "ABCDEFGH");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "PROFILE_MAX_ERRORS", false, "50");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", "OUTBOUND", "EVENT_SUBSCRIPTION", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        parameter = new ParamDefn("3.0", "BOTH", "EVENT_SUBSCRIPTION", false, null);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        Vector<String> defVals = new Vector<String>();
        defVals.add("changesync");
        defVals.add("bootstrap");
        defVals.add("failure");
        defVals.add("upgrade");
        parameter = new ParamDefn("3.0", "OUTBOUND", "SUBSCRIPTION_MODE", false, defVals);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        parameter = new ParamDefn("3.0", "BOTH", "SUBSCRIPTION_MODE", false, defVals);
        parameter.setRequiredOprns(new String[]{"CREATE"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", "OUTBOUND", "LASTCHANGENUMBER", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", "BOTH", "LASTCHANGENUMBER", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", "INBOUND", "EVENT_MAPPING_RULES", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", "BOTH", "EVENT_MAPPING_RULES", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", "INBOUND", "EVENT_PERMITTED_OPERATIONS", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", "BOTH", "EVENT_PERMITTED_OPERATIONS", false, null);
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "USER_DATA_LOCATION", false, "DEFAULT");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "ENABLE_BOOTSTRAP", false, "false");
        parameter.setValidValues(new String[]{"true", "false"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "ENABLE_UPGRADE", false, "true");
        parameter.setValidValues(new String[]{"true", "false"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "MAX_PROV_FAILURE_RETRIES", false, "1");
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
        parameter = new ParamDefn("3.0", null, "DEFAULT_PROVISIONING_POLICY", false, "PROVISIONING_REQUIRED");
        parameter.setValidValues(new String[]{"PROVISIONING_REQUIRED", "PROVISIONING_NOT_REQUIRED"});
        parameter.setNotDefaultinOperations(new String[]{"MODIFY"});
        mParamDefns.addElement(parameter);
    }

    public void validateCmdArgs() throws InvalidParameterException {
        boolean found = false;
        ProvisioningProfile.LOG("Validating Arguments");
        String ifversion = (String)this.vars.get("INTERFACE_VERSION");
        if (!(ifversion.equals("1.0") || ifversion.equals("1.1") || ifversion.equals("2.0") || ifversion.equals("2.1") || ifversion.equals("3.0"))) {
            throw new InvalidParameterException(resBundle.getString("PROV_UNSUPPORTED_VERSION") + " - " + ifversion);
        }
        String pversion = null;
        if (ifversion.equals("1.0") || ifversion.equals("1.1")) {
            pversion = "1.0";
        }
        if (ifversion.equals("2.0") || ifversion.equals("2.1")) {
            pversion = "2.0";
        }
        if (ifversion.equals("3.0") || ifversion.equals("3.1")) {
            pversion = "3.0";
        }
        String pmode = (String)this.vars.get("PROFILE_MODE");
        String oprn = (String)this.vars.get("OPERATION");
        if (oprn == null) {
            ProvisioningCmdArgs.usage();
            throw new InvalidParameterException(resBundle.getString("PROV_MAND_ARG_MISSING") + " - " + "OPERATION");
        }
        ProvisioningProfile.LOG("Checking For UnSupported Arguments");
        Enumeration args = this.vars.keys();
        while (args.hasMoreElements()) {
            String cmdarg = (String)args.nextElement();
            ProvisioningProfile.LOG("Checking Parameter : " + cmdarg);
            found = false;
            for (int i = 0; i < mParamDefns.size(); ++i) {
                ParamDefn defn = (ParamDefn)mParamDefns.elementAt(i);
                String attrName = defn.getParamName();
                ProvisioningProfile.LOG("Found Param Defn : " + attrName);
                if (!attrName.equalsIgnoreCase(cmdarg)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ProvisioningCmdArgs.usage();
            throw new InvalidParameterException(resBundle.getString("PROV_UNSUPPORTED_ARG") + " - " + cmdarg);
        }
        this.put("PROFILE_VERSION", pversion);
        ProvisioningProfile.LOG("Checking Against Parameter Definitions");
        for (int i = 0; i < mParamDefns.size(); ++i) {
            String[] validValues;
            int j;
            String mode;
            ParamDefn defn = (ParamDefn)mParamDefns.elementAt(i);
            String attrName = defn.getParamName();
            String paramVersion = defn.getProfileVersion();
            if (paramVersion != null && !paramVersion.equals(pversion)) continue;
            ProvisioningProfile.LOG("Validating Argument : " + attrName);
            ProvisioningProfile.LOG("Argument Version : " + paramVersion);
            Object argValue = this.vars.get(attrName);
            Object defValue = null;
            if (argValue == null && (defValue = defn.getParamDefValue()) != null) {
                argValue = defValue;
                String[] notDefOprns = defn.getNotDefaultinOperations();
                boolean toDefault = true;
                if (notDefOprns != null) {
                    for (int k = 0; k < notDefOprns.length; ++k) {
                        if (!oprn.equalsIgnoreCase(notDefOprns[k])) continue;
                        toDefault = false;
                        ProvisioningProfile.LOG("Cannot Default For this Operation: " + oprn);
                        break;
                    }
                }
                if (toDefault) {
                    this.put(attrName, argValue);
                }
            }
            if (argValue != null) {
                if (argValue instanceof String) {
                    ProvisioningProfile.LOG("Argument Value: " + (String)argValue);
                } else {
                    ProvisioningProfile.LOG("Argument Value: " + (Vector)argValue);
                }
            }
            if ((mode = defn.getProfileMode()) != null && !mode.equalsIgnoreCase(pmode)) continue;
            if (defn.getParamRequired()) {
                if (argValue == null && defn.getDependentParam() == null) {
                    if (!defn.requireInput()) {
                        ProvisioningCmdArgs.usage();
                        throw new InvalidParameterException(ERROR_PREFIX + " " + resBundle.getString("PROV_MAND_ARG_MISSING") + " - " + attrName);
                    }
                    if (!ProvisioningProfile.apimode) {
                        ProvisioningProfile.LOG("Getting Input for : " + attrName);
                        try {
                            argValue = ProvisioningProfile.promptMessage(attrName + " : ");
                            this.put(attrName, argValue);
                        }
                        catch (IOException ie) {
                            throw new InvalidParameterException(ERROR_PREFIX + " " + resBundle.getString("PROV_MAND_ARG_INP_ERROR") + " - " + attrName);
                        }
                    }
                }
            } else {
                String[] requiredOprns = defn.getParamRequiredOprns();
                if (requiredOprns != null) {
                    for (j = 0; j < requiredOprns.length; ++j) {
                        if (!requiredOprns[j].equalsIgnoreCase(oprn) || argValue != null || defn.getDependentParam() != null) continue;
                        ProvisioningCmdArgs.usage();
                        throw new InvalidParameterException(ERROR_PREFIX + " " + resBundle.getString("PROV_MAND_ARG_MISSING_FOR_OPRN") + " - " + oprn + " : " + attrName);
                    }
                }
            }
            if ((validValues = defn.getParamValidValues()) == null) continue;
            found = false;
            for (j = 0; j < validValues.length; ++j) {
                if (!validValues[j].equalsIgnoreCase((String)argValue)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new InvalidParameterException(ERROR_PREFIX + " " + resBundle.getString("PROV_ARG_VAL_INVALID") + " - " + attrName + " : " + (String)argValue);
        }
        this.validateSpecificArgs();
    }

    private void validateSpecificArgs() throws InvalidParameterException {
        String interfaceType;
        if (this.getOperation() == 1 && (interfaceType = (String)this.vars.get("INTERFACE_TYPE")) != null && interfaceType.equalsIgnoreCase(PLSQL)) {
            if (!this.vars.containsKey("INTERFACE_CONNECT_INFO")) {
                throw new InvalidParameterException(resBundle.getString("PROV_MAND_ARG_MISSING") + " - " + "INTERFACE_CONNECT_INFO");
            }
            if (!this.vars.containsKey("INTERFACE_NAME")) {
                throw new InvalidParameterException(resBundle.getString("PROV_MAND_ARG_MISSING") + " - " + "INTERFACE_NAME");
            }
        }
    }

    public static void usage() {
        if (!ProvisioningProfile.apimode) {
            System.out.println(resBundle.getString("USAGE"));
        }
    }
}

