/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.param;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.nls.NlsMsg;
import oracle.ldap.util.param.Parameter;
import oracle.ldap.util.param.ParameterDescriptor;
import oracle.ldap.util.param.ParameterParser;

public class PropertyFileParser
extends ParameterParser {
    private Properties mProp = null;

    public PropertyFileParser(ParameterDescriptor[] paramDes, Properties prop) {
        super(paramDes);
        if (null == prop) {
            throw new IllegalArgumentException("prop parameter cannot be NULL");
        }
        this.mProp = prop;
    }

    public void parse() throws ParameterException {
        String name;
        this.mParsedParamHT = new Hashtable();
        Properties tempProp = (Properties)this.mProp.clone();
        for (int iCnt = 0; iCnt < this.mParamDes.length; ++iCnt) {
            name = this.mParamDes[iCnt].getName();
            String value = this.mProp.getProperty(name);
            tempProp.remove(name);
            String defVal = this.mParamDes[iCnt].getDefaultValue();
            if (this.mParamDes[iCnt].isManadatory() && null == value && null == defVal) {
                throw new ParameterException(NlsMsg.getMessage("PARAMETER_MANDATORY_MISSING", name));
            }
            if (value == null) {
                value = defVal;
            }
            if (value == null) continue;
            if (this.mParamDes[iCnt].isValueValid(value)) {
                this.mParsedParamHT.put(name, new Parameter(name, value, false));
                continue;
            }
            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_INVALID_ARGUMENT_VALUE", new String[]{name, value}));
        }
        Enumeration<Object> elements = tempProp.keys();
        while (elements.hasMoreElements()) {
            name = (String)elements.nextElement();
            if (name.trim().length() <= 0) continue;
            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_UNKNOWN", name + " in parameter file"));
        }
    }

    public static void main(String[] a) throws Exception {
        Properties prop = new Properties();
        ParameterDescriptor[] paramsDesc = new ParameterDescriptor[]{new ParameterDescriptor("odip.bootstrap.srctype", true, new String[]{"LDIF", "LDAP"}, null), new ParameterDescriptor("odip.bootstrap.desttype", true, new String[]{"LDIF", "LDAP"}, null), new ParameterDescriptor("odip.bootstrap.srcurl", true, null, null), new ParameterDescriptor("odip.bootstrap.desturl", true, null, null), new ParameterDescriptor("odip.bootstrap.mapfile", true, null, null), new ParameterDescriptor("odip.bootstrap.srcdn", true, null, null), new ParameterDescriptor("odip.bootstrap.srcpassword", true, null, null), new ParameterDescriptor("odip.bootstrap.destdn", true, null, null), new ParameterDescriptor("odip.bootstrap.destpassword", true, null, null), new ParameterDescriptor("odip.bootstrap.schemasync", false, new String[]{"true", "false"}, "false")};
        PropertyFileParser paramParseObj = new PropertyFileParser(paramsDesc, prop);
        prop.setProperty("odip.bootstrap.srctype", "LDIF");
        prop.setProperty("odip.bootstrap.srcurl", "/tmp/dump.ldif");
        prop.setProperty("odip.bootstrap.srcdn", "cn=orcladmin");
        prop.setProperty("odip.bootstrap.srcpassword", "welcome");
        prop.setProperty("odip.bootstrap.desttype", "LDAP");
        prop.setProperty("odip.bootstrap.desturl", "localhost:3060");
        prop.setProperty("odip.bootstrap.destdn", "cn=Directory Manager");
        prop.setProperty("odip.bootstrap.destpassword", "welcome123");
        prop.setProperty("odip.bootstrap.mapfile", "/tmp/Mapfile.cfg");
        ((ParameterParser)paramParseObj).parse();
        System.out.println(paramParseObj.get("odip.bootstrap.srctype").getValue());
        System.out.println(paramParseObj.get("odip.bootstrap.srcurl").getValue());
        System.out.println(paramParseObj.get("odip.bootstrap.srcdn").getValue());
        System.out.println(paramParseObj.get("odip.bootstrap.srcpassword").getValue());
        System.out.println(paramParseObj.get("odip.bootstrap.desttype").getValue());
        System.out.println(paramParseObj.get("odip.bootstrap.desturl").getValue());
        System.out.println(paramParseObj.get("odip.bootstrap.destdn").getValue());
        System.out.println(paramParseObj.get("odip.bootstrap.destpassword").getValue());
        System.out.println(paramParseObj.get("odip.bootstrap.mapfile").getValue());
        System.out.println(paramParseObj.get("odip.bootstrap.schemasync").getValue());
    }
}

