/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.param;

public class ParameterDescriptor {
    protected String mName = null;
    protected String[] mPossibleValues = null;
    protected boolean mMandatory = false;
    protected boolean mIgnoreCase = true;
    private String mDefaultValue = null;

    protected ParameterDescriptor() {
    }

    public ParameterDescriptor(String name, boolean mandatory, String[] possibleValues, String defaultValue) {
        if (null == name) {
            throw new IllegalArgumentException("Name of the parameter cannot be NULL");
        }
        this.mName = name;
        this.mMandatory = mandatory;
        this.mPossibleValues = possibleValues;
        this.mDefaultValue = defaultValue;
    }

    public boolean isValueValid(String pValue) {
        if (null == this.mPossibleValues) {
            return true;
        }
        for (int iCnt = 0; iCnt < this.mPossibleValues.length; ++iCnt) {
            if (!this.mPossibleValues[iCnt].equalsIgnoreCase(pValue)) continue;
            return true;
        }
        return false;
    }

    public boolean isManadatory() {
        return this.mMandatory;
    }

    public String getName() {
        return this.mName;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    public void setCaseSensitivity(boolean caseSensitivity) {
        this.mIgnoreCase = !caseSensitivity;
    }

    public boolean equals(String pName) {
        return this.mIgnoreCase ? this.mName.equalsIgnoreCase(pName) : this.mName.equals(pName);
    }
}

