/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.param;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.nls.NlsMsg;
import oracle.ldap.util.param.FlagParameterDescriptor;
import oracle.ldap.util.param.Parameter;
import oracle.ldap.util.param.ParameterDescriptor;
import oracle.ldap.util.param.ParameterParser;

public class CmdArgParser
extends ParameterParser {
    private String[] mArgs = null;
    private int mArgsStartIndex = 0;
    private boolean mOnlyFlags = false;

    public CmdArgParser(ParameterDescriptor[] paramDes, String[] args) {
        super(paramDes);
        if (null == args) {
            throw new IllegalArgumentException("args parameter cannot be NULL");
        }
        this.mArgs = args;
    }

    public CmdArgParser(ParameterDescriptor[] paramDes, String[] args, boolean allowUndescribedParam) {
        this(paramDes, args);
        this.mAllowUndescribedParam = allowUndescribedParam;
    }

    public CmdArgParser(FlagParameterDescriptor[] paramDes, String[] args) {
        super(paramDes);
        if (null == args) {
            throw new IllegalArgumentException("args parameter cannot be NULL");
        }
        this.mArgs = args;
        this.mOnlyFlags = true;
    }

    public void parse() throws ParameterException {
        if (this.mArgs.length != 0) {
            if (this.mOnlyFlags) {
                this.parseParamValues();
            } else {
                this.parseNameValuePairs();
            }
        }
    }

    public void setStartIndex(int startIndex) {
        if (startIndex < 0 || startIndex >= this.mArgs.length) {
            throw new IllegalArgumentException();
        }
        this.mArgsStartIndex = startIndex;
    }

    private void parseParamValues() throws ParameterException {
        boolean idFound = false;
        boolean nvFound = false;
        boolean flagFound = false;
        String name = null;
        String value = null;
        int argPos = -1;
        this.mParsedParamHT = new Hashtable();
        this.mUnParsedParamVector = new Vector();
        for (int iCnt = this.mArgsStartIndex; iCnt < this.mArgs.length; ++iCnt) {
            String tmpStr = this.mArgs[iCnt];
            if (tmpStr == null) continue;
            int inx = -1;
            if (tmpStr.startsWith("-") || flagFound) {
                if (name == null) {
                    name = tmpStr.substring(1);
                    if (name.equals("")) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_NAME_NOT_SPECIFIED"));
                    }
                    flagFound = true;
                    inx = name.indexOf(this.mParamNameValueDelim);
                    if (inx != -1) {
                        if (0 == inx) {
                            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_NAME_NOT_SPECIFIED"));
                        }
                        idFound = true;
                        if (inx < name.length() - 1) {
                            value = name.substring(inx + 1);
                            nvFound = true;
                        }
                        name = name.substring(0, inx);
                    }
                    if ((argPos = this.getParameterDescriptorIndex(name, true)) == -1) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_UNKNOWN_FLAG", name));
                    }
                    if (!((FlagParameterDescriptor)this.mParamDes[argPos]).isValueRequired()) {
                        if (idFound) {
                            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_TAKES_NO_ARGUMENT", name));
                        }
                        nvFound = true;
                    }
                } else if (idFound) {
                    value = tmpStr;
                    nvFound = true;
                } else if (tmpStr.startsWith(this.mParamNameValueDelim)) {
                    idFound = true;
                    if (tmpStr.length() > 1) {
                        value = tmpStr.substring(1);
                        nvFound = true;
                    }
                } else {
                    value = tmpStr;
                    nvFound = true;
                }
                if (!nvFound) continue;
                if (this.mParsedParamHT.containsKey(name)) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_DUPLICATE", name));
                }
                if (((FlagParameterDescriptor)this.mParamDes[argPos]).isValueRequired() && !this.mParamDes[argPos].isValueValid(value)) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_INVALID_ARGUMENT_VALUE", new String[]{name, value}));
                }
                this.mParsedParamHT.put(this.mParamDes[argPos].getName(), new Parameter(this.mParamDes[argPos].getName(), value, flagFound));
                argPos = -1;
                name = null;
                value = null;
                nvFound = false;
                flagFound = false;
                idFound = false;
                continue;
            }
            this.mUnParsedParamVector.add(tmpStr);
        }
        if (name != null && value == null) {
            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_VALUE_NOT_SPECIFIED"));
        }
        this.validateAndAddDefaultParams();
    }

    private void parseNameValuePairs() throws ParameterException {
        boolean idFound = false;
        boolean nvFound = false;
        boolean flagFound = false;
        String name = null;
        String value = null;
        int argPos = -1;
        this.mParsedParamHT = new Hashtable();
        if (this.mAllowUndescribedParam) {
            this.mUnParsedParamVector = new Vector();
        }
        for (int iCnt = this.mArgsStartIndex; iCnt < this.mArgs.length; ++iCnt) {
            int inx = -1;
            String tmpStr = this.mArgs[iCnt];
            if (tmpStr == null) continue;
            if (name == null) {
                name = tmpStr;
                inx = tmpStr.indexOf(this.mParamNameValueDelim);
                if (inx != -1) {
                    if (0 == inx) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_NAME_NOT_SPECIFIED"));
                    }
                    idFound = true;
                    name = tmpStr.substring(0, inx).trim();
                    if (inx < tmpStr.length() - 1) {
                        value = tmpStr.substring(inx + 1);
                        nvFound = true;
                    }
                }
            } else if (idFound) {
                value = tmpStr;
                nvFound = true;
            } else if (tmpStr.startsWith(this.mParamNameValueDelim)) {
                idFound = true;
                if (tmpStr.length() > 1) {
                    value = tmpStr.substring(1);
                    nvFound = true;
                }
            } else if (flagFound) {
                value = tmpStr;
                nvFound = true;
            } else {
                throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_VALUE_NOT_SPECIFIED"));
            }
            if (name.startsWith("-") && !flagFound) {
                if ((name = name.substring(1)).equals("")) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_NAME_NOT_SPECIFIED"));
                }
                argPos = this.getParameterDescriptorIndex(name, true);
                if (argPos == -1) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_UNKNOWN_FLAG", name));
                }
                flagFound = true;
                if (((FlagParameterDescriptor)this.mParamDes[argPos]).isValueRequired()) {
                    if (null != value) {
                        nvFound = true;
                    }
                } else {
                    if (idFound) {
                        throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_TAKES_NO_ARGUMENT", name));
                    }
                    nvFound = true;
                }
            }
            if (!nvFound) continue;
            if (!flagFound) {
                argPos = this.getParameterDescriptorIndex(name, true);
                argPos = argPos != -1 ? -1 : this.getParameterDescriptorIndex(name, false);
            }
            if (-1 == argPos) {
                if (!this.mAllowUndescribedParam) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_UNKNOWN", name));
                }
                if (this.mUnParsedParamVector.contains(name)) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_DUPLICATE", name));
                }
                this.mUnParsedParamVector.add(name);
                this.mUnParsedParamVector.add(value);
            } else {
                if (!this.mParamDes[argPos].isValueValid(value)) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_INVALID_ARGUMENT_VALUE", new String[]{name, value}));
                }
                if (this.mParsedParamHT.containsKey(name)) {
                    throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_DUPLICATE", name));
                }
                this.mParsedParamHT.put(this.mParamDes[argPos].getName(), new Parameter(this.mParamDes[argPos].getName(), value, flagFound));
            }
            value = null;
            name = null;
            flagFound = false;
            nvFound = false;
            idFound = false;
            argPos = -1;
        }
        if (null != name) {
            throw new InvalidParameterException(NlsMsg.getMessage("PARAMETER_VALUE_NOT_SPECIFIED"));
        }
        this.validateAndAddDefaultParams();
    }

    private static void test1(String[] args) throws ParameterException {
        ParameterDescriptor[] params = new ParameterDescriptor[]{new ParameterDescriptor("input_file", false, null, null), new ParameterDescriptor("output_file", false, null, null), new FlagParameterDescriptor("lookup", false, null), new FlagParameterDescriptor("load", false, null), new FlagParameterDescriptor("reconcile", true, new String[]{"NEW_ADD", "REPLACE_OLD"}), new ParameterDescriptor("host", true, null, null), new ParameterDescriptor("port", false, null, "389")};
        CmdArgParser cmdArgParser = new CmdArgParser(params, args, true);
        params[5].setCaseSensitivity(true);
        ((ParameterParser)cmdArgParser).parse();
        Hashtable ht = cmdArgParser.getParsedParams();
        Vector vt = cmdArgParser.getUnParsedParams();
        System.out.println("++++++ PARSED PARAMS  ++++++");
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Parameter p = (Parameter)ht.get(e.nextElement());
            System.out.println(p);
        }
        System.out.println("++++++ UNPARSED PARAMS  ++++++");
        for (int iCnt = 0; iCnt < vt.size(); iCnt += 2) {
            System.out.println("[ " + vt.elementAt(iCnt) + " ] [ " + vt.elementAt(iCnt + 1) + " ]");
        }
    }

    private static void test2(String[] args) throws ParameterException {
        FlagParameterDescriptor[] params = new FlagParameterDescriptor[]{new FlagParameterDescriptor("lookup", false, null), new FlagParameterDescriptor("load", false, null), new FlagParameterDescriptor("reconcile", true, true, new String[]{"NEW_ADD", "REPLACE_OLD"})};
        CmdArgParser cmdArgParser = new CmdArgParser(params, args);
        ((ParameterParser)cmdArgParser).parse();
        Hashtable ht = cmdArgParser.getParsedParams();
        Vector vt = cmdArgParser.getUnParsedParams();
        System.out.println("++++++ PARSED PARAMS  ++++++");
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Parameter p = (Parameter)ht.get(e.nextElement());
            System.out.println(p);
        }
        System.out.println("++++++ UNPARSED PARAMS  ++++++");
        for (int iCnt = 0; iCnt < vt.size(); ++iCnt) {
            System.out.println("[ " + vt.elementAt(iCnt) + " ]");
        }
    }
}

