/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.nls;

import java.util.Hashtable;
import java.util.Locale;

public class LocaleMapper {
    public static final int ORACLE = 1;
    public static final int IANA = 2;
    public static final int JAVA = 3;
    public static final int EMAIL_WINDOWS = 4;
    public static final int EMAIL_UNIX = 5;
    public static final int WINDOWS = 6;
    public static final int UNIX = 7;
    private static Hashtable ora2iana;
    private static Hashtable iana2ora;
    private static Hashtable iana2java;
    private static Hashtable mailUnix;
    private static final String[] english;
    private static final String[] western;
    private static final String[] eastern;
    private static final String[] baltic;
    private static final String[] cyrillic;
    private static final String[] arabic;
    private static final String[] greek;
    private static final String[] hebrew;
    private static final String[] turkish;
    private static final String[] thai;
    private static final String[] vietnamese;
    private static final String[] japanese;
    private static final String[] korean;
    private static final String[] simplifiedChinese;
    private static final String[] traditionalChinese;
    private static final String[] unicode;

    private LocaleMapper() {
    }

    private static void init_ora2iana() {
        ora2iana = new Hashtable(118);
        ora2iana.put("AL16UTF16", "UTF-16BE");
        ora2iana.put("AL16UTF16LE", "UTF-16LE");
        ora2iana.put("AL32UTF8", "UTF-8");
        ora2iana.put("AR8EBCDIC420S", "CP420");
        ora2iana.put("AR8EBCDICX", "CP420");
        ora2iana.put("AR8ISO8859P6", "ISO-8859-6");
        ora2iana.put("AR8MSAWIN", "WINDOWS-1256");
        ora2iana.put("AR8MSWIN1256", "WINDOWS-1256");
        ora2iana.put("BLT8ISO8859P13", "ISO-8859-13");
        ora2iana.put("BLT8MSWIN1257", "WINDOWS-1257");
        ora2iana.put("BLT8PC775", "CP775");
        ora2iana.put("CDN8PC863", "CP863");
        ora2iana.put("CEL8ISO8859P14", "ISO-8859-14");
        ora2iana.put("CL8ISO8859P5", "ISO-8859-5");
        ora2iana.put("CL8KOI8R", "KOI8-R");
        ora2iana.put("CL8KOI8U", "KOI8-U");
        ora2iana.put("CL8MSWIN1251", "WINDOWS-1251");
        ora2iana.put("D7DEC", "DIN_66003");
        ora2iana.put("D7SIEMENS9780X", "DIN_66003");
        ora2iana.put("D8EBCDIC1141", "CP01141");
        ora2iana.put("D8EBCDIC273", "CP273");
        ora2iana.put("DK7SIEMENS9780X", "NS_4551-1");
        ora2iana.put("DK8EBCDIC1142", "CP01142");
        ora2iana.put("DK8EBCDIC277", "IBM277");
        ora2iana.put("E7DEC", "ES");
        ora2iana.put("EE8EBCDIC870", "CP870");
        ora2iana.put("EE8EBCDIC870C", "CP870");
        ora2iana.put("EE8EBCDIC870S", "CP870");
        ora2iana.put("EE8ISO8859P2", "ISO-8859-2");
        ora2iana.put("EE8MSWIN1250", "WINDOWS-1250");
        ora2iana.put("EE8PC852", "CP852");
        ora2iana.put("EL8ISO8859P7", "ISO-8859-7");
        ora2iana.put("EL8MSWIN1253", "WINDOWS-1253");
        ora2iana.put("EL8PC851", "CP851");
        ora2iana.put("EL8PC869", "CP869");
        ora2iana.put("F7DEC", "NF_Z_62-010_(1973)");
        ora2iana.put("F8EBCDIC1147", "CP01147");
        ora2iana.put("F8EBCDIC297", "CP297");
        ora2iana.put("HZ-GB-2312", "HZ-GB-2312");
        ora2iana.put("I7DEC", "IT");
        ora2iana.put("I7SIEMENS9780X", "IT");
        ora2iana.put("I8EBCDIC1144", "CP01144");
        ora2iana.put("I8EBCDIC280", "CP280");
        ora2iana.put("IS8PC861", "CP861");
        ora2iana.put("ISO2022-CN", "ISO-2022-CN");
        ora2iana.put("ISO2022-JP", "ISO-2022-JP");
        ora2iana.put("ISO2022-KR", "ISO-2022-KR");
        ora2iana.put("IW8EBCDIC424", "CP424");
        ora2iana.put("IW8EBCDIC424S", "CP424");
        ora2iana.put("IW8ISO8859P8", "ISO-8859-8-I");
        ora2iana.put("IW8MSWIN1255", "WINDOWS-1255");
        ora2iana.put("IW8PC1507", "CP862");
        ora2iana.put("JA16EUC", "EUC-JP");
        ora2iana.put("JA16EUCTILDE", "EUC-JP");
        ora2iana.put("JA16EUCYEN", "EUC-JP");
        ora2iana.put("JA16SJIS", "SHIFT_JIS");
        ora2iana.put("JA16SJISTILDE", "SHIFT_JIS");
        ora2iana.put("JA16SJISYEN", "SHIFT_JIS");
        ora2iana.put("JA16VMS", "EUC-JP");
        ora2iana.put("KO16KSC5601", "EUC-KR");
        ora2iana.put("KO16MSWIN949", "EUC-KR");
        ora2iana.put("N7SIEMENS9780X", "NS_4551-1");
        ora2iana.put("N8PC865", "CP865");
        ora2iana.put("NE8ISO8859P10", "ISO-8859-10");
        ora2iana.put("NEE8ISO8859P4", "ISO-8859-4");
        ora2iana.put("RU8PC855", "CP855");
        ora2iana.put("RU8PC866", "CP866");
        ora2iana.put("S7SIEMENS9780X", "SEN_850200_C");
        ora2iana.put("S8EBCDIC1143", "CP01143");
        ora2iana.put("S8EBCDIC278", "CP278");
        ora2iana.put("SE8ISO8859P3", "ISO-8859-3");
        ora2iana.put("SF7ASCII", "SEN_850200_B");
        ora2iana.put("TH8TISASCII", "TIS-620");
        ora2iana.put("TR8EBCDIC1026", "CP1026");
        ora2iana.put("TR8EBCDIC1026S", "CP1026");
        ora2iana.put("TR8MSWIN1254", "WINDOWS-1254");
        ora2iana.put("TR8PC857", "CP857");
        ora2iana.put("UCS2", "UTF-16");
        ora2iana.put("US7ASCII", "US-ASCII");
        ora2iana.put("US8PC437", "CP437");
        ora2iana.put("UTF16", "UTF-16");
        ora2iana.put("UTF8", "UTF-8");
        ora2iana.put("VN8MSWIN1258", "WINDOWS-1258");
        ora2iana.put("WE8DEC", "DEC-MCS");
        ora2iana.put("WE8EBCDIC1047", "IBM1047");
        ora2iana.put("WE8EBCDIC1047E", "IBM1047");
        ora2iana.put("WE8EBCDIC1140", "CP01140");
        ora2iana.put("WE8EBCDIC1140C", "CP01140");
        ora2iana.put("WE8EBCDIC1145", "CP01145");
        ora2iana.put("WE8EBCDIC1146", "CP01146");
        ora2iana.put("WE8EBCDIC1148", "CP01148");
        ora2iana.put("WE8EBCDIC1148C", "CP01148");
        ora2iana.put("WE8EBCDIC284", "CP284");
        ora2iana.put("WE8EBCDIC285", "CP285");
        ora2iana.put("WE8EBCDIC37", "CP037");
        ora2iana.put("WE8EBCDIC37C", "CP037");
        ora2iana.put("WE8EBCDIC500", "CP500");
        ora2iana.put("WE8EBCDIC500C", "CP500");
        ora2iana.put("WE8EBCDIC871", "CP871");
        ora2iana.put("WE8EBCDIC924", "CP00924");
        ora2iana.put("WE8ISO8859P1", "ISO-8859-1");
        ora2iana.put("WE8ISO8859P15", "ISO-8859-15");
        ora2iana.put("WE8ISO8859P9", "ISO-8859-9");
        ora2iana.put("WE8MACROMAN8", "MACINTOSH");
        ora2iana.put("WE8MACROMAN8S", "MACINTOSH");
        ora2iana.put("WE8MSWIN1252", "WINDOWS-1252");
        ora2iana.put("WE8NCR4970", "DEC-MCS");
        ora2iana.put("WE8PC850", "CP850");
        ora2iana.put("WE8PC858", "CP00858");
        ora2iana.put("WE8PC860", "CP860");
        ora2iana.put("WE8ROMAN8", "HP-ROMAN8");
        ora2iana.put("YUG7ASCII", "JUS_I.B1.002");
        ora2iana.put("ZHS16CGB231280", "GBK");
        ora2iana.put("ZHS16GBK", "GBK");
        ora2iana.put("ZHS32GB18030", "GB18030");
        ora2iana.put("ZHT16BIG5", "BIG5");
        ora2iana.put("ZHT16HKSCS", "BIG5-HKSCS");
        ora2iana.put("ZHT16MSWIN950", "BIG5");
    }

    private static void init_iana2ora() {
        iana2ora = new Hashtable(389);
        iana2ora.put("437", "US8PC437");
        iana2ora.put("850", "WE8PC850");
        iana2ora.put("851", "EL8PC851");
        iana2ora.put("852", "EE8PC852");
        iana2ora.put("855", "RU8PC855");
        iana2ora.put("857", "TR8PC857");
        iana2ora.put("860", "WE8PC860");
        iana2ora.put("861", "IS8PC861");
        iana2ora.put("862", "IW8PC1507");
        iana2ora.put("863", "CDN8PC863");
        iana2ora.put("865", "N8PC865");
        iana2ora.put("866", "RU8PC866");
        iana2ora.put("869", "EL8PC869");
        iana2ora.put("ANSI_X3.4-1968", "US7ASCII");
        iana2ora.put("ANSI_X3.4-1986", "US7ASCII");
        iana2ora.put("ARABIC", "AR8ISO8859P6");
        iana2ora.put("ASCII", "US7ASCII");
        iana2ora.put("ASMO-708", "AR8ISO8859P6");
        iana2ora.put("BIG5", "ZHT16MSWIN950");
        iana2ora.put("BIG5-HKSCS", "ZHT16HKSCS");
        iana2ora.put("CCSID00858", "WE8PC858");
        iana2ora.put("CCSID00924", "WE8EBCDIC924");
        iana2ora.put("CCSID01140", "WE8EBCDIC1140");
        iana2ora.put("CCSID01141", "D8EBCDIC1141");
        iana2ora.put("CCSID01142", "DK8EBCDIC1142");
        iana2ora.put("CCSID01143", "S8EBCDIC1143");
        iana2ora.put("CCSID01144", "I8EBCDIC1144");
        iana2ora.put("CCSID01145", "WE8EBCDIC1145");
        iana2ora.put("CCSID01146", "WE8EBCDIC1146");
        iana2ora.put("CCSID01147", "F8EBCDIC1147");
        iana2ora.put("CCSID01148", "WE8EBCDIC1148");
        iana2ora.put("CESU-8", "UTF8");
        iana2ora.put("CHINESE", "ZHS16GBK");
        iana2ora.put("CP-GR", "EL8PC869");
        iana2ora.put("CP-IS", "IS8PC861");
        iana2ora.put("CP00858", "WE8PC858");
        iana2ora.put("CP00924", "WE8EBCDIC924");
        iana2ora.put("CP01140", "WE8EBCDIC1140");
        iana2ora.put("CP01141", "D8EBCDIC1141");
        iana2ora.put("CP01142", "DK8EBCDIC1142");
        iana2ora.put("CP01143", "S8EBCDIC1143");
        iana2ora.put("CP01144", "I8EBCDIC1144");
        iana2ora.put("CP01145", "WE8EBCDIC1145");
        iana2ora.put("CP01146", "WE8EBCDIC1146");
        iana2ora.put("CP01147", "F8EBCDIC1147");
        iana2ora.put("CP01148", "WE8EBCDIC1148");
        iana2ora.put("CP037", "WE8EBCDIC37");
        iana2ora.put("CP1026", "TR8EBCDIC1026");
        iana2ora.put("CP273", "D8EBCDIC273");
        iana2ora.put("CP278", "S8EBCDIC278");
        iana2ora.put("CP280", "I8EBCDIC280");
        iana2ora.put("CP284", "WE8EBCDIC284");
        iana2ora.put("CP285", "WE8EBCDIC285");
        iana2ora.put("CP297", "F8EBCDIC297");
        iana2ora.put("CP367", "US7ASCII");
        iana2ora.put("CP420", "AR8EBCDIC420S");
        iana2ora.put("CP424", "IW8EBCDIC424");
        iana2ora.put("CP437", "US8PC437");
        iana2ora.put("CP500", "WE8EBCDIC500");
        iana2ora.put("CP775", "BLT8PC775");
        iana2ora.put("CP819", "WE8ISO8859P1");
        iana2ora.put("CP850", "WE8PC850");
        iana2ora.put("CP851", "EL8PC851");
        iana2ora.put("CP852", "EE8PC852");
        iana2ora.put("CP855", "RU8PC855");
        iana2ora.put("CP857", "TR8PC857");
        iana2ora.put("CP860", "WE8PC860");
        iana2ora.put("CP861", "IS8PC861");
        iana2ora.put("CP862", "IW8PC1507");
        iana2ora.put("CP863", "CDN8PC863");
        iana2ora.put("CP865", "N8PC865");
        iana2ora.put("CP866", "RU8PC866");
        iana2ora.put("CP869", "EL8PC869");
        iana2ora.put("CP870", "EE8EBCDIC870");
        iana2ora.put("CP871", "WE8EBCDIC871");
        iana2ora.put("CP891", "US7ASCII");
        iana2ora.put("CP903", "US7ASCII");
        iana2ora.put("CP936", "ZHS16GBK");
        iana2ora.put("CSASCII", "US7ASCII");
        iana2ora.put("CSBIG5", "ZHT16MSWIN950");
        iana2ora.put("CSCESU-8", "UTF8");
        iana2ora.put("CSDECMCS", "WE8DEC");
        iana2ora.put("CSEUCKR", "KO16MSWIN949");
        iana2ora.put("CSEUCPKDFMTJAPANESE", "JA16EUC");
        iana2ora.put("CSGB2312", "ZHS16GBK");
        iana2ora.put("CSHPROMAN8", "WE8ROMAN8");
        iana2ora.put("CSIBM037", "WE8EBCDIC37");
        iana2ora.put("CSIBM1026", "TR8EBCDIC1026");
        iana2ora.put("CSIBM273", "D8EBCDIC273");
        iana2ora.put("CSIBM277", "DK8EBCDIC277");
        iana2ora.put("CSIBM278", "S8EBCDIC278");
        iana2ora.put("CSIBM280", "I8EBCDIC280");
        iana2ora.put("CSIBM284", "WE8EBCDIC284");
        iana2ora.put("CSIBM285", "WE8EBCDIC285");
        iana2ora.put("CSIBM297", "F8EBCDIC297");
        iana2ora.put("CSIBM420", "AR8EBCDIC420S");
        iana2ora.put("CSIBM424", "IW8EBCDIC424");
        iana2ora.put("CSIBM500", "WE8EBCDIC500");
        iana2ora.put("CSIBM851", "EL8PC851");
        iana2ora.put("CSIBM855", "RU8PC855");
        iana2ora.put("CSIBM857", "TR8PC857");
        iana2ora.put("CSIBM860", "WE8PC860");
        iana2ora.put("CSIBM861", "IS8PC861");
        iana2ora.put("CSIBM863", "CDN8PC863");
        iana2ora.put("CSIBM865", "N8PC865");
        iana2ora.put("CSIBM866", "RU8PC866");
        iana2ora.put("CSIBM869", "EL8PC869");
        iana2ora.put("CSIBM870", "EE8EBCDIC870");
        iana2ora.put("CSIBM871", "WE8EBCDIC871");
        iana2ora.put("CSIBM891", "US7ASCII");
        iana2ora.put("CSIBM903", "US7ASCII");
        iana2ora.put("CSISO10SWEDISH", "SF7ASCII");
        iana2ora.put("CSISO11SWEDISHFORNAMES", "S7SIEMENS9780X");
        iana2ora.put("CSISO141JUSIB1002", "YUG7ASCII");
        iana2ora.put("CSISO15ITALIAN", "I7DEC");
        iana2ora.put("CSISO17SPANISH", "E7DEC");
        iana2ora.put("CSISO2022JP", "ISO2022-JP");
        iana2ora.put("CSISO2022KR", "ISO2022-KR");
        iana2ora.put("CSISO21GERMAN", "D7DEC");
        iana2ora.put("CSISO25FRENCH", "F7DEC");
        iana2ora.put("CSISO58GB231280", "ZHS16GBK");
        iana2ora.put("CSISO60DANISHNORWEGIAN", "N7SIEMENS9780X");
        iana2ora.put("CSISO60NORWEGIAN1", "N7SIEMENS9780X");
        iana2ora.put("CSISO88596I", "AR8ISO8859P6");
        iana2ora.put("CSISO88598I", "IW8ISO8859P8");
        iana2ora.put("CSISOLATIN1", "WE8ISO8859P1");
        iana2ora.put("CSISOLATIN2", "EE8ISO8859P2");
        iana2ora.put("CSISOLATIN3", "SE8ISO8859P3");
        iana2ora.put("CSISOLATIN4", "NEE8ISO8859P4");
        iana2ora.put("CSISOLATIN5", "WE8ISO8859P9");
        iana2ora.put("CSISOLATIN6", "NE8ISO8859P10");
        iana2ora.put("CSISOLATINARABIC", "AR8ISO8859P6");
        iana2ora.put("CSISOLATINCYRILLIC", "CL8ISO8859P5");
        iana2ora.put("CSISOLATINGREEK", "EL8ISO8859P7");
        iana2ora.put("CSJISENCODING", "ISO2022-JP");
        iana2ora.put("CSKOI8R", "CL8KOI8R");
        iana2ora.put("CSKSC56011987", "KO16MSWIN949");
        iana2ora.put("CSMACINTOSH", "WE8MACROMAN8");
        iana2ora.put("CSPC775BALTIC", "BLT8PC775");
        iana2ora.put("CSPC850MULTILINGUAL", "WE8PC850");
        iana2ora.put("CSPC862LATINHEBREW", "IW8PC1507");
        iana2ora.put("CSPC8CODEPAGE437", "US8PC437");
        iana2ora.put("CSPCP852", "EE8PC852");
        iana2ora.put("CSSHIFTJIS", "JA16SJIS");
        iana2ora.put("CSUNICODE", "UTF16");
        iana2ora.put("CSUSDK", "US7ASCII");
        iana2ora.put("CSWINDOWS30LATIN1", "WE8MSWIN1252");
        iana2ora.put("CSWINDOWS31J", "JA16SJIS");
        iana2ora.put("CSWINDOWS31LATIN1", "WE8MSWIN1252");
        iana2ora.put("CSWINDOWS31LATIN2", "EE8MSWIN1250");
        iana2ora.put("CSWINDOWS31LATIN5", "TR8MSWIN1254");
        iana2ora.put("CYRILLIC", "CL8ISO8859P5");
        iana2ora.put("DE", "D7DEC");
        iana2ora.put("DEC", "WE8DEC");
        iana2ora.put("DEC-MCS", "WE8DEC");
        iana2ora.put("DIN_66003", "D7DEC");
        iana2ora.put("EBCDIC-CP-AR1", "AR8EBCDIC420S");
        iana2ora.put("EBCDIC-CP-BE", "WE8EBCDIC500");
        iana2ora.put("EBCDIC-CP-CA", "WE8EBCDIC37");
        iana2ora.put("EBCDIC-CP-CH", "WE8EBCDIC500");
        iana2ora.put("EBCDIC-CP-DK", "DK8EBCDIC277");
        iana2ora.put("EBCDIC-CP-ES", "WE8EBCDIC284");
        iana2ora.put("EBCDIC-CP-FI", "S8EBCDIC278");
        iana2ora.put("EBCDIC-CP-FR", "F8EBCDIC297");
        iana2ora.put("EBCDIC-CP-GB", "WE8EBCDIC285");
        iana2ora.put("EBCDIC-CP-HE", "IW8EBCDIC424");
        iana2ora.put("EBCDIC-CP-IS", "WE8EBCDIC871");
        iana2ora.put("EBCDIC-CP-IT", "I8EBCDIC280");
        iana2ora.put("EBCDIC-CP-NL", "WE8EBCDIC37");
        iana2ora.put("EBCDIC-CP-NO", "DK8EBCDIC277");
        iana2ora.put("EBCDIC-CP-ROECE", "EE8EBCDIC870");
        iana2ora.put("EBCDIC-CP-SE", "S8EBCDIC278");
        iana2ora.put("EBCDIC-CP-US", "WE8EBCDIC37");
        iana2ora.put("EBCDIC-CP-WT", "WE8EBCDIC37");
        iana2ora.put("EBCDIC-CP-YU", "EE8EBCDIC870");
        iana2ora.put("EBCDIC-DE-273+EURO", "D8EBCDIC1141");
        iana2ora.put("EBCDIC-DK-277+EURO", "DK8EBCDIC1142");
        iana2ora.put("EBCDIC-ES-284+EURO", "WE8EBCDIC1145");
        iana2ora.put("EBCDIC-FI-278+EURO", "S8EBCDIC1143");
        iana2ora.put("EBCDIC-FR-297+EURO", "F8EBCDIC1147");
        iana2ora.put("EBCDIC-GB-285+EURO", "WE8EBCDIC1146");
        iana2ora.put("EBCDIC-INTERNATIONAL-500+EURO", "WE8EBCDIC1148");
        iana2ora.put("EBCDIC-IT-280+EURO", "I8EBCDIC1144");
        iana2ora.put("EBCDIC-LATIN9--EURO", "WE8EBCDIC924");
        iana2ora.put("EBCDIC-NO-277+EURO", "DK8EBCDIC1142");
        iana2ora.put("EBCDIC-SE-278+EURO", "S8EBCDIC1143");
        iana2ora.put("EBCDIC-US-37+EURO", "WE8EBCDIC1140");
        iana2ora.put("ECMA-114", "AR8ISO8859P6");
        iana2ora.put("ECMA-118", "EL8ISO8859P7");
        iana2ora.put("ELOT_928", "EL8ISO8859P7");
        iana2ora.put("ES", "E7DEC");
        iana2ora.put("EUC-JP", "JA16EUC");
        iana2ora.put("EUC-KR", "KO16MSWIN949");
        iana2ora.put("EUC-TW", "ZHT32EUC");
        iana2ora.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "JA16EUC");
        iana2ora.put("FI", "SF7ASCII");
        iana2ora.put("GB18030", "ZHS32GB18030");
        iana2ora.put("GB2312", "ZHS16GBK");
        iana2ora.put("GBK", "ZHS16GBK");
        iana2ora.put("GB_2312-80", "ZHS16GBK");
        iana2ora.put("GREEK", "EL8ISO8859P7");
        iana2ora.put("GREEK8", "EL8ISO8859P7");
        iana2ora.put("HP-ROMAN8", "WE8ROMAN8");
        iana2ora.put("HZ-GB-2312", "HZ-GB-2312");
        iana2ora.put("IBM-1047", "WE8EBCDIC1047");
        iana2ora.put("IBM00858", "WE8PC858");
        iana2ora.put("IBM00924", "WE8EBCDIC924");
        iana2ora.put("IBM01140", "WE8EBCDIC1140");
        iana2ora.put("IBM01141", "D8EBCDIC1141");
        iana2ora.put("IBM01142", "DK8EBCDIC1142");
        iana2ora.put("IBM01143", "S8EBCDIC1143");
        iana2ora.put("IBM01144", "I8EBCDIC1144");
        iana2ora.put("IBM01145", "WE8EBCDIC1145");
        iana2ora.put("IBM01146", "WE8EBCDIC1146");
        iana2ora.put("IBM01147", "F8EBCDIC1147");
        iana2ora.put("IBM01148", "WE8EBCDIC1148");
        iana2ora.put("IBM037", "WE8EBCDIC37");
        iana2ora.put("IBM1026", "TR8EBCDIC1026");
        iana2ora.put("IBM1047", "WE8EBCDIC1047");
        iana2ora.put("IBM273", "D8EBCDIC273");
        iana2ora.put("IBM277", "DK8EBCDIC277");
        iana2ora.put("IBM278", "S8EBCDIC278");
        iana2ora.put("IBM280", "I8EBCDIC280");
        iana2ora.put("IBM284", "WE8EBCDIC284");
        iana2ora.put("IBM285", "WE8EBCDIC285");
        iana2ora.put("IBM297", "F8EBCDIC297");
        iana2ora.put("IBM367", "US7ASCII");
        iana2ora.put("IBM420", "AR8EBCDIC420S");
        iana2ora.put("IBM424", "IW8EBCDIC424");
        iana2ora.put("IBM437", "US8PC437");
        iana2ora.put("IBM500", "WE8EBCDIC500");
        iana2ora.put("IBM775", "BLT8PC775");
        iana2ora.put("IBM819", "WE8ISO8859P1");
        iana2ora.put("IBM850", "WE8PC850");
        iana2ora.put("IBM851", "EL8PC851");
        iana2ora.put("IBM852", "EE8PC852");
        iana2ora.put("IBM855", "RU8PC855");
        iana2ora.put("IBM857", "TR8PC857");
        iana2ora.put("IBM860", "WE8PC860");
        iana2ora.put("IBM861", "IS8PC861");
        iana2ora.put("IBM862", "IW8PC1507");
        iana2ora.put("IBM863", "CDN8PC863");
        iana2ora.put("IBM865", "N8PC865");
        iana2ora.put("IBM866", "RU8PC866");
        iana2ora.put("IBM869", "EL8PC869");
        iana2ora.put("IBM870", "EE8EBCDIC870");
        iana2ora.put("IBM871", "WE8EBCDIC871");
        iana2ora.put("IBM891", "US7ASCII");
        iana2ora.put("IBM903", "US7ASCII");
        iana2ora.put("ISO-10646-UCS-2", "UTF16");
        iana2ora.put("ISO-2022-CN", "ISO2022-CN");
        iana2ora.put("ISO-2022-JP", "ISO2022-JP");
        iana2ora.put("ISO-2022-KR", "ISO2022-KR");
        iana2ora.put("ISO-8859-1", "WE8ISO8859P1");
        iana2ora.put("ISO-8859-1-WINDOWS-3.0-LATIN-1", "WE8MSWIN1252");
        iana2ora.put("ISO-8859-1-WINDOWS-3.1-LATIN-1", "WE8MSWIN1252");
        iana2ora.put("ISO-8859-10", "NE8ISO8859P10");
        iana2ora.put("ISO-8859-13", "BLT8ISO8859P13");
        iana2ora.put("ISO-8859-14", "CEL8ISO8859P14");
        iana2ora.put("ISO-8859-15", "WE8ISO8859P15");
        iana2ora.put("ISO-8859-2", "EE8ISO8859P2");
        iana2ora.put("ISO-8859-2-WINDOWS-LATIN-2", "EE8MSWIN1250");
        iana2ora.put("ISO-8859-3", "SE8ISO8859P3");
        iana2ora.put("ISO-8859-4", "NEE8ISO8859P4");
        iana2ora.put("ISO-8859-5", "CL8ISO8859P5");
        iana2ora.put("ISO-8859-6", "AR8ISO8859P6");
        iana2ora.put("ISO-8859-6-I", "AR8ISO8859P6");
        iana2ora.put("ISO-8859-7", "EL8ISO8859P7");
        iana2ora.put("ISO-8859-8-I", "IW8ISO8859P8");
        iana2ora.put("ISO-8859-9", "WE8ISO8859P9");
        iana2ora.put("ISO-8859-9-WINDOWS-LATIN-5", "TR8MSWIN1254");
        iana2ora.put("ISO-CELTIC", "CEL8ISO8859P14");
        iana2ora.put("ISO-IR-10", "SF7ASCII");
        iana2ora.put("ISO-IR-100", "WE8ISO8859P1");
        iana2ora.put("ISO-IR-101", "EE8ISO8859P2");
        iana2ora.put("ISO-IR-109", "SE8ISO8859P3");
        iana2ora.put("ISO-IR-11", "S7SIEMENS9780X");
        iana2ora.put("ISO-IR-110", "NEE8ISO8859P4");
        iana2ora.put("ISO-IR-126", "EL8ISO8859P7");
        iana2ora.put("ISO-IR-127", "AR8ISO8859P6");
        iana2ora.put("ISO-IR-141", "YUG7ASCII");
        iana2ora.put("ISO-IR-144", "CL8ISO8859P5");
        iana2ora.put("ISO-IR-148", "WE8ISO8859P9");
        iana2ora.put("ISO-IR-149", "KO16MSWIN949");
        iana2ora.put("ISO-IR-15", "I7DEC");
        iana2ora.put("ISO-IR-157", "NE8ISO8859P10");
        iana2ora.put("ISO-IR-17", "E7DEC");
        iana2ora.put("ISO-IR-199", "CEL8ISO8859P14");
        iana2ora.put("ISO-IR-21", "D7DEC");
        iana2ora.put("ISO-IR-25", "F7DEC");
        iana2ora.put("ISO-IR-58", "ZHS16GBK");
        iana2ora.put("ISO-IR-6", "US7ASCII");
        iana2ora.put("ISO-IR-60", "N7SIEMENS9780X");
        iana2ora.put("ISO646-DE", "D7DEC");
        iana2ora.put("ISO646-ES", "E7DEC");
        iana2ora.put("ISO646-FI", "SF7ASCII");
        iana2ora.put("ISO646-FR1", "F7DEC");
        iana2ora.put("ISO646-IT", "I7DEC");
        iana2ora.put("ISO646-NO", "N7SIEMENS9780X");
        iana2ora.put("ISO646-SE", "SF7ASCII");
        iana2ora.put("ISO646-SE2", "S7SIEMENS9780X");
        iana2ora.put("ISO646-US", "US7ASCII");
        iana2ora.put("ISO646-YU", "YUG7ASCII");
        iana2ora.put("ISO_646.IRV:1991", "US7ASCII");
        iana2ora.put("ISO_8859-1", "WE8ISO8859P1");
        iana2ora.put("ISO_8859-10:1992", "NE8ISO8859P10");
        iana2ora.put("ISO_8859-14", "CEL8ISO8859P14");
        iana2ora.put("ISO_8859-14:1998", "CEL8ISO8859P14");
        iana2ora.put("ISO_8859-15", "WE8ISO8859P15");
        iana2ora.put("ISO_8859-1:1987", "WE8ISO8859P1");
        iana2ora.put("ISO_8859-2", "EE8ISO8859P2");
        iana2ora.put("ISO_8859-2:1987", "EE8ISO8859P2");
        iana2ora.put("ISO_8859-3", "SE8ISO8859P3");
        iana2ora.put("ISO_8859-3:1988", "SE8ISO8859P3");
        iana2ora.put("ISO_8859-4", "NEE8ISO8859P4");
        iana2ora.put("ISO_8859-4:1988", "NEE8ISO8859P4");
        iana2ora.put("ISO_8859-5", "CL8ISO8859P5");
        iana2ora.put("ISO_8859-5:1988", "CL8ISO8859P5");
        iana2ora.put("ISO_8859-6", "AR8ISO8859P6");
        iana2ora.put("ISO_8859-6-I", "AR8ISO8859P6");
        iana2ora.put("ISO_8859-6:1987", "AR8ISO8859P6");
        iana2ora.put("ISO_8859-7", "EL8ISO8859P7");
        iana2ora.put("ISO_8859-7:1987", "EL8ISO8859P7");
        iana2ora.put("ISO_8859-8-I", "IW8ISO8859P8");
        iana2ora.put("ISO_8859-9", "WE8ISO8859P9");
        iana2ora.put("ISO_8859-9:1989", "WE8ISO8859P9");
        iana2ora.put("IT", "I7DEC");
        iana2ora.put("JIS_ENCODING", "ISO2022-JP");
        iana2ora.put("JS", "YUG7ASCII");
        iana2ora.put("JUS_I.B1.002", "YUG7ASCII");
        iana2ora.put("KOI8-R", "CL8KOI8R");
        iana2ora.put("KOI8-U", "CL8KOI8U");
        iana2ora.put("KOREAN", "KO16MSWIN949");
        iana2ora.put("KSC_5601", "KO16MSWIN949");
        iana2ora.put("KS_C_5601-1987", "KO16MSWIN949");
        iana2ora.put("KS_C_5601-1989", "KO16MSWIN949");
        iana2ora.put("L1", "WE8ISO8859P1");
        iana2ora.put("L2", "EE8ISO8859P2");
        iana2ora.put("L3", "SE8ISO8859P3");
        iana2ora.put("L4", "NEE8ISO8859P4");
        iana2ora.put("L5", "WE8ISO8859P9");
        iana2ora.put("L6", "NE8ISO8859P10");
        iana2ora.put("L8", "CEL8ISO8859P14");
        iana2ora.put("LATIN-9", "WE8ISO8859P15");
        iana2ora.put("LATIN1", "WE8ISO8859P1");
        iana2ora.put("LATIN2", "EE8ISO8859P2");
        iana2ora.put("LATIN3", "SE8ISO8859P3");
        iana2ora.put("LATIN4", "NEE8ISO8859P4");
        iana2ora.put("LATIN5", "WE8ISO8859P9");
        iana2ora.put("LATIN6", "NE8ISO8859P10");
        iana2ora.put("LATIN8", "CEL8ISO8859P14");
        iana2ora.put("MAC", "WE8MACROMAN8");
        iana2ora.put("MACINTOSH", "WE8MACROMAN8");
        iana2ora.put("MS936", "ZHS16GBK");
        iana2ora.put("MS_KANJI", "JA16SJIS");
        iana2ora.put("NF_Z_62-010_(1973)", "F7DEC");
        iana2ora.put("NO", "N7SIEMENS9780X");
        iana2ora.put("NS_4551-1", "N7SIEMENS9780X");
        iana2ora.put("PC-MULTILINGUAL-850+EURO", "WE8PC858");
        iana2ora.put("R8", "WE8ROMAN8");
        iana2ora.put("ROMAN8", "WE8ROMAN8");
        iana2ora.put("SE", "SF7ASCII");
        iana2ora.put("SE2", "S7SIEMENS9780X");
        iana2ora.put("SEN_850200_B", "SF7ASCII");
        iana2ora.put("SEN_850200_C", "S7SIEMENS9780X");
        iana2ora.put("SHIFT_JIS", "JA16SJIS");
        iana2ora.put("TIS-620", "TH8TISASCII");
        iana2ora.put("US", "US7ASCII");
        iana2ora.put("US-ASCII", "US7ASCII");
        iana2ora.put("US-DK", "US7ASCII");
        iana2ora.put("UTF-16", "UTF16");
        iana2ora.put("UTF-16BE", "AL16UTF16");
        iana2ora.put("UTF-16LE", "AL16UTF16LE");
        iana2ora.put("UTF-8", "AL32UTF8");
        iana2ora.put("WINDOWS-1250", "EE8MSWIN1250");
        iana2ora.put("WINDOWS-1251", "CL8MSWIN1251");
        iana2ora.put("WINDOWS-1252", "WE8MSWIN1252");
        iana2ora.put("WINDOWS-1253", "EL8MSWIN1253");
        iana2ora.put("WINDOWS-1254", "TR8MSWIN1254");
        iana2ora.put("WINDOWS-1255", "IW8MSWIN1255");
        iana2ora.put("WINDOWS-1256", "AR8MSWIN1256");
        iana2ora.put("WINDOWS-1257", "BLT8MSWIN1257");
        iana2ora.put("WINDOWS-1258", "VN8MSWIN1258");
        iana2ora.put("WINDOWS-31J", "JA16SJIS");
        iana2ora.put("WINDOWS-874", "TH8TISASCII");
        iana2ora.put("WINDOWS-936", "ZHS16GBK");
        iana2ora.put("WINDOWS-949", "KO16MSWIN949");
        iana2ora.put("WINDOWS-950", "ZHT16MSWIN950");
        iana2ora.put("YU", "YUG7ASCII");
    }

    private static void init_iana2java() {
        iana2java = new Hashtable(316);
        iana2java.put("437", "CP437");
        iana2java.put("850", "CP850");
        iana2java.put("852", "CP852");
        iana2java.put("855", "CP855");
        iana2java.put("857", "CP857");
        iana2java.put("860", "CP860");
        iana2java.put("861", "CP861");
        iana2java.put("862", "CP862");
        iana2java.put("863", "CP863");
        iana2java.put("865", "CP865");
        iana2java.put("866", "CP866");
        iana2java.put("869", "CP869");
        iana2java.put("ANSI_X3.4-1968", "US-ASCII");
        iana2java.put("ANSI_X3.4-1986", "US-ASCII");
        iana2java.put("ARABIC", "ISO-8859-6");
        iana2java.put("ASCII", "US-ASCII");
        iana2java.put("ASMO-708", "ISO-8859-6");
        iana2java.put("BIG5", "MS950");
        iana2java.put("BIG5-HKSCS", "MS950_HKSCS");
        iana2java.put("CCSID00858", "Cp858");
        iana2java.put("CCSID01140", "Cp1140");
        iana2java.put("CCSID01141", "Cp1141");
        iana2java.put("CCSID01142", "Cp1142");
        iana2java.put("CCSID01143", "Cp1143");
        iana2java.put("CCSID01144", "Cp1144");
        iana2java.put("CCSID01145", "Cp1145");
        iana2java.put("CCSID01146", "Cp1146");
        iana2java.put("CCSID01147", "Cp1147");
        iana2java.put("CCSID01148", "Cp1148");
        iana2java.put("CESU-8", "UTF-8");
        iana2java.put("CHINESE", "MS936");
        iana2java.put("CP-GR", "CP869");
        iana2java.put("CP-IS", "CP861");
        iana2java.put("CP00858", "Cp858");
        iana2java.put("CP01140", "Cp1140");
        iana2java.put("CP01141", "Cp1141");
        iana2java.put("CP01142", "Cp1142");
        iana2java.put("CP01143", "Cp1143");
        iana2java.put("CP01144", "Cp1144");
        iana2java.put("CP01145", "Cp1145");
        iana2java.put("CP01146", "Cp1146");
        iana2java.put("CP01147", "Cp1147");
        iana2java.put("CP01148", "Cp1148");
        iana2java.put("CP037", "CP037");
        iana2java.put("CP1026", "CP1026");
        iana2java.put("CP273", "CP273");
        iana2java.put("CP278", "CP278");
        iana2java.put("CP280", "CP280");
        iana2java.put("CP284", "CP284");
        iana2java.put("CP285", "CP285");
        iana2java.put("CP297", "CP297");
        iana2java.put("CP367", "US-ASCII");
        iana2java.put("CP420", "CP420");
        iana2java.put("CP424", "CP424");
        iana2java.put("CP437", "CP437");
        iana2java.put("CP500", "CP500");
        iana2java.put("CP775", "CP775");
        iana2java.put("CP819", "ISO-8859-1");
        iana2java.put("CP850", "CP850");
        iana2java.put("CP852", "CP852");
        iana2java.put("CP855", "CP855");
        iana2java.put("CP857", "CP857");
        iana2java.put("CP860", "CP860");
        iana2java.put("CP861", "CP861");
        iana2java.put("CP862", "CP862");
        iana2java.put("CP863", "CP863");
        iana2java.put("CP865", "CP865");
        iana2java.put("CP866", "CP866");
        iana2java.put("CP869", "CP869");
        iana2java.put("CP870", "CP870");
        iana2java.put("CP871", "CP871");
        iana2java.put("CP891", "US-ASCII");
        iana2java.put("CP903", "US-ASCII");
        iana2java.put("CP936", "MS936");
        iana2java.put("CSASCII", "US-ASCII");
        iana2java.put("CSBIG5", "MS950");
        iana2java.put("CSCESU-8", "UTF-8");
        iana2java.put("CSEUCKR", "MS949");
        iana2java.put("CSEUCPKDFMTJAPANESE", "EUC-JP");
        iana2java.put("CSGB2312", "MS936");
        iana2java.put("CSIBM037", "CP037");
        iana2java.put("CSIBM1026", "CP1026");
        iana2java.put("CSIBM273", "CP273");
        iana2java.put("CSIBM277", "IBM277");
        iana2java.put("CSIBM278", "CP278");
        iana2java.put("CSIBM280", "CP280");
        iana2java.put("CSIBM284", "CP284");
        iana2java.put("CSIBM285", "CP285");
        iana2java.put("CSIBM297", "CP297");
        iana2java.put("CSIBM420", "CP420");
        iana2java.put("CSIBM424", "CP424");
        iana2java.put("CSIBM500", "CP500");
        iana2java.put("CSIBM855", "CP855");
        iana2java.put("CSIBM857", "CP857");
        iana2java.put("CSIBM860", "CP860");
        iana2java.put("CSIBM861", "CP861");
        iana2java.put("CSIBM863", "CP863");
        iana2java.put("CSIBM865", "CP865");
        iana2java.put("CSIBM866", "CP866");
        iana2java.put("CSIBM869", "CP869");
        iana2java.put("CSIBM870", "CP870");
        iana2java.put("CSIBM871", "CP871");
        iana2java.put("CSIBM891", "US-ASCII");
        iana2java.put("CSIBM903", "US-ASCII");
        iana2java.put("CSISO2022JP", "ISO-2022-JP");
        iana2java.put("CSISO2022KR", "ISO-2022-KR");
        iana2java.put("CSISO58GB231280", "MS936");
        iana2java.put("CSISO88596I", "ISO-8859-6");
        iana2java.put("CSISO88598I", "ISO-8859-8");
        iana2java.put("CSISOLATIN1", "ISO-8859-1");
        iana2java.put("CSISOLATIN2", "ISO-8859-2");
        iana2java.put("CSISOLATIN3", "ISO-8859-3");
        iana2java.put("CSISOLATIN4", "ISO-8859-4");
        iana2java.put("CSISOLATIN5", "ISO-8859-9");
        iana2java.put("CSISOLATINARABIC", "ISO-8859-6");
        iana2java.put("CSISOLATINCYRILLIC", "ISO-8859-5");
        iana2java.put("CSISOLATINGREEK", "ISO-8859-7");
        iana2java.put("CSJISENCODING", "ISO-2022-JP");
        iana2java.put("CSKOI8R", "KOI8-R");
        iana2java.put("CSKSC56011987", "MS949");
        iana2java.put("CSMACINTOSH", "MacRoman");
        iana2java.put("CSPC775BALTIC", "CP775");
        iana2java.put("CSPC850MULTILINGUAL", "CP850");
        iana2java.put("CSPC862LATINHEBREW", "CP862");
        iana2java.put("CSPC8CODEPAGE437", "CP437");
        iana2java.put("CSPCP852", "CP852");
        iana2java.put("CSSHIFTJIS", "MS932");
        iana2java.put("CSUNICODE", "UTF-16");
        iana2java.put("CSUSDK", "US-ASCII");
        iana2java.put("CSWINDOWS30LATIN1", "WINDOWS-1252");
        iana2java.put("CSWINDOWS31J", "MS932");
        iana2java.put("CSWINDOWS31LATIN1", "WINDOWS-1252");
        iana2java.put("CSWINDOWS31LATIN2", "WINDOWS-1250");
        iana2java.put("CSWINDOWS31LATIN5", "WINDOWS-1254");
        iana2java.put("CYRILLIC", "ISO-8859-5");
        iana2java.put("EBCDIC-CP-AR1", "CP420");
        iana2java.put("EBCDIC-CP-BE", "CP500");
        iana2java.put("EBCDIC-CP-CA", "CP037");
        iana2java.put("EBCDIC-CP-CH", "CP500");
        iana2java.put("EBCDIC-CP-DK", "IBM277");
        iana2java.put("EBCDIC-CP-ES", "CP284");
        iana2java.put("EBCDIC-CP-FI", "CP278");
        iana2java.put("EBCDIC-CP-FR", "CP297");
        iana2java.put("EBCDIC-CP-GB", "CP285");
        iana2java.put("EBCDIC-CP-HE", "CP424");
        iana2java.put("EBCDIC-CP-IS", "CP871");
        iana2java.put("EBCDIC-CP-IT", "CP280");
        iana2java.put("EBCDIC-CP-NL", "CP037");
        iana2java.put("EBCDIC-CP-NO", "IBM277");
        iana2java.put("EBCDIC-CP-ROECE", "CP870");
        iana2java.put("EBCDIC-CP-SE", "CP278");
        iana2java.put("EBCDIC-CP-US", "CP037");
        iana2java.put("EBCDIC-CP-WT", "CP037");
        iana2java.put("EBCDIC-CP-YU", "CP870");
        iana2java.put("EBCDIC-DE-273+EURO", "Cp1141");
        iana2java.put("EBCDIC-DK-277+EURO", "Cp1142");
        iana2java.put("EBCDIC-ES-284+EURO", "Cp1145");
        iana2java.put("EBCDIC-FI-278+EURO", "Cp1143");
        iana2java.put("EBCDIC-FR-297+EURO", "Cp1147");
        iana2java.put("EBCDIC-GB-285+EURO", "Cp1146");
        iana2java.put("EBCDIC-INTERNATIONAL-500+EURO", "Cp1148");
        iana2java.put("EBCDIC-IT-280+EURO", "Cp1144");
        iana2java.put("EBCDIC-NO-277+EURO", "Cp1142");
        iana2java.put("EBCDIC-SE-278+EURO", "Cp1143");
        iana2java.put("EBCDIC-US-37+EURO", "Cp1140");
        iana2java.put("ECMA-114", "ISO-8859-6");
        iana2java.put("ECMA-118", "ISO-8859-7");
        iana2java.put("ELOT_928", "ISO-8859-7");
        iana2java.put("EUC-JP", "EUC-JP");
        iana2java.put("EUC-KR", "MS949");
        iana2java.put("EUC-TW", "EUC-TW");
        iana2java.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "EUC-JP");
        iana2java.put("GB18030", "GB18030");
        iana2java.put("GB2312", "MS936");
        iana2java.put("GBK", "MS936");
        iana2java.put("GB_2312-80", "MS936");
        iana2java.put("GREEK", "ISO-8859-7");
        iana2java.put("GREEK8", "ISO-8859-7");
        iana2java.put("IBM00858", "Cp858");
        iana2java.put("IBM01140", "Cp1140");
        iana2java.put("IBM01141", "Cp1141");
        iana2java.put("IBM01142", "Cp1142");
        iana2java.put("IBM01143", "Cp1143");
        iana2java.put("IBM01144", "Cp1144");
        iana2java.put("IBM01145", "Cp1145");
        iana2java.put("IBM01146", "Cp1146");
        iana2java.put("IBM01147", "Cp1147");
        iana2java.put("IBM01148", "Cp1148");
        iana2java.put("IBM037", "CP037");
        iana2java.put("IBM1026", "CP1026");
        iana2java.put("IBM273", "CP273");
        iana2java.put("IBM277", "IBM277");
        iana2java.put("IBM278", "CP278");
        iana2java.put("IBM280", "CP280");
        iana2java.put("IBM284", "CP284");
        iana2java.put("IBM285", "CP285");
        iana2java.put("IBM297", "CP297");
        iana2java.put("IBM367", "US-ASCII");
        iana2java.put("IBM420", "CP420");
        iana2java.put("IBM424", "CP424");
        iana2java.put("IBM437", "CP437");
        iana2java.put("IBM500", "CP500");
        iana2java.put("IBM775", "CP775");
        iana2java.put("IBM819", "ISO-8859-1");
        iana2java.put("IBM850", "CP850");
        iana2java.put("IBM852", "CP852");
        iana2java.put("IBM855", "CP855");
        iana2java.put("IBM857", "CP857");
        iana2java.put("IBM860", "CP860");
        iana2java.put("IBM861", "CP861");
        iana2java.put("IBM862", "CP862");
        iana2java.put("IBM863", "CP863");
        iana2java.put("IBM865", "CP865");
        iana2java.put("IBM866", "CP866");
        iana2java.put("IBM869", "CP869");
        iana2java.put("IBM870", "CP870");
        iana2java.put("IBM871", "CP871");
        iana2java.put("IBM891", "US-ASCII");
        iana2java.put("IBM903", "US-ASCII");
        iana2java.put("ISO-10646-UCS-2", "UTF-16");
        iana2java.put("ISO-2022-CN", "ISO2022CN_GB");
        iana2java.put("ISO-2022-JP", "ISO-2022-JP");
        iana2java.put("ISO-2022-KR", "ISO-2022-KR");
        iana2java.put("ISO-8859-1", "ISO-8859-1");
        iana2java.put("ISO-8859-1-WINDOWS-3.0-LATIN-1", "WINDOWS-1252");
        iana2java.put("ISO-8859-1-WINDOWS-3.1-LATIN-1", "WINDOWS-1252");
        iana2java.put("ISO-8859-13", "ISO-8859-13");
        iana2java.put("ISO-8859-15", "ISO-8859-15");
        iana2java.put("ISO-8859-2", "ISO-8859-2");
        iana2java.put("ISO-8859-2-WINDOWS-LATIN-2", "WINDOWS-1250");
        iana2java.put("ISO-8859-3", "ISO-8859-3");
        iana2java.put("ISO-8859-4", "ISO-8859-4");
        iana2java.put("ISO-8859-5", "ISO-8859-5");
        iana2java.put("ISO-8859-6", "ISO-8859-6");
        iana2java.put("ISO-8859-6-I", "ISO-8859-6");
        iana2java.put("ISO-8859-7", "ISO-8859-7");
        iana2java.put("ISO-8859-8-I", "ISO-8859-8");
        iana2java.put("ISO-8859-9", "ISO-8859-9");
        iana2java.put("ISO-8859-9-WINDOWS-LATIN-5", "WINDOWS-1254");
        iana2java.put("ISO-IR-100", "ISO-8859-1");
        iana2java.put("ISO-IR-101", "ISO-8859-2");
        iana2java.put("ISO-IR-109", "ISO-8859-3");
        iana2java.put("ISO-IR-110", "ISO-8859-4");
        iana2java.put("ISO-IR-126", "ISO-8859-7");
        iana2java.put("ISO-IR-127", "ISO-8859-6");
        iana2java.put("ISO-IR-144", "ISO-8859-5");
        iana2java.put("ISO-IR-148", "ISO-8859-9");
        iana2java.put("ISO-IR-149", "MS949");
        iana2java.put("ISO-IR-58", "MS936");
        iana2java.put("ISO-IR-6", "US-ASCII");
        iana2java.put("ISO646-US", "US-ASCII");
        iana2java.put("ISO_646.IRV:1991", "US-ASCII");
        iana2java.put("ISO_8859-1", "ISO-8859-1");
        iana2java.put("ISO_8859-15", "ISO-8859-15");
        iana2java.put("ISO_8859-1:1987", "ISO-8859-1");
        iana2java.put("ISO_8859-2", "ISO-8859-2");
        iana2java.put("ISO_8859-2:1987", "ISO-8859-2");
        iana2java.put("ISO_8859-3", "ISO-8859-3");
        iana2java.put("ISO_8859-3:1988", "ISO-8859-3");
        iana2java.put("ISO_8859-4", "ISO-8859-4");
        iana2java.put("ISO_8859-4:1988", "ISO-8859-4");
        iana2java.put("ISO_8859-5", "ISO-8859-5");
        iana2java.put("ISO_8859-5:1988", "ISO-8859-5");
        iana2java.put("ISO_8859-6", "ISO-8859-6");
        iana2java.put("ISO_8859-6-I", "ISO-8859-6");
        iana2java.put("ISO_8859-6:1987", "ISO-8859-6");
        iana2java.put("ISO_8859-7", "ISO-8859-7");
        iana2java.put("ISO_8859-7:1987", "ISO-8859-7");
        iana2java.put("ISO_8859-8-I", "ISO-8859-8");
        iana2java.put("ISO_8859-9", "ISO-8859-9");
        iana2java.put("ISO_8859-9:1989", "ISO-8859-9");
        iana2java.put("JIS_ENCODING", "ISO-2022-JP");
        iana2java.put("KOI8-R", "KOI8-R");
        iana2java.put("KOREAN", "MS949");
        iana2java.put("KSC_5601", "MS949");
        iana2java.put("KS_C_5601-1987", "MS949");
        iana2java.put("KS_C_5601-1989", "MS949");
        iana2java.put("L1", "ISO-8859-1");
        iana2java.put("L2", "ISO-8859-2");
        iana2java.put("L3", "ISO-8859-3");
        iana2java.put("L4", "ISO-8859-4");
        iana2java.put("L5", "ISO-8859-9");
        iana2java.put("LATIN-9", "ISO-8859-15");
        iana2java.put("LATIN1", "ISO-8859-1");
        iana2java.put("LATIN2", "ISO-8859-2");
        iana2java.put("LATIN3", "ISO-8859-3");
        iana2java.put("LATIN4", "ISO-8859-4");
        iana2java.put("LATIN5", "ISO-8859-9");
        iana2java.put("MAC", "MacRoman");
        iana2java.put("MACINTOSH", "MacRoman");
        iana2java.put("MS936", "MS936");
        iana2java.put("MS_KANJI", "MS932");
        iana2java.put("PC-MULTILINGUAL-850+EURO", "Cp858");
        iana2java.put("SHIFT_JIS", "MS932");
        iana2java.put("TIS-620", "MS874");
        iana2java.put("US", "US-ASCII");
        iana2java.put("US-ASCII", "US-ASCII");
        iana2java.put("US-DK", "US-ASCII");
        iana2java.put("UTF-16", "UTF-16");
        iana2java.put("UTF-16BE", "UTF-16BE");
        iana2java.put("UTF-16LE", "UTF-16LE");
        iana2java.put("UTF-8", "UTF-8");
        iana2java.put("WINDOWS-1250", "WINDOWS-1250");
        iana2java.put("WINDOWS-1251", "WINDOWS-1251");
        iana2java.put("WINDOWS-1252", "WINDOWS-1252");
        iana2java.put("WINDOWS-1253", "WINDOWS-1253");
        iana2java.put("WINDOWS-1254", "WINDOWS-1254");
        iana2java.put("WINDOWS-1255", "WINDOWS-1255");
        iana2java.put("WINDOWS-1256", "WINDOWS-1256");
        iana2java.put("WINDOWS-1257", "WINDOWS-1257");
        iana2java.put("WINDOWS-1258", "WINDOWS-1258");
        iana2java.put("WINDOWS-31J", "MS932");
        iana2java.put("WINDOWS-874", "MS874");
        iana2java.put("WINDOWS-936", "MS936");
        iana2java.put("WINDOWS-949", "MS949");
        iana2java.put("WINDOWS-950", "MS950");
    }

    private static void init_mailUnix() {
        mailUnix = new Hashtable(48);
        mailUnix.put("ar", arabic);
        mailUnix.put("bg", cyrillic);
        mailUnix.put("ca", western);
        mailUnix.put("cs", eastern);
        mailUnix.put("da", western);
        mailUnix.put("de", western);
        mailUnix.put("el", greek);
        mailUnix.put("en", english);
        mailUnix.put("es", western);
        mailUnix.put("et", baltic);
        mailUnix.put("fi", western);
        mailUnix.put("fr", western);
        mailUnix.put("gu", unicode);
        mailUnix.put("he", hebrew);
        mailUnix.put("hi", unicode);
        mailUnix.put("hr", eastern);
        mailUnix.put("hu", eastern);
        mailUnix.put("in", western);
        mailUnix.put("is", western);
        mailUnix.put("it", western);
        mailUnix.put("iw", hebrew);
        mailUnix.put("ja", japanese);
        mailUnix.put("kn", unicode);
        mailUnix.put("ko", korean);
        mailUnix.put("lt", baltic);
        mailUnix.put("lv", baltic);
        mailUnix.put("mr", unicode);
        mailUnix.put("ms", western);
        mailUnix.put("nl", western);
        mailUnix.put("no", western);
        mailUnix.put("pa", unicode);
        mailUnix.put("pl", eastern);
        mailUnix.put("pt", western);
        mailUnix.put("ro", eastern);
        mailUnix.put("ru", cyrillic);
        mailUnix.put("sk", eastern);
        mailUnix.put("sl", eastern);
        mailUnix.put("sv", western);
        mailUnix.put("ta", unicode);
        mailUnix.put("te", unicode);
        mailUnix.put("th", thai);
        mailUnix.put("tr", turkish);
        mailUnix.put("uk", cyrillic);
        mailUnix.put("vi", vietnamese);
        mailUnix.put("zh_CN", simplifiedChinese);
        mailUnix.put("zh_HK", traditionalChinese);
        mailUnix.put("zh_SG", simplifiedChinese);
        mailUnix.put("zh_TW", traditionalChinese);
    }

    public static String getIANACharacterSet(int from, String charset) {
        if (from != 1) {
            return null;
        }
        if (ora2iana == null) {
            LocaleMapper.init_ora2iana();
        }
        return (String)ora2iana.get(charset.toUpperCase(Locale.US));
    }

    public static String getOraCharacterSet(int from, String charset) {
        if (from != 2) {
            return null;
        }
        if (iana2ora == null) {
            LocaleMapper.init_iana2ora();
        }
        return (String)iana2ora.get(charset.toUpperCase(Locale.US));
    }

    public static String getJavaCharacterSet(int from, String charset) {
        if (from != 2) {
            return null;
        }
        if (iana2java == null) {
            LocaleMapper.init_iana2java();
        }
        return (String)iana2java.get(charset.toUpperCase(Locale.US));
    }

    public static String[] getIANACharSetFromLocale(int context, Locale locale) {
        String lang;
        String[] emailEncodings;
        if (context != 5) {
            return null;
        }
        if (mailUnix == null) {
            LocaleMapper.init_mailUnix();
        }
        if ((emailEncodings = (String[])mailUnix.get((lang = locale.getLanguage()) + "_" + locale.getCountry())) == null && (emailEncodings = (String[])mailUnix.get(lang)) == null) {
            emailEncodings = unicode;
        }
        return emailEncodings;
    }

    static {
        english = new String[]{"ISO-8859-1", "US-ASCII", "WINDOWS-1252", "UTF-8", "ISO-8859-15"};
        western = new String[]{"ISO-8859-1", "WINDOWS-1252", "UTF-8", "ISO-8859-15"};
        eastern = new String[]{"ISO-8859-2", "WINDOWS-1250", "UTF-8"};
        baltic = new String[]{"ISO-8859-4", "WINDOWS-1257", "ISO-8859-13", "UTF-8"};
        cyrillic = new String[]{"ISO-8859-5", "WINDOWS-1251", "UTF-8"};
        arabic = new String[]{"ISO-8859-6", "WINDOWS-1256", "UTF-8"};
        greek = new String[]{"ISO-8859-7", "WINDOWS-1253", "UTF-8"};
        hebrew = new String[]{"UTF-8", "ISO-8859-8-I", "WINDOWS-1255"};
        turkish = new String[]{"ISO-8859-9", "WINDOWS-1254", "UTF-8"};
        thai = new String[]{"UTF-8", "TIS-620"};
        vietnamese = new String[]{"UTF-8", "WINDOWS-1258"};
        japanese = new String[]{"ISO-2022-JP", "UTF-8"};
        korean = new String[]{"EUC-KR", "UTF-8"};
        simplifiedChinese = new String[]{"GBK", "UTF-8", "GB18030"};
        traditionalChinese = new String[]{"BIG5", "UTF-8", "BIG5-HKSCS"};
        unicode = new String[]{"UTF-8"};
    }
}

