/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.jndi;

import java.util.Hashtable;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;

public class LdapSasl {
    public static void main(String[] args) throws Exception {
        int numofargs = args.length;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", "ldap://" + args[0] + ":" + args[1]);
        hashtable.put("java.naming.security.authentication", "DIGEST-MD5");
        System.out.println("hash put security dn: " + args[2]);
        hashtable.put("java.naming.security.principal", args[2]);
        hashtable.put("java.naming.security.credentials", args[3]);
        hashtable.put("javax.naming.security.sasl.realm", args[5]);
        if (numofargs > 4) {
            String strength = "high";
            String cipher = new String(args[6]);
            if (cipher.compareToIgnoreCase("rc4-40") == 0) {
                strength = "low";
            } else if (cipher.compareToIgnoreCase("rc4-56") == 0 || cipher.compareToIgnoreCase("des") == 0) {
                strength = "medium";
            } else if (cipher.compareToIgnoreCase("3des") == 0 || cipher.compareToIgnoreCase("rc4") == 0) {
                strength = "high";
            }
            System.out.println("hash sasl.qop: " + args[4]);
            hashtable.put("javax.security.sasl.qop", args[4]);
            if (args[4].equalsIgnoreCase("AUTH-CONF")) {
                System.out.println("hash sasl.strength:" + strength);
                hashtable.put("javax.security.sasl.strength", strength);
            }
            if (numofargs > 7 && !"".equals(args[6])) {
                hashtable.put("javax.security.sasl.maxbuf", args[5].toString());
            }
        }
        InitialLdapContext ctx = new InitialLdapContext(hashtable, null);
        System.out.println("sasl bind successful");
        PropertySetCollection psc = Util.ldapSearch(ctx, "o=oracle,dc=com", "objectclass=*", 0, new String[]{"*"});
        Util.printResults(psc);
        System.exit(0);
    }
}

