/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.jndi;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class LDAPTrustManager
implements X509TrustManager {
    private final X509TrustManager m_standardTrustManager;
    private final boolean m_ibmJSSE;

    public LDAPTrustManager(X509TrustManager trustManager, boolean ibmJSSE) {
        this.m_standardTrustManager = trustManager;
        this.m_ibmJSSE = ibmJSSE;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.m_standardTrustManager.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.m_ibmJSSE && authType.equals("DH_anon")) {
            return;
        }
        this.m_standardTrustManager.checkServerTrusted(chain, authType);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.m_standardTrustManager.getAcceptedIssuers();
    }

    public static X509TrustManager[] wrap(TrustManager[] trustManagers, boolean ibmJSSE) {
        X509TrustManager[] newTrustManagers = new LDAPTrustManager[trustManagers.length];
        for (int i = 0; i < trustManagers.length; ++i) {
            newTrustManagers[i] = new LDAPTrustManager((X509TrustManager)trustManagers[i], ibmJSSE);
        }
        return newTrustManagers;
    }
}

