/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.jndi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public abstract class LDAPSocketFactory
extends SocketFactory {
    public static final String WALLET_LOCATION = "oracle.ldap.wltloc";
    public static final String WALLET_PASSWORD = "oracle.ldap.wltpass";
    protected static SSLSocketFactory sslf = null;

    public Socket createSocket(String s, int i) throws IOException {
        SSLSocket sock = (SSLSocket)sslf.createSocket(s, i);
        return this.init(sock);
    }

    public Socket createSocket(InetAddress iaddr, int i) throws IOException {
        SSLSocket sock = (SSLSocket)sslf.createSocket(iaddr, i);
        return this.init(sock);
    }

    public Socket createSocket(String s, int i, InetAddress iaddr, int j) throws IOException {
        SSLSocket sock = (SSLSocket)sslf.createSocket(s, i, iaddr, j);
        return this.init(sock);
    }

    public Socket createSocket(InetAddress iaddr1, int i, InetAddress iaddr2, int j) throws IOException {
        SSLSocket sock = (SSLSocket)sslf.createSocket(iaddr1, i, iaddr2, j);
        return this.init(sock);
    }

    protected abstract SSLSocket init(SSLSocket var1) throws IOException;

    public String[] addAnonymousCiphers() {
        ArrayList<String> anonCipherList = new ArrayList<String>();
        String[] cipher = sslf.getSupportedCipherSuites();
        for (int i = 0; i < cipher.length; ++i) {
            if (cipher[i].indexOf("_anon_") < 0) continue;
            anonCipherList.add(cipher[i]);
        }
        String[] enabledCipherSuites = null;
        String[] defaultCipherSuites = sslf.getDefaultCipherSuites();
        String[] anonCiphers = anonCipherList.toArray(new String[0]);
        if (anonCiphers.length > 0) {
            enabledCipherSuites = new String[defaultCipherSuites.length + anonCiphers.length];
            System.arraycopy(defaultCipherSuites, 0, enabledCipherSuites, 0, defaultCipherSuites.length);
            System.arraycopy(anonCiphers, 0, enabledCipherSuites, defaultCipherSuites.length, anonCiphers.length);
        } else {
            enabledCipherSuites = defaultCipherSuites;
        }
        return enabledCipherSuites;
    }

    protected static SSLSocketFactory initSSLSocketFactory(KeyManager[] keyManagers, TrustManager[] trustManagers) throws Exception {
        String protocol = "SSL";
        Provider[] providers = Security.getProviders("SSLContext.SSL");
        if (providers[0].getName().indexOf("IBMJSSE") >= 0) {
            protocol = "SSL_TLS";
        }
        SSLContext context = SSLContext.getInstance(protocol);
        context.init(keyManagers, trustManagers, new SecureRandom());
        return context.getSocketFactory();
    }
}

