/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.jndi;

import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.discovery.DiscoveryHelper;
import oracle.ldap.util.jndi.ConnectionThread;

public class ConnectionUtil {
    private DirContext nonSSLctx = null;
    private String host = null;
    private String port = null;

    public static String discoverSSLPort(String host, String port, String bindDN, String bindPwd) throws NamingException {
        InitialLdapContext ctx = ConnectionUtil.getDefaultDirCtx(host, port, bindDN, bindPwd);
        String[] attrList = new String[]{"orclsslport"};
        PropertySetCollection propSetCol = Util.getEntryDetails(ctx, "cn=configset0, cn=osdldapd, cn=subconfigsubentry", "(objectclass=*)", 0, attrList);
        String sslport = (String)propSetCol.getPropertySet(0).getProperty(0).getValue(0);
        ctx.close();
        return sslport;
    }

    public static InitialLdapContext getDefaultDirCtx(String host, String port, String bindDN, String bindPwd, long timelimit) throws NamingException {
        Hashtable hashtable = ConnectionUtil.createCtxHash(host, port, bindDN, bindPwd);
        return ConnectionUtil.returnInitialLdapContext(hashtable, null, timelimit);
    }

    public static InitialLdapContext getDefaultDirCtx(String host, String port, String bindDN, String bindPwd) throws NamingException {
        return ConnectionUtil.getDefaultDirCtx(host, port, bindDN, bindPwd, 10000L);
    }

    public static InitialLdapContext getDefaultDirCtx(DiscoveryHelper discObj, String bindDN, String bindPwd) throws NamingException {
        InitialLdapContext ldapctx = null;
        HashMap reshdl = new HashMap();
        ArrayList result = null;
        int size = 0;
        switch (discObj.discoveryType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new NoInitialContextException();
            }
        }
        String ssl = discObj.getProperty("3");
        if (ssl != null && !"0".equals(ssl)) {
            throw new NoInitialContextException();
        }
        if (discObj.discover(reshdl) == 0) {
            result = (ArrayList)reshdl.get(DiscoveryHelper.DIR_SERVERS);
            if (result == null) {
                throw new NoInitialContextException();
            }
            size = result.size();
            for (int i = 0; i < size; ++i) {
                String hostinfo = (String)result.get(i);
                int idx = hostinfo.indexOf(58);
                if (idx == -1) continue;
                String hostname = hostinfo.substring(0, idx);
                String port = hostinfo.substring(idx + 1);
                Hashtable hashtable = ConnectionUtil.createCtxHash(hostname, port, bindDN, bindPwd);
                try {
                    ldapctx = new InitialLdapContext(hashtable, null);
                    break;
                }
                catch (CommunicationException cexp) {
                    // empty catch block
                }
            }
        }
        if (ldapctx == null) {
            throw new NoInitialContextException();
        }
        return ldapctx;
    }

    public static InitialLdapContext getSSLDirCtx(String host, String port, String bindDN, String bindPwd) throws NamingException {
        return ConnectionUtil.getSSLDirCtx(host, port, bindDN, bindPwd, "oracle.ldap.util.jndi.LDAPJSSESocketFactoryImpl");
    }

    public static InitialLdapContext getSSLDirCtx(String host, String port, String bindDN, String bindPwd, String sslSocketFactory) throws NamingException {
        Hashtable hashtable = ConnectionUtil.createCtxHash(host, port, bindDN, bindPwd);
        hashtable.put("java.naming.ldap.factory.socket", sslSocketFactory);
        hashtable.put("java.naming.security.protocol", "ssl");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        int i = 0;
        while (true) {
            ++i;
            try {
                return new InitialLdapContext(hashtable, null);
            }
            catch (NamingException ne) {
                Throwable t;
                if (((t = ne.getRootCause()) instanceof SSLHandshakeException || t instanceof SSLException) && i <= 2) continue;
                throw ne;
            }
            break;
        }
    }

    public static InitialLdapContext getSSLDirCtx(DiscoveryHelper discObj, String bindDN, String bindPwd) throws NamingException {
        InitialLdapContext ldapctx = null;
        HashMap reshdl = new HashMap();
        ArrayList result = null;
        int size = 0;
        switch (discObj.discoveryType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new NoInitialContextException();
            }
        }
        String ssl = discObj.getProperty("3");
        if (!"1".equals(ssl)) {
            throw new NoInitialContextException();
        }
        if (discObj.discover(reshdl) == 0) {
            result = (ArrayList)reshdl.get(DiscoveryHelper.DIR_SERVERS);
            if (result == null) {
                throw new NoInitialContextException();
            }
            size = result.size();
            for (int i = 0; i < size; ++i) {
                String hostinfo = (String)result.get(i);
                int idx = hostinfo.indexOf(58);
                if (idx == -1) continue;
                String hostname = hostinfo.substring(0, idx);
                String port = hostinfo.substring(idx + 1);
                Hashtable hashtable = ConnectionUtil.createCtxHash(hostname, port, bindDN, bindPwd);
                Properties sysprop = System.getProperties();
                sysprop.put("SSLSocketFactoryImplClass", "oracle.ldap.util.jndi.LDAPJSSESocketFactoryImpl");
                Security.setProperty("ssl.SocketFactory.provider", "oracle.ldap.util.jndi.LDAPJSSESocketFactoryImpl");
                hashtable.put("java.naming.ldap.factory.socket", "oracle.ldap.util.jndi.LDAPJSSESocketFactoryImpl");
                hashtable.put("java.naming.security.protocol", "ssl");
                try {
                    ldapctx = new InitialLdapContext(hashtable, null);
                    break;
                }
                catch (CommunicationException cexp) {
                    // empty catch block
                }
            }
        }
        if (ldapctx == null) {
            throw new NoInitialContextException();
        }
        return ldapctx;
    }

    private static Hashtable createCtxHash(String host, String port, String bindDN, String bindPwd) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<Object> e = System.getProperties().keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("java.naming.") || System.getProperty(key).equals("com.evermind.server.ApplicationInitialContextFactory")) continue;
            hashtable.put(key, System.getProperty(key));
        }
        if (hashtable.get("java.naming.factory.initial") == null) {
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        } else if (hashtable.get("java.naming.factory.initial").equals("weblogic.jndi.WLInitialContextFactory")) {
            hashtable.remove("java.naming.factory.initial");
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        hashtable.put("java.naming.provider.url", "ldap://" + host + ":" + port + "/");
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", bindDN);
        hashtable.put("java.naming.security.credentials", bindPwd);
        hashtable.put("java.naming.referral", "follow");
        return hashtable;
    }

    private static InitialLdapContext returnInitialLdapContext(Hashtable ht, Control[] ctls, long timelimit) throws NamingException {
        ConnectionThread t = new ConnectionThread(ht, ctls);
        t.start();
        try {
            t.join(timelimit);
        }
        catch (InterruptedException ie) {
            throw new CommunicationException("Thread InterruptedException encountered - enable to create JNDI connection");
        }
        InitialLdapContext ctx = t.returnCtx();
        if (t.isAlive() && ctx == null) {
            t.interrupt();
            throw new CommunicationException("returnInitialLdapContext() times out after " + timelimit + " ms - JNDI initialization method not returning");
        }
        if (ctx == null) {
            NamingException ne = t.returnNamingException();
            ne.fillInStackTrace();
            throw ne;
        }
        return ctx;
    }
}

