/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import oracle.ldap.util.install.Component;
import oracle.ldap.util.install.PropertyType;

public class InstallParameters {
    private static final String LDAP_UTIL_INSTALL_PACKAGE = "oracle.ldap.util.install";
    private static final String PARAMETER_FILE_SUFFIX = "_parameterList.xml";
    private String parametersFileName;
    private Map properties = new HashMap();
    private String componentType;

    public InstallParameters(String componentName) {
        this.parametersFileName = componentName.toUpperCase() + PARAMETER_FILE_SUFFIX;
        this.readProperties();
    }

    private void readProperties() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)LDAP_UTIL_INSTALL_PACKAGE);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Component installTarget = (Component)unmarshaller.unmarshal((InputStream)this.getInputStream());
            this.getInstallParameters(installTarget);
        }
        catch (JAXBException jex) {
            System.out.println("XML Processing Error");
            jex.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            System.out.println("The XML Parameter file " + this.parametersFileName + " should be present in the same directory from which" + "you are invoking the ANT script. Alternatively it" + " should be in $oracle.home/install and the oracle.home" + " system property must be set");
            e.printStackTrace();
        }
    }

    private FileInputStream getInputStream() throws FileNotFoundException {
        if (new File(this.parametersFileName).exists()) {
            return new FileInputStream(this.parametersFileName);
        }
        String oraHome = System.getProperty("oracle.home") != null ? System.getProperty("oracle.home") : System.getProperty("ORACLE_HOME");
        return new FileInputStream(oraHome + File.separator + "install" + File.separator + this.parametersFileName);
    }

    private void getInstallParameters(Component installTarget) {
        List dipProps = installTarget.getProperty();
        Iterator iter = dipProps.iterator();
        while (iter.hasNext()) {
            PropertyType installProperty = (PropertyType)iter.next();
            this.properties.put(installProperty.getNAME(), installProperty.getVALUE());
        }
    }

    public String getParameter(String installParam) {
        return (String)this.properties.get(installParam);
    }

    public String getComponentType() {
        return this.componentType;
    }
}

