/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.guid;

public class GUIDUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int NUM_BITS_IN_BYTE = 8;
    private static final int NUM_BYTES_IN_LONG = 8;

    public static short toShort(byte[] bytes) {
        return (short)(bytes[0] << 8 | bytes[1]);
    }

    public static String toHexString(byte[] byteArray) {
        return new String(GUIDUtils.toCharArray(byteArray));
    }

    private static char[] toCharArray(byte[] byteArray) {
        int arrayLength = byteArray.length;
        char[] charArray = new char[2 * arrayLength];
        int j = 0;
        for (int i = 0; i < arrayLength; ++i) {
            charArray[j++] = HEX_DIGITS[(byteArray[i] & 0xF0) >>> 4];
            charArray[j++] = HEX_DIGITS[byteArray[i] & 0xF];
        }
        return charArray;
    }

    public static byte[] toByteArray(String hexString) {
        char[] hexCharacters = hexString.toCharArray();
        int numBytes = hexCharacters.length / 2;
        byte[] byteArray = new byte[numBytes];
        int hexCharIndex = 0;
        int MSHexDigit = 0;
        int LSHexDigit = 0;
        for (int i = 0; i < numBytes; ++i) {
            MSHexDigit = Character.digit(hexCharacters[hexCharIndex++], 16) << 4;
            LSHexDigit = Character.digit(hexCharacters[hexCharIndex++], 16);
            byteArray[i] = (byte)(MSHexDigit | LSHexDigit);
        }
        return byteArray;
    }

    static byte[] toByteArray(long longValue) {
        byte[] byteArray = new byte[8];
        int i = 0;
        int j = 7;
        while (i < 8) {
            byteArray[j] = (byte)longValue;
            longValue >>= 8;
            ++i;
            --j;
        }
        return byteArray;
    }
}

