/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.guid;

import oracle.ldap.util.guid.GUIDClock;
import oracle.ldap.util.guid.GUIDParamGenerator;
import oracle.ldap.util.guid.GUIDParams;

final class GUIDStateManager {
    private long lastTimeStamp;
    private short clockSequence;
    private byte[] nodeID;
    private static GUIDStateManager instance = new GUIDStateManager();

    private GUIDStateManager() {
        this.initializeGUIDParameters();
    }

    static GUIDStateManager getInstance() {
        return instance;
    }

    GUIDParams nextGUIDParams() {
        GUIDParams nextGuidParams = new GUIDParams();
        nextGuidParams.setTimeStamp(this.getTimeStamp());
        nextGuidParams.setClockSequence(this.getClockSequence());
        nextGuidParams.setNodeID(this.nodeID);
        return nextGuidParams;
    }

    private void initializeGUIDParameters() {
        this.nodeID = GUIDParamGenerator.generateNodeID();
        this.clockSequence = GUIDParamGenerator.generateClockSequence();
        this.lastTimeStamp = GUIDClock.getInstance().getTime();
    }

    private long getTimeStamp() {
        long currentTimeStamp = GUIDClock.getInstance().getTime();
        if (this.isTimeSetBackward(currentTimeStamp)) {
            this.incrementClockSequence();
        }
        this.lastTimeStamp = currentTimeStamp;
        return currentTimeStamp;
    }

    boolean isTimeSetBackward(long currentTimeStamp) {
        return currentTimeStamp < this.lastTimeStamp;
    }

    void incrementClockSequence() {
        this.clockSequence = (short)(this.clockSequence + 1);
    }

    private short getClockSequence() {
        return this.clockSequence;
    }
}

