/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.guid;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Iterator;
import oracle.ldap.util.guid.GUIDUtils;

class GUIDParamGenerator {
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA-1";
    private static final int NODE_ADDRESS_SIZE_IN_BYTES = 6;
    private static final int BYTE_WITH_MULTICAST_BIT_SET = 1;
    private static final int NUM_BYTES_IN_SHORT = 2;
    private static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";

    GUIDParamGenerator() {
    }

    static byte[] generateNodeID() {
        byte[] nodeHash = GUIDParamGenerator.computeNodeHash();
        byte[] nodeID = new byte[6];
        System.arraycopy(nodeHash, 0, nodeID, 0, 6);
        nodeID[0] = (byte)(nodeID[0] | 1);
        return nodeID;
    }

    private static byte[] computeNodeHash() {
        byte[] hash = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
            InetAddress nodeAddress = InetAddress.getLocalHost();
            if (!nodeAddress.isLoopbackAddress()) {
                messageDigest.update(nodeAddress.getCanonicalHostName().getBytes());
                messageDigest.update(nodeAddress.getAddress());
            }
            Collection<Object> systemValues = System.getProperties().values();
            Iterator<Object> systemValuesIter = systemValues.iterator();
            while (systemValuesIter.hasNext()) {
                messageDigest.update(((String)systemValuesIter.next()).getBytes());
            }
            hash = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hash;
    }

    static short generateClockSequence() {
        SecureRandom randomGenerator = null;
        try {
            randomGenerator = SecureRandom.getInstance(SECURE_RANDOM_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] randomBytes = new byte[2];
        randomGenerator.nextBytes(randomBytes);
        return GUIDUtils.toShort(randomBytes);
    }
}

